/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.appwork.storage.ConfigInterface;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.interfaces.ValueConverter;
import org.appwork.utils.locale.Loc;
import org.appwork.utils.locale.Tl8;
import org.appwork.utils.logging.Log;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.dialog.ComboBoxDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.FilePreview;
import org.appwork.utils.swing.dialog.InputDialog;
import org.appwork.utils.swing.dialog.PasswordDialog;
import org.appwork.utils.swing.dialog.TextAreaDialog;
import org.appwork.utils.swing.dialog.ValueDialog;

public class Dialog {
    public static final int BUTTONS_HIDE_CANCEL = 16;
    public static final int BUTTONS_HIDE_OK = 8;
    public static final String ICON_ERROR = "error";
    public static final String ICON_INFO = "info";
    public static final String ICON_QUESTION = "help";
    public static final String ICON_WARNING = "warning";
    private static final Dialog INSTANCE = new Dialog();
    public static final int LOGIC_BYPASS = 2;
    public static final int LOGIC_DONT_SHOW_AGAIN_IGNORES_CANCEL = 512;
    public static final int LOGIC_DONT_SHOW_AGAIN_IGNORES_OK = 1024;
    public static final int LOGIC_COUNTDOWN = 4;
    private JFrame owner = new JFrame();
    public static final int RETURN_CANCEL = 4;
    public static final int RETURN_TIMEOUT = 32;
    public static final int RETURN_DONT_SHOW_AGAIN = 8;
    public static final int RETURN_OK = 2;
    public static final int RETURN_CLOSED = 64;
    public static final int RETURN_SKIPPED_BY_DONT_SHOW = 16;
    public static final int STYLE_HIDE_ICON = 256;
    public static final int STYLE_HTML = 128;
    public static final int STYLE_LARGE = 64;
    public static final int STYLE_SHOW_DO_NOT_DISPLAY_AGAIN = 32;
    private int coundownTime = 20;
    private Object latestReturnMask;

    public static Dialog getInstance() {
        return INSTANCE;
    }

    public JFrame getParentOwner() {
        return this.owner;
    }

    public void setParentOwner(JFrame parent) {
        this.owner = parent;
    }

    protected int getCoundownTime() {
        return this.coundownTime;
    }

    private ImageIcon getIconByText(String text) {
        try {
            if (text.contains("?")) {
                return ImageProvider.getImageIcon(ICON_QUESTION, 32, 32);
            }
            if (text.matches(Loc.getErrorRegex())) {
                return ImageProvider.getImageIcon(ICON_ERROR, 32, 32);
            }
            if (text.contains("!")) {
                return ImageProvider.getImageIcon(ICON_WARNING, 32, 32);
            }
            return ImageProvider.getImageIcon(ICON_INFO, 32, 32);
        }
        catch (IOException e) {
            Log.exception(e);
            return null;
        }
    }

    @Deprecated
    public boolean isOK() {
        return Dialog.isOK(this.latestReturnMask);
    }

    public static boolean isOK(Object value) {
        if (!(value instanceof Integer)) {
            return false;
        }
        return BinaryLogic.containsSome((Integer)value, 2);
    }

    public static boolean isClosed(Object value) {
        if (!(value instanceof Integer)) {
            return false;
        }
        return BinaryLogic.containsSome((Integer)value, 64);
    }

    protected void setCoundownTime(int coundownTime) {
        this.coundownTime = coundownTime;
    }

    public int showComboDialog(final int flag, final String title, final String question, final Object[] options, final int defaultSelection, final ImageIcon icon, final String okOption, final String cancelOption, final ListCellRenderer renderer) {
        if ((flag & 2) > 0) {
            return defaultSelection;
        }
        Integer ret = 0;
        try {
            ret = (Integer)new EDTHelper<Integer>(){

                @Override
                public Integer edtRun() {
                    return new ComboBoxDialog(flag, title, question, options, defaultSelection, icon, okOption, cancelOption, renderer).getReturnIndex();
                }
            }.getReturnValue();
            int n = ret;
            return n;
        }
        finally {
            this.latestReturnMask = ret;
        }
    }

    public int showConfirmDialog(int flag, String question) {
        return this.showConfirmDialog(flag, Tl8.DIALOG_CONFIRMDIALOG_TITLE.toString(), question, this.getIconByText(question), null, null);
    }

    public int showConfirmDialog(int flag, String title, String question) {
        return this.showConfirmDialog(flag, title, question, this.getIconByText(String.valueOf(title) + question), null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int showConfirmDialog(final int flag, final String title, final String message, ImageIcon tmpicon, final String okOption, final String cancelOption) {
        Dialog dialog = this;
        synchronized (dialog) {
            if ((flag & 2) > 0) {
                return 0;
            }
            final ImageIcon icon = tmpicon == null ? this.getIconByText(String.valueOf(title) + message) : tmpicon;
            Integer ret = 0;
            try {
                ret = (Integer)new EDTHelper<Integer>(){

                    @Override
                    public Integer edtRun() {
                        return new ConfirmDialog(flag, title, message, icon, okOption, cancelOption).getReturnmask();
                    }
                }.getReturnValue();
                int n = ret;
                return n;
            }
            finally {
                this.latestReturnMask = ret;
            }
        }
    }

    public void showMessageDialog(String title, String message) {
        this.showMessageDialog(0, title, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] showFileChooser(final String id, final String title, final Integer fileSelectionMode, final FileFilter fileFilter, final boolean multiSelection, final Integer dialogType, final File preSelection) {
        Dialog dialog = this;
        synchronized (dialog) {
            UIManager.put("FileChooser.homeFolderToolTipText", Tl8.DIALOG_FILECHOOSER_TOOLTIP_HOMEFOLDER.toString());
            UIManager.put("FileChooser.newFolderToolTipText", Tl8.DIALOG_FILECHOOSER_TOOLTIP_NEWFOLDER.toString());
            UIManager.put("FileChooser.upFolderToolTipText", Tl8.DIALOG_FILECHOOSER_TOOLTIP_UPFOLDER.toString());
            UIManager.put("FileChooser.detailsViewButtonToolTipText", Tl8.DIALOG_FILECHOOSER_TOOLTIP_DETAILS.toString());
            UIManager.put("FileChooser.listViewButtonToolTipText", Tl8.DIALOG_FILECHOOSER_TOOLTIP_LIST.toString());
            return (File[])new EDTHelper<File[]>(){

                @Override
                public File[] edtRun() {
                    try {
                        File[] ret;
                        JFileChooser fc = new JFileChooser();
                        fc.setAccessory(new FilePreview(fc));
                        if (title != null) {
                            fc.setDialogTitle(title);
                        }
                        if (fileSelectionMode != null) {
                            fc.setFileSelectionMode(fileSelectionMode);
                        }
                        if (fileFilter != null) {
                            fc.setFileFilter(fileFilter);
                        }
                        if (multiSelection && (dialogType == null || dialogType != 1)) {
                            fc.setMultiSelectionEnabled(multiSelection);
                        }
                        if (dialogType != null) {
                            fc.setDialogType(dialogType);
                        }
                        if (preSelection != null) {
                            if (preSelection.isDirectory()) {
                                fc.setCurrentDirectory(preSelection);
                                fc.setSelectedFile(preSelection);
                            } else {
                                fc.setCurrentDirectory(preSelection.getParentFile());
                                fc.setSelectedFile(preSelection);
                            }
                        } else {
                            String latest = ConfigInterface.getStorage("FILECHOOSER").get("LASTSELECTION_" + id, null);
                            if (latest != null) {
                                for (File storeSelection = new File(latest); storeSelection != null; storeSelection = storeSelection.getParentFile()) {
                                    if (!storeSelection.exists()) {
                                        continue;
                                    }
                                    if (storeSelection.isDirectory()) {
                                        fc.setSelectedFile(storeSelection);
                                        fc.setCurrentDirectory(storeSelection);
                                        break;
                                    }
                                    fc.setCurrentDirectory(storeSelection.getParentFile());
                                    fc.setSelectedFile(storeSelection);
                                    break;
                                }
                            }
                        }
                        if (dialogType == null || dialogType == 0) {
                            if (fc.showOpenDialog(Dialog.this.getParentOwner()) == 0) {
                                if (multiSelection) {
                                    Dialog.this.latestReturnMask = fc.getSelectedFiles();
                                    if (fc.getSelectedFiles().length > 0) {
                                        File first = fc.getSelectedFiles()[0];
                                        if (first.isFile()) {
                                            first = first.getParentFile();
                                        }
                                        ConfigInterface.getStorage("FILECHOOSER").put("LASTSELECTION_" + id, first.getAbsolutePath());
                                    }
                                    return (File[])Dialog.this.latestReturnMask;
                                }
                                ret = new File[]{fc.getSelectedFile()};
                                Dialog.this.latestReturnMask = ret;
                                ConfigInterface.getStorage("FILECHOOSER").put("LASTSELECTION_" + id, ret[0].getAbsolutePath());
                                return ret;
                            }
                        } else if (dialogType == 1 && fc.showSaveDialog(Dialog.this.getParentOwner()) == 0) {
                            ret = new File[]{fc.getSelectedFile()};
                            Dialog.this.latestReturnMask = ret;
                            ConfigInterface.getStorage("FILECHOOSER").put("LASTSELECTION_" + id, ret[0].getAbsolutePath());
                            return ret;
                        }
                        return null;
                    }
                    catch (Exception e) {
                        Log.exception(e);
                        return null;
                    }
                }
            }.getReturnValue();
        }
    }

    public String showInputDialog(int flag, String question, String defaultvalue) {
        return this.showInputDialog(flag, Tl8.DIALOG_INPUT_TITLE.toString(), question, defaultvalue, this.getIconByText(question), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String showInputDialog(final int flag, final String title, final String message, final String defaultMessage, final ImageIcon icon, final String okOption, final String cancelOption) {
        Dialog dialog = this;
        synchronized (dialog) {
            if ((flag & 2) > 0) {
                return defaultMessage;
            }
            this.latestReturnMask = new EDTHelper<String>(){

                @Override
                public String edtRun() {
                    return new InputDialog(flag, title, message, defaultMessage, icon, okOption, cancelOption).getReturnID();
                }
            }.getReturnValue();
            return (String)this.latestReturnMask;
        }
    }

    public String showInputDialog(String message) {
        return this.showInputDialog(0, message, null);
    }

    public String showPasswordDialog(int flag, String question, String defaultvalue) {
        return this.showPasswordDialog(flag, Tl8.DIALOG_PASSWORD_TITLE.toString(), question, defaultvalue, this.getIconByText(question), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String showPasswordDialog(final int flag, final String title, final String message, String defaultMessage, final ImageIcon icon, final String okOption, final String cancelOption) {
        Dialog dialog = this;
        synchronized (dialog) {
            if ((flag & 2) > 0) {
                return defaultMessage;
            }
            this.latestReturnMask = new EDTHelper<String>(){

                @Override
                public String edtRun() {
                    return new PasswordDialog(flag, title, message, icon, okOption, cancelOption).getReturnID();
                }
            }.getReturnValue();
            return (String)this.latestReturnMask;
        }
    }

    public String showPasswordDialog(String message) {
        return this.showPasswordDialog(0, message, null);
    }

    public void showMessageDialog(int flag, String message) {
        this.showMessageDialog(flag, Tl8.DIALOG_MESSAGE_TITLE.toString(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMessageDialog(int flag, String title, String message) {
        Dialog dialog = this;
        synchronized (dialog) {
            this.showConfirmDialog(0x10 | flag, title, message, this.getIconByText(String.valueOf(title) + message), null, null);
        }
    }

    public void showMessageDialog(String message) {
        this.showMessageDialog(0, Tl8.DIALOG_MESSAGE_TITLE.toString(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String showTextAreaDialog(final String title, final String message, final String def) {
        Dialog dialog = this;
        synchronized (dialog) {
            this.latestReturnMask = new EDTHelper<String>(){

                @Override
                public String edtRun() {
                    try {
                        TextAreaDialog dialog = new TextAreaDialog(title, message, def);
                        if (BinaryLogic.containsAll(dialog.getReturnmask(), 2)) {
                            return dialog.getResult();
                        }
                    }
                    catch (IOException e) {
                        Log.exception(e);
                    }
                    return null;
                }
            }.getReturnValue();
            return (String)this.latestReturnMask;
        }
    }

    public long showValueDialog(int flag, String question, long defaultvalue, long min, long max, long step, ValueConverter valueConverter) {
        return this.showValueDialog(flag, Tl8.DIALOG_SLIDER_TITLE.toString(), question, defaultvalue, this.getIconByText(question), null, null, min, max, step, valueConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long showValueDialog(final int flag, final String title, final String message, final long defaultMessage, final ImageIcon icon, final String okOption, final String cancelOption, final long min, final long max, final long step, final ValueConverter valueConverter) {
        Dialog dialog = this;
        synchronized (dialog) {
            if ((flag & 2) > 0) {
                return defaultMessage;
            }
            this.latestReturnMask = new EDTHelper<Long>(){

                @Override
                public Long edtRun() {
                    return new ValueDialog(flag, title, message, icon, okOption, cancelOption, defaultMessage, min, max, step, valueConverter).getReturnValue();
                }
            }.getReturnValue();
            return (Long)this.latestReturnMask;
        }
    }

    public int showErrorDialog(String s) {
        try {
            return this.showConfirmDialog(48, Tl8.DIALOG_ERROR_TITLE.s(), s, ImageProvider.getImageIcon(ICON_ERROR, 32, 32), null, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

