/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.Files;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.swing.EDTHelper;

public class FilePreview
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 68064282036848471L;
    private File file;
    private JLabel label;
    private JPanel panel;
    private JFileChooser fileChooser;

    public FilePreview(JFileChooser fc) {
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        this.panel = new JPanel((LayoutManager)new MigLayout("ins 5", "[grow,fill]", "[grow,fill]"));
        this.add((Component)new JScrollPane(this.panel), "hidemode 3,gapleft 5");
        this.label = new JLabel();
        this.panel.add(this.label);
        this.setPreferredSize(new Dimension(200, 100));
        fc.addPropertyChangeListener(this);
        this.fileChooser = fc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("directoryChanged".equals(e.getPropertyName())) {
            this.file = (File)e.getNewValue();
        } else if ("SelectedFileChangedProperty".equals(e.getPropertyName())) {
            this.file = (File)e.getNewValue();
        }
        new Thread(){

            @Override
            public void run() {
                FilePreview.this.update();
            }
        }.start();
    }

    private void update() {
        if (this.file != null && this.file.isFile()) {
            try {
                String ext = Files.getExtension(this.file.getName());
                BufferedImage image = null;
                if (ext.equalsIgnoreCase("png")) {
                    image = ImageIO.read(this.file);
                } else if (ext.equalsIgnoreCase("jpg")) {
                    image = ImageIO.read(this.file);
                } else if (ext.equalsIgnoreCase("gif")) {
                    image = ImageIO.read(this.file);
                }
                final ImageIcon ii = new ImageIcon(ImageProvider.scaleBufferedImage(image, 160, 160));
                if (image != null) {
                    new EDTHelper<Object>(){

                        @Override
                        public Object edtRun() {
                            FilePreview.this.label.setIcon(ii);
                            int w = FilePreview.this.fileChooser.getWidth() / 3;
                            FilePreview.this.setPreferredSize(new Dimension(w, 100));
                            FilePreview.this.fileChooser.revalidate();
                            return null;
                        }
                    }.start();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                FilePreview.this.label.setIcon(null);
                FilePreview.this.label.setText("");
                FilePreview.this.setPreferredSize(new Dimension(0, 0));
                FilePreview.this.fileChooser.revalidate();
                return null;
            }
        }.start();
    }
}

