/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.JTable;
import org.appwork.utils.swing.table.ExtColumn;
import sun.swing.table.DefaultTableCellHeaderRenderer;

public class ExtTableCellHeaderRenderer
extends DefaultTableCellHeaderRenderer {
    private static final long serialVersionUID = 1984070302981234250L;
    private ExtColumn<?> column;
    private boolean order;
    private boolean paintIcon;

    public ExtTableCellHeaderRenderer(ExtColumn<?> extColumn) {
        this.column = extColumn;
        this.setHorizontalAlignment(2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.paintIcon = this.column.getModel().getSortColumn() == this.column;
        this.order = this.column.getModel().isSortOrderToggle();
        return super.getTableCellRendererComponent(table, "   " + value, isSelected, hasFocus, row, col);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.paintIcon) {
            if (this.order) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(new BasicStroke(1.0f));
                g2.setColor(Color.black);
                Polygon poly = new Polygon();
                poly.addPoint(this.getSize().width / 2, 2);
                poly.addPoint(this.getSize().width / 2 + 4, 4);
                poly.addPoint(this.getSize().width / 2 - 4, 4);
                g2.fill(poly);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(new BasicStroke(1.0f));
                g2.setColor(Color.black);
                Polygon poly = new Polygon();
                poly.addPoint(this.getSize().width / 2, this.getSize().height - 2);
                poly.addPoint(this.getSize().width / 2 + 4, this.getSize().height - 4);
                poly.addPoint(this.getSize().width / 2 - 4, this.getSize().height - 4);
                g2.fill(poly);
            }
        }
    }
}

