/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table.columns;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.appwork.utils.swing.table.ExtDefaultRowSorter;
import org.appwork.utils.swing.table.ExtTableModel;
import org.appwork.utils.swing.table.columns.ExtTextColumn;

public abstract class ExtDateColumn<E>
extends ExtTextColumn<E> {
    private static final long serialVersionUID = -5812486934156037376L;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy HH:mm");
    private Date date;
    protected String badDateText = "~";

    public ExtDateColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.setRowSorter(new ExtDefaultRowSorter<E>(){
            private Date a = new Date();
            private boolean aset = false;
            private Date b = new Date();
            private boolean bset = false;

            @Override
            public int compare(E o1, E o2) {
                Date tmp = ExtDateColumn.this.getDate(o1);
                if (tmp != null) {
                    this.a.setTime(tmp.getTime());
                    this.aset = true;
                } else {
                    this.aset = false;
                }
                tmp = ExtDateColumn.this.getDate(o2);
                if (tmp != null) {
                    this.b.setTime(tmp.getTime());
                    this.bset = true;
                } else {
                    this.bset = false;
                }
                if (this.aset != this.bset) {
                    return 0;
                }
                if (!this.aset && this.bset) {
                    return 1;
                }
                if (this.aset && !this.bset) {
                    return -1;
                }
                if (this.isSortOrderToggle()) {
                    return this.a.compareTo(this.b);
                }
                return this.b.compareTo(this.a);
            }
        });
        this.init();
    }

    protected void init() {
    }

    protected abstract Date getDate(E var1);

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public void setValue(Object value, E object) {
    }

    @Override
    public String getStringValue(E value) {
        this.date = this.getDate(value);
        if (this.date == null) {
            return this.setText(value, this.badDateText);
        }
        return this.setText(value, this.getDateFormat().format(this.date));
    }

    protected String setText(E value, String badDateText2) {
        return badDateText2;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }
}

