/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table.columns;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.table.ExtColumn;
import org.appwork.utils.swing.table.ExtDefaultRowSorter;
import org.appwork.utils.swing.table.ExtTableModel;

public abstract class ExtIconColumn<E>
extends ExtColumn<E> {
    private RenderLabel label = new RenderLabel();
    private static final long serialVersionUID = -5751315870107507714L;

    public ExtIconColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.label.setOpaque(false);
        this.label.setHorizontalAlignment(0);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.initIcons();
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                if (ExtIconColumn.this.getIcon(o1).hashCode() == ExtIconColumn.this.getIcon(o2).hashCode()) {
                    return 0;
                }
                if (this.isSortOrderToggle()) {
                    return ExtIconColumn.this.getIcon(o1).hashCode() > ExtIconColumn.this.getIcon(o2).hashCode() ? -1 : 1;
                }
                return ExtIconColumn.this.getIcon(o1).hashCode() < ExtIconColumn.this.getIcon(o2).hashCode() ? -1 : 1;
            }
        });
    }

    public String getToolTip(E obj) {
        return null;
    }

    protected void initIcons() {
    }

    protected abstract Icon getIcon(E var1);

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public void setValue(Object value, E object) {
    }

    @Override
    protected int getMaxWidth() {
        return 30;
    }

    @Override
    public int getMinWidth() {
        return 30;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.label.setIcon(this.getIcon(value));
        this.label.setToolTipText(this.getToolTip(value));
        this.label.setEnabled(this.isEnabled(value));
        return this.label;
    }
}

