/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table.columns;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.table.ExtColumn;
import org.appwork.utils.swing.table.ExtDefaultRowSorter;
import org.appwork.utils.swing.table.ExtTableModel;

public abstract class ExtLongColumn<E>
extends ExtColumn<E> {
    private static final long serialVersionUID = -6917352290094392921L;
    private RenderLabel label = new RenderLabel();

    public ExtLongColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.label.setBorder(null);
        this.label.setOpaque(false);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                if (ExtLongColumn.this.getLong(o1) == ExtLongColumn.this.getLong(o2)) {
                    return 0;
                }
                if (this.isSortOrderToggle()) {
                    return ExtLongColumn.this.getLong(o1) > ExtLongColumn.this.getLong(o2) ? -1 : 1;
                }
                return ExtLongColumn.this.getLong(o1) < ExtLongColumn.this.getLong(o2) ? -1 : 1;
            }
        });
    }

    protected abstract long getLong(E var1);

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(Object obj) {
        return true;
    }

    @Override
    public void setValue(Object value, E object) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.label.setText(String.valueOf(this.getLong(value)));
        this.label.setEnabled(this.isEnabled(value));
        return this.label;
    }
}

