/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table.columns;

import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.table.ExtColumn;
import org.appwork.utils.swing.table.ExtDefaultRowSorter;
import org.appwork.utils.swing.table.ExtTableModel;

public abstract class ExtTextColumn<E>
extends ExtColumn<E> {
    private static final long serialVersionUID = 2114805529462086691L;
    private RenderLabel label = new RenderLabel();

    public ExtTextColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.label.setOpaque(false);
        this.prepareTableCellRendererComponent(this.label);
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                if (this.isSortOrderToggle()) {
                    return ExtTextColumn.this.getStringValue(o1).compareTo(ExtTextColumn.this.getStringValue(o2));
                }
                return ExtTextColumn.this.getStringValue(o2).compareTo(ExtTextColumn.this.getStringValue(o1));
            }
        });
    }

    protected void prepareTableCellRendererComponent(JLabel jlr) {
    }

    protected abstract String getStringValue(E var1);

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    public String getToolTip(E obj) {
        return null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.label.setText(this.getStringValue(value));
        this.label.setToolTipText(this.getToolTip(value));
        this.label.setEnabled(this.isEnabled(value));
        this.label.setIcon(this.getIcon(value));
        return this.label;
    }

    protected Icon getIcon(E value) {
        return null;
    }

    @Override
    protected boolean matchSearch(E object, Pattern pattern) {
        return pattern.matcher(this.getStringValue(object)).matches();
    }

    @Override
    public void setValue(Object value, E object) {
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }
}

