/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.appwork.utils.Hash;
import org.appwork.utils.zip.ZipIOException;

public class ZipIOWriter {
    private ZipOutputStream zipStream = null;
    private FileOutputStream fileStream = null;
    private File zipFile = null;
    private byte[] buf = new byte[8192];

    public ZipIOWriter(File zipFile) throws FileNotFoundException, ZipIOException {
        this.zipFile = zipFile;
        this.openZip(false);
    }

    public ZipIOWriter(File zipFile, boolean overwrite) throws FileNotFoundException, ZipIOException {
        this.zipFile = zipFile;
        this.openZip(overwrite);
    }

    private void openZip(boolean overwrite) throws ZipIOException, FileNotFoundException {
        if (this.fileStream != null && this.zipStream != null) {
            return;
        }
        if (this.zipFile == null || this.zipFile.isDirectory()) {
            throw new ZipIOException("invalid zipFile");
        }
        if (this.zipFile.exists() && !overwrite) {
            throw new ZipIOException("zipFile already exists");
        }
        this.fileStream = new FileOutputStream(this.zipFile);
        this.zipStream = new ZipOutputStream(this.fileStream);
    }

    public synchronized void close() throws IOException {
        try {
            if (this.zipStream != null) {
                this.zipStream.flush();
                this.zipStream.close();
            }
            if (this.fileStream != null) {
                this.fileStream.flush();
                this.fileStream.close();
            }
        }
        finally {
            this.zipStream = null;
            this.fileStream = null;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public synchronized void add(File add, boolean compress, String path) throws ZipIOException, IOException {
        if (add == null || !add.exists()) {
            throw new ZipIOException("add " + add.getAbsolutePath() + " invalid");
        }
        if (add.isFile()) {
            this.addFileInternal(add, compress, path);
        } else if (add.isDirectory()) {
            this.addDirectoryInternal(add, compress, path);
        } else {
            throw new ZipIOException("add " + add.getAbsolutePath() + " invalid");
        }
    }

    public synchronized void addFile(File addFile, boolean compress, String path) throws ZipIOException, IOException {
        this.addFileInternal(addFile, compress, path);
    }

    public synchronized void addDirectory(File addDirectory, boolean compress, String path) throws ZipIOException, IOException {
        this.addDirectoryInternal(addDirectory, compress, path);
    }

    private void addDirectoryInternal(File addDirectory, boolean compress, String path) throws ZipIOException, IOException {
        if (addDirectory == null || !addDirectory.isDirectory() || !addDirectory.exists()) {
            throw new ZipIOException("addDirectory " + addDirectory.getAbsolutePath() + " invalid");
        }
        File[] fileArray = addDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File add = fileArray[n2];
            if (add.isFile()) {
                this.addFileInternal(add, compress, String.valueOf(path != null && path.trim().length() > 0 ? String.valueOf(path) + "/" : "") + addDirectory.getName());
            } else if (add.isDirectory()) {
                this.addDirectoryInternal(add, compress, String.valueOf(path != null && path.trim().length() > 0 ? String.valueOf(path) + "/" : "") + addDirectory.getName());
            } else {
                throw new ZipIOException("addDirectory " + addDirectory.getAbsolutePath() + " invalid");
            }
            ++n2;
        }
    }

    private void addFileInternal(File addFile, boolean compress, String path) throws ZipIOException, IOException {
        FileInputStream fin = null;
        boolean zipEntryAdded = false;
        try {
            int len;
            if (addFile == null || !addFile.isFile() || !addFile.exists()) {
                throw new ZipIOException("addFile " + addFile.getAbsolutePath() + " invalid");
            }
            ZipEntry zipAdd = new ZipEntry(String.valueOf(path != null && path.trim().length() > 0 ? String.valueOf(path) + "/" : "") + addFile.getName());
            zipAdd.setSize(addFile.length());
            if (compress) {
                zipAdd.setMethod(8);
            } else {
                zipAdd.setMethod(0);
                zipAdd.setCompressedSize(addFile.length());
                zipAdd.setCrc(Hash.getCRC32(addFile));
            }
            fin = new FileInputStream(addFile);
            this.zipStream.putNextEntry(zipAdd);
            zipEntryAdded = true;
            while ((len = fin.read(this.buf)) > 0) {
                this.zipStream.write(this.buf, 0, len);
            }
        }
        finally {
            if (zipEntryAdded) {
                this.zipStream.closeEntry();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }

    public static void main(String[] args) throws ZipIOException, IOException {
        ZipIOWriter zip = new ZipIOWriter(new File("/home/daniel/test.zip"), true);
        zip.add(new File("/home/daniel/Rain-OST"), true, "home/uu");
        zip.close();
    }
}

