/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.js.event.BasicEvent;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.html2.HTMLScriptElement;

public class HTMLScriptElementImpl
extends HTMLElementImpl
implements HTMLScriptElement {
    private static final Logger logger = Logger.getLogger(HTMLScriptElementImpl.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private String text;
    private boolean defer;

    public HTMLScriptElementImpl() {
        super("SCRIPT", true);
    }

    public HTMLScriptElementImpl(String name) {
        super(name, true);
    }

    @Override
    public String getText() {
        String t = this.text;
        if (t == null) {
            return this.getRawInnerText(true);
        }
        return t;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getHtmlFor() {
        return this.getAttribute("htmlFor");
    }

    @Override
    public void setHtmlFor(String htmlFor) {
        this.setAttribute("htmlFor", htmlFor);
    }

    @Override
    public String getEvent() {
        return this.getAttribute("event");
    }

    @Override
    public void setEvent(String event) {
        this.setAttribute("event", event);
    }

    @Override
    public boolean getDefer() {
        return this.defer;
    }

    @Override
    public void setDefer(boolean defer) {
        this.defer = defer;
    }

    @Override
    public String getSrc() {
        return this.getAttribute("src");
    }

    @Override
    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    @Override
    public String getType() {
        return this.getAttribute("type");
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if ("cobra.suspend".equals(key) && data != Boolean.TRUE) {
            this.processScript();
        }
        return super.setUserData(key, data, handler);
    }

    protected final void processScript() {
        UserAgentContext bcontext = this.getUserAgentContext();
        if (bcontext == null) {
            throw new IllegalStateException("No user agent context.");
        }
        if (bcontext.isScriptingEnabled()) {
            int baseLineNumber;
            String scriptURI;
            String text;
            String src = this.getSrc();
            Document doc = this.document;
            if (!(doc instanceof HTMLDocumentImpl)) {
                throw new IllegalStateException("no valid document");
            }
            boolean liflag = loggableInfo;
            if (src == null) {
                text = this.getText();
                scriptURI = doc.getBaseURI();
                baseLineNumber = 1;
            } else {
                this.informExternalScriptLoading();
                URL scriptURL = ((HTMLDocumentImpl)doc).getFullURL(src);
                scriptURI = scriptURL == null ? src : scriptURL.toExternalForm();
                long time1 = liflag ? System.currentTimeMillis() : 0L;
                try {
                    final HttpRequest request = bcontext.createHttpRequest();
                    SecurityManager sm = System.getSecurityManager();
                    if (sm == null) {
                        try {
                            request.open("GET", scriptURI, false);
                            request.send(null);
                        }
                        catch (IOException thrown) {
                            logger.log(Level.WARNING, "processScript()", thrown);
                        }
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    request.open("GET", scriptURI, false);
                                    request.send(null);
                                }
                                catch (IOException thrown) {
                                    logger.log(Level.WARNING, "processScript()", thrown);
                                }
                                return null;
                            }
                        });
                    }
                    int status = request.getStatus();
                    if (status != 200 && status != 0) {
                        this.getHtmlRendererContext().dispatch(new BasicEvent("error", this));
                        this.warn("Script at [" + scriptURI + "] failed to load; HTTP status: " + status + ".");
                        return;
                    }
                    this.getHtmlRendererContext().dispatch(new BasicEvent("load", this));
                    text = request.getResponseText();
                }
                finally {
                    if (liflag) {
                        long time2 = System.currentTimeMillis();
                        logger.info("processScript(): Loaded external Javascript from URI=[" + scriptURI + "] in " + (time2 - time1) + " ms.");
                    }
                }
                baseLineNumber = 1;
            }
            text = bcontext.doScriptFilter(this, text);
            if (text != null) {
                Context ctx = Executor.createContext(this.getDocumentURL(), bcontext);
                try {
                    try {
                        long time1;
                        Scriptable scope = (Scriptable)doc.getUserData("cobra.js.scope");
                        if (scope == null) {
                            throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
                        }
                        long l = time1 = liflag ? System.currentTimeMillis() : 0L;
                        if (text == null) {
                            throw new IllegalStateException("Script source is null: " + this + ".");
                        }
                        ctx.evaluateString(scope, text, scriptURI, baseLineNumber, null);
                        if (liflag) {
                            long time2 = System.currentTimeMillis();
                            logger.info("addNotify(): Evaluated (or attempted to evaluate) Javascript in " + (time2 - time1) + " ms.");
                        }
                    }
                    catch (EcmaError ecmaError) {
                        logger.log(Level.WARNING, "Javascript error at " + ecmaError.getSourceName() + ":" + ecmaError.getLineNumber() + ": " + ecmaError.getMessage(), ecmaError);
                        Context.exit();
                    }
                    catch (Throwable err) {
                        logger.log(Level.WARNING, "Unable to evaluate Javascript code", err);
                        Context.exit();
                    }
                }
                finally {
                    Context.exit();
                }
            }
        }
    }

    @Override
    protected void appendInnerTextImpl(StringBuffer buffer) {
    }
}

