/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.js.Event;
import org.lobobrowser.html.js.SecurityControllerImpl;
import org.lobobrowser.js.JavaScript;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.w3c.dom.Document;

public class Executor {
    private static final Logger logger = Logger.getLogger(Executor.class.getName());
    public static final String SCOPE_KEY = "cobra.js.scope";

    public static Context createContext(URL codeSource, UserAgentContext ucontext) {
        Context prev = Context.getCurrentContext();
        Context ctx = Context.enter();
        ctx.setOptimizationLevel(ucontext.getScriptingOptimizationLevel());
        if (prev == null) {
            ctx.setSecurityController((SecurityController)new SecurityControllerImpl(codeSource, ucontext.getSecurityPolicy()));
        }
        return ctx;
    }

    public static boolean executeFunction(NodeImpl element, Function f, Event event) {
        return Executor.executeFunction(element, element, f, event);
    }

    public static boolean executeFunction(NodeImpl element, Object thisObject, Function f, Event event) {
        Document doc = element.getOwnerDocument();
        if (doc == null) {
            throw new IllegalStateException("Element does not belong to a document.");
        }
        Context ctx = Executor.createContext(element.getDocumentURL(), element.getUserAgentContext());
        try {
            Scriptable scope = (Scriptable)doc.getUserData(SCOPE_KEY);
            if (scope == null) {
                throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
            }
            JavaScript js = JavaScript.getInstance();
            Scriptable thisScope = (Scriptable)js.getJavascriptObject(thisObject, scope);
            try {
                Scriptable eventScriptable = (Scriptable)js.getJavascriptObject(event, thisScope);
                ScriptableObject.defineProperty((Scriptable)thisScope, (String)"event", (Object)eventScriptable, (int)1);
                System.out.println("Run Function \r\n" + ctx.decompileFunction(f, 1));
                Object result = f.call(ctx, thisScope, thisScope, new Object[0]);
                if (!(result instanceof Boolean)) {
                    return true;
                }
                boolean bl = (Boolean)result;
                return bl;
            }
            catch (Throwable thrown) {
                logger.log(Level.WARNING, "executeFunction(): There was an error in Javascript code.", thrown);
                return true;
            }
        }
        finally {
            Context.exit();
        }
    }

    public static boolean executeFunction(Scriptable thisScope, Function f, URL codeSource, UserAgentContext ucontext) {
        Context ctx = Executor.createContext(codeSource, ucontext);
        System.out.println("execute \r\n" + ctx.decompileFunction(f, 3));
        try {
            Object result = f.call(ctx, thisScope, thisScope, new Object[0]);
            if (!(result instanceof Boolean)) {
                return true;
            }
            boolean bl = (Boolean)result;
            return bl;
        }
        catch (Throwable err) {
            logger.log(Level.WARNING, "executeFunction(): Unable to execute Javascript function " + f.getClassName() + ".", err);
            return true;
        }
        finally {
            Context.exit();
        }
    }
}

