/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.renderer.BaseControl;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.HtmlValues;

class ImgControl
extends BaseControl
implements ImageListener {
    private volatile Image image;
    private String lastSrc;
    private int valign = 5;
    private Dimension preferredSize;
    private int declaredWidth;
    private int declaredHeight;

    public ImgControl(HTMLImageElementImpl modelNode) {
        super(modelNode);
        modelNode.addImageListener(this);
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        ImgControl imgControl = this;
        // MONITORENTER : imgControl
        // MONITOREXIT : imgControl
        Image image = this.image;
        if (image == null) return;
        g.drawImage(image, insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom, this);
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        HTMLElementImpl element = this.controlElement;
        int dw = HtmlValues.getOldSyntaxPixelSize(element.getAttribute("width"), availWidth, -1);
        int dh = HtmlValues.getOldSyntaxPixelSize(element.getAttribute("height"), availHeight, -1);
        this.declaredWidth = dw;
        this.declaredHeight = dh;
        this.preferredSize = this.createPreferredSize(dw, dh);
        String alignText = element.getAttribute("align");
        int valign = alignText == null ? 5 : ("middle".equals(alignText = alignText.toLowerCase().trim()) ? 1 : ("absmiddle".equals(alignText) ? 3 : ("top".equals(alignText) ? 0 : ("bottom".equals(alignText) ? 2 : ("baseline".equals(alignText) ? 5 : ("absbottom".equals(alignText) ? 4 : 5))))));
        this.valign = valign;
    }

    @Override
    public int getVAlign() {
        return this.valign;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = this.preferredSize;
        return ps == null ? new Dimension(0, 0) : ps;
    }

    public Dimension createPreferredSize(int dw, int dh) {
        int ih;
        int iw;
        Image img = this.image;
        if (dw == -1) {
            if (dh != -1) {
                iw = img == null ? -1 : img.getWidth(this);
                int n = ih = img == null ? -1 : img.getHeight(this);
                dw = ih == 0 ? (iw == -1 ? 0 : iw) : (iw == -1 || ih == -1 ? 0 : dh * iw / ih);
            } else {
                int n = dw = img == null ? -1 : img.getWidth(this);
                if (dw == -1) {
                    dw = 0;
                }
            }
        }
        if (dh == -1) {
            if (dw != -1) {
                iw = img == null ? -1 : img.getWidth(this);
                int n = ih = img == null ? -1 : img.getHeight(this);
                dh = iw == 0 ? (ih == -1 ? 0 : ih) : (iw == -1 || ih == -1 ? 0 : dw * ih / iw);
            } else {
                int n = dh = img == null ? -1 : img.getHeight(this);
                if (dh == -1) {
                    dh = 0;
                }
            }
        }
        return new Dimension(dw, dh);
    }

    private final boolean checkPreferredSizeChange() {
        Dimension newPs = this.createPreferredSize(this.declaredWidth, this.declaredHeight);
        Dimension ps = this.preferredSize;
        if (ps == null) {
            return true;
        }
        if (ps.width != newPs.width || ps.height != newPs.height) {
            this.preferredSize = newPs;
            return true;
        }
        return false;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x20) != 0 || (infoflags & 0x10) != 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ImgControl.this.checkPreferredSizeChange()) {
                        ImgControl.this.repaint();
                    } else {
                        ImgControl.this.ruicontrol.preferredSizeInvalidated();
                    }
                }
            });
        }
        return true;
    }

    public void imageUpdate(Image img, int w, int h) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ImgControl.this.checkPreferredSizeChange()) {
                    ImgControl.this.repaint();
                } else {
                    ImgControl.this.ruicontrol.preferredSizeInvalidated();
                }
            }
        });
    }

    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return inSelection;
    }

    @Override
    public void imageLoaded(ImageEvent event) {
        Image image;
        this.image = image = event.image;
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        if (width != -1 && height != -1) {
            this.imageUpdate(image, width, height);
        }
    }

    @Override
    public String toString() {
        return "ImgControl[src=" + this.lastSrc + "]";
    }
}

