/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.TableMatrix;
import org.lobobrowser.html.renderer.VirtualCell;
import org.lobobrowser.html.style.RenderState;

class RTableCell
extends RBlock {
    private final HTMLTableCellElementImpl cellElement;
    private VirtualCell topLeftVirtualCell;
    private int colSpan = -1;
    private int rowSpan = -1;

    public RTableCell(HTMLTableCellElementImpl element, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer tableAsContainer) {
        super(element, 0, pcontext, rcontext, frameContext, tableAsContainer);
        this.cellElement = element;
    }

    protected Dimension doCellLayout(int width, int height, boolean expandWidth, boolean expandHeight, boolean sizeOnly) {
        return this.doCellLayout(width, height, expandWidth, expandHeight, sizeOnly, true);
    }

    protected Dimension doCellLayout(int width, int height, boolean expandWidth, boolean expandHeight, boolean sizeOnly, boolean useCache) {
        try {
            this.doLayout(width, height, expandWidth, expandHeight, null, 0, 0, sizeOnly, useCache);
            this.layout(width, height, expandWidth, expandHeight, null, sizeOnly);
            Dimension dimension = new Dimension(this.width, this.height);
            return dimension;
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    void clearLayoutCache() {
        this.cachedLayout.clear();
    }

    @Override
    protected Integer getDeclaredHeight(RenderState renderState, int availHeight) {
        return null;
    }

    @Override
    protected Integer getDeclaredWidth(RenderState renderState, int availWidth) {
        return null;
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
    }

    public void setTopLeftVirtualCell(VirtualCell vc) {
        this.topLeftVirtualCell = vc;
    }

    public VirtualCell getTopLeftVirtualCell() {
        return this.topLeftVirtualCell;
    }

    public int getVirtualColumn() {
        VirtualCell vc = this.topLeftVirtualCell;
        return vc == null ? 0 : vc.getColumn();
    }

    public int getVirtualRow() {
        VirtualCell vc = this.topLeftVirtualCell;
        return vc == null ? 0 : vc.getRow();
    }

    public int getColSpan() {
        int cs = this.colSpan;
        if (cs == -1) {
            cs = this.cellElement.getColSpan();
            if (cs < 1) {
                cs = 1;
            }
            this.colSpan = cs;
        }
        return cs;
    }

    public int getRowSpan() {
        int rs = this.rowSpan;
        if (rs == -1) {
            rs = this.cellElement.getRowSpan();
            if (rs < 1) {
                rs = 1;
            }
            this.rowSpan = rs;
        }
        return rs;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public String getHeightText() {
        return this.cellElement.getHeight();
    }

    public String getWidthText() {
        return this.cellElement.getWidth();
    }

    public void setCellBounds(TableMatrix.SizeInfo[] colSizes, TableMatrix.SizeInfo[] rowSizes, int hasBorder, int cellSpacingX, int cellSpacingY) {
        int height;
        int width;
        int vcol = this.getVirtualColumn();
        int vrow = this.getVirtualRow();
        TableMatrix.SizeInfo colSize = colSizes[vcol];
        TableMatrix.SizeInfo rowSize = rowSizes[vrow];
        int x = colSize.offset;
        int y = rowSize.offset;
        int colSpan = this.getColSpan();
        if (colSpan > 1) {
            width = 0;
            int i = 0;
            while (i < colSpan) {
                int vc = vcol + i;
                width += colSizes[vc].actualSize;
                if (i + 1 < colSpan) {
                    width += cellSpacingX + hasBorder * 2;
                }
                ++i;
            }
        } else {
            width = colSizes[vcol].actualSize;
        }
        int rowSpan = this.getRowSpan();
        if (rowSpan > 1) {
            height = 0;
            int i = 0;
            while (i < rowSpan) {
                int vr = vrow + i;
                height += rowSizes[vr].actualSize;
                if (i + 1 < rowSpan) {
                    height += cellSpacingY + hasBorder * 2;
                }
                ++i;
            }
        } else {
            height = rowSizes[vrow].actualSize;
        }
        this.setBounds(x, y, width, height);
    }

    @Override
    protected boolean isMarginBoundary() {
        return true;
    }
}

