/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

public class Html {
    public static String textToHTML(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        boolean prevSlashR = false;
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\r': {
                    if (prevSlashR) {
                        out.append("<br>");
                    }
                    prevSlashR = true;
                    break;
                }
                case '\n': {
                    prevSlashR = false;
                    out.append("<br>");
                    break;
                }
                case '\"': {
                    if (prevSlashR) {
                        out.append("<br>");
                        prevSlashR = false;
                    }
                    out.append("&quot;");
                    break;
                }
                case '<': {
                    if (prevSlashR) {
                        out.append("<br>");
                        prevSlashR = false;
                    }
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    if (prevSlashR) {
                        out.append("<br>");
                        prevSlashR = false;
                    }
                    out.append("&gt;");
                    break;
                }
                case '&': {
                    if (prevSlashR) {
                        out.append("<br>");
                        prevSlashR = false;
                    }
                    out.append("&amp;");
                    break;
                }
                default: {
                    if (prevSlashR) {
                        out.append("<br>");
                        prevSlashR = false;
                    }
                    out.append(ch);
                }
            }
            ++i;
        }
        return out.toString();
    }
}

