/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import jd.PluginWrapper;
import jd.gui.UserIO;
import jd.gui.swing.SwingGui;
import jd.gui.swing.components.ImportRouterDialog;
import jd.gui.swing.components.JDFileChooser;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.interfaces.SwitchPanelEvent;
import jd.gui.swing.jdgui.interfaces.SwitchPanelListener;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.gui.swing.jdgui.views.ClosableView;
import jd.nutils.io.JDFileFilter;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginOptional;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9446 $", id="livescripter", hasGui=true, interfaceversion=5)
public class HTTPLiveHeaderScripter
extends PluginOptional {
    private ClosableView tabbedPanel;
    private JMenuItem menHelpWiki;
    private JMenuItem menEditAddDefine;
    private JMenuItem menEditAddRequest;
    private JMenuItem menEditAddWait;
    private JMenuItem menEditValidate;
    private JMenuItem menImportFile;
    private JMenuItem menImportHTTPLive;
    private JMenuItem menImportJDLH;
    private JMenuItem menSave;
    private JTextArea textArea;
    private MenuAction action;

    public HTTPLiveHeaderScripter(PluginWrapper wrapper) {
        super(wrapper);
    }

    public void setGuiEnable(boolean b) {
        if (b) {
            this.initGUI();
            SwingGui.getInstance().setContent((SwitchPanel)this.tabbedPanel);
        } else if (this.tabbedPanel != null) {
            this.tabbedPanel.close();
        }
        if (this.action != null && this.action.isSelected() != b) {
            this.action.setSelected(b);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.action) {
            this.setGuiEnable(this.action.isSelected());
        } else if (e.getSource() == this.menImportHTTPLive) {
            this.importFF();
        } else if (e.getSource() == this.menHelpWiki) {
            try {
                JLink.openURL((String)JDL.L((String)"jd.plugins.optional.HTTPLiveHeaderScripter.actionPerformed.wikilink", (String)"http://jdownloader.org/knowledge/wiki/reconnect/live-header-script"));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource() == this.menImportJDLH) {
            this.importLHScript();
        } else if (e.getSource() == this.menImportFile) {
            JDFileChooser fc = new JDFileChooser();
            fc.setApproveButtonText(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.openfile", (String)"Open"));
            fc.setFileSelectionMode(0);
            fc.setFileFilter((FileFilter)new JDFileFilter(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.desc", (String)"XML-File"), ".xml", true));
            fc.showSaveDialog((Component)this.tabbedPanel);
            File ret = fc.getSelectedFile();
            if (ret == null || !ret.exists()) {
                return;
            }
            try {
                Vector save = (Vector)JDIO.loadObject((Component)this.tabbedPanel, (File)ret, (boolean)true);
                this.textArea.setText((String)save.get(2));
            }
            catch (Exception e2) {
                this.textArea.setText(JDIO.readFileToString((File)ret));
            }
        } else if (e.getSource() == this.menSave) {
            JDFileChooser fc = new JDFileChooser();
            fc.setApproveButtonText(JDL.L((String)"gui.btn_save", (String)"Save"));
            fc.setFileSelectionMode(0);
            fc.setFileFilter((FileFilter)new JDFileFilter(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.desc", (String)"XML-File"), ".xml", true));
            fc.showSaveDialog((Component)this.tabbedPanel);
            File ret = fc.getSelectedFile();
            if (ret == null) {
                return;
            }
            if (JDIO.getFileExtension((File)ret) == null || !JDIO.getFileExtension((File)ret).equalsIgnoreCase("xml")) {
                ret = new File(String.valueOf(ret.getAbsolutePath()) + ".xml");
            }
            ArrayList<String> save = new ArrayList<String>();
            String manu = UserIO.getInstance().requestInputDialog(0, JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.save.manufactur", (String)"Manufactur? (e.g. Siemens)"), null);
            String model = UserIO.getInstance().requestInputDialog(0, JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.save.model", (String)"Model? (e.g. Gigaset 555 (fw 3.01.05)"), null);
            if (manu == null || model == null) {
                return;
            }
            save.add(manu);
            save.add(model);
            save.add(this.textArea.getText());
            save.add("?s).*" + manu.toLowerCase() + ".*");
            JDIO.saveObject((Component)this.tabbedPanel, save, (File)ret, null, null, (boolean)true);
        } else if (e.getSource() == this.menEditValidate) {
            if (this.validate()) {
                UserIO.getInstance().requestMessageDialog(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.validate.ok", (String)"Script is Valid."));
            }
        } else if (e.getSource() == this.menEditAddRequest) {
            if (!this.validate()) {
                return;
            }
            String script = this.textArea.getText();
            int id = Math.max(script.lastIndexOf("[[[/STEP]]]") + 11, script.lastIndexOf("[[[HSRC]]]") + 9);
            StringBuilder sb = new StringBuilder();
            sb.append(script.substring(0, id).trim());
            sb.append("\r\n");
            sb.append("     [[[STEP]]]\r\n");
            sb.append("          [[[REQUEST]]]\r\n\r\n");
            sb.append("          [[[/REQUEST]]]\r\n");
            sb.append("     [[[/STEP]]]\r\n");
            sb.append(script.substring(id).trim());
            this.textArea.setText("" + sb);
        } else if (e.getSource() == this.menEditAddDefine) {
            if (!this.validate()) {
                return;
            }
            String script = this.textArea.getText();
            int id = Math.max(script.indexOf("[[[STEP]]]"), script.indexOf("[[[HSRC]]]") + 9);
            StringBuilder sb = new StringBuilder();
            sb.append(script.substring(0, id).trim());
            sb.append("\r\n");
            sb.append("     [[[STEP]]]\r\n");
            sb.append("          [[[DEFINE variablename=\"VALUE\"/]]]\r\n");
            sb.append("     [[[/STEP]]]\r\n");
            sb.append(script.substring(id).trim());
            this.textArea.setText("" + sb);
        } else if (e.getSource() == this.menEditAddWait) {
            if (!this.validate()) {
                return;
            }
            String script = this.textArea.getText();
            int id = Math.max(script.lastIndexOf("[[[/STEP]]]") + 11, script.lastIndexOf("[[[HSRC]]]") + 9);
            StringBuilder sb = new StringBuilder();
            sb.append(script.substring(0, id).trim());
            sb.append("\r\n");
            sb.append("     [[[STEP]]]\r\n");
            sb.append("          [[[WAIT seconds=\"3\"/]]]\r\n");
            sb.append("     [[[/STEP]]]\r\n");
            sb.append(script.substring(id).trim());
            this.textArea.setText("" + sb);
        }
    }

    private String convertFF(String script) {
        String[] forbidden = new String[]{"jpg", "gif", "ico", "png", "mid", "css", "js", "xml"};
        String[] forbiddenHeaders = new String[]{"accept", "user-agent", "If-Modified-Since", "Cache-Control"};
        ArrayList<String> ips = new ArrayList<String>();
        String[] requests = script.split("----------------------------------------------------------");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            String request = stringArray[n2];
            String[] lines = Regex.getLines((String)request.trim());
            if (lines.length >= 3) {
                String url = lines[0];
                if (url.indexOf("?") > 0) {
                    url = url.substring(0, url.indexOf("?"));
                }
                boolean f = false;
                String[] stringArray2 = forbidden;
                int n3 = forbidden.length;
                int n4 = 0;
                while (n4 < n3) {
                    String end = stringArray2[n4];
                    if (url.toLowerCase().endsWith(end.toLowerCase())) {
                        f = true;
                        break;
                    }
                    ++n4;
                }
                if (!f) {
                    sb.append("     [[[STEP]]]\r\n");
                    sb.append("          [[[REQUEST]]]\r\n");
                    boolean post = lines[2].trim().toLowerCase().startsWith("post");
                    int i = 2;
                    while (i < lines.length) {
                        block14: {
                            lines[i] = lines[i].trim();
                            if (lines[i].toLowerCase().startsWith("http/")) break;
                            String[] stringArray3 = forbiddenHeaders;
                            int n5 = forbiddenHeaders.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String forb = stringArray3[n6];
                                if (!lines[i].toLowerCase().startsWith(forb.toLowerCase())) {
                                    ++n6;
                                    continue;
                                }
                                break block14;
                            }
                            if (lines[i].toLowerCase().startsWith("host:")) {
                                String ip = lines[i].substring(6).trim();
                                if (!ips.contains(ip)) {
                                    ips.add(ip);
                                }
                                sb.append("Host: %%%IP" + ips.indexOf(ip) + "%%%" + "\r\n");
                            } else {
                                if (post && lines.length > i + 1 && lines[i + 1].toLowerCase().startsWith("http/")) {
                                    sb.append("\r\n");
                                }
                                sb.append(String.valueOf(lines[i].trim()) + "\r\n");
                            }
                        }
                        ++i;
                    }
                    sb.append("          [[[/REQUEST]]]\r\n");
                    sb.append("     [[[/STEP]]]\r\n");
                }
            }
            ++n2;
        }
        int i = 0;
        String sc = sb.toString();
        sb = new StringBuilder();
        sb.append("     [[[STEP]]]\r\n");
        sb.append("          [[[DEFINE");
        for (String ip : ips) {
            sb.append(" ip");
            sb.append(i);
            sb.append("=");
            sb.append("\"");
            sb.append(ip);
            sb.append("\"");
            sc = sc.replaceAll(ip, "%%%ip" + i + "%%%");
            ++i;
        }
        sb.append("/]]]\r\n");
        sb.append("     [[[/STEP]]]\r\n");
        ++i;
        StringBuilder ret = new StringBuilder();
        ret.append("[[[HSRC]]]\r\n");
        ret.append((CharSequence)sb);
        ret.append(sc);
        ret.append("[[[/HSRC]]]");
        return "" + ret;
    }

    public ArrayList<MenuAction> createMenuitems() {
        ArrayList<MenuAction> menu = new ArrayList<MenuAction>();
        menu.add(this.action);
        return menu;
    }

    public boolean initAddon() {
        this.action = new MenuAction(this.getWrapper().getID(), 0);
        this.action.setActionListener((ActionListener)((Object)this));
        this.action.setTitle(this.getHost());
        this.action.setIcon(this.getIconKey());
        this.action.setSelected(false);
        return true;
    }

    public String getIconKey() {
        return "gui.images.config.reconnect";
    }

    private void initGUI() {
        if (this.tabbedPanel != null) {
            return;
        }
        this.tabbedPanel = new ClosableView(){
            private static final long serialVersionUID = 1L;

            public void onShow() {
            }

            public Icon getIcon() {
                return JDTheme.II((String)HTTPLiveHeaderScripter.this.getIconKey(), (int)16, (int)16);
            }

            public void onHide() {
            }

            public String getTitle() {
                return JDL.L((String)"jd.plugins.optional.HTTPLiveHeaderScripter.title", (String)"HLH Scripter");
            }

            public String getTooltip() {
                return JDL.L((String)"jd.plugins.optional.HTTPLiveHeaderScripter.tooltip", (String)"HTTP-Live-Header Scripter: Create Reconnect scripts easily");
            }

            protected void initMenu(JMenuBar menuBar) {
                JMenu menFile = new JMenu(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.file", (String)"File"));
                HTTPLiveHeaderScripter.this.menImportFile = new JMenuItem(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.file.importfile", (String)"Open file"));
                HTTPLiveHeaderScripter.this.menSave = new JMenuItem(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.file.save", (String)"Save file"));
                HTTPLiveHeaderScripter.this.menImportHTTPLive = new JMenuItem(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.file.importhhtplive", (String)"Import Firefox LiveHeader Script"));
                HTTPLiveHeaderScripter.this.menImportJDLH = new JMenuItem(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.file.importjdlh", (String)"Import JD-LiveHeader Script"));
                HTTPLiveHeaderScripter.this.menImportFile.addActionListener((ActionListener)((Object)HTTPLiveHeaderScripter.this));
                HTTPLiveHeaderScripter.this.menSave.addActionListener((ActionListener)((Object)HTTPLiveHeaderScripter.this));
                HTTPLiveHeaderScripter.this.menImportHTTPLive.addActionListener((ActionListener)((Object)HTTPLiveHeaderScripter.this));
                HTTPLiveHeaderScripter.this.menImportJDLH.addActionListener((ActionListener)((Object)HTTPLiveHeaderScripter.this));
                menFile.add(HTTPLiveHeaderScripter.this.menImportFile);
                menFile.add(HTTPLiveHeaderScripter.this.menSave);
                menFile.add(new JSeparator());
                menFile.add(HTTPLiveHeaderScripter.this.menImportHTTPLive);
                menFile.add(HTTPLiveHeaderScripter.this.menImportJDLH);
                JMenu menEdit = new JMenu(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.edit", (String)"Edit"));
                HTTPLiveHeaderScripter.this.menEditValidate = new JMenuItem(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.edit.validate", (String)"Validate current script"));
                HTTPLiveHeaderScripter.this.menEditAddRequest = new JMenuItem(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.edit.addrequest", (String)"Add request tag"));
                HTTPLiveHeaderScripter.this.menEditAddDefine = new JMenuItem(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.edit.adddefine", (String)"Add define tag"));
                HTTPLiveHeaderScripter.this.menEditAddWait = new JMenuItem(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.edit.addwait", (String)"Add wait tag"));
                HTTPLiveHeaderScripter.this.menEditValidate.addActionListener((ActionListener)((Object)HTTPLiveHeaderScripter.this));
                HTTPLiveHeaderScripter.this.menEditAddRequest.addActionListener((ActionListener)((Object)HTTPLiveHeaderScripter.this));
                HTTPLiveHeaderScripter.this.menEditAddDefine.addActionListener((ActionListener)((Object)HTTPLiveHeaderScripter.this));
                HTTPLiveHeaderScripter.this.menEditAddWait.addActionListener((ActionListener)((Object)HTTPLiveHeaderScripter.this));
                menEdit.add(HTTPLiveHeaderScripter.this.menEditValidate);
                menEdit.add(new JSeparator());
                menEdit.add(HTTPLiveHeaderScripter.this.menEditAddRequest);
                menEdit.add(HTTPLiveHeaderScripter.this.menEditAddDefine);
                menEdit.add(HTTPLiveHeaderScripter.this.menEditAddWait);
                JMenu menHelp = new JMenu(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.help", (String)"Help"));
                HTTPLiveHeaderScripter.this.menHelpWiki = new JMenuItem(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.menu.help.wiki", (String)"Howto"));
                HTTPLiveHeaderScripter.this.menHelpWiki.addActionListener((ActionListener)((Object)HTTPLiveHeaderScripter.this));
                menHelp.add(HTTPLiveHeaderScripter.this.menHelpWiki);
                menuBar.add(menFile);
                menuBar.add(menEdit);
                menuBar.add(menHelp);
            }
        };
        this.tabbedPanel.getBroadcaster().addListener((EventListener)new SwitchPanelListener(){

            public void onPanelEvent(SwitchPanelEvent event) {
                switch (event.getID()) {
                    case 3: {
                        HTTPLiveHeaderScripter.this.action.setSelected(false);
                    }
                }
            }
        });
        this.tabbedPanel.init();
        this.textArea = new JTextArea();
        this.textArea.setText("[[[HSRC]]]\r\n\r\n\r\n[[[/HSRC]]]");
        this.textArea.setEditable(true);
        this.textArea.requestFocusInWindow();
        SwitchPanel sp = new SwitchPanel(){
            private static final long serialVersionUID = -258117300311991599L;

            protected void onHide() {
            }

            protected void onShow() {
            }
        };
        sp.setLayout((LayoutManager)new MigLayout("ins 0", "[grow, fill]", "[grow, fill]"));
        sp.add((Component)new JScrollPane(this.textArea));
        this.tabbedPanel.setContent(sp);
    }

    public void onExit() {
    }

    private void importFF() {
        String script = UserIO.getInstance().requestTextAreaDialog(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.importff.title", (String)"Import Firefox Live header Log"), JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.importff.message", (String)"Insert your firefox Liveaheader Log here"), null);
        script = this.convertFF(script);
        this.textArea.setText(script);
    }

    private void importLHScript() {
        String[] data = ImportRouterDialog.showDialog();
        if (data != null) {
            if (data[2].toLowerCase().indexOf("curl") >= 0) {
                UserIO.getInstance().requestMessageDialog(JDL.L((String)"gui.config.liveHeader.warning.noCURLConvert", (String)"JD could not convert this curl-batch to a Live-Header Script. Please consult your JD-Support Team!"));
            }
            this.textArea.setText(data[2]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validate() {
        String script = this.textArea.getText();
        if (script == null) {
            UserIO.getInstance().requestMessageDialog(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.validate.error", (String)"Script not valid"));
            return false;
        }
        script = script.replaceAll("\\[\\[\\[", "<");
        script = script.replaceAll("\\]\\]\\]", ">");
        script = script.replaceAll("<REQUEST>", "<REQUEST><![CDATA[");
        script = script.replaceAll("</REQUEST>", "]]></REQUEST>");
        script = script.replaceAll("<RESPONSE(.*?)>", "<RESPONSE$1><![CDATA[");
        script = script.replaceAll("</RESPONSE.*>", "]]></RESPONSE>");
        try {
            Document xmlScript = JDUtilities.parseXmlString((String)script, (boolean)false);
            Node root = xmlScript.getChildNodes().item(0);
            if (root == null || !root.getNodeName().equalsIgnoreCase("HSRC")) {
                String error = "Root Node must be [[[HSRC]]]*[/HSRC]";
                UserIO.getInstance().requestMessageDialog(String.valueOf(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.validate.error", (String)"Script not valid:")) + error);
                return false;
            }
            NodeList steps = root.getChildNodes();
            int step = 0;
            while (true) {
                if (step >= steps.getLength()) {
                    return true;
                }
                Node current = steps.item(step);
                if (current.getNodeType() != 3 && !current.getNodeName().equalsIgnoreCase("STEP")) {
                    String error = "Root Node should only contain [[[STEP]]]*[[[/STEP]]] ChildTag: " + current.getNodeName();
                    UserIO.getInstance().requestMessageDialog(String.valueOf(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.validate.error", (String)"Script not valid:")) + error);
                    return false;
                }
                ++step;
            }
        }
        catch (Exception e) {
            String error = e.getMessage();
            UserIO.getInstance().requestMessageDialog(String.valueOf(JDL.L((String)"plugins.optional.httpliveheaderscripter.gui.validate.error", (String)"Script not valid:")) + error);
            return false;
        }
    }
}

