/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import jd.JDInit;
import jd.PluginWrapper;
import jd.config.container.JDLabelContainer;
import jd.controlling.JDLogger;
import jd.nutils.Formatter;
import jd.plugins.PluginForHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostPluginWrapper
extends PluginWrapper
implements JDLabelContainer {
    private static final ArrayList<HostPluginWrapper> HOST_WRAPPER = new ArrayList();
    private static boolean uninitialized = true;
    public static Object LOCK = new Object();
    private static final String AGB_CHECKED = "AGB_CHECKED";
    private String revision = "idle";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<HostPluginWrapper> getHostWrapper() {
        Object object = LOCK;
        synchronized (object) {
            if (uninitialized) {
                try {
                    JDInit.loadPluginForHost();
                }
                catch (Throwable throwable) {
                    JDLogger.exception(throwable);
                }
                uninitialized = false;
            }
            return HOST_WRAPPER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostPluginWrapper(String string, String string2, String string3, String string4, int n, String string5) {
        super(string, string2, string3, string4, n);
        this.revision = Formatter.getRevision((String)string5);
        Object object = LOCK;
        synchronized (object) {
            HOST_WRAPPER.add(this);
        }
    }

    public HostPluginWrapper(String string, String string2, String string3, int n, String string4) {
        this(string, "jd.plugins.hoster.", string2, string3, n, string4);
    }

    @Override
    public String getVersion() {
        return this.revision;
    }

    @Override
    public PluginForHost getPlugin() {
        return (PluginForHost)super.getPlugin();
    }

    public boolean isAGBChecked() {
        return super.getPluginConfig().getBooleanProperty(AGB_CHECKED, false);
    }

    public void setAGBChecked(Boolean bl) {
        super.getPluginConfig().setProperty(AGB_CHECKED, bl);
        super.getPluginConfig().save();
    }

    public boolean isPremiumEnabled() {
        return this.isLoaded() && this.getPlugin().isPremiumEnabled();
    }

    @Override
    public int compareTo(PluginWrapper pluginWrapper) {
        if (!(pluginWrapper instanceof HostPluginWrapper)) {
            return super.compareTo(pluginWrapper);
        }
        HostPluginWrapper hostPluginWrapper = (HostPluginWrapper)pluginWrapper;
        if (this.isLoaded() && hostPluginWrapper.isLoaded()) {
            if (this.isPremiumEnabled() && hostPluginWrapper.isPremiumEnabled()) {
                return this.getHost().compareToIgnoreCase(hostPluginWrapper.getHost());
            }
            if (this.isPremiumEnabled() && !hostPluginWrapper.isPremiumEnabled()) {
                return -1;
            }
            if (!this.isPremiumEnabled() && hostPluginWrapper.isPremiumEnabled()) {
                return 1;
            }
        }
        if (this.isLoaded() && !hostPluginWrapper.isLoaded() && this.isPremiumEnabled()) {
            return -1;
        }
        if (!this.isLoaded() && hostPluginWrapper.isLoaded() && hostPluginWrapper.isPremiumEnabled()) {
            return 1;
        }
        return this.getHost().compareToIgnoreCase(hostPluginWrapper.getHost());
    }

    public String toString() {
        return this.getHost();
    }

    public static boolean hasPlugin(String string) {
        for (HostPluginWrapper hostPluginWrapper : HostPluginWrapper.getHostWrapper()) {
            if (!hostPluginWrapper.canHandle(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ImageIcon getIcon() {
        return this.getPlugin().getHosterIcon();
    }

    @Override
    public String getLabel() {
        return this.toString();
    }
}

