/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jd.CPluginWrapper;
import jd.DecryptPluginWrapper;
import jd.HostPluginWrapper;
import jd.Installer;
import jd.OptionalPluginWrapper;
import jd.config.Configuration;
import jd.config.DatabaseConnector;
import jd.config.SubConfiguration;
import jd.controlling.AccountController;
import jd.controlling.ByteBufferController;
import jd.controlling.DownloadController;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.PasswordListController;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.UserIF;
import jd.gui.UserIO;
import jd.gui.swing.SwingGui;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.events.EDTEventQueue;
import jd.gui.swing.laf.LookAndFeelController;
import jd.http.Browser;
import jd.http.JDProxy;
import jd.nutils.ClassFinder;
import jd.nutils.JDFlags;
import jd.nutils.OSDetector;
import jd.nutils.encoding.Encoding;
import jd.nutils.io.JDIO;
import jd.plugins.DecrypterPlugin;
import jd.plugins.HostPlugin;
import jd.plugins.OptionalPlugin;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class JDInit {
    private static final boolean TEST_INSTALLER = false;
    private static Logger logger = JDLogger.getLogger();
    private static ClassLoader CL;
    private boolean installerVisible = false;

    public void checkUpdate() {
        String string;
        if (JDUtilities.getResourceFile("webcheck.tmp").exists() && JDIO.readFileToString((File)JDUtilities.getResourceFile("webcheck.tmp")).indexOf("(Revision" + JDUtilities.getRevision() + ")") > 0) {
            UserIO.getInstance().requestTextAreaDialog("Error", "Failed Update detected!", "It seems that the previous webupdate failed.\r\nPlease ensure that your java-version is equal- or above 1.5.\r\nMore infos at http://www.syncom.org/projects/jdownloader/wiki/FAQ.\r\n\r\nErrorcode: \r\n" + JDIO.readFileToString((File)JDUtilities.getResourceFile("webcheck.tmp")));
            JDUtilities.getResourceFile("webcheck.tmp").delete();
            JDUtilities.getConfiguration().setProperty("WEBUPDATE_AUTO_RESTART", false);
        }
        if (JDUtilities.getRunType() == 2 && !(string = JDUtilities.getConfiguration().getStringProperty("UPDATE_VERSION", "")).equals(JDUtilities.getRevision())) {
            logger.info("Detected that JD just got updated");
            JDUtilities.getController().fireControlEvent(new ControlEvent(this, 0));
            int n = UserIO.getInstance().requestHelpDialog(16, JDL.LF("system.update.message.title", "Updated to version %s", JDUtilities.getRevision()), JDL.L("system.update.message", "Update successfull"), JDL.L("system.update.showchangelogv2", "What's new?"), "http://jdownloader.org/changes/index");
            if (JDFlags.hasAllFlags((int)n, (int[])new int[]{2}) && JDUtilities.getConfiguration().getBooleanProperty("WEBUPDATE_AUTO_SHOW_CHANGELOG", true).booleanValue()) {
                try {
                    JLink.openURL((String)"http://jdownloader.org/changes/index");
                }
                catch (Exception exception) {
                    JDLogger.exception(exception);
                }
            }
        }
        this.submitVersion();
    }

    private void submitVersion() {
        new Thread(new Runnable(){

            public void run() {
                if (JDUtilities.getRunType() == 2) {
                    String string = "unk";
                    if (OSDetector.isLinux()) {
                        string = "lin";
                    } else if (OSDetector.isMac()) {
                        string = "mac";
                    } else if (OSDetector.isWindows()) {
                        string = "win";
                    }
                    String string2 = System.getProperty("user.timezone");
                    if (string2 == null) {
                        string2 = "unknown";
                    }
                    Browser browser = new Browser();
                    browser.setConnectTimeout(15000);
                    if (!JDUtilities.getConfiguration().getStringProperty("UPDATE_VERSION", "").equals(JDUtilities.getRevision())) {
                        try {
                            String string3 = JDUtilities.getConfiguration().getStringProperty("UPDATE_VERSION", "");
                            string3 = string3 == null || string3.length() < 3 ? "0" : string3.replaceAll(",|\\.", "");
                            browser.postPage("http://service.jdownloader.org/tools/s.php", "v=" + JDUtilities.getRevision().replaceAll(",|\\.", "") + "&p=" + string3 + "&os=" + string + "&tz=" + Encoding.urlEncode((String)string2));
                            JDUtilities.getConfiguration().setProperty("UPDATE_VERSION", JDUtilities.getRevision());
                            JDUtilities.getConfiguration().save();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }).start();
    }

    public void init() {
        this.initBrowser();
    }

    public void initBrowser() {
        JDProxy jDProxy;
        String string;
        String string2;
        Browser.setLogger((Logger)JDLogger.getLogger());
        Browser.init();
        Browser.setGlobalReadTimeout((int)SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_READ_TIMEOUT_V3", 100000));
        Browser.setGlobalConnectTimeout((int)SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_CONNECT_TIMEOUT_V3", 100000));
        if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("USE_PROXY", false).booleanValue()) {
            string2 = SubConfiguration.getConfig("DOWNLOAD").getStringProperty("PROXY_HOST", "");
            int n = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("PROXY_PORT", 8080);
            string = SubConfiguration.getConfig("DOWNLOAD").getStringProperty("PROXY_USER", "");
            String string3 = SubConfiguration.getConfig("DOWNLOAD").getStringProperty("PROXY_PASS", "");
            if (string2.trim().equals("")) {
                JDLogger.getLogger().warning("Proxy disabled. No host");
                SubConfiguration.getConfig("DOWNLOAD").setProperty("USE_PROXY", false);
                return;
            }
            jDProxy = new JDProxy(Proxy.Type.HTTP, string2, n);
            if (string != null && string.trim().length() > 0) {
                jDProxy.setUser(string);
            }
            if (string3 != null && string3.trim().length() > 0) {
                jDProxy.setPass(string3);
            }
            Browser.setGlobalProxy((JDProxy)jDProxy);
        }
        if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("USE_SOCKS", false).booleanValue()) {
            string2 = SubConfiguration.getConfig("DOWNLOAD").getStringProperty("PROXY_USER_SOCKS", "");
            String string4 = SubConfiguration.getConfig("DOWNLOAD").getStringProperty("PROXY_PASS_SOCKS", "");
            string = SubConfiguration.getConfig("DOWNLOAD").getStringProperty("SOCKS_HOST", "");
            int n = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("SOCKS_PORT", 1080);
            if (string.trim().equals("")) {
                JDLogger.getLogger().warning("Socks Proxy disabled. No host");
                SubConfiguration.getConfig("DOWNLOAD").setProperty("USE_SOCKS", false);
                return;
            }
            jDProxy = new JDProxy(Proxy.Type.SOCKS, string, n);
            if (string2 != null && string2.trim().length() > 0) {
                jDProxy.setUser(string2);
            }
            if (string4 != null && string4.trim().length() > 0) {
                jDProxy.setPass(string4);
            }
            Browser.setGlobalProxy((JDProxy)jDProxy);
        }
        Browser.init();
    }

    public void initControllers() {
        DownloadController.getInstance();
        PasswordListController.getInstance();
        DownloadController.getInstance().addListener(PasswordListController.getInstance());
        AccountController.getInstance();
        ByteBufferController.getInstance();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    if (DatabaseConnector.isDatabaseShutdown()) {
                        System.out.println("ShutDownHook: normal shutdown event, nothing to do.");
                        return;
                    }
                    System.out.println("ShutDownHook: unexpected shutdown event, hurry up and save database!");
                    JDController.getInstance().prepareShutdown(true);
                    System.out.println("ShutDownHook: unexpected shutdown event, could finish saving database!");
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        });
    }

    public void initGUI(JDController jDController) {
        LookAndFeelController.setUIManager();
        Toolkit.getDefaultToolkit().getSystemEventQueue().push((EventQueue)new EDTEventQueue());
        SwingGui.setInstance((SwingGui)JDGui.getInstance());
        UserIF.setInstance((UserIF)SwingGui.getInstance());
        jDController.addControlListener((ControlListener)SwingGui.getInstance());
    }

    public void initPlugins() {
        try {
            this.movePluginUpdates(JDUtilities.getResourceFile("update"));
        }
        catch (Throwable throwable) {
            JDLogger.exception(throwable);
        }
        try {
            this.loadCPlugins();
            this.loadPluginOptional();
            for (OptionalPluginWrapper optionalPluginWrapper : OptionalPluginWrapper.getOptionalWrapper()) {
                if (!optionalPluginWrapper.isLoaded()) continue;
                try {
                    if (!optionalPluginWrapper.isEnabled() || optionalPluginWrapper.getPlugin().initAddon()) continue;
                    logger.severe("Error loading Optional Plugin:" + optionalPluginWrapper.getClassName());
                }
                catch (Throwable throwable) {
                    logger.severe("Error loading Optional Plugin: " + throwable.getMessage());
                    JDLogger.exception(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            JDLogger.exception(throwable);
        }
    }

    private void movePluginUpdates(File file) {
        if (!JDUtilities.getResourceFile("update").exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                this.movePluginUpdates(file2);
            } else {
                File file3 = JDUtilities.getResourceFile("update");
                File file4 = file3.getParentFile();
                String string = JDUtilities.getResourceFile("update").getAbsolutePath();
                string = file2.getAbsolutePath().replace(string, "").substring(1);
                File file5 = new File(file4, string).getAbsoluteFile();
                logger.info("./update -> real  " + string + " ->" + file5.getAbsolutePath());
                logger.info("Exists: " + file5.exists());
                if (!file5.getParentFile().exists()) {
                    logger.info("Parent Exists: false");
                    if (file5.getParentFile().mkdirs()) {
                        logger.info("^^CREATED");
                    } else {
                        logger.info("^^CREATION FAILED");
                    }
                }
                file5.delete();
                file2.renameTo(file5);
                File file6 = file5.getParentFile();
                while (file6.listFiles().length == 0) {
                    file6.delete();
                    file6 = file6.getParentFile();
                }
            }
            ++n2;
        }
        if (file.list() != null && file.list().length == 0) {
            file.delete();
        }
    }

    public boolean installerWasVisible() {
        return this.installerVisible;
    }

    public Configuration loadConfiguration() {
        Object object = JDUtilities.getDatabaseConnector().getData("jdownloaderconfig");
        if (object == null) {
            logger.finest("Fresh install?");
        }
        if (object != null && ((Configuration)object).getStringProperty("DOWNLOAD_DIRECTORY") != null) {
            Configuration configuration = (Configuration)object;
            JDUtilities.setConfiguration(configuration);
            JDLogger.getLogger().setLevel(configuration.getGenericProperty("LOGGER_LEVEL3", Level.WARNING));
            JDTheme.setTheme(GUIUtils.getConfig().getStringProperty("THEME2", "default"));
        } else {
            File file = JDUtilities.getResourceFile("config");
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    System.err.println("Could not create configdir");
                    return null;
                }
                if (!file.canWrite()) {
                    System.err.println("Cannot write to configdir");
                    return null;
                }
            }
            Configuration configuration = new Configuration();
            JDUtilities.setConfiguration(configuration);
            JDLogger.getLogger().setLevel(configuration.getGenericProperty("LOGGER_LEVEL3", Level.WARNING));
            JDTheme.setTheme(GUIUtils.getConfig().getStringProperty("THEME2", "default"));
            JDUtilities.getDatabaseConnector().saveConfiguration("jdownloaderconfig", JDUtilities.getConfiguration());
            this.installerVisible = true;
            JDUtilities.getController().fireControlEvent(new ControlEvent(this, 0));
            LookAndFeelController.setUIManager();
            Installer installer = new Installer();
            if (!installer.isAborted()) {
                File file2 = JDUtilities.getResourceFile(".");
                if (file2.canWrite()) {
                    JDUtilities.getResourceFile("noupdate.txt").exists();
                }
                if (!file2.canWrite()) {
                    logger.severe("INSTALL abgebrochen");
                    UserIO.getInstance().requestMessageDialog(JDL.L("installer.error.noWriteRights", "Error. You do not have permissions to write to the dir"));
                    JDIO.removeDirectoryOrFile((File)JDUtilities.getResourceFile("config"));
                    System.exit(1);
                }
            } else {
                logger.severe("INSTALL abgebrochen2");
                UserIO.getInstance().requestMessageDialog(JDL.L("installer.abortInstallation", "Error. User aborted installation."));
                JDIO.removeDirectoryOrFile((File)JDUtilities.getResourceFile("config"));
                System.exit(0);
            }
        }
        return JDUtilities.getConfiguration();
    }

    public void loadCPlugins() {
        try {
            new CPluginWrapper("ccf", "C", ".+\\.ccf");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            new CPluginWrapper("rsdf", "R", ".+\\.rsdf");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            new CPluginWrapper("dlc", "D", ".+\\.dlc");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            new CPluginWrapper("jdc", "J", ".+\\.jdc");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            new CPluginWrapper("metalink", "MetaLink", ".+\\.metalink");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void loadPluginForDecrypt() {
        try {
            for (Class clazz : ClassFinder.getClasses((String)"jd.plugins.decrypter", (ClassLoader)JDInit.getPluginClassLoader())) {
                try {
                    SubConfiguration subConfiguration;
                    logger.finest("Try to load " + clazz);
                    if (clazz == null || clazz.getAnnotations().length <= 0) continue;
                    DecrypterPlugin decrypterPlugin = (DecrypterPlugin)clazz.getAnnotations()[0];
                    if (decrypterPlugin.interfaceVersion() != 2) {
                        logger.warning("Outdated Plugin found: " + decrypterPlugin);
                        continue;
                    }
                    String[] stringArray = decrypterPlugin.names();
                    String[] stringArray2 = decrypterPlugin.urls();
                    int[] nArray = decrypterPlugin.flags();
                    String string = "";
                    if (stringArray.length == 0) {
                        subConfiguration = SubConfiguration.getConfig("jd.JDInit.loadPluginForDecrypt");
                        stringArray = subConfiguration.getGenericProperty(String.valueOf(clazz.getName()) + "_names_" + string + decrypterPlugin.revision(), stringArray);
                        stringArray2 = subConfiguration.getGenericProperty(String.valueOf(clazz.getName()) + "_pattern_" + string + decrypterPlugin.revision(), stringArray2);
                        nArray = subConfiguration.getGenericProperty(String.valueOf(clazz.getName()) + "_flags_" + string + decrypterPlugin.revision(), nArray);
                    }
                    if (stringArray.length == 0) {
                        stringArray = (String[])clazz.getMethod("getAnnotationNames", new Class[0]).invoke(null, new Object[0]);
                        stringArray2 = (String[])clazz.getMethod("getAnnotationUrls", new Class[0]).invoke(null, new Object[0]);
                        nArray = (int[])clazz.getMethod("getAnnotationFlags", new Class[0]).invoke(null, new Object[0]);
                        subConfiguration = SubConfiguration.getConfig("jd.JDInit.loadPluginForDecrypt");
                        subConfiguration.setProperty(String.valueOf(clazz.getName()) + "_names_" + decrypterPlugin.revision(), stringArray);
                        subConfiguration.setProperty(String.valueOf(clazz.getName()) + "_pattern_" + decrypterPlugin.revision(), stringArray2);
                        subConfiguration.setProperty(String.valueOf(clazz.getName()) + "_flags_" + decrypterPlugin.revision(), nArray);
                        subConfiguration.save();
                    }
                    int n = 0;
                    while (n < stringArray.length) {
                        try {
                            new DecryptPluginWrapper(stringArray[n], clazz.getSimpleName(), stringArray2[n], nArray[n], decrypterPlugin.revision());
                            System.out.println("Add decrypter for " + stringArray[n]);
                        }
                        catch (Throwable throwable) {
                            JDLogger.exception(throwable);
                        }
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    JDLogger.exception(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            JDLogger.exception(throwable);
        }
    }

    private static ClassLoader getPluginClassLoader() {
        if (CL == null) {
            try {
                CL = JDUtilities.getRunType() == 2 ? new URLClassLoader(new URL[]{JDUtilities.getJDHomeDirectoryFromEnvironment().toURI().toURL(), JDUtilities.getResourceFile("java").toURI().toURL()}, Thread.currentThread().getContextClassLoader()) : Thread.currentThread().getContextClassLoader();
            }
            catch (MalformedURLException malformedURLException) {
                JDLogger.exception(malformedURLException);
            }
        }
        return CL;
    }

    public static void loadPluginForHost() {
        try {
            for (Class clazz : ClassFinder.getClasses((String)"jd.plugins.hoster", (ClassLoader)JDInit.getPluginClassLoader())) {
                try {
                    logger.finest("Try to load " + clazz);
                    if (clazz == null || clazz.getAnnotations().length <= 0) continue;
                    HostPlugin hostPlugin = (HostPlugin)clazz.getAnnotations()[0];
                    if (hostPlugin.interfaceVersion() != 2) {
                        logger.warning("Outdated Plugin found: " + hostPlugin);
                        continue;
                    }
                    int n = 0;
                    while (n < hostPlugin.names().length) {
                        try {
                            new HostPluginWrapper(hostPlugin.names()[n], clazz.getSimpleName(), hostPlugin.urls()[n], hostPlugin.flags()[n], hostPlugin.revision());
                        }
                        catch (Throwable throwable) {
                            JDLogger.exception(throwable);
                        }
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    JDLogger.exception(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            JDLogger.exception(throwable);
        }
    }

    public void loadPluginOptional() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (Class clazz : ClassFinder.getClasses((String)"jd.plugins.optional", (ClassLoader)JDUtilities.getJDClassLoader())) {
                try {
                    OptionalPlugin optionalPlugin;
                    if (arrayList.contains(clazz.getName())) {
                        System.out.println("Already loaded:" + clazz);
                        continue;
                    }
                    if (clazz.getAnnotations().length <= 0 || !((optionalPlugin = (OptionalPlugin)clazz.getAnnotations()[0]).windows() && OSDetector.isWindows() || optionalPlugin.linux() && OSDetector.isLinux()) && (!optionalPlugin.mac() || !OSDetector.isMac()) || !(JDUtilities.getJavaVersion() >= optionalPlugin.minJVM()) || 5 != optionalPlugin.interfaceversion()) continue;
                    logger.finest("Init PluginWrapper!");
                    new OptionalPluginWrapper(clazz, optionalPlugin);
                    arrayList.add(clazz.getName());
                }
                catch (Throwable throwable) {
                    JDLogger.exception(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            JDLogger.exception(throwable);
        }
    }
}

