/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import jd.JDClassLoader;
import jd.PluginWrapper;
import jd.controlling.JDLogger;
import jd.nutils.Formatter;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginOptional;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionalPluginWrapper
extends PluginWrapper {
    private static final ArrayList<OptionalPluginWrapper> OPTIONAL_WRAPPER = new ArrayList();
    private double version;
    private String id;
    private String name;
    private String revision;
    private OptionalPlugin annotation;

    public static ArrayList<OptionalPluginWrapper> getOptionalWrapper() {
        return OPTIONAL_WRAPPER;
    }

    public OptionalPluginWrapper(Class<?> clazz, OptionalPlugin optionalPlugin) {
        super(clazz.getName(), null, clazz.getName(), null, 0);
        this.id = optionalPlugin.id();
        this.revision = Formatter.getRevision((String)optionalPlugin.rev());
        this.version = optionalPlugin.minJVM();
        this.name = JDL.L(clazz.getName(), clazz.getSimpleName());
        this.annotation = optionalPlugin;
        try {
            this.logger.finer("OPTIONAL loaded " + optionalPlugin);
            OPTIONAL_WRAPPER.add(this);
            if (this.isEnabled()) {
                this.getPlugin();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public OptionalPlugin getAnnotation() {
        return this.annotation;
    }

    public double getJavaVersion() {
        return this.version;
    }

    @Override
    public String getHost() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.revision;
    }

    @Override
    public PluginOptional getPlugin() {
        if (!OPTIONAL_WRAPPER.contains(this)) {
            return null;
        }
        if (this.loadedPlugin == null) {
            this.loadPlugin();
        }
        return (PluginOptional)this.loadedPlugin;
    }

    private PluginOptional loadPlugin() {
        Class<?> clazz;
        block6: {
            JDClassLoader jDClassLoader = JDUtilities.getJDClassLoader();
            Double d = JDUtilities.getJavaVersion();
            if (d < this.version) {
                this.logger.finer("Plugin " + this.getClassName() + " requires Java Version " + this.version + " your Version is: " + d);
                return null;
            }
            this.logger.finer("Try to initialize " + this.getClassName());
            clazz = jDClassLoader.loadClass(this.getClassName());
            if (clazz != null) break block6;
            this.logger.info("PLUGIN NOT FOUND!");
            return null;
        }
        try {
            Class[] classArray = new Class[]{PluginWrapper.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            try {
                this.loadedPlugin = (PluginOptional)constructor.newInstance(this);
                this.logger.finer("Successfully loaded " + this.getClassName());
                return (PluginOptional)this.loadedPlugin;
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
                this.logger.severe("Addon " + this.getClassName() + " is outdated and incompatible. Please update(Packagemanager) :" + exception.getLocalizedMessage());
            }
        }
        catch (Exception exception) {
            this.logger.info("Plugin Exception!");
            JDLogger.exception(exception);
        }
        return null;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getConfigParamKey() {
        return "OPTIONAL_PLUGIN2_" + this.id;
    }

    @Override
    public int compareTo(PluginWrapper pluginWrapper) {
        return this.getHost().toLowerCase().compareTo(pluginWrapper.getHost().toLowerCase());
    }

    @Override
    public boolean isEnabled() {
        return JDUtilities.getConfiguration().getBooleanProperty(this.getConfigParamKey(), this.annotation.defaultEnabled());
    }
}

