/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.JDInitFlags;
import jd.config.SubConfiguration;
import jd.controlling.DownloadController;
import jd.controlling.JDLogger;
import jd.nutils.JDFlags;
import jd.plugins.Plugin;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginWrapper
implements Comparable<PluginWrapper> {
    public static final int LOAD_ON_INIT = 2;
    public static final int PATTERN_ACCEPTS_INVALID_URI = 4;
    public static final int ALWAYS_ENABLED = 8;
    public static final int CNL_2 = 16;
    public static final int DEBUG_ONLY = 16;
    private Pattern pattern;
    private String host;
    private String className;
    protected Logger logger = JDLogger.getLogger();
    protected Plugin loadedPlugin = null;
    private boolean acceptOnlyURIs = true;
    private boolean alwaysenabled = false;
    private int flags;
    private static URLClassLoader CL;
    private static final HashMap<String, PluginWrapper> WRAPPER;

    static {
        WRAPPER = new HashMap();
    }

    public PluginWrapper(String string, String string2, String string3, String string4, int n) {
        String string5 = String.valueOf(string2 == null ? "" : string2) + string3;
        if (string4 != null) {
            this.pattern = Pattern.compile(string4, 2);
        }
        this.host = string.toLowerCase();
        this.className = string5;
        this.flags = n;
        if (JDFlags.hasSomeFlags((int)n, (int[])new int[]{2})) {
            this.getPlugin();
        }
        if (JDFlags.hasSomeFlags((int)n, (int[])new int[]{8})) {
            this.alwaysenabled = true;
        }
        if (JDFlags.hasSomeFlags((int)n, (int[])new int[]{4})) {
            this.acceptOnlyURIs = false;
        }
        if (JDFlags.hasNoFlags((int)n, (int[])new int[]{16}) || JDInitFlags.SWITCH_DEBUG) {
            WRAPPER.put(string5, this);
        }
    }

    public String getID() {
        return this.getHost();
    }

    public synchronized Plugin getPlugin() {
        Class<?> clazz;
        block7: {
            if (this.loadedPlugin != null) {
                return this.loadedPlugin;
            }
            try {
                if (CL == null) {
                    CL = new URLClassLoader(new URL[]{JDUtilities.getJDHomeDirectoryFromEnvironment().toURI().toURL(), JDUtilities.getResourceFile("java").toURI().toURL()}, Thread.currentThread().getContextClassLoader());
                }
                this.logger.finer("load plugin: " + this.getClassName());
                try {
                    clazz = CL.loadClass(this.getClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.severe("Fallback cloassloader used");
                    clazz = JDUtilities.getJDClassLoader().loadClass(this.getClassName());
                }
                if (clazz != null) break block7;
                this.logger.severe("PLUGIN " + this.getClassName() + "NOT FOUND!");
                return null;
            }
            catch (Exception exception) {
                this.logger.severe("Plugin Exception!");
                JDLogger.exception(exception);
                return null;
            }
        }
        Class[] classArray = new Class[]{PluginWrapper.class};
        Constructor<?> constructor = clazz.getConstructor(classArray);
        classArray = null;
        this.loadedPlugin = (Plugin)constructor.newInstance(this);
        return this.loadedPlugin;
    }

    public abstract String getVersion();

    public String getCoder() {
        return this.loadedPlugin != null ? this.loadedPlugin.getCoder() : JDL.L("plugin.system.notloaded", "idle");
    }

    public boolean isEnabled() {
        return this.alwaysenabled || this.getPluginConfig().getBooleanProperty("USE_PLUGIN", true) != false;
    }

    public void setEnabled(boolean bl) {
        if (this.alwaysenabled) {
            return;
        }
        this.getPluginConfig().setProperty("USE_PLUGIN", bl);
        this.getPluginConfig().save();
        if (JDUtilities.getController() != null) {
            DownloadController.getInstance().fireGlobalUpdate();
        }
    }

    public boolean canHandle(String string) {
        Matcher matcher;
        if (this.isLoaded()) {
            return this.getPlugin().canHandle(string);
        }
        if (string == null) {
            return false;
        }
        Pattern pattern = this.getPattern();
        return pattern != null && (matcher = pattern.matcher(string)).find();
    }

    public boolean isLoaded() {
        return this.loadedPlugin != null;
    }

    public SubConfiguration getPluginConfig() {
        return SubConfiguration.getConfig(this.getHost());
    }

    public Plugin getNewPluginInstance() {
        try {
            return (Plugin)this.getPlugin().getClass().getConstructor(PluginWrapper.class).newInstance(this);
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    public boolean hasConfig() {
        return this.isLoaded() && !this.getPlugin().getConfig().getEntries().isEmpty();
    }

    @Override
    public int compareTo(PluginWrapper pluginWrapper) {
        return this.getHost().toLowerCase().compareTo(pluginWrapper.getHost().toLowerCase());
    }

    public String getConfigName() {
        return this.getHost();
    }

    public static PluginWrapper getWrapper(String string) {
        return WRAPPER.get(string);
    }

    public static Plugin getNewInstance(String string) {
        if (!WRAPPER.containsKey(string)) {
            try {
                throw new Exception("plugin " + string + " could not be found");
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
                return null;
            }
        }
        return WRAPPER.get(string).getNewPluginInstance();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isAlwaysenabled() {
        return this.alwaysenabled;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isAcceptOnlyURIs() {
        return this.acceptOnlyURIs;
    }
}

