/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ImageIcon;
import jd.config.ConfigContainer;
import jd.config.ConfigGroup;
import jd.config.Property;
import jd.controlling.ListController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigEntry
implements Serializable {
    private static final long serialVersionUID = 7422046260361380162L;
    private ActionListener actionListener;
    private boolean changes;
    private ConfigEntry conditionEntry;
    private Boolean compareValue;
    private ConfigContainer container;
    private transient ListController controller;
    private Object defaultValue;
    private String description;
    private boolean enabled = true;
    private int end;
    private ConfigGroup group;
    private PropertyChangeListener guiListener;
    private String helptags = null;
    private ImageIcon imageIcon;
    private String label;
    private Object[] list;
    private Vector<ConfigEntry> listener = new Vector();
    private Property propertyInstance;
    private String propertyName;
    private PropertyType propertyType = PropertyType.NORMAL;
    private int start;
    private int step = 1;
    private int type;

    public ConfigEntry(int n) {
        this.type = n;
    }

    public ConfigEntry(int n, ActionListener actionListener, String string, String string2, ImageIcon imageIcon) {
        this.type = n;
        this.label = string;
        this.imageIcon = imageIcon;
        this.description = string2;
        this.actionListener = actionListener;
        this.enabled = true;
    }

    public ConfigEntry(int n, ConfigContainer configContainer) {
        this.type = n;
        this.container = configContainer;
        this.enabled = true;
    }

    public ConfigEntry(int n, ListController listController, String string) {
        this.type = n;
        this.label = string;
        this.controller = listController;
        this.propertyName = "ListControlled";
        this.enabled = true;
    }

    public ConfigEntry(int n, Property property, String string, int n2) {
        this.type = n;
        this.propertyName = string;
        this.propertyInstance = property;
        this.end = n2;
    }

    public ConfigEntry(int n, Property property, String string, Object[] objectArray, String string2) {
        this.type = n;
        this.propertyName = string;
        this.propertyInstance = property;
        this.list = objectArray;
        this.label = string2;
    }

    public ConfigEntry(int n, Property property, String string, String string2) {
        this.type = n;
        this.propertyName = string;
        this.propertyInstance = property;
        this.label = string2;
        this.enabled = true;
    }

    public ConfigEntry(int n, Property property, String string, String string2, int n2, int n3) {
        this.type = n;
        this.propertyName = string;
        this.propertyInstance = property;
        this.label = string2;
        this.start = n2;
        this.end = n3;
    }

    public ConfigEntry(int n, String string) {
        this.type = n;
        this.label = string;
        this.enabled = true;
    }

    public ConfigEntry(int n, String string, String string2) {
        this.type = n;
        this.propertyName = string2;
        this.label = string;
        this.enabled = true;
    }

    public void addListener(ConfigEntry configEntry) {
        if (configEntry != null) {
            this.listener.add(configEntry);
        }
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public ConfigContainer getContainer() {
        return this.container;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public int getEnd() {
        return this.end;
    }

    public ConfigGroup getGroup() {
        return this.group;
    }

    public PropertyChangeListener getGuiListener() {
        return this.guiListener;
    }

    public String getHelptags() {
        if (this.helptags == null) {
            return this.label;
        }
        return this.helptags;
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    public String getLabel() {
        return this.label;
    }

    public Object[] getList() {
        return this.list;
    }

    public ListController getListController() {
        if (this.controller == null) {
            this.controller = new ListController(){

                public String getList() {
                    return "";
                }

                public void setList(String string) {
                }
            };
        }
        return this.controller;
    }

    public Vector<ConfigEntry> getListener() {
        return this.listener;
    }

    public Property getPropertyInstance() {
        return this.propertyInstance;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public int getStart() {
        return this.start;
    }

    public int getStep() {
        return this.step;
    }

    public int getType() {
        return this.type;
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public boolean isConditionalEnabled(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.conditionEntry) {
            return this.compareValue.equals((Boolean)propertyChangeEvent.getNewValue());
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ConfigEntry setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
        return this;
    }

    public void setChanges(boolean bl) {
        this.changes = bl;
    }

    public void setContainer(ConfigContainer configContainer) {
        this.container = configContainer;
    }

    public ConfigEntry setDefaultValue(Object object) {
        this.defaultValue = object;
        return this;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public ConfigEntry setEnabled(boolean bl) {
        this.enabled = bl;
        return this;
    }

    public ConfigEntry setEnabledCondidtion(ConfigEntry configEntry, boolean bl) {
        if (configEntry.getType() != 3) {
            new Exception("Only checkbox-configentries are allowed").printStackTrace();
        }
        this.conditionEntry = configEntry;
        this.compareValue = bl;
        configEntry.addListener(this);
        return this;
    }

    public ConfigEntry setEnd(int n) {
        this.end = n;
        return this;
    }

    public ConfigEntry setGroup(ConfigGroup configGroup) {
        this.group = configGroup;
        return this;
    }

    public void setGuiListener(PropertyChangeListener propertyChangeListener) {
        if (this.guiListener == null) {
            this.guiListener = propertyChangeListener;
        }
    }

    public void setHelptags(String string) {
        this.helptags = string;
    }

    public void setImageIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }

    public ConfigEntry setLabel(String string) {
        this.label = string;
        return this;
    }

    public ConfigEntry setList(Object[] objectArray) {
        this.list = objectArray;
        return this;
    }

    public ConfigEntry setPropertyInstance(Property property) {
        this.propertyInstance = property;
        return this;
    }

    public ConfigEntry setPropertyName(String string) {
        this.propertyName = string;
        return this;
    }

    public ConfigEntry setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    public ConfigEntry setStart(int n) {
        this.start = n;
        return this;
    }

    public ConfigEntry setStep(int n) {
        this.step = n;
        return this;
    }

    public ConfigEntry setType(int n) {
        this.type = n;
        return this;
    }

    public void valueChanged(Object object) {
        for (ConfigEntry configEntry : this.listener) {
            if (configEntry.getGuiListener() == null) continue;
            configEntry.getGuiListener().propertyChange(new PropertyChangeEvent(this, this.getPropertyName(), null, object));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyType {
        NONE,
        NORMAL,
        NEEDS_RESTART;


        public static PropertyType getMax(PropertyType ... propertyTypeArray) {
            PropertyType propertyType;
            ArrayList<PropertyType> arrayList = new ArrayList<PropertyType>();
            PropertyType[] propertyTypeArray2 = propertyTypeArray;
            int n = propertyTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                propertyType = propertyTypeArray2[n2];
                arrayList.add(propertyType);
                ++n2;
            }
            Collections.sort(arrayList);
            propertyType = (PropertyType)((Object)arrayList.get(arrayList.size() - 1));
            return propertyType;
        }

        public PropertyType getMax(PropertyType propertyType) {
            return PropertyType.getMax(propertyType, this);
        }

        public String toString() {
            return this.name();
        }
    }
}

