/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Logger;
import jd.controlling.JDLogger;
import jd.event.ControlEvent;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property
implements Serializable {
    private static final long serialVersionUID = -6093927038856757256L;
    public static final Object NULL = new Object();
    protected transient Logger logger = null;
    private HashMap<String, Object> properties = new HashMap();
    private HashMap<String, Integer> propertiesHashes = new HashMap();
    protected transient boolean changes = false;

    public Property() {
        this.logger = JDLogger.getLogger();
    }

    public Property(String string, Object object) {
        this();
        this.setProperty(string, object);
    }

    public <E> E getGenericProperty(String string, E e) {
        Object object = this.getProperty(string, e);
        try {
            Object object2 = object;
            return (E)object2;
        }
        catch (Exception exception) {
            this.logger.finer("Could not cast " + object.getClass().getSimpleName() + " to " + exception.getClass().getSimpleName() + " for key " + string);
            return e;
        }
    }

    public Boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public Boolean getBooleanProperty(String string, boolean bl) {
        try {
            Object object = this.getProperty(string, bl);
            if (!(object instanceof Boolean)) {
                object = ((String)(object = String.valueOf(object))).equals("false") ? Boolean.valueOf(false) : Boolean.valueOf(((String)object).length() > 0);
            }
            Boolean bl2 = (Boolean)object;
            return bl2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Double getDoubleProperty(String string) {
        return this.getDoubleProperty(string, -1.0);
    }

    public Double getDoubleProperty(String string, Double d) {
        try {
            Object object = this.getProperty(string, d);
            if (object instanceof String) {
                object = Double.parseDouble((String)object);
            }
            Double d2 = (Double)object;
            return d2;
        }
        catch (Exception exception) {
            return d;
        }
    }

    public int getIntegerProperty(String string) {
        return this.getIntegerProperty(string, -1);
    }

    public int getIntegerProperty(String string, int n) {
        try {
            Object object = this.getProperty(string, n);
            if (object instanceof String) {
                object = Integer.parseInt((String)object);
            }
            Integer n2 = (Integer)object;
            return n2;
        }
        catch (Exception exception) {
            return n;
        }
    }

    public HashMap<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties.get(string);
    }

    public Object getProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if (this.properties.get(string) == null) {
            this.setProperty(string, object);
            return object;
        }
        return this.properties.get(string);
    }

    public String getStringProperty(String string) {
        return this.getStringProperty(string, null);
    }

    public String getStringProperty(String string, String string2) {
        try {
            Object object = this.getProperty(string, string2);
            String string3 = object == null ? null : object.toString();
            return string3;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public boolean hasProperty(String string) {
        return this.properties.containsKey(string);
    }

    public void setProperties(HashMap<String, Object> hashMap) {
        this.properties = hashMap;
        this.propertiesHashes = new HashMap();
    }

    public void setProperty(String string, Object object) {
        if (object == NULL) {
            if (this.properties.containsKey(string)) {
                this.properties.remove(string);
                this.propertiesHashes.remove(string);
                JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, string));
                this.changes = true;
            }
            return;
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if (this.propertiesHashes == null) {
            this.propertiesHashes = new HashMap();
        }
        Object object2 = this.getProperty(string);
        this.properties.put(string, object);
        Integer n = this.propertiesHashes.get(string);
        this.propertiesHashes.put(string, object == null ? null : Integer.valueOf(object.toString().hashCode()));
        if (JDUtilities.getController() == null) {
            return;
        }
        try {
            if (object2 == null && object != null) {
                JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, string));
                this.changes = true;
                return;
            }
            if (object instanceof Comparable) {
                if (((Comparable)object).compareTo((Comparable)object2) != 0) {
                    JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, string));
                    this.changes = true;
                }
                return;
            }
            if (!object.equals(object2) || n.intValue() != object.hashCode()) {
                JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, string));
                this.changes = true;
            }
            return;
        }
        catch (Exception exception) {
            JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, string));
            this.changes = true;
            return;
        }
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public String toString() {
        if (this.properties.size() == 0) {
            return "";
        }
        return "Property: " + this.properties;
    }
}

