/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import jd.config.ConfigurationListener;
import jd.config.Property;
import jd.controlling.JDLogger;
import jd.utils.JDUtilities;

public class SubConfiguration
extends Property
implements Serializable {
    private static final long serialVersionUID = 7803718581558607222L;
    private static transient boolean SUBCONFIG_LOCK = false;
    protected String name;
    private transient ArrayList<ConfigurationListener> listener = null;
    private static transient HashMap<String, SubConfiguration> SUB_CONFIGS = new HashMap();

    public void addConfigurationListener(ConfigurationListener configurationListener) {
        if (this.listener == null) {
            this.listener = new ArrayList();
        }
        this.removeConfigurationListener(configurationListener);
        this.listener.add(configurationListener);
    }

    private void fireEventPreSave() {
        if (this.listener == null) {
            return;
        }
        for (ConfigurationListener configurationListener : this.listener) {
            configurationListener.onPreSave(this);
        }
    }

    private void fireEventPostSave() {
        if (this.listener == null) {
            return;
        }
        for (ConfigurationListener configurationListener : this.listener) {
            configurationListener.onPostSave(this);
        }
    }

    public void removeConfigurationListener(ConfigurationListener configurationListener) {
        if (configurationListener == null) {
            return;
        }
        this.listener.remove(configurationListener);
    }

    public SubConfiguration() {
    }

    public SubConfiguration(String string) {
        this.name = string;
        Object object = JDUtilities.getDatabaseConnector().getData(string);
        if (object != null) {
            this.setProperties((HashMap)object);
        }
    }

    public void save() {
        this.fireEventPreSave();
        JDUtilities.getDatabaseConnector().saveConfiguration(this.name, this.getProperties());
        this.fireEventPostSave();
        this.changes = false;
    }

    public String toString() {
        return this.name;
    }

    public static synchronized SubConfiguration getConfig(String string) {
        if (SUBCONFIG_LOCK) {
            JDLogger.exception(new Exception("Static Database init error!!"));
        }
        SUBCONFIG_LOCK = true;
        try {
            if (SUB_CONFIGS.containsKey(string)) {
                SubConfiguration subConfiguration = SUB_CONFIGS.get(string);
                return subConfiguration;
            }
            SubConfiguration subConfiguration = new SubConfiguration(string);
            SUB_CONFIGS.put(string, subConfiguration);
            subConfiguration.save();
            SubConfiguration subConfiguration2 = subConfiguration;
            return subConfiguration2;
        }
        finally {
            SUBCONFIG_LOCK = false;
        }
    }

    public static SubConfiguration getConfig(Object object) {
        return SubConfiguration.getConfig(object.getClass().getSimpleName());
    }
}

