/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Timer;
import jd.Main;
import jd.config.Property;
import jd.controlling.DownloadControllerBroadcaster;
import jd.controlling.DownloadControllerEvent;
import jd.controlling.DownloadControllerListener;
import jd.controlling.DownloadInformations;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageEvent;
import jd.plugins.FilePackageListener;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadController
implements FilePackageListener,
DownloadControllerListener,
ActionListener {
    public static final byte MOVE_BEFORE = 1;
    public static final byte MOVE_AFTER = 2;
    public static final byte MOVE_BEGIN = 3;
    public static final byte MOVE_END = 4;
    public static final byte MOVE_TOP = 5;
    public static final byte MOVE_BOTTOM = 6;
    public static final byte MOVE_UP = 7;
    public static final byte MOVE_DOWN = 8;
    public static final Object ControllerLock = new Object();
    private static DownloadController INSTANCE = null;
    private ArrayList<FilePackage> packages = new ArrayList();
    private Logger logger = null;
    private JDController controller;
    private transient DownloadControllerBroadcaster broadcaster = new DownloadControllerBroadcaster();
    private Timer asyncSaveIntervalTimer;
    private boolean saveinprogress;

    public static synchronized DownloadController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DownloadController();
        }
        return INSTANCE;
    }

    private DownloadController() {
        this.logger = JDLogger.getLogger();
        this.controller = JDUtilities.getController();
        this.initDownloadLinks();
        this.asyncSaveIntervalTimer = new Timer(2000, this);
        this.asyncSaveIntervalTimer.setInitialDelay(2000);
        this.asyncSaveIntervalTimer.setRepeats(false);
        this.broadcaster.addListener(this);
    }

    public void addListener(DownloadControllerListener downloadControllerListener) {
        this.broadcaster.addListener(downloadControllerListener);
    }

    public void removeListener(DownloadControllerListener downloadControllerListener) {
        this.broadcaster.removeListener(downloadControllerListener);
    }

    private void initDownloadLinks() {
        try {
            this.packages = this.loadDownloadLinks();
        }
        catch (Exception exception) {
            this.packages = null;
        }
        if (this.packages == null) {
            this.packages = new ArrayList();
            File file = JDUtilities.getResourceFile("backup/links.linkbackup");
            if (file.exists()) {
                this.logger.warning("Strange: No Linklist,Try to restore from backup file");
                this.controller.loadContainerFile(file);
            }
            return;
        }
        if (this.packages.size() == 0 && Main.returnedfromUpdate()) {
            File file = JDUtilities.getResourceFile("backup/links.linkbackup");
            if (file.exists() && file.lastModified() >= System.currentTimeMillis() - 600000L) {
                this.logger.warning("Strange: Empty Linklist,Try to restore from backup file");
                this.controller.loadContainerFile(file);
            }
            return;
        }
        for (FilePackage filePackage : this.packages) {
            filePackage.addListener(this);
            filePackage.update_linksDisabled();
            for (DownloadLink downloadLink : filePackage.getDownloadLinkList()) {
                downloadLink.getBroadcaster().addListener(filePackage);
            }
        }
    }

    public void saveDownloadLinksAsync() {
        if (this.saveinprogress) {
            return;
        }
        this.asyncSaveIntervalTimer.setDelay(2000);
        this.asyncSaveIntervalTimer.setInitialDelay(2000);
        this.asyncSaveIntervalTimer.restart();
    }

    public void saveDownloadLinksSync() {
        if (this.saveinprogress) {
            return;
        }
        new Thread(){

            public void run() {
                this.setName("DownloadController: Saving");
                DownloadController.this.saveDownloadLinksSyncnonThread();
                DownloadController.this.asyncSaveIntervalTimer.setDelay(600000);
                DownloadController.this.asyncSaveIntervalTimer.setInitialDelay(600000);
                DownloadController.this.asyncSaveIntervalTimer.restart();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDownloadLinksSyncnonThread() {
        this.asyncSaveIntervalTimer.stop();
        String string = JDController.requestDelayExit("downloadcontroller");
        ArrayList<FilePackage> arrayList = this.packages;
        synchronized (arrayList) {
            this.saveinprogress = true;
            JDUtilities.getDatabaseConnector().saveLinks(this.packages);
            this.saveinprogress = false;
        }
        JDController.releaseDelayExit(string);
    }

    private ArrayList<FilePackage> loadDownloadLinks() throws Exception {
        Object object = JDUtilities.getDatabaseConnector().getLinks();
        if (object != null && object instanceof ArrayList && (((ArrayList)object).size() == 0 || ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof FilePackage)) {
            ArrayList arrayList = (ArrayList)object;
            Iterator iterator = arrayList.iterator();
            PluginForHost pluginForHost = null;
            PluginsC pluginsC = null;
            while (iterator.hasNext()) {
                FilePackage filePackage = (FilePackage)iterator.next();
                if (filePackage.getDownloadLinkList().size() == 0) {
                    iterator.remove();
                    continue;
                }
                Iterator<DownloadLink> iterator2 = filePackage.getDownloadLinkList().iterator();
                while (iterator2.hasNext()) {
                    DownloadLink downloadLink = iterator2.next();
                    downloadLink.getLinkStatus().resetStatus(8192, 32, 2, 131072);
                    if (downloadLink.getLinkStatus().isFinished() && JDUtilities.getConfiguration().getIntegerProperty("FINISHED_DOWNLOADS_ACTION", 3) == 1) {
                        iterator2.remove();
                        if (filePackage.getDownloadLinkList().size() != 0) continue;
                        iterator.remove();
                        continue;
                    }
                    try {
                        pluginForHost = JDUtilities.getNewPluginForHostInstance(downloadLink.getHost());
                    }
                    catch (Exception exception) {
                        JDLogger.exception(exception);
                    }
                    try {
                        if (downloadLink.getContainer() != null && (pluginsC = JDUtilities.getPluginForContainer(downloadLink.getContainer(), downloadLink.getContainerFile())) == null) {
                            downloadLink.setEnabled(false);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        JDLogger.exception(nullPointerException);
                    }
                    if (pluginForHost != null) {
                        downloadLink.setLoadedPlugin(pluginForHost);
                    }
                    if (pluginsC != null) {
                        downloadLink.setLoadedPluginForContainer(pluginsC);
                    }
                    if (pluginForHost != null) continue;
                    this.logger.severe("couldn't find plugin(" + downloadLink.getHost() + ") for this DownloadLink." + downloadLink.getName());
                }
            }
            return arrayList;
        }
        if (object != null && object instanceof Vector && (((Vector)object).size() == 0 || ((Vector)object).size() > 0 && ((Vector)object).get(0) instanceof FilePackage)) {
            Vector vector = (Vector)object;
            ArrayList<FilePackage> arrayList = new ArrayList<FilePackage>();
            Iterator iterator = vector.iterator();
            PluginForHost pluginForHost = null;
            PluginsC pluginsC = null;
            String string = null;
            String string2 = null;
            while (iterator.hasNext()) {
                FilePackage filePackage = (FilePackage)iterator.next();
                if (filePackage.getDownloadLinkList() == null) {
                    filePackage.convert();
                }
                arrayList.add(filePackage);
                if (filePackage.getDownloadLinkList().size() == 0) {
                    arrayList.remove(filePackage);
                    continue;
                }
                Iterator<DownloadLink> iterator3 = filePackage.getDownloadLinkList().iterator();
                while (iterator3.hasNext()) {
                    DownloadLink downloadLink = iterator3.next();
                    if (!downloadLink.getLinkStatus().isFinished()) {
                        string = downloadLink.getLinkStatus().getStatusText();
                        string2 = downloadLink.getLinkStatus().getErrorMessage();
                        downloadLink.getLinkStatus().reset();
                        downloadLink.getLinkStatus().setErrorMessage(string2);
                        downloadLink.getLinkStatus().setStatusText(string);
                    }
                    if (downloadLink.getLinkStatus().isFinished() && JDUtilities.getConfiguration().getIntegerProperty("FINISHED_DOWNLOADS_ACTION") == 1) {
                        iterator3.remove();
                        if (filePackage.getDownloadLinkList().size() != 0) continue;
                        arrayList.remove(filePackage);
                        continue;
                    }
                    try {
                        pluginForHost = JDUtilities.getNewPluginForHostInstance(downloadLink.getHost());
                    }
                    catch (Exception exception) {
                        JDLogger.exception(exception);
                    }
                    try {
                        if (downloadLink.getContainer() != null && (pluginsC = JDUtilities.getPluginForContainer(downloadLink.getContainer(), downloadLink.getContainerFile())) == null) {
                            downloadLink.setEnabled(false);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        JDLogger.exception(nullPointerException);
                    }
                    if (pluginForHost != null) {
                        downloadLink.setLoadedPlugin(pluginForHost);
                    }
                    if (pluginsC != null) {
                        downloadLink.setLoadedPluginForContainer(pluginsC);
                    }
                    if (pluginForHost != null) continue;
                    this.logger.severe("couldn't find plugin(" + downloadLink.getHost() + ") for this DownloadLink." + downloadLink.getName());
                }
            }
            return arrayList;
        }
        throw new Exception("Linklist incompatible");
    }

    public ArrayList<FilePackage> getPackages() {
        return this.packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(ArrayList<FilePackage> arrayList) {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList2 = this.packages;
            synchronized (arrayList2) {
                int n = 0;
                while (n < arrayList.size()) {
                    this.addPackage(arrayList.get(n));
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(FilePackage filePackage) {
        if (filePackage == null) {
            return;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList = this.packages;
            synchronized (arrayList) {
                if (!this.packages.contains(filePackage)) {
                    filePackage.addListener(this);
                    this.packages.add(filePackage);
                    this.broadcaster.fireEvent(new DownloadControllerEvent(this, 2, filePackage));
                }
            }
        }
    }

    public int indexOf(FilePackage filePackage) {
        return this.packages.indexOf(filePackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPackageAt(FilePackage filePackage, int n, int n2) {
        if (filePackage == null) {
            return n2;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList = this.packages;
            synchronized (arrayList) {
                if (this.packages.size() == 0) {
                    this.addPackage(filePackage);
                    return n2;
                }
                boolean bl = false;
                if (this.packages.contains(filePackage)) {
                    int n3 = this.indexOf(filePackage);
                    if (n3 < n) {
                        n -= ++n2;
                    }
                    this.packages.remove(filePackage);
                    if (n > this.packages.size() - 1) {
                        this.packages.add(filePackage);
                    } else if (n < 0) {
                        this.packages.add(0, filePackage);
                    } else {
                        this.packages.add(n, filePackage);
                    }
                } else {
                    if (n > this.packages.size() - 1) {
                        this.packages.add(filePackage);
                    } else if (n < 0) {
                        this.packages.add(0, filePackage);
                    } else {
                        this.packages.add(n, filePackage);
                    }
                    bl = true;
                }
                if (bl) {
                    filePackage.addListener(this);
                    this.broadcaster.fireEvent(new DownloadControllerEvent(this, 2, filePackage));
                } else {
                    this.broadcaster.fireEvent(new DownloadControllerEvent(this, 1));
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllAt(ArrayList<FilePackage> arrayList, int n) {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList2 = this.packages;
            synchronized (arrayList2) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    n2 = this.addPackageAt(arrayList.get(n3), n + n3, n2);
                    ++n3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(FilePackage filePackage) {
        if (filePackage == null) {
            return;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList = this.packages;
            synchronized (arrayList) {
                filePackage.abortDownload();
                filePackage.removeListener(this);
                if (this.packages.remove(filePackage)) {
                    this.broadcaster.fireEvent(new DownloadControllerEvent(this, 3, filePackage));
                }
            }
        }
    }

    public int size() {
        return this.packages.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DownloadLink> getAllDownloadLinks() {
        ArrayList<DownloadLink> arrayList = new ArrayList<DownloadLink>();
        ArrayList<FilePackage> arrayList2 = this.packages;
        synchronized (arrayList2) {
            for (FilePackage filePackage : this.packages) {
                arrayList.addAll(filePackage.getDownloadLinkList());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDownloadStatus(DownloadInformations downloadInformations) {
        downloadInformations.reset();
        downloadInformations.addRunningDownloads(DownloadWatchDog.getInstance().getActiveDownloads());
        ArrayList<FilePackage> arrayList = this.packages;
        synchronized (arrayList) {
            for (FilePackage filePackage : this.packages) {
                downloadInformations.addPackages(1);
                downloadInformations.addDownloadLinks(filePackage.getDownloadLinkList().size());
                for (DownloadLink downloadLink : filePackage.getDownloadLinkList()) {
                    if (!downloadLink.getLinkStatus().hasStatus(8192) && downloadLink.isEnabled()) {
                        downloadInformations.addTotalDownloadSize(downloadLink.getDownloadSize());
                        downloadInformations.addCurrentDownloadSize(downloadLink.getDownloadCurrent());
                    }
                    if (downloadLink.getLinkStatus().hasStatus(8192)) {
                        downloadInformations.addDuplicateDownloads(1);
                        continue;
                    }
                    if (!downloadLink.isEnabled()) {
                        downloadInformations.addDisabledDownloads(1);
                        continue;
                    }
                    if (!downloadLink.getLinkStatus().hasStatus(2)) continue;
                    downloadInformations.addFinishedDownloads(1);
                }
            }
        }
    }

    public boolean hasDownloadLinkwithURL(String string) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        for (DownloadLink downloadLink : this.getAllDownloadLinks()) {
            if (downloadLink.getDownloadURL() == null || !downloadLink.getDownloadURL().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public DownloadLink getFirstLinkThatBlocks(DownloadLink downloadLink) {
        for (DownloadLink downloadLink2 : this.getAllDownloadLinks()) {
            if (downloadLink2 == downloadLink) continue;
            if (downloadLink2.getLinkStatus().hasStatus(2) && downloadLink2.getFileOutput().equalsIgnoreCase(downloadLink.getFileOutput()) && new File(downloadLink2.getFileOutput()).exists()) {
                return downloadLink2;
            }
            if (!downloadLink2.getLinkStatus().isPluginInProgress() || !downloadLink2.getFileOutput().equalsIgnoreCase(downloadLink.getFileOutput())) continue;
            return downloadLink2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Object object, Object object2, byte by) {
        Object object3;
        boolean bl = false;
        Object object4 = null;
        FilePackage filePackage = null;
        if (object instanceof ArrayList) {
            if (((ArrayList)object).isEmpty()) {
                return;
            }
            object3 = ((ArrayList)object).get(0);
            if (object3 == null) {
                this.logger.warning("Null src, cannot move!");
                return;
            }
            if (object3 instanceof DownloadLink) {
                object4 = object;
                bl = false;
            } else if (object3 instanceof FilePackage) {
                object4 = object;
                bl = true;
            }
        } else if (object instanceof DownloadLink) {
            bl = false;
            object4 = new ArrayList<Property>();
            ((ArrayList)object4).add((DownloadLink)object);
        } else if (object instanceof FilePackage) {
            bl = true;
            object4 = new ArrayList();
            ((ArrayList)object4).add((FilePackage)object);
        }
        if (object4 == null) {
            this.logger.warning("Unknown src, cannot move!");
            return;
        }
        object3 = ControllerLock;
        synchronized (object3) {
            ArrayList<FilePackage> arrayList = this.packages;
            synchronized (arrayList) {
                if (object2 != null) {
                    if (!bl) {
                        if (object2 instanceof FilePackage) {
                            switch (by) {
                                case 3: {
                                    filePackage = (FilePackage)object2;
                                    filePackage.addLinksAt((ArrayList)object4, 0);
                                    return;
                                }
                                case 4: {
                                    filePackage = (FilePackage)object2;
                                    filePackage.addLinksAt((ArrayList)object4, filePackage.size());
                                    return;
                                }
                            }
                            this.logger.warning("Unsupported mode, cannot move!");
                            return;
                        }
                        if (object2 instanceof DownloadLink) {
                            switch (by) {
                                case 1: {
                                    filePackage = ((DownloadLink)object2).getFilePackage();
                                    filePackage.addLinksAt((ArrayList)object4, filePackage.indexOf((DownloadLink)object2));
                                    return;
                                }
                                case 2: {
                                    filePackage = ((DownloadLink)object2).getFilePackage();
                                    filePackage.addLinksAt((ArrayList)object4, filePackage.indexOf((DownloadLink)object2) + 1);
                                    return;
                                }
                            }
                            this.logger.warning("Unsupported mode, cannot move!");
                            return;
                        }
                        this.logger.warning("Unsupported dst, cannot move!");
                        return;
                    }
                    if (object2 instanceof FilePackage) {
                        switch (by) {
                            case 1: {
                                this.addAllAt((ArrayList)object4, this.indexOf((FilePackage)object2));
                                return;
                            }
                            case 2: {
                                this.addAllAt((ArrayList)object4, this.indexOf((FilePackage)object2) + 1);
                                return;
                            }
                        }
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                    if (object2 instanceof DownloadLink) {
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                } else {
                    if (bl) {
                        switch (by) {
                            case 7: {
                                int n = 0;
                                for (FilePackage filePackage2 : (ArrayList)object4) {
                                    n = this.indexOf(filePackage2);
                                    this.addPackageAt(filePackage2, n - 1, 0);
                                }
                                return;
                            }
                            case 8: {
                                int n = 0;
                                ArrayList arrayList2 = (ArrayList)object4;
                                int n2 = arrayList2.size() - 1;
                                while (n2 >= 0) {
                                    n = this.indexOf((FilePackage)arrayList2.get(n2));
                                    this.addPackageAt((FilePackage)arrayList2.get(n2), n + 2, 0);
                                    --n2;
                                }
                                return;
                            }
                            case 5: {
                                this.addAllAt((ArrayList)object4, 0);
                                return;
                            }
                            case 6: {
                                this.addAllAt((ArrayList)object4, this.size() + 1);
                                return;
                            }
                        }
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                    switch (by) {
                        case 7: {
                            int n = 0;
                            for (DownloadLink downloadLink : (ArrayList)object4) {
                                n = downloadLink.getFilePackage().indexOf(downloadLink);
                                downloadLink.getFilePackage().add(n - 1, downloadLink, 0);
                                if (n != 0) continue;
                                n = this.indexOf(downloadLink.getFilePackage());
                                this.addPackageAt(downloadLink.getFilePackage(), n - 1, 0);
                            }
                            return;
                        }
                        case 8: {
                            int n = 0;
                            ArrayList arrayList3 = (ArrayList)object4;
                            int n3 = arrayList3.size() - 1;
                            while (n3 >= 0) {
                                n = ((DownloadLink)arrayList3.get(n3)).getFilePackage().indexOf((DownloadLink)arrayList3.get(n3));
                                ((DownloadLink)arrayList3.get(n3)).getFilePackage().add(n + 2, (DownloadLink)arrayList3.get(n3), 0);
                                if (n == ((DownloadLink)arrayList3.get(n3)).getFilePackage().size() - 1) {
                                    n = this.indexOf(((DownloadLink)arrayList3.get(n3)).getFilePackage());
                                    this.addPackageAt(((DownloadLink)arrayList3.get(n3)).getFilePackage(), n + 2, 0);
                                }
                                --n3;
                            }
                            return;
                        }
                        case 5: {
                            ArrayList<ArrayList<DownloadLink>> arrayList4 = DownloadController.splitByFilePackage((ArrayList)object4);
                            for (ArrayList<DownloadLink> arrayList5 : arrayList4) {
                                if (arrayList5.get(0).getFilePackage().indexOf(arrayList5.get(0)) == 0) {
                                    this.addPackageAt(arrayList5.get(0).getFilePackage(), 0, 0);
                                }
                                arrayList5.get(0).getFilePackage().addLinksAt(arrayList5, 0);
                            }
                            return;
                        }
                        case 6: {
                            ArrayList<ArrayList<DownloadLink>> arrayList6 = DownloadController.splitByFilePackage((ArrayList)object4);
                            for (ArrayList<DownloadLink> arrayList7 : arrayList6) {
                                if (arrayList7.get(0).getFilePackage().indexOf(arrayList7.get(arrayList7.size() - 1)) == arrayList7.get(0).getFilePackage().size() - 1) {
                                    this.addPackageAt(arrayList7.get(0).getFilePackage(), this.size() + 1, 0);
                                }
                                arrayList7.get(0).getFilePackage().addLinksAt(arrayList7, arrayList7.get(0).getFilePackage().size() + 1);
                            }
                            return;
                        }
                    }
                    this.logger.warning("Unsupported mode, cannot move!");
                    return;
                }
            }
        }
    }

    public static ArrayList<ArrayList<DownloadLink>> splitByFilePackage(ArrayList<DownloadLink> arrayList) {
        ArrayList<ArrayList<DownloadLink>> arrayList2 = new ArrayList<ArrayList<DownloadLink>>();
        boolean bl = false;
        for (DownloadLink downloadLink : arrayList) {
            if (arrayList2.size() == 0) {
                ArrayList<DownloadLink> arrayList3 = new ArrayList<DownloadLink>();
                arrayList3.add(downloadLink);
                arrayList2.add(arrayList3);
                continue;
            }
            bl = false;
            for (ArrayList<DownloadLink> arrayList4 : arrayList2) {
                if (downloadLink.getFilePackage() != arrayList4.get(0).getFilePackage()) continue;
                bl = true;
                arrayList4.add(downloadLink);
            }
            if (bl) continue;
            ArrayList<DownloadLink> arrayList5 = new ArrayList<DownloadLink>();
            arrayList5.add(downloadLink);
            arrayList2.add(arrayList5);
        }
        return arrayList2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.asyncSaveIntervalTimer) {
            this.saveDownloadLinksSync();
        }
    }

    public void fireStructureUpdate() {
        this.broadcaster.fireEvent(new DownloadControllerEvent(this, 1));
    }

    public void fireGlobalUpdate() {
        this.broadcaster.fireEvent(new DownloadControllerEvent(this, 12));
    }

    public void fireDownloadLinkUpdate(Object object) {
        this.broadcaster.fireEvent(new DownloadControllerEvent(this, 11, object));
    }

    @Override
    public void onDownloadControllerEvent(DownloadControllerEvent downloadControllerEvent) {
        switch (downloadControllerEvent.getID()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.fireStructureUpdate();
                break;
            }
            case 1: {
                this.saveDownloadLinksAsync();
            }
        }
    }

    @Override
    public void onFilePackageEvent(FilePackageEvent filePackageEvent) {
        switch (filePackageEvent.getID()) {
            case 2: {
                this.broadcaster.fireEvent(new DownloadControllerEvent(this, 4, filePackageEvent.getParameter()));
                break;
            }
            case 3: {
                this.broadcaster.fireEvent(new DownloadControllerEvent(this, 5, filePackageEvent.getParameter()));
                break;
            }
            case 1: {
                this.fireStructureUpdate();
                break;
            }
            case 999: {
                this.removePackage((FilePackage)filePackageEvent.getSource());
            }
        }
    }
}

