/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Timer;
import jd.controlling.DownloadController;
import jd.controlling.LinkCheckBroadcaster;
import jd.controlling.LinkCheckEvent;
import jd.controlling.LinkCheckListener;
import jd.controlling.ProgressController;
import jd.controlling.ProgressControllerEvent;
import jd.controlling.ProgressControllerListener;
import jd.event.JDBroadcaster;
import jd.nutils.jobber.JDRunnable;
import jd.nutils.jobber.Jobber;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkCheck
implements ActionListener,
ProgressControllerListener {
    private static LinkCheck INSTANCE = null;
    private Timer checkTimer = null;
    private Thread checkThread = null;
    private ArrayList<DownloadLink> linksToCheck = new ArrayList();
    private boolean checkRunning = false;
    protected ProgressController pc;
    protected Jobber checkJobbers;
    private transient LinkCheckBroadcaster broadcaster = new LinkCheckBroadcaster();

    public static synchronized LinkCheck getLinkChecker() {
        if (INSTANCE == null) {
            INSTANCE = new LinkCheck();
        }
        return INSTANCE;
    }

    private LinkCheck() {
        this.checkTimer = new Timer(2000, this);
        this.checkTimer.setInitialDelay(2000);
        this.checkTimer.setRepeats(false);
    }

    public boolean isRunning() {
        return this.checkRunning;
    }

    public synchronized JDBroadcaster<LinkCheckListener, LinkCheckEvent> getBroadcaster() {
        if (this.broadcaster == null) {
            this.broadcaster = new LinkCheckBroadcaster();
        }
        return this.broadcaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removefromWaitingList(ArrayList<DownloadLink> arrayList) {
        ArrayList<DownloadLink> arrayList2 = this.linksToCheck;
        synchronized (arrayList2) {
            this.linksToCheck.removeAll(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkLinks(ArrayList<DownloadLink> arrayList, boolean bl) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        this.checkRunning = true;
        for (DownloadLink downloadLink : arrayList) {
            ArrayList<DownloadLink> arrayList2 = this.linksToCheck;
            synchronized (arrayList2) {
                if (!this.linksToCheck.contains(downloadLink)) {
                    if (bl) {
                        downloadLink.setAvailableStatus(DownloadLink.AvailableStatus.UNCHECKED);
                    }
                    this.linksToCheck.add(downloadLink);
                }
            }
        }
        this.checkTimer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLinksandWait(ArrayList<DownloadLink> arrayList) {
        final Object object = new Object();
        final ArrayList<DownloadLink> arrayList2 = new ArrayList<DownloadLink>(arrayList);
        this.checkLinks(arrayList, false);
        this.getBroadcaster().addListener(new LinkCheckListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLinkCheckEvent(LinkCheckEvent linkCheckEvent) {
                ArrayList arrayList = arrayList2;
                synchronized (arrayList) {
                    Object object2;
                    if (linkCheckEvent.getID() == 4) {
                        if (linkCheckEvent.getParameter() instanceof ArrayList) {
                            object2 = (ArrayList)linkCheckEvent.getParameter();
                            Iterator iterator = ((ArrayList)object2).iterator();
                            while (iterator.hasNext()) {
                                DownloadLink downloadLink = (DownloadLink)iterator.next();
                                arrayList2.remove(downloadLink);
                            }
                        } else if (linkCheckEvent.getParameter() instanceof DownloadLink) {
                            arrayList2.remove((DownloadLink)linkCheckEvent.getParameter());
                        }
                        object2 = object;
                        synchronized (object2) {
                            if (arrayList2.size() == 0) {
                                object.notify();
                            }
                        }
                    }
                    if (linkCheckEvent.getID() == 2 || linkCheckEvent.getID() == 3) {
                        object2 = object;
                        synchronized (object2) {
                            if (arrayList2.size() == 0) {
                                object.notify();
                            }
                        }
                    }
                }
            }
        });
        Object object2 = object;
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void checkHosterList(ArrayList<DownloadLink> arrayList) {
        if (arrayList.size() != 0) {
            DownloadLink downloadLink = arrayList.get(0);
            long l = System.currentTimeMillis();
            boolean bl = ((PluginForHost)downloadLink.getPlugin().getWrapper().getNewPluginInstance()).checkLinks(arrayList.toArray(new DownloadLink[0]));
            if (!bl) {
                int n = 0;
                while (n < arrayList.size()) {
                    downloadLink = arrayList.get(n);
                    if (!this.checkRunning) {
                        return;
                    }
                    if (!downloadLink.getBooleanProperty("removed", false).booleanValue()) {
                        downloadLink.isAvailable();
                        this.getBroadcaster().fireEvent(new LinkCheckEvent(this, 4, downloadLink));
                    }
                    this.pc.increase(1L);
                    ++n;
                }
            } else {
                long l2 = System.currentTimeMillis() - l;
                for (DownloadLink downloadLink2 : arrayList) {
                    downloadLink2.setRequestTime(l2);
                }
                this.getBroadcaster().fireEvent(new LinkCheckEvent(this, 4, arrayList));
                this.pc.increase(arrayList.size());
            }
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(arrayList);
    }

    private void startLinkCheck() {
        if (this.checkThread != null && this.checkThread.isAlive()) {
            return;
        }
        this.checkThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.setName("OnlineCheck");
                LinkCheck.this.getBroadcaster().fireEvent(new LinkCheckEvent(this, 1));
                LinkCheck.this.pc = new ProgressController(JDL.L("gui.linkgrabber.pc.onlinecheck", "Checking online availability..."));
                LinkCheck.this.pc.getBroadcaster().addListener(LinkCheck.getLinkChecker());
                LinkCheck.this.pc.setRange(0L);
                while (LinkCheck.this.linksToCheck.size() != 0) {
                    ArrayList<DownloadLink> arrayList;
                    ArrayList arrayList2;
                    Cloneable cloneable = LinkCheck.this.linksToCheck;
                    synchronized (cloneable) {
                        arrayList2 = new ArrayList(LinkCheck.this.linksToCheck);
                        LinkCheck.this.pc.addToMax(arrayList2.size());
                    }
                    cloneable = new HashMap();
                    for (Serializable serializable : arrayList2) {
                        arrayList = (ArrayList<DownloadLink>)((HashMap)cloneable).get(((DownloadLink)serializable).getPlugin().getHost());
                        if (arrayList == null) {
                            arrayList = new ArrayList<DownloadLink>();
                            ((HashMap)cloneable).put(((DownloadLink)serializable).getPlugin().getHost(), arrayList);
                        }
                        arrayList.add((DownloadLink)serializable);
                    }
                    LinkCheck.this.checkJobbers = new Jobber(4);
                    for (Serializable serializable : ((HashMap)cloneable).values()) {
                        arrayList = new CheckThread((ArrayList<DownloadLink>)serializable);
                        LinkCheck.this.checkJobbers.add((JDRunnable)arrayList);
                    }
                    int n = LinkCheck.this.checkJobbers.getJobsAdded();
                    LinkCheck.this.checkJobbers.start();
                    while (LinkCheck.this.checkJobbers.getJobsFinished() != n) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    LinkCheck.this.checkJobbers.stop();
                    arrayList = LinkCheck.this.linksToCheck;
                    synchronized (arrayList) {
                        LinkCheck.this.linksToCheck.removeAll(arrayList2);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                LinkCheck.this.pc.doFinalize();
                LinkCheck.this.pc.getBroadcaster().removeListener(LinkCheck.getLinkChecker());
                LinkCheck.this.getBroadcaster().fireEvent(new LinkCheckEvent(this, 2));
                LinkCheck.this.checkRunning = false;
            }
        };
        this.checkThread.start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.checkTimer) {
            this.checkTimer.stop();
            if (this.linksToCheck.size() > 0) {
                this.startLinkCheck();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortLinkCheck() {
        this.checkRunning = false;
        this.checkTimer.stop();
        if (this.checkThread != null && this.checkThread.isAlive()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    LinkCheck.this.pc.setStatusText(String.valueOf(LinkCheck.this.pc.getStatusText()) + ": Aborted");
                    LinkCheck.this.pc.doFinalize(5000L);
                }
            });
            this.checkJobbers.stop();
            this.checkThread.interrupt();
        }
        ArrayList<DownloadLink> arrayList = this.linksToCheck;
        synchronized (arrayList) {
            this.linksToCheck.clear();
        }
    }

    @Override
    public void onProgressControllerEvent(ProgressControllerEvent progressControllerEvent) {
        if (progressControllerEvent.getSource() == this.pc) {
            this.abortLinkCheck();
            this.getBroadcaster().fireEvent(new LinkCheckEvent(this, 3));
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CheckThread
    implements JDRunnable {
        private ArrayList<DownloadLink> links = null;

        public CheckThread(ArrayList<DownloadLink> arrayList) {
            this.links = arrayList;
        }

        public void run() {
            if (this.links == null || this.links.size() == 0) {
                return;
            }
            LinkCheck.this.checkHosterList(this.links);
        }

        public void go() throws Exception {
            this.run();
        }
    }
}

