/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jd.config.ConfigPropertyListener;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.DownloadController;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberControllerBroadcaster;
import jd.controlling.LinkGrabberControllerEvent;
import jd.controlling.LinkGrabberControllerListener;
import jd.controlling.LinkGrabberDistributeEvent;
import jd.controlling.LinkGrabberPackager;
import jd.controlling.LinkGrabberPackagingEvent;
import jd.parser.Regex;
import jd.plugins.CryptedLink;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.LinkGrabberFilePackage;
import jd.plugins.LinkGrabberFilePackageEvent;
import jd.plugins.LinkGrabberFilePackageListener;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkGrabberController
implements LinkGrabberFilePackageListener,
LinkGrabberControllerListener {
    public static final Object ControllerLock = new Object();
    public static final byte MOVE_BEFORE = 1;
    public static final byte MOVE_AFTER = 2;
    public static final byte MOVE_BEGIN = 3;
    public static final byte MOVE_END = 4;
    public static final byte MOVE_TOP = 5;
    public static final byte MOVE_BOTTOM = 6;
    public static final byte MOVE_UP = 7;
    public static final byte MOVE_DOWN = 8;
    public static final String PARAM_ONLINECHECK = "PARAM_ONLINECHECK";
    public static final String PARAM_REPLACECHARS = "PARAM_REPLACECHARS";
    public static final String PARAM_INFOPANEL_ONLINKGRAB = "PARAM_INFOPANEL_ONLINKGRAB";
    public static final String CONFIG = "LINKGRABBER";
    public static final String IGNORE_LIST = "IGNORE_LIST";
    public static final String DONTFORCEPACKAGENAME = "dontforcename";
    private static ArrayList<LinkGrabberFilePackage> packages = new ArrayList();
    private static final HashSet<String> extensionFilter = new HashSet();
    public static final String PARAM_CONTROLPOSITION = "PARAM_CONTROLPOSITION";
    public static final String PARAM_USE_CNL2 = "PARAM_USE_CNL2";
    private static LinkGrabberController INSTANCE = null;
    private LinkGrabberControllerBroadcaster broadcaster;
    private static String[] filter;
    private ConfigPropertyListener cpl;
    private LinkGrabberFilePackage FP_UNSORTED;
    private LinkGrabberFilePackage FP_UNCHECKED;
    private LinkGrabberFilePackage FP_OFFLINE;
    private LinkGrabberFilePackage FP_FILTERED;
    private LinkGrabberDistributeEvent distributer = null;
    private LinkGrabberPackagingEvent customizedpackager = null;
    private Logger logger = JDLogger.getLogger();

    public static synchronized LinkGrabberController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LinkGrabberController();
        }
        return INSTANCE;
    }

    public LinkGrabberFilePackage getFilterPackage() {
        return this.FP_FILTERED;
    }

    public void setDistributer(LinkGrabberDistributeEvent linkGrabberDistributeEvent) {
        this.distributer = linkGrabberDistributeEvent;
    }

    public void setCustomizedPackager(LinkGrabberPackagingEvent linkGrabberPackagingEvent) {
        this.customizedpackager = linkGrabberPackagingEvent;
    }

    public void addLinks(ArrayList<DownloadLink> arrayList, boolean bl, boolean bl2) {
        if (arrayList.size() > 0) {
            this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 0));
        }
        if (this.distributer != null) {
            this.distributer.addLinks(arrayList, bl, bl2);
        } else {
            this.addLinksInternal(arrayList, bl, bl2);
        }
    }

    public void addLinksInternal(ArrayList<DownloadLink> arrayList, boolean bl, boolean bl2) {
        JDLogger.getLogger().info("No Distributer set, using minimal version");
        ArrayList<FilePackage> arrayList2 = new ArrayList<FilePackage>();
        FilePackage filePackage = FilePackage.getInstance();
        filePackage.setName("Added");
        for (DownloadLink downloadLink : arrayList) {
            if (downloadLink.getFilePackage() == FilePackage.getDefaultFilePackage()) {
                filePackage.add(downloadLink);
                if (arrayList2.contains(filePackage)) continue;
                arrayList2.add(filePackage);
                continue;
            }
            if (arrayList2.contains(downloadLink.getFilePackage())) continue;
            arrayList2.add(downloadLink.getFilePackage());
        }
        DownloadController.getInstance().addAllAt(arrayList2, 0);
        if (bl2) {
            DownloadWatchDog.getInstance().startDownloads();
        }
    }

    public void addListener(LinkGrabberControllerListener linkGrabberControllerListener) {
        this.broadcaster.addListener(linkGrabberControllerListener);
    }

    public void removeListener(LinkGrabberControllerListener linkGrabberControllerListener) {
        this.broadcaster.removeListener(linkGrabberControllerListener);
    }

    private LinkGrabberController() {
        this.broadcaster = new LinkGrabberControllerBroadcaster();
        this.broadcaster.addListener(this);
        filter = this.getLinkFilterPattern();
        this.cpl = new ConfigPropertyListener(new String[]{IGNORE_LIST}){

            public void onPropertyChanged(Property property, String string) {
                filter = LinkGrabberController.this.getLinkFilterPattern();
            }
        };
        JDController.getInstance().addControlListener(this.cpl);
        this.FP_UNSORTED = new LinkGrabberFilePackage(JDL.L("gui.linkgrabber.package.unsorted", "various"), this);
        this.FP_UNCHECKED = new LinkGrabberFilePackage(JDL.L("gui.linkgrabber.package.unchecked", "unchecked"), this);
        this.FP_OFFLINE = new LinkGrabberFilePackage(JDL.L("gui.linkgrabber.package.offline", "offline"), this);
        this.FP_OFFLINE.setIgnore(true);
        this.FP_FILTERED = new LinkGrabberFilePackage(JDL.L("gui.linkgrabber.package.filtered", "filtered"));
        this.FP_FILTERED.setIgnore(true);
    }

    public HashSet<String> getExtensionFilter() {
        return extensionFilter;
    }

    public boolean isLinkCheckEnabled() {
        return SubConfiguration.getConfig(CONFIG).getBooleanProperty(PARAM_ONLINECHECK, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExtensionFilter() {
        HashSet<String> hashSet = extensionFilter;
        synchronized (hashSet) {
            extensionFilter.clear();
        }
        this.FP_FILTERED.setDownloadLinks(new ArrayList<DownloadLink>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void filterExtension(String string, boolean bl) {
        boolean bl2 = false;
        HashSet<String> hashSet = extensionFilter;
        synchronized (hashSet) {
            if (!bl) {
                if (extensionFilter.contains(string)) {
                    return;
                }
                extensionFilter.add(string);
                bl2 = true;
            } else {
                if (!extensionFilter.contains(string)) {
                    return;
                }
                extensionFilter.remove(string);
                bl2 = true;
            }
        }
        if (bl2) {
            this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 9));
        }
    }

    public String[] getLinkFilterPattern() {
        String string = SubConfiguration.getConfig(CONFIG).getStringProperty(IGNORE_LIST, null);
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = Regex.getLines(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (!string2.trim().startsWith("#") && string2.trim().length() != 0) {
                try {
                    Pattern.compile(string2.trim());
                    arrayList.add(string2.trim());
                }
                catch (Exception exception) {
                    this.logger.severe("Filter " + string2.trim() + " is invalid!");
                }
            }
            ++n2;
        }
        return arrayList.toArray(new String[0]);
    }

    protected void finalize() {
        JDController.getInstance().removeControlListener(this.cpl);
        System.out.println("REMOVED LISTENER " + this.cpl);
    }

    public ArrayList<LinkGrabberFilePackage> getPackages() {
        return packages;
    }

    public int indexOf(LinkGrabberFilePackage linkGrabberFilePackage) {
        return packages.indexOf(linkGrabberFilePackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExtensionFiltered(DownloadLink downloadLink) {
        HashSet<String> hashSet = extensionFilter;
        synchronized (hashSet) {
            String string;
            Iterator<String> iterator = extensionFilter.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                string = iterator.next();
            } while (!downloadLink.getName().endsWith(string));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkGrabberFilePackage getFPwithName(String string) {
        ArrayList<LinkGrabberFilePackage> arrayList = packages;
        synchronized (arrayList) {
            block6: {
                if (string != null) break block6;
                return null;
            }
            for (LinkGrabberFilePackage linkGrabberFilePackage : packages) {
                if (!linkGrabberFilePackage.getName().equalsIgnoreCase(string)) continue;
                return linkGrabberFilePackage;
            }
            if (this.FP_FILTERED.getName().equalsIgnoreCase(string)) {
                return this.FP_FILTERED;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkGrabberFilePackage getFPwithLink(DownloadLink downloadLink) {
        ArrayList<LinkGrabberFilePackage> arrayList = packages;
        synchronized (arrayList) {
            block6: {
                if (downloadLink != null) break block6;
                return null;
            }
            for (LinkGrabberFilePackage linkGrabberFilePackage : packages) {
                if (!linkGrabberFilePackage.contains(downloadLink)) continue;
                return linkGrabberFilePackage;
            }
            if (this.FP_FILTERED.contains(downloadLink)) {
                return this.FP_FILTERED;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postprocessing() {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                ArrayList<LinkGrabberFilePackage> arrayList2 = new ArrayList<LinkGrabberFilePackage>(packages);
                for (LinkGrabberFilePackage linkGrabberFilePackage : arrayList2) {
                    boolean bl = false;
                    if (linkGrabberFilePackage.countFailedLinks(true) == linkGrabberFilePackage.size()) {
                        bl = true;
                    }
                    ArrayList<DownloadLink> arrayList3 = new ArrayList<DownloadLink>(linkGrabberFilePackage.getDownloadLinks());
                    for (DownloadLink downloadLink : arrayList3) {
                        if (!downloadLink.isAvailabilityStatusChecked() || downloadLink.isAvailable() || arrayList3.size() != 1 && !bl) continue;
                        this.FP_OFFLINE.add(downloadLink);
                    }
                    Collections.sort(linkGrabberFilePackage.getDownloadLinks(), new Comparator<DownloadLink>(){

                        @Override
                        public int compare(DownloadLink downloadLink, DownloadLink downloadLink2) {
                            return downloadLink.getName().compareToIgnoreCase(downloadLink2.getName());
                        }
                    });
                }
            }
            this.throwRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDupe(DownloadLink downloadLink) {
        ArrayList<LinkGrabberFilePackage> arrayList = packages;
        synchronized (arrayList) {
            if (downloadLink == null) {
                return false;
            }
            if (downloadLink.getBooleanProperty("ALLOW_DUPE", false).booleanValue()) {
                return false;
            }
            LinkGrabberFilePackage linkGrabberFilePackage = null;
            DownloadLink downloadLink2 = null;
            Iterator<LinkGrabberFilePackage> iterator = packages.iterator();
            block3: while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                linkGrabberFilePackage = iterator.next();
                Iterator<DownloadLink> iterator2 = linkGrabberFilePackage.getDownloadLinks().iterator();
                do {
                    if (!iterator2.hasNext()) continue block3;
                } while ((downloadLink2 = iterator2.next()).compareTo(downloadLink) != 0);
                break;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(LinkGrabberFilePackage linkGrabberFilePackage) {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                if (!packages.contains(linkGrabberFilePackage)) {
                    packages.add(linkGrabberFilePackage);
                    linkGrabberFilePackage.addListener(this);
                    this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 2, linkGrabberFilePackage));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllAt(ArrayList<LinkGrabberFilePackage> arrayList, int n) {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList2 = packages;
            synchronized (arrayList2) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    n2 = this.addPackageAt(arrayList.get(n3), n + n3, n2);
                    ++n3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPackageAt(LinkGrabberFilePackage linkGrabberFilePackage, int n, int n2) {
        if (linkGrabberFilePackage == null) {
            return n2;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                if (packages.size() == 0) {
                    this.addPackage(linkGrabberFilePackage);
                    return n2;
                }
                boolean bl = false;
                if (packages.contains(linkGrabberFilePackage)) {
                    int n3 = this.indexOf(linkGrabberFilePackage);
                    if (n3 < n) {
                        n -= ++n2;
                    }
                    packages.remove(linkGrabberFilePackage);
                    if (n > packages.size() - 1) {
                        packages.add(linkGrabberFilePackage);
                    } else if (n < 0) {
                        packages.add(0, linkGrabberFilePackage);
                    } else {
                        packages.add(n, linkGrabberFilePackage);
                    }
                } else if (n > packages.size() - 1) {
                    packages.add(linkGrabberFilePackage);
                } else if (n < 0) {
                    packages.add(0, linkGrabberFilePackage);
                } else {
                    packages.add(n, linkGrabberFilePackage);
                }
                if (bl) {
                    linkGrabberFilePackage.addListener(this);
                    this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 2, linkGrabberFilePackage));
                } else {
                    this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 1, linkGrabberFilePackage));
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(LinkGrabberFilePackage linkGrabberFilePackage) {
        if (linkGrabberFilePackage == null) {
            return;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                if (linkGrabberFilePackage != this.FP_FILTERED && linkGrabberFilePackage != this.FP_OFFLINE && linkGrabberFilePackage != this.FP_UNCHECKED && linkGrabberFilePackage != this.FP_UNSORTED) {
                    linkGrabberFilePackage.removeListener(this);
                }
                packages.remove(linkGrabberFilePackage);
                this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 3, linkGrabberFilePackage));
            }
        }
    }

    public void throwRefresh() {
        this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterPackages() {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                ArrayList<LinkGrabberFilePackage> arrayList2 = new ArrayList<LinkGrabberFilePackage>(packages);
                arrayList2.add(this.FP_FILTERED);
                for (LinkGrabberFilePackage linkGrabberFilePackage : arrayList2) {
                    if (linkGrabberFilePackage == this.FP_UNCHECKED || linkGrabberFilePackage == this.FP_OFFLINE || linkGrabberFilePackage == this.FP_UNSORTED) continue;
                    ArrayList<DownloadLink> arrayList3 = new ArrayList<DownloadLink>(linkGrabberFilePackage.getDownloadLinks());
                    for (DownloadLink downloadLink : arrayList3) {
                        LinkGrabberFilePackage linkGrabberFilePackage2 = this.getFPwithLink(downloadLink);
                        if (linkGrabberFilePackage2 != null && linkGrabberFilePackage2 != this.FP_FILTERED) {
                            downloadLink.setProperty("oldfp", linkGrabberFilePackage2.getName());
                        }
                        if (this.isExtensionFiltered(downloadLink)) {
                            if (this.FP_FILTERED.contains(downloadLink)) continue;
                            this.FP_FILTERED.add(downloadLink);
                            continue;
                        }
                        this.attachToPackagesSecondStage(downloadLink);
                    }
                }
            }
        }
    }

    public void attachToPackagesFirstStage(DownloadLink downloadLink) {
        if (this.customizedpackager != null) {
            this.customizedpackager.attachToPackagesFirstStage(downloadLink);
        } else {
            this.attachToPackagesFirstStageInternal(downloadLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToPackagesFirstStageInternal(DownloadLink downloadLink) {
        Object object = ControllerLock;
        synchronized (object) {
            LinkGrabberFilePackage linkGrabberFilePackage = null;
            if (this.isExtensionFiltered(downloadLink)) {
                linkGrabberFilePackage = this.FP_FILTERED;
            } else if (downloadLink.getFilePackage() != FilePackage.getDefaultFilePackage()) {
                String string = downloadLink.getFilePackage().getName();
                linkGrabberFilePackage = this.getFPwithName(string);
                if (linkGrabberFilePackage == null) {
                    linkGrabberFilePackage = new LinkGrabberFilePackage(string, this);
                }
                linkGrabberFilePackage.setDownloadDirectory(downloadLink.getFilePackage().getDownloadDirectory());
                linkGrabberFilePackage.setPassword(downloadLink.getFilePackage().getPassword());
            }
            if (linkGrabberFilePackage == null) {
                linkGrabberFilePackage = this.isLinkCheckEnabled() ? this.FP_UNCHECKED : this.FP_UNSORTED;
            }
            linkGrabberFilePackage.add(downloadLink);
        }
    }

    public int size() {
        return packages.size();
    }

    public void attachToPackagesSecondStage(DownloadLink downloadLink) {
        if (this.customizedpackager != null) {
            this.customizedpackager.attachToPackagesSecondStage(downloadLink);
        } else {
            this.attachToPackagesSecondStageInternal(downloadLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToPackagesSecondStageInternal(DownloadLink downloadLink) {
        Object object = ControllerLock;
        synchronized (object) {
            if (this.isExtensionFiltered(downloadLink)) {
                this.FP_FILTERED.add(downloadLink);
                return;
            }
            LinkGrabberFilePackage linkGrabberFilePackage = this.getGeneratedPackage(downloadLink);
            linkGrabberFilePackage.add(downloadLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkGrabberFilePackage getGeneratedPackage(DownloadLink downloadLink) {
        Object object = ControllerLock;
        synchronized (object) {
            String string;
            boolean bl = false;
            if (downloadLink.hasProperty("oldfp")) {
                string = downloadLink.getStringProperty("oldfp");
                downloadLink.setProperty("oldfp", Property.NULL);
            } else if (downloadLink.getFilePackage() != FilePackage.getDefaultFilePackage()) {
                if (downloadLink.getFilePackage().getStringProperty(DONTFORCEPACKAGENAME, null) != null) {
                    bl = true;
                    string = LinkGrabberPackager.cleanFileName(downloadLink.getName());
                } else {
                    string = downloadLink.getFilePackage().getName();
                }
            } else {
                bl = true;
                string = LinkGrabberPackager.cleanFileName(downloadLink.getName());
            }
            int n = 0;
            LinkGrabberFilePackage linkGrabberFilePackage = null;
            Object object2 = packages;
            synchronized (object2) {
                int n2 = 0;
                while (n2 < packages.size()) {
                    int n3 = LinkGrabberPackager.comparepackages(packages.get(n2).getName(), string);
                    if (n3 > n) {
                        n = n3;
                        linkGrabberFilePackage = packages.get(n2);
                    }
                    ++n2;
                }
            }
            if (n < 99) {
                linkGrabberFilePackage = new LinkGrabberFilePackage(string, this);
                linkGrabberFilePackage.setPassword(downloadLink.getFilePackage().getPassword());
                linkGrabberFilePackage.setDownloadDirectory(downloadLink.getFilePackage().getDownloadDirectory());
            } else {
                object2 = bl ? this.getSimString(linkGrabberFilePackage.getName(), string) : string;
                linkGrabberFilePackage.setName((String)object2);
            }
            return linkGrabberFilePackage;
        }
    }

    private String getSimString(String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < Math.min(string3.length(), string4.length())) {
            if (string3.charAt(n) == string4.charAt(n)) {
                stringBuilder.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public void handle_LinkGrabberFilePackageEvent(LinkGrabberFilePackageEvent linkGrabberFilePackageEvent) {
        switch (linkGrabberFilePackageEvent.getID()) {
            case 999: {
                this.removePackage((LinkGrabberFilePackage)linkGrabberFilePackageEvent.getSource());
                if (packages.size() != 0 || this.FP_FILTERED.size() != 0) break;
                this.clearExtensionFilter();
                this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 4));
                break;
            }
            case 2: 
            case 3: {
                if (!packages.contains((LinkGrabberFilePackage)linkGrabberFilePackageEvent.getSource())) {
                    this.addPackage((LinkGrabberFilePackage)linkGrabberFilePackageEvent.getSource());
                    break;
                }
                this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 1, linkGrabberFilePackageEvent.getSource()));
                break;
            }
            case 1: {
                this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 1, linkGrabberFilePackageEvent.getSource()));
                break;
            }
        }
    }

    public void throwLinksAdded() {
        this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 5));
    }

    @Override
    public void onLinkGrabberControllerEvent(LinkGrabberControllerEvent linkGrabberControllerEvent) {
        switch (linkGrabberControllerEvent.getID()) {
            case 2: 
            case 3: {
                this.broadcaster.fireEvent(new LinkGrabberControllerEvent(this, 1));
                break;
            }
            case 9: {
                this.filterPackages();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFiltered(DownloadLink downloadLink) {
        if (filter == null || filter.length == 0) {
            return false;
        }
        String[] stringArray = filter;
        synchronized (filter) {
            String[] stringArray2 = filter;
            int n = filter.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                String string = stringArray2[n2];
                if (downloadLink.getDownloadURL().matches(string) || downloadLink.getName().matches(string)) {
                    JDLogger.getLogger().finer("Filtered link: " + downloadLink.getName() + " due to filter entry " + string);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFiltered(CryptedLink cryptedLink) {
        if (filter == null || filter.length == 0) {
            return false;
        }
        String[] stringArray = filter;
        synchronized (filter) {
            String[] stringArray2 = filter;
            int n = filter.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                String string = stringArray2[n2];
                String string2 = cryptedLink.getCryptedUrl().replaceAll("httpviajd://", "http://").replaceAll("httpsviajd://", "https://");
                if (string2.matches(string)) {
                    JDLogger.getLogger().finer("Filtered link: due to filter entry " + string);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Object object, Object object2, byte by) {
        Object object3;
        boolean bl = false;
        Object object4 = null;
        LinkGrabberFilePackage linkGrabberFilePackage = null;
        if (object instanceof ArrayList) {
            object3 = ((ArrayList)object).get(0);
            if (object3 == null) {
                this.logger.warning("Null src, cannot move!");
                return;
            }
            if (object3 instanceof DownloadLink) {
                object4 = object;
                bl = false;
            } else if (object3 instanceof LinkGrabberFilePackage) {
                object4 = object;
                bl = true;
            }
        } else if (object instanceof DownloadLink) {
            bl = false;
            object4 = new ArrayList<DownloadLink>();
            ((ArrayList)object4).add((DownloadLink)object);
        } else if (object instanceof LinkGrabberFilePackage) {
            bl = true;
            object4 = new ArrayList<LinkGrabberFilePackage>();
            ((ArrayList)object4).add((LinkGrabberFilePackage)object);
        }
        if (object4 == null) {
            this.logger.warning("Unknown src, cannot move!");
            return;
        }
        object3 = ControllerLock;
        synchronized (object3) {
            ArrayList<LinkGrabberFilePackage> arrayList = packages;
            synchronized (arrayList) {
                if (object2 != null) {
                    if (!bl) {
                        if (object2 instanceof LinkGrabberFilePackage) {
                            switch (by) {
                                case 3: {
                                    linkGrabberFilePackage = (LinkGrabberFilePackage)object2;
                                    linkGrabberFilePackage.addAllAt((ArrayList)object4, 0);
                                    return;
                                }
                                case 4: {
                                    linkGrabberFilePackage = (LinkGrabberFilePackage)object2;
                                    linkGrabberFilePackage.addAllAt((ArrayList)object4, linkGrabberFilePackage.size());
                                    return;
                                }
                            }
                            this.logger.warning("Unsupported mode, cannot move!");
                            return;
                        }
                        if (object2 instanceof DownloadLink) {
                            switch (by) {
                                case 1: {
                                    linkGrabberFilePackage = this.getFPwithLink((DownloadLink)object2);
                                    linkGrabberFilePackage.addAllAt((ArrayList)object4, linkGrabberFilePackage.indexOf((DownloadLink)object2));
                                    return;
                                }
                                case 2: {
                                    linkGrabberFilePackage = this.getFPwithLink((DownloadLink)object2);
                                    linkGrabberFilePackage.addAllAt((ArrayList)object4, linkGrabberFilePackage.indexOf((DownloadLink)object2) + 1);
                                    return;
                                }
                            }
                            this.logger.warning("Unsupported mode, cannot move!");
                            return;
                        }
                        this.logger.warning("Unsupported dst, cannot move!");
                        return;
                    }
                    if (object2 instanceof LinkGrabberFilePackage) {
                        switch (by) {
                            case 1: {
                                this.addAllAt((ArrayList)object4, this.indexOf((LinkGrabberFilePackage)object2));
                                return;
                            }
                            case 2: {
                                this.addAllAt((ArrayList)object4, this.indexOf((LinkGrabberFilePackage)object2) + 1);
                                return;
                            }
                        }
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                    if (object2 instanceof DownloadLink) {
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                } else {
                    if (bl) {
                        switch (by) {
                            case 7: {
                                int n = 0;
                                for (LinkGrabberFilePackage linkGrabberFilePackage2 : (ArrayList)object4) {
                                    n = this.indexOf(linkGrabberFilePackage2);
                                    this.addPackageAt(linkGrabberFilePackage2, n - 1, 0);
                                }
                                return;
                            }
                            case 8: {
                                int n = 0;
                                ArrayList arrayList2 = (ArrayList)object4;
                                int n2 = arrayList2.size() - 1;
                                while (n2 >= 0) {
                                    n = this.indexOf((LinkGrabberFilePackage)arrayList2.get(n2));
                                    this.addPackageAt((LinkGrabberFilePackage)arrayList2.get(n2), n + 2, 0);
                                    --n2;
                                }
                                return;
                            }
                            case 5: {
                                this.addAllAt((ArrayList)object4, 0);
                                return;
                            }
                            case 6: {
                                this.addAllAt((ArrayList)object4, this.size() + 1);
                                return;
                            }
                        }
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                    switch (by) {
                        case 7: {
                            int n = 0;
                            for (DownloadLink downloadLink : (ArrayList)object4) {
                                linkGrabberFilePackage = this.getFPwithLink(downloadLink);
                                n = linkGrabberFilePackage.indexOf(downloadLink);
                                linkGrabberFilePackage.add(n - 1, downloadLink, 0);
                                if (n != 0) continue;
                                n = this.indexOf(linkGrabberFilePackage);
                                this.addPackageAt(linkGrabberFilePackage, n - 1, 0);
                            }
                            return;
                        }
                        case 8: {
                            int n = 0;
                            ArrayList arrayList3 = (ArrayList)object4;
                            int n3 = arrayList3.size() - 1;
                            while (n3 >= 0) {
                                linkGrabberFilePackage = this.getFPwithLink((DownloadLink)arrayList3.get(n3));
                                n = linkGrabberFilePackage.indexOf((DownloadLink)arrayList3.get(n3));
                                linkGrabberFilePackage.add(n + 2, (DownloadLink)arrayList3.get(n3), 0);
                                if (n == linkGrabberFilePackage.size() - 1) {
                                    n = this.indexOf(linkGrabberFilePackage);
                                    this.addPackageAt(linkGrabberFilePackage, n + 2, 0);
                                }
                                --n3;
                            }
                            return;
                        }
                        case 5: {
                            ArrayList<ArrayList<DownloadLink>> arrayList4 = LinkGrabberController.splitByFilePackage((ArrayList)object4);
                            for (ArrayList<DownloadLink> arrayList5 : arrayList4) {
                                linkGrabberFilePackage = this.getFPwithLink(arrayList5.get(0));
                                if (linkGrabberFilePackage.indexOf(arrayList5.get(0)) == 0) {
                                    this.addPackageAt(linkGrabberFilePackage, 0, 0);
                                }
                                linkGrabberFilePackage.addAllAt(arrayList5, 0);
                            }
                            return;
                        }
                        case 6: {
                            ArrayList<ArrayList<DownloadLink>> arrayList6 = LinkGrabberController.splitByFilePackage((ArrayList)object4);
                            for (ArrayList<DownloadLink> arrayList7 : arrayList6) {
                                linkGrabberFilePackage = this.getFPwithLink(arrayList7.get(0));
                                if (linkGrabberFilePackage.indexOf(arrayList7.get(arrayList7.size() - 1)) == linkGrabberFilePackage.size() - 1) {
                                    this.addPackageAt(linkGrabberFilePackage, this.size() + 1, 0);
                                }
                                linkGrabberFilePackage.addAllAt(arrayList7, linkGrabberFilePackage.size() + 1);
                            }
                            return;
                        }
                    }
                    this.logger.warning("Unsupported mode, cannot move!");
                    return;
                }
            }
        }
    }

    public static ArrayList<ArrayList<DownloadLink>> splitByFilePackage(ArrayList<DownloadLink> arrayList) {
        ArrayList<ArrayList<DownloadLink>> arrayList2 = new ArrayList<ArrayList<DownloadLink>>();
        boolean bl = false;
        for (DownloadLink downloadLink : arrayList) {
            LinkGrabberFilePackage linkGrabberFilePackage = INSTANCE.getFPwithLink(downloadLink);
            if (arrayList2.size() == 0) {
                ArrayList<DownloadLink> arrayList3 = new ArrayList<DownloadLink>();
                arrayList3.add(downloadLink);
                arrayList2.add(arrayList3);
                continue;
            }
            bl = false;
            for (ArrayList<DownloadLink> arrayList4 : arrayList2) {
                LinkGrabberFilePackage linkGrabberFilePackage2 = INSTANCE.getFPwithLink(arrayList4.get(0));
                if (linkGrabberFilePackage != linkGrabberFilePackage2) continue;
                bl = true;
                arrayList4.add(downloadLink);
            }
            if (bl) continue;
            ArrayList<DownloadLink> arrayList5 = new ArrayList<DownloadLink>();
            arrayList5.add(downloadLink);
            arrayList2.add(arrayList5);
        }
        return arrayList2;
    }
}

