/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import jd.controlling.JDLogger;

public class LogFormatter
extends SimpleFormatter {
    private final Date dat = new Date();
    private final DateFormat longTimestamp = DateFormat.getDateTimeInstance(3, 2);
    private final String lineSeparator = System.getProperty("line.separator");
    private final StringBuilder sb = new StringBuilder();
    private int lastThreadID;

    public synchronized String format(LogRecord logRecord) {
        this.sb.delete(0, this.sb.capacity());
        this.dat.setTime(logRecord.getMillis());
        String string = this.formatMessage(logRecord);
        int n = logRecord.getThreadID();
        if (n != this.lastThreadID) {
            this.sb.append("\r\n------------------------  Thread: ");
            this.sb.append(n);
            this.sb.append("  -----------------------\r\n");
        }
        this.lastThreadID = n;
        if (JDLogger.getLogger().getLevel() == Level.ALL) {
            this.sb.append(logRecord.getThreadID());
            this.sb.append(' ');
            this.sb.append(this.longTimestamp.format(this.dat));
            this.sb.append(" - ");
            this.sb.append(logRecord.getLevel().getName());
            this.sb.append(" [");
            if (logRecord.getSourceClassName() != null) {
                this.sb.append(logRecord.getSourceClassName());
            } else {
                this.sb.append(logRecord.getLoggerName());
            }
            if (logRecord.getSourceMethodName() != null) {
                this.sb.append('(');
                this.sb.append(logRecord.getSourceMethodName());
                this.sb.append(')');
            }
            this.sb.append("] ");
            this.sb.append("-> ");
        } else {
            this.sb.append(this.longTimestamp.format(this.dat));
            this.sb.append(" - ");
            if (logRecord.getSourceClassName() != null) {
                this.sb.append(logRecord.getSourceClassName().substring(logRecord.getSourceClassName().lastIndexOf(".") + 1));
            } else {
                this.sb.append(logRecord.getLoggerName());
            }
            this.sb.append("-> ");
        }
        this.sb.append(string);
        this.sb.append(this.lineSeparator);
        if (logRecord.getThrown() != null) {
            this.sb.append(JDLogger.getStackTrace(logRecord.getThrown()));
        }
        return this.sb.toString();
    }
}

