/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.Color;
import javax.swing.Icon;
import jd.controlling.ProgressControllerBroadcaster;
import jd.controlling.ProgressControllerEvent;
import jd.controlling.ProgressControllerListener;
import jd.event.ControlEvent;
import jd.event.JDBroadcaster;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressController
implements MessageListener {
    private static int idCounter = 0;
    private long currentValue;
    private boolean finished;
    private boolean finalizing = false;
    private int id;
    private boolean indeterminate = false;
    private long max;
    private Object source;
    private String statusText;
    private Color progresscolor;
    private Icon icon = null;
    private transient ProgressControllerBroadcaster broadcaster = new ProgressControllerBroadcaster();
    private boolean abort = false;

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public ProgressController(String string) {
        this(string, 100L);
    }

    public boolean isInterruptable() {
        return this.getBroadcaster().hasListener();
    }

    public ProgressController(String string, long l) {
        this.id = idCounter++;
        this.max = l;
        this.statusText = string;
        this.currentValue = 0L;
        this.finished = false;
        this.progresscolor = null;
        this.fireChanges();
    }

    public synchronized JDBroadcaster<ProgressControllerListener, ProgressControllerEvent> getBroadcaster() {
        if (this.broadcaster == null) {
            this.broadcaster = new ProgressControllerBroadcaster();
        }
        return this.broadcaster;
    }

    public void setColor(Color color) {
        this.progresscolor = color;
        this.fireChanges();
    }

    public Color getColor() {
        return this.progresscolor;
    }

    public void addToMax(long l) {
        this.setRange(this.max + l);
    }

    public void decrease(long l) {
        this.setStatus(this.currentValue - l);
    }

    public void doFinalize() {
        if (this.finalizing) {
            return;
        }
        this.finished = true;
        this.currentValue = this.max;
        JDUtilities.getController().fireControlEvent(new ControlEvent(this, 24, this.source));
    }

    public boolean isFinalizing() {
        return this.finalizing;
    }

    public void doFinalize(final long l) {
        if (this.finalizing) {
            return;
        }
        this.finalizing = true;
        final ProgressController progressController = this;
        new Thread(){

            public void run() {
                long l2 = l;
                progressController.setRange(l2);
                while (l2 > 0L) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l2 -= 1000L;
                    progressController.increase(1000L);
                }
                ProgressController.this.finished = true;
                ProgressController.this.currentValue = ProgressController.this.max;
                if (JDUtilities.getController() != null) {
                    JDUtilities.getController().fireControlEvent(new ControlEvent(progressController, 24, ProgressController.this.source));
                }
            }
        }.start();
    }

    public void fireChanges() {
        if (!this.isFinished() && JDUtilities.getController() != null) {
            JDUtilities.getController().fireControlEvent(new ControlEvent(this, 24, this.source));
        }
    }

    public int getID() {
        return this.id;
    }

    public long getMax() {
        return this.max;
    }

    public int getPercent() {
        if (Math.min(this.currentValue, this.max) <= 0L) {
            return 0;
        }
        return (int)(10000L * this.currentValue / Math.max(1L, Math.max(this.currentValue, this.max)));
    }

    public Object getSource() {
        return this.source;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public long getValue() {
        return this.currentValue;
    }

    public synchronized void increase(long l) {
        this.setStatus(this.currentValue + l);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setRange(long l) {
        this.max = l;
        this.setStatus(this.currentValue);
    }

    public void setSource(Object object) {
        this.source = object;
        this.fireChanges();
    }

    public void setStatus(long l) {
        if (l < 0L) {
            l = 0L;
        }
        if (l > this.max) {
            l = this.max;
        }
        this.currentValue = l;
        this.fireChanges();
    }

    public void setStatusText(String string) {
        this.statusText = string;
        this.fireChanges();
    }

    public String toString() {
        return "ProgressController " + this.id;
    }

    public void fireCancelAction() {
        this.abort = true;
        this.getBroadcaster().fireEvent(new ProgressControllerEvent(this, 1));
    }

    public void setIndeterminate(boolean bl) {
        this.indeterminate = bl;
        this.fireChanges();
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    @Override
    public void onMessage(MessageEvent messageEvent) {
        this.setStatusText(messageEvent.getMessage());
    }
}

