/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import jd.config.ConfigEntry;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.ProgressController;
import jd.controlling.reconnect.ReconnectMethod;
import jd.nutils.OSDetector;
import jd.parser.Regex;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class BatchReconnect
extends ReconnectMethod {
    private SubConfiguration configuration = SubConfiguration.getConfig("BATCHRECONNECT");
    private static final String PROPERTY_IP_WAIT_FOR_RETURN = "WAIT_FOR_RETURN5";
    private static final String PROPERTY_RECONNECT_EXECUTE_FOLDER = "RECONNECT_EXECUTE_FOLDER";
    private static final String PROPERTY_TERMINAL = "TERMINAL";
    private static final String PROPERTY_BATCHTEXT = "BATCH_TEXT";

    protected void initConfig() {
        ConfigEntry configEntry = new ConfigEntry(0, (Property)this.configuration, PROPERTY_TERMINAL, JDL.L("interaction.batchreconnect.terminal", "Interpreter"));
        this.config.addEntry(configEntry);
        if (OSDetector.isWindows()) {
            configEntry.setDefaultValue("cmd /c");
        } else {
            configEntry.setDefaultValue("/bin/bash");
        }
        this.config.addEntry(new ConfigEntry(10, (Property)this.configuration, PROPERTY_BATCHTEXT, JDL.L("interaction.batchreconnect.batch", "Batch Script")));
        this.config.addEntry(new ConfigEntry(9, (Property)this.configuration, PROPERTY_RECONNECT_EXECUTE_FOLDER, JDL.L("interaction.batchreconnect.executeIn", "Ausf\u00fchren in (Ordner der Anwendung)")));
    }

    protected boolean runCommands(ProgressController progressController) {
        int n = this.configuration.getIntegerProperty(PROPERTY_IP_WAIT_FOR_RETURN, -1);
        String string = this.configuration.getStringProperty(PROPERTY_RECONNECT_EXECUTE_FOLDER);
        String string2 = this.configuration.getStringProperty(PROPERTY_TERMINAL);
        String[] stringArray = string2.split("\\ ");
        string2 = stringArray[0];
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            stringArray[n2] = stringArray[n2 + 1];
            ++n2;
        }
        String string3 = this.configuration.getStringProperty(PROPERTY_BATCHTEXT, "");
        String[] stringArray2 = Regex.getLines(string3);
        logger.info("Using Batch-Mode: using " + string2 + " as interpreter! (default: windows(cmd.exe) linux&mac(/bin/bash) )");
        String[] stringArray3 = stringArray2;
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String string4;
            stringArray[stringArray.length - 1] = string4 = stringArray3[n4];
            logger.finer("Execute Batchline: " + JDUtilities.runCommand(string2, stringArray, string, stringArray2.length >= 2 ? n : -1));
            ++n4;
        }
        return true;
    }
}

