/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import jd.config.Configuration;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.controlling.reconnect.ReconnectMethod;
import jd.http.Browser;
import jd.http.JDProxy;
import jd.http.RequestHeader;
import jd.nutils.Formatter;
import jd.nutils.JDHash;
import jd.nutils.encoding.Encoding;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.utils.CLRLoader;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPLiveHeader
extends ReconnectMethod {
    private Configuration configuration = JDUtilities.getConfiguration();
    private HashMap<String, String> headerProperties;
    private HashMap<String, String> variables;

    private static String[] splitLines(String string) {
        return string.split("\r\n|\r|\n");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean runCommands(ProgressController progressController) {
        Object object;
        String string = this.configuration.getIntegerProperty("RECONNECT_TYPE", 0) == 3 ? ((object = CLRLoader.createLiveHeader(this.configuration.getStringProperty("HTTPSEND_REQUESTS_CLR"))) != null ? object[1] : null) : this.configuration.getStringProperty("HTTPSEND_REQUESTS");
        object = this.configuration.getStringProperty("HTTPSEND_USER");
        String string2 = this.configuration.getStringProperty("HTTPSEND_PASS");
        String string3 = this.configuration.getStringProperty("HTTPSEND_IP");
        if (string == null || string.length() == 0) {
            progressController.doFinalize();
            logger.severe("No LiveHeader Script found");
            return false;
        }
        string = string.replaceAll("\\[\\[\\[", "<");
        string = string.replaceAll("\\]\\]\\]", ">");
        string = string.replaceAll("<REQUEST(.*?)>", "<REQUEST$1><![CDATA[");
        string = string.replaceAll("</REQUEST>", "]]></REQUEST>");
        string = string.replaceAll("<RESPONSE(.*?)>", "<RESPONSE$1><![CDATA[");
        string = string.replaceAll("</RESPONSE.*>", "]]></RESPONSE>");
        this.variables = new HashMap();
        this.variables.put("user", (String)object);
        this.variables.put("pass", string2);
        this.variables.put("basicauth", Encoding.Base64Encode((String)(String.valueOf(object) + ":" + string2)));
        this.variables.put("routerip", string3);
        this.headerProperties = new HashMap();
        Browser browser = new Browser();
        browser.setProxy(JDProxy.NO_PROXY);
        if (object != null && string2 != null) {
            browser.setAuth(string3, (String)object, string2);
        }
        try {
            Document document = JDUtilities.parseXmlString(string, false);
            if (document == null) {
                progressController.doFinalize();
                logger.severe("Error while parsing the xml string: " + string);
                return false;
            }
            Node node = document.getChildNodes().item(0);
            if (node == null || !node.getNodeName().equalsIgnoreCase("HSRC")) {
                progressController.doFinalize();
                logger.severe("Root Node must be [[[HSRC]]]*[/HSRC]");
                return false;
            }
            NodeList nodeList = node.getChildNodes();
            progressController.addToMax(nodeList.getLength());
            int n = 0;
            while (n < nodeList.getLength()) {
                progressController.setStatusText(String.valueOf(JDL.L("interaction.liveHeader.progress.3_step", "(STEP)HTTPLiveHeader :")) + n);
                progressController.increase(1L);
                Node node2 = nodeList.item(n);
                if (node2.getNodeType() != 3) {
                    if (!node2.getNodeName().equalsIgnoreCase("STEP")) {
                        progressController.doFinalize();
                        logger.severe("Root Node should only contain [[[STEP]]]*[[[/STEP]]] ChildTag: " + node2.getNodeName());
                        return false;
                    }
                    NodeList nodeList2 = node2.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        CharSequence charSequence;
                        Object object2;
                        String[] stringArray;
                        Object object3;
                        Object object4;
                        Node node3 = nodeList2.item(n2);
                        progressController.setStatusText(JDL.LF("interaction.liveHeader.progress.4_step", "(%s)HTTPLiveHeader", node3.getNodeName()));
                        if (node3.getNodeName().equalsIgnoreCase("DEFINE")) {
                            object4 = node3.getAttributes();
                            int n3 = 0;
                            while (n3 < object4.getLength()) {
                                object3 = object4.item(n3).getNodeName();
                                String string4 = object4.item(n3).getNodeValue();
                                stringArray = string4.split("\\%\\%\\%(.*?)\\%\\%\\%");
                                object2 = new Regex(string4, "%%%(.*?)%%%").getColumn(-1);
                                if (((String[])object2).length > 0) {
                                    int n4;
                                    if (string4.startsWith(object2[0])) {
                                        charSequence = new StringBuilder();
                                        logger.finer("Variables: " + this.variables);
                                        logger.finer("Headerproperties: " + this.headerProperties);
                                        n4 = 0;
                                        while (n4 <= stringArray.length) {
                                            logger.finer("Replace variable: ********(" + (String)object2[n4 - 1] + ")");
                                            ((StringBuilder)charSequence).append(this.getModifiedVariable((String)object2[n4 - 1]));
                                            if (n4 < stringArray.length) {
                                                ((StringBuilder)charSequence).append(stringArray[n4]);
                                            }
                                            ++n4;
                                        }
                                    } else {
                                        charSequence = new StringBuilder(stringArray[0]);
                                        logger.finer("Variables: " + this.variables);
                                        logger.finer("Headerproperties: " + this.headerProperties);
                                        n4 = 1;
                                        while (n4 <= stringArray.length) {
                                            if (n4 <= ((Object)object2).length) {
                                                logger.finer("Replace variable: *********(" + (String)object2[n4 - 1] + ")");
                                                ((StringBuilder)charSequence).append(this.getModifiedVariable((String)object2[n4 - 1]));
                                                if (n4 < stringArray.length) {
                                                    ((StringBuilder)charSequence).append(stringArray[n4]);
                                                }
                                            }
                                            ++n4;
                                        }
                                    }
                                    string4 = ((StringBuilder)charSequence).toString();
                                }
                                this.variables.put((String)object3, string4);
                                ++n3;
                            }
                            logger.finer("Variables set: " + this.variables);
                        }
                        if (node3.getNodeName().equalsIgnoreCase("PARSE")) {
                            object4 = HTTPLiveHeader.splitLines(node3.getChildNodes().item(0).getNodeValue().trim());
                            stringArray = object4;
                            int n5 = ((String[])object4).length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String string5 = stringArray[n6];
                                object2 = new Regex(string5, "(.*?):").getMatch(0);
                                charSequence = new Regex(string5, ".*?:(.+)").getMatch(0);
                                if (object2 != null && charSequence != null) {
                                    object2 = ((String)object2).trim();
                                    String string6 = browser.getRegex((String)(charSequence = ((String)charSequence).trim())).getMatch(0);
                                    if (string6 != null) {
                                        string6 = string6.trim();
                                        logger.finer("Parse: Varname=" + (String)object2 + " Pattern=" + (String)charSequence + "->" + string6);
                                        this.variables.put((String)object2, string6);
                                    } else {
                                        logger.finer("Parse: Varname=" + (String)object2 + " Pattern=" + (String)charSequence + "->NOT FOUND!");
                                    }
                                }
                                ++n6;
                            }
                        }
                        if (node3.getNodeName().equalsIgnoreCase("REQUEST")) {
                            boolean bl = false;
                            boolean bl2 = false;
                            if (node3.getChildNodes().getLength() != 1) {
                                progressController.doFinalize();
                                logger.severe("A REQUEST Tag is not allowed to have childTags.");
                                return false;
                            }
                            object3 = node3.getAttributes();
                            if (object3.getNamedItem("https") != null) {
                                bl = true;
                            }
                            if (object3.getNamedItem("raw") != null) {
                                bl2 = true;
                            }
                            Browser browser2 = null;
                            try {
                                browser2 = this.doRequest(node3.getChildNodes().item(0).getNodeValue().trim(), browser, bl, bl2);
                            }
                            catch (Exception exception) {
                                browser2 = null;
                            }
                            try {
                                Thread.sleep(150L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (browser2 == null || !browser2.getHttpConnection().isOK()) {
                                logger.severe("Request error!");
                            } else {
                                browser = browser2;
                            }
                        }
                        if (node3.getNodeName().equalsIgnoreCase("RESPONSE")) {
                            logger.finer("get Response");
                            if (node3.getChildNodes().getLength() != 1) {
                                progressController.doFinalize();
                                logger.severe("A RESPONSE Tag is not allowed to have childTags.");
                                return false;
                            }
                            object4 = node3.getAttributes();
                            if (object4.getNamedItem("keys") == null) {
                                progressController.doFinalize();
                                logger.severe("A RESPONSE Node needs a Keys Attribute: " + node3);
                                return false;
                            }
                            String[] stringArray2 = object4.getNamedItem("keys").getNodeValue().split("\\;");
                            this.getVariables(node3.getChildNodes().item(0).getNodeValue().trim(), stringArray2, browser);
                        }
                        if (node3.getNodeName().equalsIgnoreCase("WAIT")) {
                            object4 = node3.getAttributes();
                            Node node4 = object4.getNamedItem("seconds");
                            if (node4 == null) {
                                logger.severe("A Wait Step needs a Waittimeattribute: e.g.: <WAIT seconds=\"15\"/>");
                                return false;
                            }
                            logger.finer("Wait " + node4.getNodeValue() + " seconds");
                            int n7 = Formatter.filterInt((String)node4.getNodeValue());
                            Thread.sleep(n7 * 1000);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            progressController.doFinalize();
            logger.severe(exception.getCause() + " : " + exception.getMessage());
            return false;
        }
        return true;
    }

    private Browser doRequest(String string, Browser browser, boolean bl, boolean bl2) {
        block35: {
            String string2;
            String string3;
            HashMap<String, String> hashMap;
            String string4;
            String string5;
            StringBuilder stringBuilder;
            block34: {
                int n;
                Object object;
                String[] stringArray;
                block33: {
                    block32: {
                        stringBuilder = new StringBuilder();
                        string5 = null;
                        string4 = "http://";
                        if (bl) {
                            string4 = "https://";
                        }
                        if (logger.isLoggable(Level.FINEST)) {
                            browser.forceDebug(true);
                        } else {
                            browser.forceDebug(false);
                        }
                        hashMap = new HashMap<String, String>();
                        if (bl2) {
                            browser.setHeaders(new RequestHeader());
                        }
                        stringArray = string.split("\\%\\%\\%(.*?)\\%\\%\\%");
                        String[] stringArray2 = new Regex(string, "%%%(.*?)%%%").getColumn(0);
                        if (stringArray2.length > 0) {
                            if (string.startsWith(stringArray2[0])) {
                                object = new StringBuilder();
                                logger.finer("Variables: " + this.variables);
                                logger.finer("Headerproperties: " + this.headerProperties);
                                n = 0;
                                while (n <= stringArray.length) {
                                    logger.finer("Replace variable: " + this.getModifiedVariable(stringArray2[n - 1]) + "(" + stringArray2[n - 1] + ")");
                                    ((StringBuilder)object).append(this.getModifiedVariable(stringArray2[n - 1]));
                                    if (n < stringArray.length) {
                                        ((StringBuilder)object).append(stringArray[n]);
                                    }
                                    ++n;
                                }
                            } else {
                                object = new StringBuilder(stringArray[0]);
                                logger.finer("Variables: " + this.variables);
                                logger.finer("Headerproperties: " + this.headerProperties);
                                n = 1;
                                while (n <= stringArray.length) {
                                    if (n <= stringArray2.length) {
                                        logger.finer("Replace variable: " + this.getModifiedVariable(stringArray2[n - 1]) + "(" + stringArray2[n - 1] + ")");
                                        ((StringBuilder)object).append(this.getModifiedVariable(stringArray2[n - 1]));
                                        if (n < stringArray.length) {
                                            ((StringBuilder)object).append(stringArray[n]);
                                        }
                                    }
                                    ++n;
                                }
                            }
                            string = ((StringBuilder)object).toString();
                        }
                        if (((String[])(object = HTTPLiveHeader.splitLines(string))).length != 0) break block32;
                        logger.severe("Parse Fehler:" + string);
                        return null;
                    }
                    stringArray = object[0].split(" ");
                    if (stringArray.length >= 2) break block33;
                    logger.severe("Konnte Requesttyp nicht finden: " + object[0]);
                    return null;
                }
                try {
                    string3 = stringArray[0];
                    string2 = stringArray[1];
                    n = 0;
                    int n2 = 1;
                    while (n2 < ((String[])object).length) {
                        if (n != 0) {
                            stringBuilder.append((String)object[n2]);
                            stringBuilder.append(new char[]{'\r', '\n'});
                        } else if (((String)object[n2]).trim().length() == 0) {
                            n = 1;
                        } else {
                            String[] stringArray3 = ((String)object[n2]).split("\\:");
                            if (stringArray3.length < 2) {
                                logger.warning("Syntax Fehler in: " + (String)object[n2] + "\r\n Vermute Post Parameter");
                                n = 1;
                                --n2;
                            } else {
                                hashMap.put(stringArray3[0].trim(), ((String)object[n2]).substring(stringArray3[0].length() + 1).trim());
                                if (stringArray3[0].trim().equalsIgnoreCase("HOST")) {
                                    string5 = ((String)object[n2]).substring(stringArray3[0].length() + 1).trim();
                                }
                            }
                        }
                        ++n2;
                    }
                    if (string5 != null) break block34;
                    logger.severe("Host nicht gefunden: " + string);
                    return null;
                }
                catch (Exception exception) {
                    JDLogger.exception(exception);
                    return null;
                }
            }
            browser.setConnectTimeout(5000);
            browser.setReadTimeout(5000);
            if (hashMap != null) {
                browser.getHeaders().putAll(hashMap);
            }
            if (string3.equalsIgnoreCase("GET")) {
                browser.getPage(String.valueOf(string4) + string5 + string2);
                break block35;
            }
            if (string3.equalsIgnoreCase("POST")) {
                String string6 = stringBuilder.toString().trim();
                browser.postPageRaw(String.valueOf(string4) + string5 + string2, string6);
                break block35;
            }
            if (string3.equalsIgnoreCase("AUTH")) {
                logger.finer("Convert AUTH->GET");
                browser.getPage(String.valueOf(string4) + string5 + string2);
                break block35;
            }
            logger.severe("Unknown requesttyp: " + string3);
            return null;
        }
        try {
            return browser;
        }
        catch (IOException iOException) {
            logger.severe("IO Error: " + iOException.getLocalizedMessage());
            JDLogger.exception(iOException);
            return null;
        }
    }

    public static ArrayList<String[]> getLHScripts() {
        File[] fileArray = new File(new File(JDUtilities.getJDHomeDirectoryFromEnvironment(), "jd"), "router").listFiles();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (file.isFile() && file.getName().toLowerCase().matches(".*\\.xml$")) {
                arrayList.addAll((Collection)JDIO.loadObject((Component)new JFrame(), (File)file, (boolean)true));
            }
            ++n2;
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    private String getModifiedVariable(String var1_1) {
        if (var1_1.indexOf(":::") == -1 && this.headerProperties.containsKey(var1_1)) {
            return this.headerProperties.get(var1_1);
        }
        if (var1_1.indexOf(":::") == -1) {
            return this.variables.get(var1_1);
        }
        var2_2 = this.variables.get(var1_1.substring(var1_1.lastIndexOf(":::") + 3));
        if (this.headerProperties.containsKey(var1_1.substring(var1_1.lastIndexOf(":::") + 3))) {
            var2_2 = this.headerProperties.get(var1_1.substring(var1_1.lastIndexOf(":::") + 3));
        }
        if (var2_2 != null) ** GOTO lbl29
        return "";
lbl-1000:
        // 1 sources

        {
            var4_4 = var1_1.substring(0, var3_3);
            var1_1 = var1_1.substring(var3_3 + 3);
            if (var4_4.equalsIgnoreCase("URLENCODE")) {
                var2_2 = Encoding.urlEncode((String)var2_2);
                continue;
            }
            if (var4_4.equalsIgnoreCase("URLDECODE")) {
                var2_2 = Encoding.htmlDecode((String)var2_2);
                continue;
            }
            if (var4_4.equalsIgnoreCase("UTF8DECODE")) {
                var2_2 = Encoding.UTF8Decode((String)var2_2);
                continue;
            }
            if (var4_4.equalsIgnoreCase("UTF8ENCODE")) {
                var2_2 = Encoding.UTF8Encode((String)var2_2);
                continue;
            }
            if (var4_4.equalsIgnoreCase("MD5")) {
                var2_2 = JDHash.getMD5((String)var2_2);
                continue;
            }
            if (!var4_4.equalsIgnoreCase("BASE64")) continue;
            var2_2 = Encoding.Base64Encode((String)var2_2);
lbl29:
            // 8 sources

            ** while ((var3_3 = var1_1.indexOf((String)":::")) >= 0)
        }
lbl30:
        // 1 sources

        return var2_2;
    }

    private void getVariables(String string, String[] stringArray, Browser browser) {
        logger.info("GetVariables");
        if (browser == null) {
            return;
        }
        logger.finer(string);
        Pattern pattern = Pattern.compile(string, 34);
        Matcher matcher = pattern.matcher("" + browser);
        logger.info("Matches: " + matcher.groupCount());
        if (matcher.find() && matcher.groupCount() > 0) {
            int n = 0;
            while (n < stringArray.length && n < matcher.groupCount()) {
                this.variables.put(stringArray[n], matcher.group(n + 1));
                logger.info("Set Variable: " + stringArray[n] + " = " + matcher.group(n + 1));
                ++n;
            }
        } else {
            logger.severe("Regular Expression without matches: " + string);
        }
    }

    @Override
    protected void initConfig() {
    }
}

