/*
 * Decompiled with CFR 0.152.
 */
package jd.crypt;

public class AEStables {
    private byte[] E = new byte[256];
    private byte[] inv = new byte[256];
    private byte[] invS = new byte[256];
    private byte[] L = new byte[256];
    private byte[] powX = new byte[15];
    private byte[] S = new byte[256];

    public AEStables() {
        this.loadE();
        this.loadL();
        this.loadInv();
        this.loadS();
        this.loadInvS();
        this.loadPowX();
    }

    public byte FFInv(byte by) {
        byte by2 = this.L[by & 0xFF];
        return this.E[255 - (by2 & 0xFF)];
    }

    public byte FFMul(byte by, byte by2) {
        byte by3 = by;
        byte by4 = by2;
        byte by5 = 0;
        while (by3 != 0) {
            if ((by3 & 1) != 0) {
                by5 = (byte)(by5 ^ by4);
            }
            byte by6 = (byte)(by4 & 0x80);
            by4 = (byte)(by4 << 1);
            if (by6 != 0) {
                by4 = (byte)(by4 ^ 0x1B);
            }
            by3 = (byte)((by3 & 0xFF) >> 1);
        }
        return by5;
    }

    public byte FFMulFast(byte by, byte by2) {
        int n = 0;
        if (by == 0 || by2 == 0) {
            return 0;
        }
        n = (this.L[by & 0xFF] & 0xFF) + (this.L[by2 & 0xFF] & 0xFF);
        if (n > 255) {
            n -= 255;
        }
        return this.E[n & 0xFF];
    }

    public byte invSBox(byte by) {
        return this.invS[by & 0xFF];
    }

    public int ithBit(byte by, int n) {
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        return (by & nArray[n]) >> n;
    }

    private void loadE() {
        byte by = 1;
        int n = 0;
        this.E[n++] = 1;
        int n2 = 0;
        while (n2 < 255) {
            byte by2 = this.FFMul(by, (byte)3);
            this.E[n++] = by2;
            by = by2;
            ++n2;
        }
    }

    private void loadInv() {
        int n = 0;
        while (n < 256) {
            this.inv[n] = (byte)(this.FFInv((byte)(n & 0xFF)) & 0xFF);
            ++n;
        }
    }

    private void loadInvS() {
        int n = 0;
        while (n < 256) {
            this.invS[this.S[n] & 0xFF] = (byte)n;
            ++n;
        }
    }

    private void loadL() {
        int n = 0;
        while (n < 255) {
            this.L[this.E[n] & 0xFF] = (byte)n;
            ++n;
        }
    }

    private void loadPowX() {
        byte by;
        byte by2 = by = 2;
        this.powX[0] = 1;
        this.powX[1] = by;
        int n = 2;
        while (n < 15) {
            this.powX[n] = by2 = this.FFMul(by2, by);
            ++n;
        }
    }

    private void loadS() {
        int n = 0;
        while (n < 256) {
            this.S[n] = (byte)(this.subBytes((byte)(n & 0xFF)) & 0xFF);
            ++n;
        }
    }

    public byte Rcon(int n) {
        return this.powX[n - 1];
    }

    public byte SBox(byte by) {
        return this.S[by & 0xFF];
    }

    public int subBytes(byte by) {
        int n = 0;
        if (by != 0) {
            by = (byte)(this.FFInv(by) & 0xFF);
        }
        byte by2 = 99;
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 0;
            n3 = this.ithBit(by, n2) ^ this.ithBit(by, (n2 + 4) % 8) ^ this.ithBit(by, (n2 + 5) % 8) ^ this.ithBit(by, (n2 + 6) % 8) ^ this.ithBit(by, (n2 + 7) % 8) ^ this.ithBit(by2, n2);
            n |= n3 << n2;
            ++n2;
        }
        return n;
    }
}

