/*
 * Decompiled with CFR 0.152.
 */
package jd.nrouter;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.nrouter.IPCheckProvider;
import jd.nrouter.WebIPCheck;

public class IPCheck {
    public static ArrayList<IPCheckProvider> IP_CHECK_SERVICES = new ArrayList();
    private static int IP_CHECK_INDEX = 0;
    private static final Object LOCK = new Object();
    private static IPCheckProvider CustomIPCheckProvider = null;
    private static final IPCheckProvider CustomWebIPCheck = new IPCheckProvider(){
        private int maxerror = 2;
        private int errorcount = 0;
        private Browser br = new Browser();

        public Object getIP() {
            if (this.errorcount > this.maxerror) {
                this.errorcount = 0;
                return CheckStatus.SEQFAILED;
            }
            String string = SubConfiguration.getConfig("DOWNLOAD").getStringProperty("GLOBAL_IP_CHECK_SITE3", "Please enter Website for IPCheck here");
            String string2 = SubConfiguration.getConfig("DOWNLOAD").getStringProperty("GLOBAL_IP_PATTERN3", "Please enter Regex for IPCheck here");
            try {
                new URL(string);
                this.br.setConnectTimeout(15000);
                this.br.setReadTimeout(15000);
                Matcher matcher = Pattern.compile(string2, 34).matcher(this.br.getPage(string));
                if (matcher.find() && matcher.groupCount() > 0) {
                    this.errorcount = 0;
                    return matcher.group(1);
                }
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
            }
            ++this.errorcount;
            return CheckStatus.FAILED;
        }

        public String getInfo() {
            return "Customized IPCheck: " + SubConfiguration.getConfig("DOWNLOAD").getStringProperty("GLOBAL_IP_CHECK_SITE3", "Please enter Website for IPCheck here");
        }
    };
    public static String LATEST_IP;

    static {
        IP_CHECK_SERVICES.add(new WebIPCheck("http://ipcheck1.jdownloader.org", "(\\d+\\.\\d+\\.\\d+\\.\\d+)"));
        IP_CHECK_SERVICES.add(new WebIPCheck("http://ipcheck0.jdownloader.org", "(\\d+\\.\\d+\\.\\d+\\.\\d+)"));
        Collections.shuffle(IP_CHECK_SERVICES);
        LATEST_IP = null;
    }

    public static void setCustomIPCheckProvider(IPCheckProvider iPCheckProvider) {
        CustomIPCheckProvider = iPCheckProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIPAddress() {
        Object object = null;
        Object object2 = LOCK;
        synchronized (object2) {
            if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("GLOBAL_IP_BALANCE3", true).booleanValue()) {
                if (CustomIPCheckProvider != null) {
                    object = CustomIPCheckProvider.getIP();
                } else {
                    int n = 0;
                    while (n < IP_CHECK_SERVICES.size() / 2 + 1) {
                        object = IPCheck.checkIPProvider();
                        if (object == null || object == CheckStatus.FAILED) {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else if (object == CheckStatus.SEQFAILED) {
                            try {
                                Thread.sleep(9000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else if (object instanceof String) break;
                        ++n;
                    }
                }
            } else {
                object = CustomWebIPCheck.getIP();
            }
        }
        if (object == null || object instanceof CheckStatus || !(object instanceof String)) {
            JDLogger.getLogger().severe("IPCheck failed");
            return "na";
        }
        return object.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object checkIPProvider() {
        if (IP_CHECK_SERVICES.size() == 0) {
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            IPCheckProvider iPCheckProvider = IP_CHECK_SERVICES.get(IP_CHECK_INDEX %= IP_CHECK_SERVICES.size());
            ++IP_CHECK_INDEX;
            return iPCheckProvider.getIP();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CheckStatus {
        FAILED,
        SEQFAILED;

    }
}

