/*
 * Decompiled with CFR 0.152.
 */
package jd.nrouter;

import java.net.InetAddress;
import jd.controlling.JDLogger;
import jd.nrouter.Router;
import jd.nutils.Threader;
import jd.nutils.jobber.JDRunnable;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.control.ActionRequest;
import org.cybergarage.upnp.device.SearchResponseListener;
import org.cybergarage.upnp.ssdp.SSDPPacket;

public class UPNPRouter
extends Router {
    private int timeout = 10000;
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private ControlPoint controlPoint = null;
    protected Device device;
    private Device wanConnectionDevice;

    public UPNPRouter(InetAddress inetAddress) {
        super(inetAddress);
        this.discover();
    }

    public String toString() {
        return String.valueOf(this.device.getFriendlyName()) + " @ " + this.device.getInterfaceAddress();
    }

    public String getRefreshIPRequest() {
        Device device = this.getWanConnectionDevice();
        Action action = device.getAction("ForceTermination");
        ArgumentList argumentList = action.getInputArgumentList();
        ActionRequest actionRequest = new ActionRequest();
        actionRequest.setRequest(action, argumentList);
        return actionRequest.toString();
    }

    public boolean refreshIP() {
        Device device = this.getWanConnectionDevice();
        Action action = device.getAction("ForceTermination");
        if (action.postControlAction()) {
            ArgumentList argumentList = action.getOutputArgumentList();
            int n = argumentList.size();
            int n2 = 0;
            while (n2 < n) {
                Argument argument = argumentList.getArgument(n2);
                System.out.println(String.valueOf(argument.getName()) + ": " + argument.getValue());
                ++n2;
            }
            return true;
        }
        return super.refreshIP();
    }

    public synchronized void discover() {
        if (this.controlPoint != null) {
            return;
        }
        this.controlPoint = new ControlPoint();
        final Threader threader = new Threader();
        this.controlPoint.addSearchResponseListener(new SearchResponseListener(){

            public void deviceSearchResponseReceived(SSDPPacket sSDPPacket) {
                InetAddress inetAddress = sSDPPacket.getRemoteInetAddress();
                JDLogger.getLogger().info("Received foreign package: " + sSDPPacket);
                if (inetAddress.getHostAddress().equals(UPNPRouter.this.getAddress().getHostAddress())) {
                    UPNPRouter.this.controlPoint.stop();
                    for (Object e : UPNPRouter.this.controlPoint.getDeviceList()) {
                        Device device = (Device)e;
                        System.out.println("Device: " + device.getFriendlyName() + device.getDeviceType());
                        if (!device.getDeviceType().equals(UPNPRouter.ROUTER_DEVICE)) continue;
                        UPNPRouter.this.device = device;
                        break;
                    }
                    threader.interrupt();
                }
            }
        });
        threader.add(new JDRunnable(){

            public void go() throws Exception {
                try {
                    Thread.sleep(UPNPRouter.this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                UPNPRouter.this.controlPoint.stop();
                threader.interrupt();
            }
        });
        this.controlPoint.start();
        threader.startAndWait();
    }

    public boolean isUPNPDevice() {
        this.discover();
        return this.device != null;
    }

    public String getExternalIPAddress() {
        Device device = this.getWanConnectionDevice();
        Action action = device.getAction("GetExternalIPAddress");
        if (action.postControlAction()) {
            int n = 0;
            ArgumentList argumentList = action.getOutputArgumentList();
            int n2 = argumentList.size();
            if (n < n2) {
                Argument argument = argumentList.getArgument(n);
                return argument.getValue();
            }
            return super.getExternalIPAddress();
        }
        return super.getExternalIPAddress();
    }

    public Device getWanConnectionDevice() {
        this.discover();
        if (this.wanConnectionDevice != null) {
            return this.wanConnectionDevice;
        }
        for (Object e : this.device.getDeviceList()) {
            Device device = (Device)e;
            System.out.println("Device: " + device.getFriendlyName() + device.getDeviceType());
            if (!device.getDeviceType().equals(WAN_DEVICE)) continue;
            DeviceList deviceList = device.getDeviceList();
            int n = 0;
            while (n < device.getDeviceList().size()) {
                Device device2 = deviceList.getDevice(n);
                System.out.println("Device: " + device2.getFriendlyName() + device2.getDeviceType());
                if (device2.getDeviceType().equals(WANCON_DEVICE)) {
                    this.wanConnectionDevice = device;
                    return device;
                }
                ++n;
            }
        }
        return null;
    }
}

