/*
 * Decompiled with CFR 0.152.
 */
package jd.parser.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.parser.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLParser {
    public static ArrayList<String> findPasswords(String string) {
        String string2;
        if (string == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.replaceAll("(?s)<!-- .*? -->", "").replaceAll("(?s)<script .*?>.*?</script>", "").replaceAll("(?s)<.*?>", "").replaceAll("Spoiler:", "").replaceAll("(no.{0,2}|kein.{0,8}|ohne.{0,8}|nicht.{0,8})(pw|passwort|password|pass)", "").replaceAll("(pw|passwort|password|pass).{0,12}(nicht|falsch|wrong)", "");
        Pattern pattern = Pattern.compile("(\u043f\u0430\u0440\u043e\u043b\u044c|\u043f\u0430\u0441\u0441|ps?w|passwort|password|passw?)[\\s][\\s]*?[\"']([[^\\:\"'\\s]][^\"'\\s]*)[\"']?", 2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(2);
            if (string2.length() <= 2 || string2.matches(".*(rar|zip|jpg|gif|png|html|php|avi|mpg)$") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        pattern = Pattern.compile("(\u043f\u0430\u0440\u043e\u043b\u044c|\u043f\u0430\u0441\u0441|ps?w|passwort|password|passw?)[\\s][\\s]*?([[^\\:\"'\\s]][^\"'\\s]*)[\\s]?", 2);
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(2);
            if (string2.length() <= 4 || string2.matches(".*(rar|zip|jpg|gif|png|html|php|avi|mpg)$") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        pattern = Pattern.compile("(\u043f\u0430\u0440\u043e\u043b\u044c|\u043f\u0430\u0441\u0441|ps?w|passwort|password|passw?)[\\s]?\\:[\\s]*?[\"']([^\"']+)[\"']?", 2);
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(2);
            if (string2.length() <= 2 || string2.matches(".*(rar|zip|jpg|gif|png|html|php|avi|mpg)$") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        pattern = Pattern.compile("(\u043f\u0430\u0440\u043e\u043b\u044c|\u043f\u0430\u0441\u0441|ps?w|passwort|password|passw?)[\\s]?\\:[\\s]*?([^\"'\\s]+)[\\s]?", 2);
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(2);
            if (string2.length() <= 2 || string2.matches(".*(rar|zip|jpg|gif|png|html|php|avi|mpg)$") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String getFormInputHidden(String string) {
        return HTMLParser.joinMap(HTMLParser.getInputHiddenFields(string), "=", "&");
    }

    public static String getFormInputHidden(String string, String string2, String string3) {
        String string4 = new Regex(string, String.valueOf(string2) + "(.*?)" + string3).getMatch(0);
        if (string4 == null) {
            return null;
        }
        return HTMLParser.getFormInputHidden(string4);
    }

    public static String getHttpLinkList(String string) {
        String[] stringArray = HTMLParser.getHttpLinks(string, null);
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[]{'\"', '\r', '\n'};
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            stringBuilder.append('\"');
            stringBuilder.append(string2.trim());
            stringBuilder.append(cArray);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String[] getHttpLinks(String string, String string2) {
        Httppattern[] httppatternArray;
        Object object;
        Pattern[] patternArray;
        String string3;
        String string4;
        string = string.trim();
        String string5 = "(flashget|h.{2,3}|httpviajd|httpsviajd|https|ccf|dlc|ftp|jd|rsdf|jdlist)";
        if (!string.matches(".*<.*>.*")) {
            int n = new Regex(string, "(" + string5 + "://|(?<!://)www\\.)").count();
            if (n == 0) {
                return new String[0];
            }
            if (n == 1 && string.length() < 100 && string.matches("^(" + string5 + "://|www\\.).*")) {
                string4 = string.replaceFirst("h.{2,3}://", "http://").replaceFirst("^www\\.", "http://www.").replaceFirst("[<>\"].*", "");
                string3 = null;
                try {
                    if (!string4.matches(".*\\s.*") || (string3 = new Browser().openGetConnection(string4.replaceFirst("^httpviajd", "http").replaceAll("\\s", "%20"))).isOK()) {
                        if (string3 != null) {
                            string3.disconnect();
                        }
                        return new String[]{string4.replaceAll("\\s", "%20")};
                    }
                }
                catch (Exception exception) {
                    JDLogger.exception(exception);
                }
                if (string3 != null) {
                    string3.disconnect();
                }
            }
        }
        string2 = string2 == null ? "" : string2;
        string3 = "";
        String string6 = "";
        LinkedList<String> linkedList = new LinkedList<String>();
        Pattern[] patternArray2 = patternArray = new Pattern[]{Pattern.compile("(?s)<[ ]?base[^>]*?href=('|\")(.*?)\\1", 2), Pattern.compile("(?s)<[ ]?base[^>]*?(href)=([^'\"][^\\s]*)", 2)};
        int n = patternArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = patternArray2[n2];
            Matcher matcher = ((Pattern)object).matcher(string);
            if (matcher.find()) {
                string2 = matcher.group(2);
                break;
            }
            ++n2;
        }
        object = "http";
        if (string2 != null && string2.trim().length() > 0) {
            if (string2.startsWith("https://")) {
                object = "https";
            }
            if (string2.startsWith("jd://")) {
                object = "jd";
            }
            if (string2.startsWith("rsdf://")) {
                object = "rsdf";
            }
            if (string2.startsWith("ccf://")) {
                object = "ccf";
            }
            if (string2.startsWith("dlc://")) {
                object = "dlc";
            }
            if (string2.startsWith("jdlist://")) {
                object = "jdlist";
            }
            if (string2.startsWith("ftp://")) {
                object = "ftp";
            }
            if (string2.startsWith("flashget://")) {
                object = "flashget";
            }
            string3 = (n2 = (string2 = string2.replace(String.valueOf(object) + "://", "")).lastIndexOf(47)) != -1 ? String.valueOf(object) + "://" + string2.substring(0, n2 + 1) : String.valueOf(object) + "://" + string2 + "/";
            n2 = string2.indexOf(47);
            string6 = n2 != -1 ? String.valueOf(object) + "://" + string2.substring(0, n2) : String.valueOf(object) + "://" + string2;
            string2 = String.valueOf(object) + "://" + string2;
        } else {
            string2 = "";
        }
        final class Httppattern {
            public Pattern p;
            public int group;

            public Httppattern(Pattern pattern, int n) {
                this.p = pattern;
                this.group = n;
            }
        }
        Httppattern[] httppatternArray2 = httppatternArray = new Httppattern[]{new Httppattern(Pattern.compile("src.*?=.*?['|\"](.*?)['|\"]", 34), 1), new Httppattern(Pattern.compile("src.*?=(.*?)[ |>]", 34), 1), new Httppattern(Pattern.compile("(<[ ]?a[^>]*?href=|<[ ]?form[^>]*?action=)('|\")(.*?)\\2", 34), 3), new Httppattern(Pattern.compile("(<[ ]?a[^>]*?href=|<[ ]?form[^>]*?action=)([^'\"][^\\s]*)", 34), 2), new Httppattern(Pattern.compile("\\[(link|url)\\](.*?)\\[/\\1\\]", 34), 2)};
        int n3 = httppatternArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Httppattern httppattern = httppatternArray2[n4];
            Matcher matcher = httppattern.p.matcher(string);
            while (matcher.find()) {
                string4 = matcher.group(httppattern.group);
                if (!((string4 = string4.replaceAll("h.{2,3}://", "http://")).length() > 3 && string4.matches("^" + string5 + "://.*") || string4.length() <= 0)) {
                    if (string4.length() > 2 && string4.startsWith("www")) {
                        string4 = String.valueOf(object) + "://" + string4;
                    }
                    string4 = string4.charAt(0) == '/' ? String.valueOf(string6) + string4 : (string4.charAt(0) == '#' ? String.valueOf(string2) + string4 : String.valueOf(string3) + string4);
                }
                string4 = string4.trim();
                try {
                    new URL(string4);
                    if (linkedList.contains(string4)) continue;
                    linkedList.add(string4);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ++n4;
        }
        string = string.replaceAll("(?s)<.*?>", "\r\n");
        string = string.replaceAll("(?s)\\[(url|link)\\].*?\\[/(url|link)\\]", "");
        Matcher matcher = Pattern.compile("(" + string5 + "://|www\\.)[^\\s<>'\"]*(((?!\\s" + string5 + "://|\\swww\\.)[^<>'\"]){0,20}([\\?|\\&][^<>'\\s\"]{1,10}\\=[^<>'\\s\"]+|\\.(htm[^<>'\\s\"]*|php|cgi|rar|zip|exe|avi|mpe?g|7z|bz2|doc|jpg|bmp|m4a|mdf|mkv|wav|mp[34]|pdf|wm[^<>'\\s\"]*|xcf|jar|swf|class|cue|bin|dll|cab|png|ico|gif|iso)[^<>'\\s\"]*))?", 2).matcher(string);
        while (matcher.find()) {
            string4 = matcher.group(0);
            string4 = string4.replaceAll("^h.{2,3}://", "http://");
            string4 = string4.replaceFirst("^www\\.", "http://www\\.");
            if (linkedList.contains(string4 = string4.trim())) continue;
            linkedList.add(string4);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static HashMap<String, String> getInputHiddenFields(String string) {
        Pattern pattern = Pattern.compile("(?s)<[ ]?input([^>]*?type=['\"]?hidden['\"]?[^>]*?)[/]?>", 2);
        Pattern pattern2 = Pattern.compile("name=['\"]([^'\"]*?)['\"]", 2);
        Pattern pattern3 = Pattern.compile("value=['\"]([^'\"]*?)['\"]", 2);
        Pattern pattern4 = Pattern.compile("name=([^\\s]*)", 2);
        Pattern pattern5 = Pattern.compile("value=([^\\s]*)", 2);
        Matcher matcher = pattern.matcher(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            Matcher matcher2 = pattern2.matcher(String.valueOf(matcher.group(1)) + " ");
            Matcher matcher3 = pattern3.matcher(String.valueOf(matcher.group(1)) + " ");
            Matcher matcher4 = pattern4.matcher(String.valueOf(matcher.group(1)) + " ");
            Matcher matcher5 = pattern5.matcher(String.valueOf(matcher.group(1)) + " ");
            boolean bl = false;
            String string2 = null;
            String string3 = null;
            if (matcher2.find()) {
                bl = true;
                string3 = matcher2.group(1);
            } else if (matcher4.find()) {
                bl = true;
                string3 = matcher4.group(1);
            }
            if (matcher3.find() && bl) {
                string2 = matcher3.group(1);
            } else if (matcher5.find() && bl) {
                string2 = matcher5.group(1);
            } else {
                bl = false;
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    public static HashMap<String, String> getInputHiddenFields(String string, String string2, String string3) {
        return HTMLParser.getInputHiddenFields(new Regex(string, String.valueOf(string2) + "(.*?)" + string3).getMatch(0));
    }

    public static String joinMap(Map<String, String> map, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append(string);
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }
}

