/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.File;
import java.lang.reflect.Field;
import jd.controlling.JDLogger;
import jd.nutils.Formatter;

public class ContainerStatus {
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_FINISHED = 2;
    public static final int TODO = 1;
    private File container;
    private int status = 1;
    private String statusText;
    private int latestStatus;

    public ContainerStatus() {
    }

    public ContainerStatus(File file) {
        this.container = file;
    }

    public void addStatus(int n) {
        this.latestStatus = n;
        this.status |= n;
    }

    public File getContainer() {
        return this.container;
    }

    public boolean hasStatus(int n) {
        return (this.status & n) > 0;
    }

    public boolean isStatus(int n) {
        return this.status == n;
    }

    public void removeStatus(int n) {
        this.status ^= n;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setStatusText(String string) {
        this.statusText = string;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String toString() {
        Object object;
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(Formatter.fillString((String)Integer.toBinaryString(this.status), (String)"0", (String)"", (int)32)) + " <Statuscode\r\n");
        String string = "";
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = fieldArray2[n2];
            if (((Field)object).getModifiers() == 25) {
                try {
                    int n3 = ((Field)object).getInt(this);
                    if (this.hasStatus(n3)) {
                        if (n3 == this.latestStatus) {
                            string = "latest:" + ((Field)object).getName() + "\r\n";
                            stringBuilder.append(String.valueOf(Formatter.fillString((String)Integer.toBinaryString(n3), (String)"0", (String)"", (int)32)) + " |" + ((Field)object).getName() + "\r\n");
                        } else {
                            stringBuilder.append(String.valueOf(Formatter.fillString((String)Integer.toBinaryString(n3), (String)"0", (String)"", (int)32)) + " |" + ((Field)object).getName() + "\r\n");
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    JDLogger.exception(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    JDLogger.exception(illegalAccessException);
                }
            }
            ++n2;
        }
        object = String.valueOf(string) + stringBuilder;
        if (this.statusText != null) {
            object = String.valueOf(object) + "StatusText: " + this.statusText + "\r\n";
        }
        return object;
    }
}

