/*
 * Decompiled with CFR 0.152.
 */
package jd.router;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import jd.controlling.JDLogger;
import jd.nrouter.RouterUtils;
import jd.nutils.OSDetector;
import jd.parser.Regex;
import jd.router.RouterInfoCollector;
import jd.utils.JDUtilities;

public class GetMacAdress {
    public static String getMacAddress() throws SocketException, UnknownHostException {
        try {
            return new GetMacAdress().getMacAddress(RouterInfoCollector.getRouterIP());
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    public String getMacAddress(InetAddress inetAddress) throws UnknownHostException, IOException, InterruptedException {
        String string = this.callArpTool(inetAddress.getHostAddress());
        String string2 = new Regex(string, "..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?").getMatch(-1).replaceAll("-", ":");
        if (string2 == null) {
            return null;
        }
        string2 = string2.replaceAll("\\s", "0");
        String[] stringArray = string2.split("[:\\-]");
        StringBuilder stringBuilder = new StringBuilder(18);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            if (string3.length() < 2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string3);
            stringBuilder.append(':');
            ++n2;
        }
        return stringBuilder.toString().substring(0, 17);
    }

    private String callArpTool(String string) throws IOException, InterruptedException {
        if (OSDetector.isWindows()) {
            return this.callArpToolWindows(string);
        }
        return this.callArpToolDefault(string);
    }

    private String callArpToolWindows(String string) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder("ping", string);
        processBuilder.start();
        String[] stringArray = JDUtilities.runCommand("arp", new String[]{"-a"}, null, 10).split(System.getProperty("line.separator"));
        processBuilder.directory();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.indexOf(string) > -1) {
                return string2;
            }
            ++n2;
        }
        return null;
    }

    private String callArpToolDefault(String string) throws IOException, InterruptedException {
        String string2;
        block8: {
            ProcessBuilder processBuilder;
            InetAddress inetAddress;
            block7: {
                string2 = null;
                inetAddress = InetAddress.getByName(string);
                processBuilder = null;
                try {
                    processBuilder = new ProcessBuilder("ping", string);
                    processBuilder.start();
                    string2 = JDUtilities.runCommand("arp", new String[]{string}, null, 10);
                    processBuilder.directory();
                    if (!string2.matches("(?is).*((" + inetAddress.getHostName() + "|" + inetAddress.getHostAddress() + ").*..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?|.*..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?.*(" + inetAddress.getHostName() + "|" + inetAddress.getHostAddress() + ")).*")) {
                        string2 = null;
                    }
                }
                catch (Exception exception) {
                    if (processBuilder == null) break block7;
                    processBuilder.directory();
                }
            }
            if (string2 == null || string2.trim().length() == 0) {
                try {
                    processBuilder = new ProcessBuilder("ping", string);
                    processBuilder.start();
                    string2 = JDUtilities.runCommand("ip", new String[]{"neigh", "show"}, null, 10);
                    processBuilder.directory();
                    if (string2 != null) {
                        string2 = !string2.matches("(?is).*((" + inetAddress.getHostName() + "|" + inetAddress.getHostAddress() + ").*..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?|.*..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?[:\\-]..?.*(" + inetAddress.getHostName() + "|" + inetAddress.getHostAddress() + ")).*") ? null : new Regex(string2, "(" + inetAddress.getHostName() + "|" + inetAddress.getHostAddress() + ")[^\r\n]*").getMatch(-1);
                    }
                }
                catch (Exception exception) {
                    if (processBuilder == null) break block8;
                    processBuilder.directory();
                }
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(new GetMacAdress().getMacAddress(RouterUtils.getAddress(false)));
        }
        catch (SocketException socketException) {
            JDLogger.exception(socketException);
        }
        catch (UnknownHostException unknownHostException) {
            JDLogger.exception(unknownHostException);
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
        }
        catch (InterruptedException interruptedException) {
            JDLogger.exception(interruptedException);
        }
    }
}

