/*
 * Decompiled with CFR 0.152.
 */
package jd.router;

import java.awt.Component;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import jd.controlling.JDLogger;
import jd.nutils.io.JDIO;
import jd.router.RouterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterParser {
    private static Logger logger = JDLogger.getLogger();
    int positionInFile = 0;
    private byte[] readBuffer = new byte[8];

    private String getPlainURL(String string) {
        if (string.startsWith("POST")) {
            int n = (string = string.substring("POST".length())).indexOf("?");
            if (n > 0) {
                string = string.substring(0, n);
            }
        } else if (string.startsWith("<POST>")) {
            int n = (string = string.substring("<POST>".length())).indexOf("?");
            if (n > 0) {
                string = string.substring(0, n);
            }
        } else if (string.startsWith("GET")) {
            string = string.substring("GET".length());
        } else if (string.startsWith("<GET>")) {
            string = string.substring("<GET>".length());
        }
        return string;
    }

    private String getPostParams(String string) {
        if (!string.startsWith("POST") && !string.startsWith("<POST>")) {
            return null;
        }
        int n = string.indexOf("?");
        if (n > 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    private int getRequestType(String string) {
        if (string.startsWith("POST") || string.startsWith("<POST>")) {
            return 3;
        }
        return 2;
    }

    public Vector<RouterData> parseFile(File file) {
        Vector<RouterData> vector = new Vector<RouterData>();
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n2 = this.readInt(fileInputStream) * 2;
            while (n < n2) {
                vector.add(this.parseSingleRouter(fileInputStream));
                ++n;
            }
            logger.info(String.valueOf(n) + " router data loaded");
            return vector;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JDLogger.exception(fileNotFoundException);
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
        }
        return null;
    }

    public RouterData parseSingleRouter(InputStream inputStream) throws IOException {
        RouterData routerData = new RouterData();
        this.readInt(inputStream);
        this.readByte(inputStream);
        String string = this.readNextString(inputStream);
        this.readLong(inputStream);
        routerData.setRouterName(this.readNextString(inputStream));
        this.readNextString(inputStream);
        this.readNextString(inputStream);
        String string2 = this.readNextString(inputStream);
        String string3 = this.readNextString(inputStream);
        routerData.setIpAddressSite(this.readNextString(inputStream));
        routerData.setIpAddressOffline(this.readNextString(inputStream));
        String string4 = this.readNextString(inputStream);
        String string5 = this.readNextString(inputStream);
        this.readNextString(inputStream);
        int n = this.readInt(inputStream);
        int n2 = 0;
        while (n2 < n) {
            this.readNextString(inputStream);
            this.readNextString(inputStream);
            ++n2;
        }
        n2 = 0;
        while (n2 < 3) {
            this.readNextString(inputStream);
            ++n2;
        }
        inputStream.read();
        inputStream.read();
        inputStream.read();
        inputStream.read();
        inputStream.read();
        this.positionInFile += 5;
        routerData.setLogoff(this.readNextString(inputStream));
        this.readNextString(inputStream);
        n2 = this.readInt(inputStream);
        int n3 = 0;
        while (n3 < n2) {
            this.readNextString(inputStream);
            this.readNextString(inputStream);
            ++n3;
        }
        this.readNextString(inputStream);
        n3 = this.readInt(inputStream);
        int n4 = 0;
        while (n4 < n3) {
            this.readNextString(inputStream);
            this.readNextString(inputStream);
            ++n4;
        }
        string4 = Pattern.quote(string4);
        string5 = Pattern.quote(string5);
        routerData.setIpAddressRegEx(String.valueOf(string4) + "([0-9.]*)" + string5);
        routerData.setDisconnectType(this.getRequestType(string3));
        routerData.setDisconnectPostParams(this.getPostParams(string3));
        routerData.setDisconnect(this.getPlainURL(string3));
        routerData.setConnectType(this.getRequestType(string2));
        routerData.setConnectPostParams(this.getPostParams(string2));
        routerData.setConnect(this.getPlainURL(string2));
        routerData.setLoginType(this.getRequestType(string));
        routerData.setLoginPostParams(this.getPostParams(string));
        routerData.setLogin(this.getPlainURL(string));
        return routerData;
    }

    public Vector<RouterData> parseXMLFile(File file) {
        Vector vector = (Vector)JDIO.loadObject((Component)new JFrame(), (File)file, (boolean)true);
        return vector;
    }

    public byte readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        ++this.positionInFile;
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    private int readInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        ++this.positionInFile;
        int n2 = inputStream.read();
        ++this.positionInFile;
        int n3 = inputStream.read();
        ++this.positionInFile;
        int n4 = inputStream.read();
        ++this.positionInFile;
        if ((n | n2 | n3 | n4) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public final long readLong(InputStream inputStream) throws IOException {
        this.positionInFile += inputStream.read(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
    }

    private String readNextString(InputStream inputStream) throws IOException {
        short s = this.readShort(inputStream);
        byte[] byArray = new byte[s];
        inputStream.read(byArray);
        this.positionInFile += s;
        return new String(byArray);
    }

    public short readShort(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        ++this.positionInFile;
        int n2 = inputStream.read();
        ++this.positionInFile;
        if ((n | n2) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public void routerDatToXML(File file, File file2) {
        RouterParser routerParser = new RouterParser();
        JDIO.saveObject((Component)new JFrame(), routerParser.parseFile(file), (File)file2, (String)"routerdata", (String)"xml", (boolean)true);
    }
}

