/*
 * Decompiled with CFR 0.152.
 */
package jd.router;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.parser.Regex;
import jd.router.RInfo;
import org.hsqldb.lib.StringInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLRouterData {
    public static Browser br = new Browser();

    public static String setPlaceHolder(String string) {
        if (string == null) {
            return null;
        }
        String string2 = new Regex(string, "(\\&aa|password|pws|passwor|pass|\\@\\&ps|^p1|^t1|pswd)=([^\\&]*?)([\\s]+\\[\\[\\[| HTTP|$)").getMatch(1);
        String string3 = "%%%pass%%%";
        if (string2 != null && string2.length() == 32 && string2.matches("[a-zA-Z0-9]*")) {
            string3 = "MD5PasswordL(%%%pass%%%)";
        }
        string = string.replaceAll("(?is)(\\&aa|password|pws|passwor|pass|\\@\\&ps|^p1|^t1|pswd)=([^\\&$]*?)([\\s]+\\[\\[\\[|\\[\\[\\[| HTTP|$)", "$1=" + string3 + "$3").replaceAll("(?is)(username|(?<!router)name|user)\\=([^\\&]*?)([\\s]+\\[\\[\\[|\\[\\[\\[| HTTP|$)", "$1=%%%user%%%$3").replaceAll("(?is)=NAME([^\\&]*)\\&PASSWOR", "=NAME%%%user%%%&PASSWOR").replaceAll("(?is)RC=@D=([^\\=]*)=([^\\=]*) HTTP", "RC=@D=%%%pass%%%=%%%user%%% HTTP").replaceAll("(?is)RC=@D([^\\=].*?) HTTP", "RC=@D%%%pass%%%%%%user%%% HTTP");
        return string;
    }

    public static String replaceTimeStamps(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("[A-Z][a-z]{1,2}, \\d{2} [A-Z][a-z]{1,2} \\d{4} \\d{2}:\\d{2}:\\d{2}( [A-Z]{2,3})", "");
    }

    public static boolean writeLocalFile(File file, String string) {
        try {
            if (file.getParent() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF8"));
            bufferedWriter.write(string);
            bufferedWriter.close();
            return true;
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return false;
        }
    }

    public static boolean haveUpnpReconnect(HashMap<String, String> hashMap) {
        if (hashMap == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            if (!entry.getValue().contains("ForceTermination")) continue;
            return true;
        }
        return false;
    }

    public static String[] getNameFormUPnPSCPDs(HashMap<String, String> hashMap) {
        if (hashMap == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            if (!entry.getValue().contains("<modelName>")) continue;
            String string = new Regex(entry.getValue(), "<modelName>(.*?)</modelName>").getMatch(0);
            String string2 = new Regex(entry.getValue(), "<UDN>.*?-.*?-.*?-.*?-([a-zA-Z0-9]{12})").getMatch(0);
            if (string2 != null) {
                string2 = string2.replaceAll("..", "$0:").substring(0, 8);
            }
            String string3 = null;
            string3 = new Regex(entry.getValue(), "<modelNumber>(.*?)</modelNumber>").getMatch(0);
            if (string3 == null) {
                string3 = new Regex(entry.getValue(), "<friendlyName>[^<]*" + string + " (.*?)[\r\n]?</friendlyName>").getMatch(0);
            }
            return new String[]{string, string3, string2};
        }
        return null;
    }

    private static RInfo readString(String string) throws ParserConfigurationException, SAXException, IOException {
        try {
            byte[] byArray = string.getBytes();
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] == 0) {
                    byArray[n] = 32;
                }
                ++n;
            }
            string = new String(byArray, "UTF-8");
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringInputStream stringInputStream = new StringInputStream(string);
            Document document = documentBuilder.parse((InputStream)stringInputStream);
            NodeList nodeList = document.getElementsByTagName("router_liste").item(0).getChildNodes();
            Node node = null;
            RInfo rInfo = new RInfo();
            Class<?> clazz = rInfo.getClass();
            Class[] classArray = new Class[]{String.class};
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                node = nodeList.item(n2);
                if (!node.getNodeName().endsWith("#text")) {
                    try {
                        Method method = clazz.getMethod("set" + node.getNodeName().substring(0, 1).toUpperCase() + node.getNodeName().substring(1), classArray);
                        method.invoke((Object)rInfo, node.getTextContent());
                    }
                    catch (Exception exception) {
                        JDLogger.exception(exception);
                    }
                }
                ++n2;
            }
            if (rInfo.getReconnectMethodeClr() != null && rInfo.getReconnectMethodeClr().length() > 0) {
                rInfo.setRouterName(new Regex(rInfo.getReconnectMethodeClr(), "<Router name=\"(.*?)\" />").getMatch(0));
            }
            if (rInfo.setPlaceholder) {
                rInfo.setReconnectMethode(SQLRouterData.setPlaceHolder(rInfo.getReconnectMethode()));
            }
            return rInfo;
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    private static void readFile(File file) throws SAXException, ParserConfigurationException {
        if (!file.exists()) {
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals("    <router_liste>")) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("<?xml version=\"1.0\"?><root>");
                    bl = true;
                } else if (string.equals("    </router_liste>")) {
                    bl = false;
                    stringBuilder.append(string);
                    stringBuilder.append("</root>");
                    SQLRouterData.readString(stringBuilder.toString());
                }
                if (!bl) continue;
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws SAXException, ParserConfigurationException {
        SQLRouterData.readFile(new File("/home/dwd/www/router/rd/db.xml"));
    }
}

