/*
 * Decompiled with CFR 0.152.
 */
package jd.router;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.nutils.Threader;
import jd.nutils.jobber.JDRunnable;
import jd.parser.Regex;
import jd.router.RouterInfoCollector;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.device.SearchResponseListener;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.hsqldb.lib.StringInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPnPInfo {
    private InetAddress host = null;
    private SSDPPacket ssdpP = null;
    public ArrayList<String> met = new ArrayList();
    public HashMap<String, String> SCPDs = null;

    private void getSCPDURLs(String string) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        String string2 = new Browser().getPage(string);
        StringInputStream stringInputStream = new StringInputStream(string2);
        Document document = documentBuilder.parse((InputStream)stringInputStream);
        if (this.SCPDs == null) {
            this.SCPDs = new HashMap();
        }
        this.SCPDs.put(string, string2);
        NodeList nodeList = document.getElementsByTagName("SCPDURL");
        int n = 0;
        while (n < nodeList.getLength()) {
            this.getSCPDURLs(this.ssdpP.getLocation().replaceFirst("(http://.*?)/.*", "$1/" + nodeList.item(n).getTextContent().replaceFirst("^\\/", "")));
            ++n;
        }
    }

    public UPnPInfo(InetAddress inetAddress) {
        this(inetAddress, 10000L);
    }

    private static ArrayList<String> createUpnpReconnect(HashMap<String, String> hashMap, String string) throws ParserConfigurationException, SAXException, IOException {
        Map.Entry<String, String> entry2;
        StringInputStream stringInputStream = new StringInputStream(hashMap.get(string));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse((InputStream)stringInputStream);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Map.Entry<String, String> entry2 : hashMap.entrySet()) {
            if (!entry2.getValue().contains("<name>ForceTermination</name>")) continue;
            arrayList.add(((String)entry2.getKey()).replaceFirst(".*?\\:\\d+", ""));
        }
        if (arrayList.size() == 0) {
            return arrayList2;
        }
        entry2 = document.getElementsByTagName("SCPDURL");
        Object object = null;
        int n = 0;
        while (n < entry2.getLength()) {
            object = entry2.item(n);
            if (object.getTextContent() != null) {
                for (String string2 : arrayList) {
                    Object object2;
                    if (!object.getFirstChild().getTextContent().contains(string2)) continue;
                    NodeList nodeList = object.getParentNode().getChildNodes();
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        object2 = nodeList.item(n2);
                        if (object2.hasChildNodes()) {
                            hashMap2.put(object2.getNodeName(), object2.getTextContent().trim());
                        }
                        ++n2;
                    }
                    if (!hashMap2.containsKey("serviceType") || !hashMap2.containsKey("controlURL") || !hashMap2.containsKey("SCPDURL")) continue;
                    String string3 = "[[[HSRC]]]\r\n[[[STEP]]]\r\n[[[REQUEST]]]\r\n";
                    string3 = String.valueOf(string3) + "POST " + (String)hashMap2.get("controlURL") + " HTTP/1.1\r\n";
                    object2 = new Regex(hashMap.keySet().iterator().next(), ".*(\\:[\\d]+)").getMatch(0);
                    string3 = String.valueOf(string3) + "Host: %%%routerip%%%" + (String)object2 + "\r\n";
                    string3 = String.valueOf(string3) + "Content-Type: text/xml; charset=\"utf-8\"\r\n";
                    string3 = String.valueOf(string3) + "SoapAction:" + (String)hashMap2.get("serviceType") + "#ForceTermination\r\n\r\n";
                    string3 = String.valueOf(string3) + "<?xml version='1.0' encoding='utf-8'?> <s:Envelope s:encodingStyle='http://schemas.xmlsoap.org/soap/encoding/' xmlns:s='http://schemas.xmlsoap.org/soap/envelope/'> <s:Body> <u:ForceTermination xmlns:u='" + (String)hashMap2.get("serviceType") + "' /> </s:Body> </s:Envelope>\r\n";
                    string3 = String.valueOf(string3) + "[[[/REQUEST]]]\r\n[[[/STEP]]]\r\n[[[/HSRC]]]";
                    arrayList2.add(string3);
                }
            }
            object = null;
            ++n;
        }
        return arrayList2;
    }

    public static ArrayList<String> createUpnpReconnect(HashMap<String, String> hashMap) throws SAXException, IOException, ParserConfigurationException {
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            if (!entry.getValue().contains("</UDN>")) continue;
            return UPnPInfo.createUpnpReconnect(hashMap, entry.getKey());
        }
        return null;
    }

    public UPnPInfo(InetAddress inetAddress, final long l) {
        this.host = inetAddress;
        if (this.host == null) {
            this.host = RouterInfoCollector.getRouterIP();
        }
        if (this.host == null) {
            return;
        }
        final ControlPoint controlPoint = new ControlPoint();
        controlPoint.start();
        final Threader threader = new Threader();
        threader.add(new JDRunnable(){

            public void go() throws Exception {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                controlPoint.stop();
                threader.interrupt();
            }
        });
        controlPoint.addSearchResponseListener(new SearchResponseListener(){

            public void deviceSearchResponseReceived(SSDPPacket sSDPPacket) {
                InetAddress inetAddress = sSDPPacket.getRemoteInetAddress();
                if (inetAddress.getHostAddress().equals(UPnPInfo.this.host.getHostAddress())) {
                    UPnPInfo.this.ssdpP = sSDPPacket;
                    controlPoint.stop();
                    threader.interrupt();
                }
            }
        });
        threader.startAndWait();
        if (this.ssdpP == null) {
            return;
        }
        try {
            if (this.ssdpP.getLocation() == null) {
                return;
            }
            this.getSCPDURLs(this.ssdpP.getLocation());
            this.met = UPnPInfo.createUpnpReconnect(this.SCPDs, this.ssdpP.getLocation());
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException.getException() != null ? sAXParseException.getException() : sAXParseException;
            JDLogger.exception(exception);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException() != null ? sAXException.getException() : sAXException;
            JDLogger.exception(exception);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            JDLogger.exception(parserConfigurationException);
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
        }
    }

    public static void main(String[] stringArray) {
        UPnPInfo uPnPInfo = new UPnPInfo(RouterInfoCollector.getRouterIP());
        for (String string : uPnPInfo.met) {
            System.out.println(string);
        }
        System.exit(0);
    }
}

