/*
 * Decompiled with CFR 0.152.
 */
package jd.router.reconnectrecorder;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.parser.Regex;
import jd.router.reconnectrecorder.Proxy;

public class ReconnectRecorder {
    public static Vector<String> steps;
    static boolean running;
    static ServerSocket Server_Socket_HTTP;
    static ServerSocket Server_Socket_HTTPS;
    static final String PROPERTY_PORT = "PARAM_PORT";
    static String auth;

    static {
        running = false;
    }

    public static void startServer(String string, boolean bl) {
        steps = new Vector();
        auth = null;
        running = true;
        steps.add("[[[HSRC]]]");
        int n = 80;
        try {
            Server_Socket_HTTP = new ServerSocket(SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty(PROPERTY_PORT, 8972));
            Server_Socket_HTTPS = new ServerSocket(SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty(PROPERTY_PORT, 8972) + 1);
            if (string.contains(":")) {
                String string2 = new Regex(string, ".*?:(\\d+)").getMatch(0);
                n = Integer.parseInt(string2);
                string = new Regex(string, "(.*?):").getMatch(0);
            }
            new JDRRServer(Server_Socket_HTTP, string, n, false, bl).start();
            new JDRRServer(Server_Socket_HTTPS, string, 443, true, bl).start();
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
    }

    public static void stopServer() {
        running = false;
        if (steps != null) {
            steps.add("[[[/HSRC]]]");
        }
        try {
            Server_Socket_HTTP.close();
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        try {
            Server_Socket_HTTPS.close();
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
    }

    public static class JDRRServer
    extends Thread {
        ServerSocket Server_Socket = null;
        String serverip;
        int port;
        boolean ishttps = false;
        boolean israw = false;

        public JDRRServer(ServerSocket serverSocket, String string, int n, boolean bl, boolean bl2) {
            this.Server_Socket = serverSocket;
            this.serverip = string;
            this.setName("JDRRServer " + n + " " + string);
            this.port = n;
            this.ishttps = bl;
            this.israw = bl2;
        }

        public void run() {
            while (running) {
                Socket socket = null;
                try {
                    socket = this.Server_Socket.accept();
                }
                catch (Exception exception) {
                    break;
                }
                if (!running) continue;
                Proxy proxy = new Proxy(socket, steps, this.serverip, this.port, this.ishttps, this.israw);
                proxy.start();
            }
            running = false;
            try {
                this.Server_Socket.close();
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
            }
        }
    }
}

