/*
 * Decompiled with CFR 0.152.
 */
package jd.update;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import jd.config.SubConfiguration;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.gui.UserIO;
import jd.http.Browser;
import jd.nutils.Formatter;
import jd.nutils.JDHash;
import jd.nutils.io.JDIO;
import jd.update.FileUpdate;
import jd.update.JDUpdateUtils;
import jd.update.Restarter;
import jd.update.Server;
import jd.update.WebUpdater;
import jd.utils.JDUtilities;

public class Main {
    private static int BOTHRESIZE = 1;
    private static Insets INSETS = new Insets(5, 5, 5, 5);
    private static int NORESIZE = 0;
    private static int NORTHWEST = 18;
    private static int REL = -1;
    private static int REM = 0;
    private static SubConfiguration guiConfig;
    private static StringBuilder log;
    private static JFrame frame;
    private static JTextArea logWindow;
    public static ArrayList<Server> clonePrefix;
    public static boolean clone;
    private static JProgressBar progressload;
    private static JTextPane warnings;
    private static int TICKET_TIME;
    private static Logger logger;
    private static boolean RESTORE;

    static {
        clonePrefix = new ArrayList();
        clone = false;
        TICKET_TIME = -1;
        RESTORE = false;
    }

    private static void log(StringBuilder stringBuilder, String string) {
        if (stringBuilder != null) {
            stringBuilder.append(string);
        }
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            log = new StringBuilder();
            FileHandler fileHandler = new FileHandler("jdupdate.log", false);
            logger = Logger.getLogger("org.jdownloader.jdupdate");
            logger.addHandler(fileHandler);
            boolean bl = true;
            File file = JDUtilities.getResourceFile("jdownloader.config");
            if (file.exists()) {
                JDUtilities.getResourceFile("backup/").mkdirs();
                file.renameTo(JDUtilities.getResourceFile("backup/jdownloader.config.outdated"));
            }
            int n = 0;
            while (n < stringArray.length) {
                object = stringArray[n];
                if (((String)object).trim().equalsIgnoreCase("-noosfilter")) {
                    bl = false;
                } else if (((String)object).trim().equalsIgnoreCase("-full")) {
                    bl = false;
                } else if (((String)object).trim().equalsIgnoreCase("-brdebug")) {
                    Browser.setVerbose((boolean)true);
                } else if (((String)object).trim().equalsIgnoreCase("-restore")) {
                    RESTORE = true;
                } else if (((String)object).trim().equalsIgnoreCase("-branch")) {
                    String string;
                    if ((string = stringArray[++n]).equalsIgnoreCase("reset")) {
                        string = null;
                    }
                    WebUpdater.getConfig("WEBUPDATE").setProperty("BRANCH", string);
                    WebUpdater.getConfig("WEBUPDATE").save();
                    System.out.println("Switched branch: " + string);
                } else if (((String)object).trim().equalsIgnoreCase("-clone")) {
                    bl = false;
                    clone = true;
                } else if (clone && clonePrefix.size() == 0) {
                    clonePrefix.add(new Server(100, ((String)object).trim()));
                }
                ++n;
            }
            Browser.init();
            guiConfig = WebUpdater.getConfig("WEBUPDATE");
            log.append("Update JDownloader  at " + JDUtilities.getResourceFile(".") + "\r\n");
            log.append(WebUpdater.getConfig("WEBUPDATE").getProperties() + "\r\n");
            System.out.println(WebUpdater.getConfig("WEBUPDATE").getProperties() + "\r\n");
            System.out.println(WebUpdater.getConfig("PACKAGEMANAGER").getProperties() + "\r\n");
            log.append(WebUpdater.getConfig("PACKAGEMANAGER").getProperties() + "\r\n");
            Main.initGUI();
            try {
                Browser browser = new Browser();
                TICKET_TIME = Integer.parseInt(browser.getPage("http://update0.jdownloader.org/tickettime.txt").trim());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (TICKET_TIME < 0) {
                warnings.setText("There are currently no free update slots. Please try again later!\r\n\r\nYou can close this Programm now.\r\nWe advise you to download the latest version from http://jdownloader.org/download!");
                if (JOptionPane.showConfirmDialog(frame, "There are currently no free update slots. Please try again later!\r\n Start JDownloader now?") != 0) {
                    while (true) {
                        Thread.sleep(10000000L);
                    }
                }
            } else {
                warnings.setText("\r\n\r\n\r\n");
                while (TICKET_TIME > 0) {
                    Thread.sleep(1000L);
                    warnings.setText("Update starts in " + Formatter.formatSeconds((long)(TICKET_TIME / 1000)) + ".\r\n\r\n\r\nIf you do not want to wait, we suggest you to download the latest version from http://jdownloader.org/download!");
                    TICKET_TIME -= 1000;
                }
                warnings.setText("Update is too slow and takes too much time?\r\n\r\n\r\nDownload latest Version no at http://jdownloader.org/download");
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                Main.log(log, "Parameter " + n2 + " " + stringArray[n2] + " " + System.getProperty("line.separator"));
                logWindow.setText(log.toString());
                ++n2;
            }
            final WebUpdater webUpdater = new WebUpdater();
            webUpdater.setOSFilter(bl);
            webUpdater.getBroadcaster().addListener(new MessageListener(){
                private String msg0 = "";
                private String msg1 = "";
                private String msg2 = "";

                public void onMessage(MessageEvent messageEvent) {
                    if (webUpdater.getErrors() > 0) {
                        JOptionPane.showConfirmDialog(frame, "Update Server are too busy.\r\n Please try again later or download update at http://jdownloader.org/download!", "UPDATE WARNINGS", 0, 2);
                        Main.log(log, "Abort due to errors ");
                        Main.log(log, "Local: " + new File("").getAbsolutePath());
                        Main.log(log, "Start java -jar -Xmx512m JDownloader.jar in " + JDUtilities.getResourceFile(".").getAbsolutePath());
                        JDUtilities.runCommand("java", new String[]{"-Xmx512m", "-jar", "JDownloader.jar", "-rfu"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0);
                        logWindow.setText(log.toString());
                        JDIO.writeLocalFile((File)JDUtilities.getResourceFile("updateLog.txt"), (String)log.toString());
                        System.exit(0);
                        return;
                    }
                    if (messageEvent.getID() == 40 || messageEvent.getID() == 2) {
                        this.msg2 = this.msg1;
                        this.msg1 = this.msg0;
                        this.msg0 = messageEvent.getMessage();
                        warnings.setText(String.valueOf(this.msg2) + "\r\n" + this.msg1 + "\r\n" + this.msg0 + "\r\n               Download latest Version no at http://jdownloader.org/download");
                    }
                    if (messageEvent.getID() == 43) {
                        warnings.setText("Update is too slow and takes too much time?\r\n\r\n\r\nDownload latest Version at http://jdownloader.org/download");
                    }
                    Main.log(log, String.valueOf(messageEvent.getMessage()) + "\r\n");
                }
            });
            Main.log(log, "Current Date:" + new Date() + "\r\n");
            Main.checkBackup();
            webUpdater.ignorePlugins(false);
            Main.checkUpdateMessage();
            webUpdater.setLogger(log);
            webUpdater.setDownloadProgress(progressload);
            Main.trace("Start Webupdate");
            if (RESTORE) {
                JDIO.removeByPattern((File)JDUtilities.getResourceFile("jd").getParentFile(), (Pattern)Pattern.compile(".*\\.extract", 2));
            }
            try {
                object = webUpdater.getAvailableFiles();
            }
            catch (Exception exception) {
                Main.trace("Update failed");
                Main.log(log, "Update failed");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                object = new ArrayList<FileUpdate>();
            }
            if (object != null) {
                webUpdater.filterAvailableUpdates((ArrayList<FileUpdate>)object);
                JDUpdateUtils.backupDataBase();
                webUpdater.updateFiles((ArrayList<FileUpdate>)object, null);
            }
            Restarter.main(new String[0]);
            Main.trace(webUpdater.getLogger().toString());
            Main.trace("End Webupdate");
            logWindow.setText(log.toString());
            Main.trace(JDUtilities.getResourceFile("updateLog.txt").getAbsoluteFile());
            if (JDUtilities.getResourceFile("webcheck.tmp").exists()) {
                JDUtilities.getResourceFile("webcheck.tmp").delete();
            }
            Main.log(log, "Local: " + JDUtilities.getResourceFile(".").getAbsolutePath());
            Main.log(log, "Start java -jar -Xmx512m JDownloader.jar in " + JDUtilities.getResourceFile(".").getAbsolutePath());
            JDUtilities.getDatabaseConnector().shutdownDatabase();
            JDUtilities.runCommand("java", new String[]{"-Xmx512m", "-jar", "JDownloader.jar", "-rfu"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0);
            logWindow.setText(log.toString());
            JDIO.writeLocalFile((File)JDUtilities.getResourceFile("updateLog.txt"), (String)log.toString());
            Main.log(log, "Errors: " + webUpdater.getErrors());
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Main.log(log, "ERROR " + exception.getLocalizedMessage());
        }
    }

    private static void checkUpdateMessage() throws IOException {
        try {
            if (JDUtilities.getResourceFile("updateLog.txt").exists()) {
                String string;
                String string2 = JDHash.getMD5((File)JDUtilities.getResourceFile("updatewarnings.html"));
                Browser.download((File)JDUtilities.getResourceFile("updatewarnings.html"), (String)"http://update1.jdownloader.org/messages/updatewarning.html");
                String string3 = JDHash.getMD5((File)JDUtilities.getResourceFile("updatewarnings.html"));
                if (string3 != null && !string3.equals(string2) && (string = JDIO.readFileToString((File)new File("updatewarnings.html"))).trim().length() > 0 && JOptionPane.showConfirmDialog(frame, string, "UPDATE WARNINGS", 0, 2) == 1) {
                    Main.log(log, "Abort due to warnings " + string);
                    JDUtilities.getResourceFile("updatewarnings.html").delete();
                    JDUtilities.getResourceFile("updatewarnings.html").deleteOnExit();
                    if (JDUtilities.getResourceFile("webcheck.tmp").exists()) {
                        JDUtilities.getResourceFile("webcheck.tmp").delete();
                    }
                    Main.log(log, "Local: " + new File("").getAbsolutePath());
                    Main.log(log, "Start java -jar -Xmx512m JDownloader.jar in " + JDUtilities.getResourceFile(".").getAbsolutePath());
                    JDUtilities.runCommand("java", new String[]{"-Xmx512m", "-jar", "JDownloader.jar", "-rfu"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0);
                    logWindow.setText(log.toString());
                    JDIO.writeLocalFile((File)JDUtilities.getResourceFile("updateLog.txt"), (String)log.toString());
                    System.exit(0);
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void checkBackup() {
        if (JDUtilities.getResourceFile("updateLog.txt").exists()) {
            if (!JDUtilities.getResourceFile("/backup/").exists()) {
                JDUtilities.getResourceFile("/backup/").mkdirs();
                Main.log(log, "Not found: " + JDUtilities.getResourceFile("/backup/").getAbsolutePath() + "\r\n");
                UserIO.getInstance().requestMessageDialog("JDownloader could not create a backup. Please make sure that\r\n " + JDUtilities.getResourceFile("/backup/").getAbsolutePath() + " exists and is writable before starting the update");
                JDUtilities.runCommand("java", new String[]{"-Xmx512m", "-jar", "JDownloader.jar", "-rfu"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0);
                System.exit(0);
                return;
            }
            File file = JDUtilities.getResourceFile("/backup/links.linkbackup");
            Main.log(log, "Backup found. date:" + new Date(file.lastModified()) + "\r\n");
            if (!file.exists() || System.currentTimeMillis() - file.lastModified() > 300000L) {
                JDUtilities.getResourceFile("/backup/").mkdirs();
                String string = "";
                string = !file.exists() ? "Do you want to continue without a backup? Your queue may get lost.\r\nLatest backup found: NONE!\r\nNote: You can ignore this message if this is a fresh JD-Installation and your linklist is empty anyway" : "Do you want to continue without a backup? Your queue may get lost.\r\nLatest backup found: " + new Date(file.lastModified()) + "\r\nin " + file.getAbsolutePath();
                if (JOptionPane.showConfirmDialog(frame, string, "There is no backup of your current Downloadqueue", 2) != 0) {
                    JDUtilities.runCommand("java", new String[]{"-Xmx512m", "-jar", "JDownloader.jar", "-rfu"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0);
                    System.exit(0);
                    return;
                }
            }
        }
    }

    private static void initGUI() {
        Object object;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        String string = guiConfig.getStringProperty("PLAF", null);
        boolean bl = false;
        if (string != null) {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray2 = lookAndFeelInfoArray;
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = lookAndFeelInfoArray2[n2];
                if (((UIManager.LookAndFeelInfo)object).getName().equals(string)) {
                    try {
                        UIManager.setLookAndFeel(((UIManager.LookAndFeelInfo)object).getClassName());
                        bl = true;
                        break;
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        } else {
            int n = 0;
            while (n < lookAndFeelInfoArray.length) {
                if (!lookAndFeelInfoArray[n].getName().matches("(?is).*(metal|motif).*")) {
                    try {
                        UIManager.setLookAndFeel(lookAndFeelInfoArray[n].getClassName());
                        bl = true;
                        break;
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                // empty catch block
            }
        }
        frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setTitle("JD Update");
        frame.setLayout(new GridBagLayout());
        progressload = new JProgressBar();
        progressload.setMaximum(100);
        progressload.setStringPainted(true);
        warnings = new JTextPane();
        warnings.setForeground(Color.RED);
        warnings.setText("Please wait.. check ticket");
        warnings.setOpaque(false);
        warnings.setBackground(null);
        warnings.setEditable(false);
        warnings.setPreferredSize(new Dimension(500, 80));
        warnings.setMinimumSize(new Dimension(50, 80));
        warnings.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        logWindow = new JTextArea(30, 120);
        object = new JScrollPane(logWindow);
        ((JComponent)object).setAutoscrolls(true);
        logWindow.setEditable(false);
        logWindow.setAutoscrolls(true);
        JDUtilities.addToGridBag(frame, warnings, REL, REL, REM, 1, 0, 0, INSETS, BOTHRESIZE, NORTHWEST);
        JDUtilities.addToGridBag(frame, new JLabel("Webupdate is running..."), REL, REL, REM, 1, 0, 0, INSETS, NORESIZE, NORTHWEST);
        JDUtilities.addToGridBag(frame, new JLabel("Download: "), REL, REL, REL, 1, 0, 0, INSETS, NORESIZE, NORTHWEST);
        JDUtilities.addToGridBag(frame, progressload, REL, REL, REM, 1, 1, 0, INSETS, BOTHRESIZE, NORTHWEST);
        Main.log(log, "Starting...");
        logWindow.setText(log.toString());
        JDUtilities.addToGridBag(frame, (Component)object, REL, REL, REM, 1, 1, 1, INSETS, BOTHRESIZE, NORTHWEST);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 5;
        ((JComponent)frame.getContentPane()).setBorder(new EmptyBorder(n, n, n, n));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        new Thread(){

            public void run() {
                while (true) {
                    logWindow.setText(log.toString());
                    logWindow.setCaretPosition(logWindow.getText().length());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
    }

    public static void trace(Object object) {
        try {
            System.out.println(object.toString());
        }
        catch (Exception exception) {
            System.out.println(object);
        }
    }
}

