/*
 * Decompiled with CFR 0.152.
 */
package jd.update;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JProgressBar;
import jd.config.CFGConfig;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.event.JDBroadcaster;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.http.Browser;
import jd.nutils.JDHash;
import jd.nutils.OSDetector;
import jd.nutils.io.JDIO;
import jd.nutils.zip.UnZip;
import jd.parser.Regex;
import jd.update.FileUpdate;
import jd.update.Main;
import jd.update.Server;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUpdater
implements Serializable {
    public static final int DO_UPDATE_FAILED = 40;
    public static final int DO_UPDATE_FILE = 42;
    public static final int DO_UPDATE_SUCCESS = 43;
    private static HashMap<String, File> fileMap;
    private static final int NEW_FILE = 0;
    public static HashMap<String, FileUpdate> PLUGIN_LIST;
    private static final long serialVersionUID = 1946622313175234371L;
    private static final int UPDATE_FILE = 1;
    public static final String[] UPDATE_MIRROR;
    private static final String UPDATE_ZIP_LOCAL_PATH = "tmp/update.zip";
    public static final String PARAM_BRANCH = "BRANCH";
    public static final String BRANCHINUSE = "BRANCHINUSE";
    private Browser br;
    private String[] branches;
    private transient JDBroadcaster<MessageListener, MessageEvent> broadcaster;
    private Integer errors = 0;
    private boolean ignorePlugins = true;
    private StringBuilder logger;
    private boolean OSFilter = true;
    private JProgressBar progressload = null;
    public byte[] sum;
    private File workingdir;
    private String betaBranch;

    static {
        PLUGIN_LIST = null;
        UPDATE_MIRROR = new String[]{"http://update0.jdownloader.org/", "http://update1.jdownloader.org/", "http://update2.jdownloader.org/"};
    }

    public static SubConfiguration getConfig(String string) {
        SubConfiguration subConfiguration = SubConfiguration.getConfig(string);
        CFGConfig cFGConfig = CFGConfig.getConfig(string);
        if (cFGConfig.getProperties().size() != 0) {
            subConfiguration.getProperties().putAll(cFGConfig.getProperties());
            cFGConfig.getProperties().clear();
            cFGConfig.save();
        }
        subConfiguration.save();
        return subConfiguration;
    }

    public static HashMap<String, File> getFileMap() {
        return fileMap;
    }

    public static HashMap<String, FileUpdate> getPluginList() {
        if (PLUGIN_LIST == null && JDUtilities.getResourceFile("tmp/hashlist.lst").exists()) {
            PLUGIN_LIST = new HashMap();
            WebUpdater webUpdater = new WebUpdater();
            webUpdater.ignorePlugins(false);
            webUpdater.parseFileList(JDUtilities.getResourceFile("tmp/hashlist.lst"), null, PLUGIN_LIST);
        }
        return PLUGIN_LIST;
    }

    public static void randomizeMirrors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = UPDATE_MIRROR;
        int n = UPDATE_MIRROR.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            arrayList.add(string);
            ++n2;
        }
        int n3 = 0;
        while (n3 < UPDATE_MIRROR.length) {
            WebUpdater.UPDATE_MIRROR[n3] = (String)arrayList.remove((int)(Math.random() * (double)(UPDATE_MIRROR.length - 1 - n3)));
            ++n3;
        }
    }

    public WebUpdater() {
        WebUpdater.randomizeMirrors();
        this.logger = new StringBuilder();
        this.br = new Browser();
        this.br.setReadTimeout(20000);
        this.br.setConnectTimeout(10000);
        this.errors = 0;
        this.initBroadcaster();
    }

    public void filterAvailableUpdates(ArrayList<FileUpdate> arrayList) {
        Iterator<FileUpdate> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FileUpdate fileUpdate = iterator.next();
            if (new File(fileUpdate.getLocalFile(), ".noupdate").exists()) {
                System.out.println("User excluded. " + fileUpdate.getLocalPath());
                iterator.remove();
                continue;
            }
            if (!fileUpdate.exists()) {
                this.broadcaster.fireEvent(new MessageEvent((Object)this, 0, "New: " + WebUpdater.formatPathReadable(fileUpdate.getLocalPath())));
                continue;
            }
            if (!fileUpdate.equals()) {
                this.broadcaster.fireEvent(new MessageEvent((Object)this, 1, "Update: " + WebUpdater.formatPathReadable(fileUpdate.getLocalPath())));
                continue;
            }
            iterator.remove();
        }
    }

    public ArrayList<FileUpdate> getAvailableFiles() throws Exception {
        HashMap<String, FileUpdate> hashMap = new HashMap<String, FileUpdate>();
        ArrayList<FileUpdate> arrayList = new ArrayList<FileUpdate>();
        this.updateAvailableServers();
        this.loadUpdateList();
        this.parseFileList(fileMap.get("hashlist.lst"), arrayList, hashMap);
        return arrayList;
    }

    private ArrayList<Server> getAvailableServers() {
        if (Main.clone) {
            return Main.clonePrefix;
        }
        try {
            return (ArrayList)WebUpdater.getConfig("WEBUPDATE").getProperty("SERVERLIST");
        }
        catch (Exception exception) {
            WebUpdater.getConfig("WEBUPDATE").setProperty("SERVERLIST", new ArrayList());
            return (ArrayList)WebUpdater.getConfig("WEBUPDATE").getProperty("SERVERLIST");
        }
    }

    public String getBranch() {
        String string;
        block4: {
            try {
                String string2 = this.getLatestBranch();
                string = WebUpdater.getConfig("WEBUPDATE").getStringProperty(PARAM_BRANCH);
                if (string == null) {
                    string = string2;
                }
                WebUpdater.getConfig("WEBUPDATE").setProperty(BRANCHINUSE, string);
                WebUpdater.getConfig("WEBUPDATE").save();
                if (string != null) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return string;
    }

    private String[] getBranches() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = UPDATE_MIRROR;
        int n = UPDATE_MIRROR.length;
        int n2 = 0;
        while (n2 < n) {
            String string = object[n2];
            arrayList.add(string);
            ++n2;
        }
        int n3 = 0;
        while (n3 < UPDATE_MIRROR.length) {
            String string = (String)arrayList.remove((int)(Math.random() * (double)(UPDATE_MIRROR.length - 1 - n3)));
            try {
                this.br.getPage(String.valueOf(string) + "branches.lst?branch=" + WebUpdater.getConfig("WEBUPDATE").getStringProperty(BRANCHINUSE, null));
                if (this.br.getRequest().getHttpConnection().isOK()) {
                    String[] stringArray = Regex.getLines(this.br.toString());
                    object = new ArrayList();
                    this.branches = new String[stringArray.length];
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        if (WebUpdater.isBetaBranch(stringArray[n4]) && this.betaBranch == null) {
                            this.betaBranch = stringArray[n4];
                        } else if (!WebUpdater.isBetaBranch(stringArray[n4])) {
                            ((ArrayList)object).add(stringArray[n4]);
                        }
                        ++n4;
                    }
                    this.branches = ((ArrayList)object).toArray(new String[0]);
                    System.out.println("Found branches on " + string + ":\r\n" + this.br);
                    String string2 = WebUpdater.getConfig("WEBUPDATE").getStringProperty(PARAM_BRANCH);
                    if (this.branches.length > 0 && string2 != null && WebUpdater.isBetaBranch(string2) && (this.betaBranch == null || !string2.equals(this.betaBranch))) {
                        WebUpdater.getConfig("WEBUPDATE").setProperty(PARAM_BRANCH, this.branches[0]);
                        WebUpdater.getConfig("WEBUPDATE").save();
                        JDLogger.getLogger().severe("RESETTED BRANCH; SINCE BETA branch " + string2 + " is not available any more");
                    }
                    return this.branches;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.errorWait();
            }
            System.err.println("No branches found on " + string);
            ++n3;
        }
        this.branches = new String[0];
        return this.branches;
    }

    public static boolean isBetaBranch(String string) {
        return string.trim().startsWith("beta_");
    }

    public String getBetaBranch() {
        return this.betaBranch;
    }

    public JDBroadcaster<MessageListener, MessageEvent> getBroadcaster() {
        return this.broadcaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrors() {
        Integer n = this.errors;
        synchronized (n) {
            return this.errors;
        }
    }

    private synchronized String getLatestBranch() {
        if (this.branches == null) {
            this.getBranches();
        }
        if (this.branches == null || this.branches.length == 0) {
            return null;
        }
        return this.branches[0];
    }

    private String getListPath(int n) {
        if (this.getBranch() == null) {
            return null;
        }
        return String.valueOf(UPDATE_MIRROR[n % UPDATE_MIRROR.length]) + this.getBranch() + "_server.list";
    }

    public StringBuilder getLogger() {
        return this.logger;
    }

    public boolean getOSFilter() {
        return this.OSFilter;
    }

    public File getWorkingdir() {
        return this.workingdir;
    }

    private String getZipMD5(int n) {
        return String.valueOf(UPDATE_MIRROR[n % UPDATE_MIRROR.length]) + this.getBranch() + "_update.md5";
    }

    private String getZipUrl(int n) {
        return String.valueOf(UPDATE_MIRROR[n % UPDATE_MIRROR.length]) + this.getBranch() + "_update.zip";
    }

    public void ignorePlugins(boolean bl) {
        this.ignorePlugins = bl;
    }

    private void initBroadcaster() {
        this.broadcaster = new JDBroadcaster<MessageListener, MessageEvent>(){

            @Override
            protected void fireEvent(MessageListener messageListener, MessageEvent messageEvent) {
                messageListener.onMessage(messageEvent);
            }
        };
    }

    public boolean isIgnorePlugins() {
        return this.ignorePlugins;
    }

    private void loadUpdateList() throws Exception {
        int n = 0;
        while (n < 10) {
            block8: {
                try {
                    String string;
                    String string2 = this.getZipMD5(n);
                    if (string2 == null) break block8;
                    String string3 = this.br.getPage(String.valueOf(string2) + "?t=" + System.currentTimeMillis()).trim();
                    if (!string3.equalsIgnoreCase(string = JDHash.getMD5((File)JDUtilities.getResourceFile(UPDATE_ZIP_LOCAL_PATH)))) {
                        string2 = this.getZipUrl(n);
                        if (string2 == null) break block8;
                        Browser.download((File)JDUtilities.getResourceFile(UPDATE_ZIP_LOCAL_PATH), (String)(String.valueOf(string2) + "?t=" + System.currentTimeMillis()));
                    }
                    UnZip unZip = new UnZip(JDUtilities.getResourceFile(UPDATE_ZIP_LOCAL_PATH), JDUtilities.getResourceFile("tmp/"));
                    File[] fileArray = unZip.extract();
                    fileMap = new HashMap();
                    File[] fileArray2 = fileArray;
                    int n2 = fileArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        File file = fileArray2[n3];
                        fileMap.put(file.getName().toLowerCase(), file);
                        ++n3;
                    }
                    return;
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
        throw new Exception("could not load Updatelist");
    }

    private void parseFileList(File file, ArrayList<FileUpdate> arrayList, HashMap<String, FileUpdate> hashMap) {
        String string = JDIO.readFileToString((File)file);
        String string2 = "[\r\n\\;]*([^=]+)\\=(.*?)\\;";
        if (string == null) {
            System.out.println("filelist nicht verf\u00fcpgbar");
            return;
        }
        String[] stringArray = new String[]{"windows", "mac", "linux"};
        String[][] stringArray2 = new Regex(string, string2).getMatches();
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        String[][] stringArray3 = stringArray2;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray4 = stringArray3[n2];
            FileUpdate fileUpdate = this.workingdir != null ? new FileUpdate(stringArray4[0], stringArray4[1], this.workingdir) : new FileUpdate(stringArray4[0], stringArray4[1]);
            fileUpdate.getBroadcaster().addAllListener(this.broadcaster.getListener());
            arrayList2.add((byte)fileUpdate.getRemoteHash().charAt(0));
            if (fileUpdate.getLocalPath().endsWith(".class")) {
                hashMap.put(fileUpdate.getLocalPath(), fileUpdate);
            }
            if (!fileUpdate.getLocalPath().endsWith(".class") || !this.ignorePlugins) {
                String string3;
                boolean bl = false;
                boolean bl2 = false;
                String[] stringArray5 = stringArray;
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    string3 = stringArray5[n4];
                    String string4 = fileUpdate.getRawUrl();
                    if (string4 == null) {
                        string4 = fileUpdate.getRelURL();
                    }
                    if (string4.toLowerCase().indexOf(string3) >= 0) {
                        bl = true;
                        if (OSDetector.getOSString().toLowerCase().indexOf(string3) >= 0) {
                            bl2 = true;
                        }
                    }
                    ++n4;
                }
                if (this.OSFilter) {
                    if (!bl || bl && bl2) {
                        if (arrayList != null) {
                            arrayList.add(fileUpdate);
                        }
                    } else {
                        string3 = fileUpdate.getRawUrl();
                        if (string3 == null) {
                            string3 = fileUpdate.getRelURL();
                        }
                        System.out.println("OS Filter: " + string3);
                    }
                } else if (arrayList != null) {
                    arrayList.add(fileUpdate);
                }
            }
            ++n2;
        }
        this.sum = new byte[arrayList2.size()];
        int n5 = 0;
        n2 = arrayList2.size() - 1;
        while (n2 >= 0) {
            this.sum[n5++] = (Byte)arrayList2.get(n2);
            --n2;
        }
        PLUGIN_LIST = hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetErrors() {
        Integer n = this.errors;
        synchronized (n) {
            this.errors = 0;
        }
    }

    public void setDownloadProgress(JProgressBar jProgressBar) {
        this.progressload = jProgressBar;
    }

    public void setIgnorePlugins(boolean bl) {
        this.ignorePlugins = bl;
    }

    public void setLogger(StringBuilder stringBuilder) {
        this.logger = stringBuilder;
    }

    public void setOSFilter(boolean bl) {
        this.OSFilter = bl;
    }

    public void setWorkingdir(File file) {
        this.workingdir = file;
    }

    public String toString() {
        return "Updater";
    }

    private ArrayList<Server> updateAvailableServers() {
        boolean bl = true;
        int n = 0;
        while (n < 10) {
            block14: {
                try {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 0, "Update Downloadmirrors"));
                    String string = this.getListPath(n);
                    if (string == null) break block14;
                    this.br.getPage(String.valueOf(string) + "?t=" + System.currentTimeMillis());
                    if ((long)this.br.getRequest().getHttpConnection().getResponseCode() != 404L) {
                        bl = false;
                    }
                    if ((long)this.br.getRequest().getHttpConnection().getResponseCode() != 200L) {
                        this.errorWait();
                        break block14;
                    }
                    int n2 = 0;
                    ArrayList<Server> arrayList = new ArrayList<Server>();
                    boolean bl2 = false;
                    String[][] stringArray = this.br.getRegex("(\\-?\\d+)\\:([^\r^\n]*)").getMatches();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String[] object = stringArray[n4];
                        Server server = new Server(Integer.parseInt(object[0]), object[1].trim());
                        arrayList.add(server);
                        if (server.getPercent() < 0) {
                            bl2 = true;
                        }
                        n2 += server.getPercent();
                        ++n4;
                    }
                    for (Server server : arrayList) {
                        if (bl2) {
                            server.setPercent(-1);
                        } else {
                            server.setPercent(server.getPercent() * 100 / n2);
                        }
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 0, "Updateserver: " + server));
                    }
                    if (arrayList.size() > 0) {
                        WebUpdater.getConfig("WEBUPDATE").setProperty("SERVERLIST", arrayList);
                    }
                    return this.getAvailableServers();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.errorWait();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
        if (bl && WebUpdater.getConfig("WEBUPDATE").getStringProperty(PARAM_BRANCH) != null) {
            System.err.println("Branch " + WebUpdater.getConfig("WEBUPDATE").getStringProperty(PARAM_BRANCH) + " is not available any more. Reset to default");
            WebUpdater.getConfig("WEBUPDATE").setProperty(PARAM_BRANCH, null);
            WebUpdater.getConfig("WEBUPDATE").save();
            return this.updateAvailableServers();
        }
        return this.getAvailableServers();
    }

    private void errorWait() {
        try {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, "Server Busy. Wait 10 Seconds"));
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void updateFile(Vector<String> vector) throws IOException {
        String[] stringArray = vector.elementAt(0).split("\\?");
        this.broadcaster.fireEvent(new MessageEvent((Object)this, 42, String.format("Download %s to %s", WebUpdater.formatPathReadable(stringArray[1]), WebUpdater.formatPathReadable(JDUtilities.getResourceFile(stringArray[0]).getAbsolutePath()))));
        Browser.download((File)JDUtilities.getResourceFile(stringArray[0]), (String)stringArray[0]);
    }

    public void updateFiles(ArrayList<FileUpdate> arrayList, ProgressController progressController) throws IOException {
        if (this.progressload != null) {
            this.progressload.setMaximum(arrayList.size());
        }
        int n = 0;
        if (progressController != null) {
            progressController.addToMax(arrayList.size());
        }
        for (FileUpdate fileUpdate : arrayList) {
            block12: {
                try {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 0, String.format("Update %s", WebUpdater.formatPathReadable(fileUpdate.getLocalPath()))));
                    if (this.updateUpdatefile(fileUpdate)) {
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 43, WebUpdater.formatPathReadable(fileUpdate.toString())));
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 43, "Successfull"));
                    } else {
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, WebUpdater.formatPathReadable(fileUpdate.toString())));
                        this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, "Failed"));
                        if (this.progressload != null) {
                            this.progressload.setForeground(Color.RED);
                        }
                        if (progressController != null) {
                            progressController.setColor(Color.RED);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, exception.getLocalizedMessage()));
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, WebUpdater.formatPathReadable(fileUpdate.toString())));
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, "Failed"));
                    if (this.progressload != null) {
                        this.progressload.setForeground(Color.RED);
                    }
                    if (progressController == null) break block12;
                    progressController.setColor(Color.RED);
                }
            }
            ++n;
            if (this.progressload != null) {
                this.progressload.setValue(n);
            }
            if (progressController == null) continue;
            progressController.increase(1L);
        }
        if (this.progressload != null) {
            this.progressload.setValue(100);
        }
    }

    public static String formatPathReadable(String string) {
        string = string.replace(".class", "-Plugin");
        string = string.replace(".jar", "-Module");
        string = string.replace("plugins/decrypter/.*", "Decrypter-Plugin");
        return string;
    }

    public boolean updateUpdatefile(FileUpdate fileUpdate) {
        if (fileUpdate.update(this.getAvailableServers())) {
            if (fileUpdate.getLocalTmpFile().getName().endsWith(".extract")) {
                UnZip unZip = new UnZip(fileUpdate.getLocalTmpFile(), fileUpdate.getLocalTmpFile().getParentFile());
                unZip.setOverwrite(false);
                try {
                    File[] fileArray = unZip.extract();
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 43, "Extracted " + fileUpdate.getLocalTmpFile().getName() + ": " + fileArray.length + " files"));
                }
                catch (Exception exception) {
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, exception.getLocalizedMessage()));
                    this.broadcaster.fireEvent(new MessageEvent((Object)this, 40, "Extracting " + fileUpdate.getLocalTmpFile().getAbsolutePath() + " failed"));
                    exception.printStackTrace();
                    fileUpdate.getLocalTmpFile().delete();
                    fileUpdate.getLocalTmpFile().deleteOnExit();
                    this.errors = this.errors + 1;
                    return false;
                }
            }
            return true;
        }
        this.errors = this.errors + 1;
        return false;
    }

    public void cleanUp() {
    }
}

