/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import de.savemytube.flv.FLV;
import java.io.File;
import java.util.logging.Logger;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.gui.swing.components.ConvertDialog;
import jd.plugins.DownloadLink;
import jd.utils.locale.JDL;

public class JDMediaConvert {
    private static Logger logger = JDLogger.getLogger();
    private static String TempExt = ".tmp$";

    public static boolean ConvertFile(DownloadLink downloadLink, ConvertDialog.ConversionMode conversionMode, ConvertDialog.ConversionMode conversionMode2) {
        logger.info("Convert " + downloadLink.getName() + " - " + conversionMode.getText() + " - " + conversionMode2.getText());
        if (conversionMode.equals((Object)conversionMode2)) {
            logger.info("No Conversion needed, renaming...");
            File file = new File(downloadLink.getFileOutput());
            File file2 = new File(downloadLink.getFileOutput().replaceAll(TempExt, conversionMode2.getExtFirst()));
            downloadLink.setFinalFileName(downloadLink.getName().replaceAll(TempExt, conversionMode2.getExtFirst()));
            file.renameTo(file2);
            return true;
        }
        ProgressController progressController = new ProgressController(String.valueOf(JDL.L("convert.progress.convertingto", "Konvertiere zu")) + " " + conversionMode2.toString(), 3L);
        downloadLink.getLinkStatus().setStatusText(String.valueOf(JDL.L("convert.progress.convertingto", "Konvertiere zu")) + " " + conversionMode2.toString());
        progressController.increase(1L);
        switch (conversionMode) {
            case VIDEOFLV: {
                switch (conversionMode2) {
                    case AUDIOMP3: {
                        logger.info("Convert FLV to mp3...");
                        new FLV(downloadLink.getFileOutput(), true, true);
                        progressController.increase(1L);
                        if (!new File(downloadLink.getFileOutput()).delete()) {
                            new File(downloadLink.getFileOutput()).deleteOnExit();
                        }
                        if (!new File(downloadLink.getFileOutput().replaceAll(TempExt, ".avi")).delete()) {
                            new File(downloadLink.getFileOutput().replaceAll(TempExt, ".avi")).deleteOnExit();
                        }
                        progressController.doFinalize();
                        return true;
                    }
                    case AUDIOMP3_AND_VIDEOFLV: {
                        logger.info("Convert FLV to mp3 (keep FLV)...");
                        new FLV(downloadLink.getFileOutput(), true, true);
                        progressController.increase(1L);
                        if (!new File(downloadLink.getFileOutput().replaceAll(TempExt, ".avi")).delete()) {
                            new File(downloadLink.getFileOutput().replaceAll(TempExt, ".avi")).deleteOnExit();
                        }
                        new File(downloadLink.getFileOutput()).renameTo(new File(downloadLink.getFileOutput().replaceAll(".tmp", ConvertDialog.ConversionMode.VIDEOFLV.getExtFirst())));
                        progressController.doFinalize();
                        return true;
                    }
                }
                logger.warning("Don't know how to convert " + conversionMode.getText() + " to " + conversionMode2.getText());
                downloadLink.getLinkStatus().setErrorMessage(JDL.L("convert.progress.unknownintype", "Unbekanntes Format"));
                progressController.doFinalize();
                return false;
            }
        }
        logger.warning("Don't know how to convert " + conversionMode.getText() + " to " + conversionMode2.getText());
        downloadLink.getLinkStatus().setErrorMessage(JDL.L("convert.progress.unknownintype", "Unbekanntes Format"));
        progressController.doFinalize();
        return false;
    }
}

