/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jd.CPluginWrapper;
import jd.DecryptPluginWrapper;
import jd.HostPluginWrapper;
import jd.JDClassLoader;
import jd.OptionalPluginWrapper;
import jd.config.Configuration;
import jd.config.DatabaseConnector;
import jd.controlling.DownloadController;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.gui.UserIO;
import jd.nutils.Executer;
import jd.nutils.Formatter;
import jd.nutils.OSDetector;
import jd.nutils.io.JDIO;
import jd.plugins.CryptedLink;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import jd.utils.GetExplorer;
import jd.utils.locale.JDL;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDUtilities {
    public static Configuration CONFIGURATION = null;
    private static DatabaseConnector DB_CONNECT = null;
    private static HashMap<String, PluginsC> CONTAINER_PLUGINS = new HashMap();
    private static JDController CONTROLLER = null;
    public static final String JD_VERSION = "0.";
    private static JDClassLoader JD_CLASSLOADER = null;
    public static final int RUNTYPE_LOCAL = 1;
    public static final int RUNTYPE_LOCAL_JARED = 2;
    private static File JD_HOME = null;
    public static final Object USERIO_LOCK = new Object();
    private static String REVISION;
    private static String[] JD_ARGUMENTS;

    static {
        JD_ARGUMENTS = new String[1];
    }

    public static <K extends Comparable<K>, V> TreeMap<K, V> revSortByKey(Map<K, V> map) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(new Comparator<K>(){

            @Override
            public int compare(K k, K k2) {
                return k2.compareTo(k);
            }
        });
        treeMap.putAll(map);
        return treeMap;
    }

    public static <K extends Comparable<K>, V> TreeMap<K, V> sortByKey(Map<K, V> map) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(new Comparator<K>(){

            @Override
            public int compare(K k, K k2) {
                return k.compareTo(k2);
            }
        });
        treeMap.putAll(map);
        return treeMap;
    }

    public static void addToGridBag(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, Insets insets, int n7, int n8) {
        if (container == null) {
            JDLogger.getLogger().severe("Container ==null");
            return;
        }
        if (component == null) {
            JDLogger.getLogger().severe("Componente ==null");
            return;
        }
        JDUtilities.addToGridBag(container, component, n, n2, n3, n4, n5, n6, insets, 0, 0, n7, n8);
    }

    public static void addToGridBag(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, Insets insets, int n7, int n8, int n9, int n10) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.fill = n9;
        gridBagConstraints.anchor = n10;
        if (insets != null) {
            gridBagConstraints.insets = insets;
        }
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        container.add(component, gridBagConstraints);
    }

    public static String convertExceptionReadable(Exception exception) {
        String string = exception.getClass().getName().replaceAll("Exception", "");
        string = string.substring(string.lastIndexOf(".") + 1);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        int n = 0;
        while (n < string.length()) {
            string2 = string.substring(n, n + 1);
            if (string2.equals(string2.toUpperCase())) {
                stringBuilder.append(' ');
                stringBuilder.append(string2);
            } else {
                stringBuilder.append(string2);
            }
            ++n;
        }
        String string3 = exception.getLocalizedMessage();
        String string4 = stringBuilder.toString();
        return string3 != null ? String.valueOf(string4.trim()) + ": " + string3 : string4.trim();
    }

    public static String createContainerString(ArrayList<DownloadLink> arrayList, String string) {
        ArrayList<CPluginWrapper> arrayList2 = CPluginWrapper.getCWrapper();
        int n = 0;
        while (n < arrayList2.size()) {
            String string2 = arrayList2.get(n).getHost();
            if (string2.equalsIgnoreCase(string)) {
                return arrayList2.get(n).getPlugin().createContainerString(arrayList);
            }
            ++n;
        }
        return null;
    }

    public static String[] encrypt(String string, String string2) {
        ArrayList<CPluginWrapper> arrayList = CPluginWrapper.getCWrapper();
        int n = 0;
        while (n < arrayList.size()) {
            if (arrayList.get(n).getHost().equalsIgnoreCase(string2)) {
                return arrayList.get(n).getPlugin().encrypt(string);
            }
            ++n;
        }
        return null;
    }

    public static String getUserInput(String string, DownloadLink downloadLink) {
        return JDUtilities.getUserInput(string, null, downloadLink);
    }

    public static String getUserInput(String string, String string2, DownloadLink downloadLink) {
        try {
            downloadLink.getLinkStatus().addStatus(0x800000);
            downloadLink.requestGuiUpdate();
            String string3 = JDUtilities.getUserInput(string, string2);
            downloadLink.requestGuiUpdate();
            String string4 = string3;
            return string4;
        }
        finally {
            downloadLink.getLinkStatus().removeStatus(0x800000);
        }
    }

    public static String getUserInput(String string, CryptedLink cryptedLink) {
        return JDUtilities.getUserInput(string, null, cryptedLink);
    }

    public static String getUserInput(String string, String string2, CryptedLink cryptedLink) {
        cryptedLink.getProgressController().setStatusText(JDL.L("gui.linkgrabber.waitinguserio", "Waiting for user input"));
        String string3 = JDUtilities.getUserInput(string, string2);
        cryptedLink.getProgressController().setStatusText(null);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserInput(String string, String string2) {
        Object object = USERIO_LOCK;
        synchronized (object) {
            if (string == null) {
                string = JDL.L("gui.linkgrabber.password", "Password?");
            }
            if (string2 == null) {
                string2 = "";
            }
            String string3 = UserIO.getInstance().requestInputDialog(0, string, string2);
            return string3;
        }
    }

    public static Configuration getConfiguration() {
        if (CONFIGURATION == null) {
            CONFIGURATION = new Configuration();
        }
        return CONFIGURATION;
    }

    public static JDController getController() {
        return CONTROLLER;
    }

    public static long getCRC(File file) {
        CheckedInputStream checkedInputStream = null;
        try {
            checkedInputStream = new CheckedInputStream(new FileInputStream(file), new CRC32());
        }
        catch (FileNotFoundException fileNotFoundException) {
            JDLogger.exception(fileNotFoundException);
            return 0L;
        }
        try {
            byte[] byArray = new byte[128];
            while (checkedInputStream.read(byArray) >= 0) {
            }
            long l = checkedInputStream.getChecksum().getValue();
            return l;
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
            return 0L;
        }
    }

    public static File getCurrentWorkingDirectory(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = JDUtilities.getConfiguration().getStringProperty("DOWNLOAD_DIRECTORY", null);
        String string3 = JDUtilities.getConfiguration().getStringProperty("CURRENT_BROWSE_PATH" + string, null);
        File file = string2 == null ? new File("") : new File(string2);
        if (string3 == null) {
            return file;
        }
        return new File(string3);
    }

    public static String getJACMethodsDirectory() {
        return "jd/captcha/methods/";
    }

    public static Double getJavaVersion() {
        String string = System.getProperty("java.version");
        int n = Formatter.filterInt((String)string.substring(0, string.indexOf(".")));
        int n2 = Formatter.filterInt((String)string.substring(string.indexOf(".") + 1));
        return Double.parseDouble(String.valueOf(n) + "." + n2);
    }

    public static JDClassLoader getJDClassLoader() {
        if (JD_CLASSLOADER == null) {
            File file = JDUtilities.getJDHomeDirectoryFromEnvironment();
            JDLogger.getLogger().finest("Create Classloader: for: " + file.getAbsolutePath());
            JD_CLASSLOADER = new JDClassLoader(file.getAbsolutePath(), Thread.currentThread().getContextClassLoader());
        }
        return JD_CLASSLOADER;
    }

    public static File getJDHomeDirectoryFromEnvironment() {
        File file;
        if (JD_HOME != null) {
            return JD_HOME;
        }
        String string = null;
        File file2 = null;
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("jd/Main.class");
        if (uRL == null) {
            uRL = Thread.currentThread().getContextClassLoader().getResource("jd/update/Main.class");
        }
        String string2 = "" + uRL;
        string2 = String.valueOf(string2.split("\\.jar\\!")[0]) + ".jar";
        string2 = string2.substring(Math.max(string2.indexOf("file:"), 0));
        try {
            file2 = new File(new URI(string2));
            if (file2.isFile()) {
                file2 = file2.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            JDLogger.exception(uRISyntaxException);
        }
        switch (JDUtilities.getRunType()) {
            case 2: {
                System.out.println("JAR");
                string = file2.getAbsolutePath();
                break;
            }
            default: {
                System.out.println("USER");
                string = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".jd_home/";
            }
        }
        if (string == null) {
            string = "." + System.getProperty("file.separator") + ".jd_home/";
            JDLogger.getLogger().info("JD_HOME from current directory:" + string);
        }
        if (!(file = new File(string)).exists()) {
            file.mkdirs();
        }
        JD_HOME = file;
        return file;
    }

    public static String getJDTitle() {
        int n;
        StringBuilder stringBuilder = new StringBuilder("JDownloader");
        if (JDUtilities.getController() != null && JDUtilities.getController().getWaitingUpdates() != null && (n = JDUtilities.getController().getWaitingUpdates().size()) > 0) {
            stringBuilder.append(new char[]{' ', '('});
            stringBuilder.append(JDL.LF("gui.mainframe.title.updatemessage2", "%s Updates available", n));
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static String getPercent(long l, long l2) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        return String.valueOf(decimalFormat.format(100.0 * (double)l / (double)l2)) + "%";
    }

    public static PluginsC getPluginForContainer(String string, String string2) {
        if (string2 != null && CONTAINER_PLUGINS.containsKey(string2)) {
            return CONTAINER_PLUGINS.get(string2);
        }
        PluginsC pluginsC = null;
        for (CPluginWrapper cPluginWrapper : CPluginWrapper.getCWrapper()) {
            if (!cPluginWrapper.getHost().equalsIgnoreCase(string)) continue;
            pluginsC = (PluginsC)cPluginWrapper.getNewPluginInstance();
            if (string2 != null) {
                CONTAINER_PLUGINS.put(string2, pluginsC);
            }
            return pluginsC;
        }
        return null;
    }

    public static PluginForDecrypt getPluginForDecrypt(String string) {
        for (DecryptPluginWrapper decryptPluginWrapper : DecryptPluginWrapper.getDecryptWrapper()) {
            if (!decryptPluginWrapper.getHost().equals(string.toLowerCase())) continue;
            return decryptPluginWrapper.getPlugin();
        }
        return null;
    }

    public static PluginForHost getPluginForHost(String string) {
        for (HostPluginWrapper hostPluginWrapper : HostPluginWrapper.getHostWrapper()) {
            if (!hostPluginWrapper.getHost().equals(string.toLowerCase())) continue;
            return hostPluginWrapper.getPlugin();
        }
        return null;
    }

    public static PluginForHost getNewPluginForHostInstance(String string) {
        for (HostPluginWrapper hostPluginWrapper : HostPluginWrapper.getHostWrapper()) {
            if (!hostPluginWrapper.getHost().equals(string.toLowerCase())) continue;
            return (PluginForHost)hostPluginWrapper.getNewPluginInstance();
        }
        return null;
    }

    public static OptionalPluginWrapper getOptionalPlugin(String string) {
        for (OptionalPluginWrapper optionalPluginWrapper : OptionalPluginWrapper.getOptionalWrapper()) {
            if (optionalPluginWrapper.getID() == null || !optionalPluginWrapper.getID().equalsIgnoreCase(string)) continue;
            return optionalPluginWrapper;
        }
        return null;
    }

    public static ArrayList<HostPluginWrapper> getPremiumPluginsForHost() {
        ArrayList<HostPluginWrapper> arrayList = new ArrayList<HostPluginWrapper>(HostPluginWrapper.getHostWrapper());
        int n = arrayList.size() - 1;
        while (n >= 0) {
            if (!arrayList.get(n).isPremiumEnabled()) {
                arrayList.remove(n);
            }
            --n;
        }
        return arrayList;
    }

    public static String getRevision() {
        if (REVISION != null) {
            return REVISION;
        }
        int n = -1;
        try {
            n = Formatter.filterInt((String)JDIO.readFileToString((File)JDUtilities.getResourceFile("config/version.cfg")));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        int n2 = Integer.parseInt(Formatter.getRevision((String)"$Revision: 9334 $"));
        double d = (double)Math.max(n2, n) / 1000.0;
        REVISION = new DecimalFormat("0.000").format(d).replace(",", ".");
        return REVISION;
    }

    public static int getRunType() {
        String string = "" + Thread.currentThread().getContextClassLoader().getResource("jd");
        if (string.matches("jar\\:.*\\.jar\\!.*")) {
            return 2;
        }
        return 1;
    }

    public static void setJDargs(String[] stringArray) {
        JD_ARGUMENTS = stringArray;
    }

    public static String[] getJDargs() {
        return JD_ARGUMENTS;
    }

    public static void restartJDandWait() {
        JDUtilities.restartJD(false);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void restartJD(final boolean bl) {
        new Thread(new Runnable(){

            public void run() {
                if (JDUtilities.getController() != null) {
                    JDUtilities.getController().prepareShutdown(false);
                }
                List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl6 = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                System.out.println("RESTART NOW");
                for (String stringArray2 : list) {
                    if (stringArray2.contains("Xmx")) {
                        bl6 = true;
                        if (Runtime.getRuntime().maxMemory() < 533000000L) {
                            arrayList.add("-Xmx512m");
                            continue;
                        }
                    } else if (stringArray2.contains("xms")) {
                        bl2 = true;
                    } else if (stringArray2.contains("XX:+useconc")) {
                        bl3 = true;
                    } else if (stringArray2.contains("minheapfree")) {
                        bl4 = true;
                    } else if (stringArray2.contains("maxheapfree")) {
                        bl5 = true;
                    }
                    arrayList.add(stringArray2);
                }
                if (!bl6) {
                    arrayList.add("-Xmx512m");
                }
                if (OSDetector.isLinux()) {
                    if (!bl2) {
                        arrayList.add("-Xms64m");
                    }
                    if (!bl3) {
                        arrayList.add("-XX:+UseConcMarkSweepGC");
                    }
                    if (!bl4) {
                        arrayList.add("-XX:MinHeapFreeRatio=0");
                    }
                    if (!bl5) {
                        arrayList.add("-XX:MaxHeapFreeRatio=0");
                    }
                }
                arrayList.add("-jar");
                arrayList.add("JDownloader.jar");
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                String[] stringArray3 = new String[JD_ARGUMENTS.length + stringArray.length];
                System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                System.arraycopy(JD_ARGUMENTS, 0, stringArray3, stringArray.length, JD_ARGUMENTS.length);
                ArrayList arrayList2 = JDIO.listFiles((File)JDUtilities.getResourceFile("update"));
                String string = new File(new File(System.getProperty("sun.boot.library.path")), "javaw.exe").getAbsolutePath();
                if (arrayList2 != null && arrayList2.size() > 0 || bl) {
                    if (OSDetector.isMac()) {
                        JDLogger.getLogger().info(JDUtilities.runCommand("java", new String[]{"-jar", "tools/tinyupdate.jar", "-restart"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0));
                    } else if (new File(string).exists()) {
                        JDLogger.getLogger().info(JDUtilities.runCommand(string, new String[]{"-jar", "tools/tinyupdate.jar", "-restart"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0));
                    } else {
                        JDLogger.getLogger().info(JDUtilities.runCommand("java", new String[]{"-jar", "tools/tinyupdate.jar", "-restart"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0));
                    }
                } else if (OSDetector.isMac()) {
                    JDLogger.getLogger().info(JDUtilities.runCommand("open", new String[]{"-n", "jDownloader.app"}, JDUtilities.getResourceFile(".").getParentFile().getParentFile().getParentFile().getParentFile().getAbsolutePath(), 0));
                } else if (new File(string).exists()) {
                    JDLogger.getLogger().info(JDUtilities.runCommand(string, stringArray3, JDUtilities.getResourceFile(".").getAbsolutePath(), 0));
                } else {
                    JDLogger.getLogger().info(JDUtilities.runCommand("java", stringArray3, JDUtilities.getResourceFile(".").getAbsolutePath(), 0));
                }
                System.out.println("EXIT NOW");
                System.exit(0);
            }
        }).start();
    }

    public static URL getResourceURL(String string) {
        JDClassLoader jDClassLoader = JDUtilities.getJDClassLoader();
        if (jDClassLoader == null) {
            System.err.println("Classloader == null");
            return null;
        }
        return jDClassLoader.getResource(string);
    }

    public static File getResourceFile(String string) {
        URL uRL = JDUtilities.getResourceURL(string);
        if (uRL != null) {
            try {
                return new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static File getResourceFile(String string, boolean bl) {
        URL uRL = JDUtilities.getResourceURL(string);
        if (uRL != null) {
            try {
                File file;
                File file2 = new File(uRL.toURI());
                if (bl && (file = file2.getParentFile()) != null && !file.exists()) {
                    file.mkdirs();
                }
                return file2;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String runCommand(String string, String[] stringArray, String string2, int n) {
        Executer executer = new Executer(string);
        executer.addParameters(stringArray);
        executer.setRunin(string2);
        executer.setWaitTimeout(n);
        executer.start();
        executer.waitTimeout();
        return String.valueOf(executer.getOutputStream()) + " \r\n " + executer.getErrorStream();
    }

    public static void saveConfig() {
        JDUtilities.getConfiguration().save();
    }

    public static String objectToXml(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        XMLEncoder xMLEncoder = new XMLEncoder(dataOutputStream);
        xMLEncoder.writeObject(object);
        xMLEncoder.close();
        dataOutputStream.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static Object xmlStringToObjekt(String string) throws IOException {
        Object object = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        XMLDecoder xMLDecoder = new XMLDecoder(byteArrayInputStream);
        object = xMLDecoder.readObject();
        xMLDecoder.close();
        byteArrayInputStream.close();
        return object;
    }

    public static void setConfiguration(Configuration configuration) {
        CONFIGURATION = configuration;
    }

    public static void setController(JDController jDController) {
        CONTROLLER = jDController;
    }

    public static DownloadController getDownloadController() {
        return DownloadController.getInstance();
    }

    public static void setCurrentWorkingDirectory(File file, String string) {
        if (string == null) {
            string = "";
        }
        JDUtilities.getConfiguration().setProperty("CURRENT_BROWSE_PATH" + string, file.getAbsolutePath());
        JDUtilities.getConfiguration().save();
    }

    public static String removeEndingPoints(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        while (string2.endsWith(".")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static synchronized DatabaseConnector getDatabaseConnector() {
        if (DB_CONNECT == null) {
            try {
                DB_CONNECT = new DatabaseConnector();
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
                String string = String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/config/";
                Logger logger = JDLogger.getLogger();
                if (exception.getMessage().equals("Database broken!")) {
                    logger.severe("Database broken! Creating fresh Database");
                    if (!new File(String.valueOf(string) + "database.script").delete() || !new File(String.valueOf(string) + "database.properties").delete()) {
                        logger.severe("Could not delete broken Database");
                        UserIO.getInstance().requestMessageDialog("Could not delete broken database. Please remove the JD_HOME/config directory and restart JD");
                    }
                }
                try {
                    DB_CONNECT = new DatabaseConnector();
                }
                catch (Exception exception2) {
                    JDLogger.exception(exception2);
                    UserIO.getInstance().requestMessageDialog("Could not create database. Please remove the JD_HOME/config directory and restart JD");
                    System.exit(1);
                }
            }
        }
        return DB_CONNECT;
    }

    public static boolean openExplorer(File file) {
        try {
            return new GetExplorer().openExplorer(file);
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return false;
        }
    }

    public static Document parseXmlString(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            InputSource inputSource = new InputSource(new StringReader(string));
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            return document;
        }
        catch (Exception exception) {
            JDLogger.getLogger().severe(string);
            JDLogger.exception(exception);
            return null;
        }
    }

    public static String createXmlString(Document document) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            return streamResult.getWriter().toString();
        }
        catch (TransformerException transformerException) {
            JDLogger.exception(transformerException);
            return null;
        }
    }

    public static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getNamedItem(string) == null) {
            return null;
        }
        return namedNodeMap.getNamedItem(string).getNodeValue();
    }

    public static String getDefaultDownloadDirectory() {
        return JDUtilities.getConfiguration().getStringProperty("DOWNLOAD_DIRECTORY", JDUtilities.getResourceFile("downloads").getAbsolutePath());
    }

    @Deprecated
    public static ArrayList<HostPluginWrapper> getPluginsForHost() {
        return HostPluginWrapper.getHostWrapper();
    }
}

