/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.langfileeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.gui.UserIF;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.pieapi.ChartAPIEntity;
import jd.gui.swing.components.pieapi.PieChartAPI;
import jd.gui.swing.components.table.JDRowHighlighter;
import jd.gui.swing.components.table.JDTable;
import jd.gui.swing.components.table.JDTableModel;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.nutils.JDFlags;
import jd.nutils.nativeintegration.LocalBrowser;
import jd.nutils.svn.ResolveHandler;
import jd.nutils.svn.Subversion;
import jd.parser.Regex;
import jd.plugins.optional.langfileeditor.KeyInfo;
import jd.plugins.optional.langfileeditor.LFETableModel;
import jd.plugins.optional.langfileeditor.LangFileEditor;
import jd.plugins.optional.langfileeditor.LngEntry;
import jd.plugins.optional.langfileeditor.SrcParser;
import jd.utils.JDGeoCode;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.search.SearchFactory;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFEGui
extends SwitchPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = -143452893912428555L;
    public static final String SOURCE_SVN = "svn://svn.jdownloader.org/jdownloader/trunk/src";
    public static final String LANGUAGE_SVN = "svn://svn.jdownloader.org/jdownloader/trunk/ressourcen/jd/languages";
    private static final String LOCALE_PREFIX = "plugins.optional.langfileeditor.";
    private final SubConfiguration subConfig;
    public static final String PROPERTY_SVN_ACCESS_USER = "PROPERTY_SVN_CHECKOUT_USER";
    public static final String PROPERTY_SVN_ACCESS_PASS = "PROPERTY_SVN_CHECKOUT_PASS";
    private static final String MISSING_KEY = "~MISSING KEY/REMOVED~";
    private LFETableModel tableModel;
    private JDTable table;
    private File languageFile;
    private PieChartAPI keyChart;
    private ChartAPIEntity entDone;
    private ChartAPIEntity entMissing;
    private ChartAPIEntity entOld;
    private JMenuBar menubar;
    private JMenu mnuFile;
    private JMenu mnuLoad;
    private JMenu mnuKey;
    private JMenu mnuTest;
    private JMenuItem mnuSave;
    private JMenuItem mnuSaveLocal;
    private JMenuItem mnuReload;
    private JMenuItem mnuCompleteReload;
    private JMenuItem mnuAdd;
    private JMenuItem mnuAdopt;
    private JMenuItem mnuClear;
    private JMenuItem mnuDelete;
    private JMenuItem mnuDeleteOld;
    private JMenuItem mnuOpenSearchDialog;
    private JMenuItem mnuCurrent;
    private JMenuItem mnuKeymode;
    private JPopupMenu mnuContextPopup;
    private JMenuItem mnuContextAdopt;
    private JMenuItem mnuContextClear;
    private JMenuItem mnuContextDelete;
    private HashMap<String, String> languageKeysFormFile = new HashMap();
    private HashMap<String, String> languageENKeysFormFile = new HashMap();
    private ArrayList<KeyInfo> data = new ArrayList();
    private String lngKey = null;
    private boolean changed = false;
    private final File dirLanguages;
    private final File dirWorkingCopy;
    public static final Color COLOR_DONE = new Color(204, 255, 170);
    public static final Color COLOR_MISSING = new Color(221, 34, 34);
    public static final Color COLOR_OLD = Color.ORANGE;
    private SrcParser sourceParser;
    private Thread updater;
    private JButton warning;
    private LangFileEditor plugin;

    public LFEGui(SubConfiguration cfg, LangFileEditor plg) {
        this.subConfig = cfg;
        this.plugin = plg;
        this.setName(JDL.L((String)"plugins.optional.langfileeditor.title", (String)"Language Editor"));
        this.dirLanguages = JDUtilities.getResourceFile((String)"tmp/lfe/lng/");
        this.dirWorkingCopy = JDUtilities.getResourceFile((String)"tmp/lfe/src/");
        this.dirLanguages.mkdirs();
        this.dirWorkingCopy.mkdirs();
        this.showGui();
    }

    public ArrayList<KeyInfo> getData() {
        return this.data;
    }

    private void showGui() {
        this.tableModel = new LFETableModel(this);
        this.table = new JDTable((JDTableModel)this.tableModel);
        this.table.setEnabled(false);
        this.table.addMouseListener((MouseListener)this);
        this.table.setSelectionMode(2);
        this.table.setAutoStartEditOnKeyStroke(false);
        this.table.addJDRowHighlighter(new JDRowHighlighter(COLOR_MISSING){

            public boolean doHighlight(Object obj) {
                return ((KeyInfo)obj).isMissing();
            }
        });
        this.table.addJDRowHighlighter(new JDRowHighlighter(COLOR_OLD){

            public boolean doHighlight(Object obj) {
                return ((KeyInfo)obj).isOld();
            }
        });
        this.keyChart = new PieChartAPI("", 350, 50);
        this.entDone = new ChartAPIEntity(JDL.L((String)"plugins.optional.langfileeditor.keychart.done", (String)"Done"), (Object)0, COLOR_DONE);
        this.keyChart.addEntity(this.entDone);
        this.entMissing = new ChartAPIEntity(JDL.L((String)"plugins.optional.langfileeditor.keychart.missing", (String)"Missing"), (Object)0, COLOR_MISSING);
        this.keyChart.addEntity(this.entMissing);
        this.entOld = new ChartAPIEntity(JDL.L((String)"plugins.optional.langfileeditor.keychart.old", (String)"Old"), (Object)0, COLOR_OLD);
        this.keyChart.addEntity(this.entOld);
        this.setLayout((LayoutManager)new MigLayout("wrap 3", "[grow, fill]", "[][grow, fill][]"));
        this.warning = new JButton(JDL.L((String)"plugins.optional.langfileeditor.account.warning", (String)"SVN Account missing. Click here to read more."));
        this.warning.setVisible(false);
        this.warning.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    LocalBrowser.openURL(null, (URL)new URL("http://jdownloader.org/knowledge/wiki/development/translation/translate-jdownloader"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    UserIO.getInstance().requestMessageDialog(JDL.L((String)"jd.plugins.optional.langfileeditor.LangFileEditor.btn.readmore", (String)"more..."), "http://jdownloader.org/knowledge/wiki/development/translation/translate-jdownloader");
                }
            }
        });
        this.add(this.warning, "grow, spanx,hidemode 2");
        this.add(new JScrollPane((Component)this.table), "grow, spanx");
        this.add((Component)this.keyChart, "h 50!, w 350!");
        this.updater = new Thread(new Runnable(){

            public void run() {
                boolean cfgRequested = false;
                while (true) {
                    if (LFEGui.this.subConfig.getStringProperty(LFEGui.PROPERTY_SVN_ACCESS_USER) == null || LFEGui.this.subConfig.getStringProperty(LFEGui.PROPERTY_SVN_ACCESS_USER).trim().length() == 0) {
                        if (!cfgRequested) {
                            UserIF.getInstance().requestPanel(UserIF.Panels.CONFIGPANEL, (Object)LFEGui.this.plugin.getConfig());
                        }
                        cfgRequested = true;
                        try {
                            new GuiRunnable<Object>(){

                                public Object runSave() {
                                    LFEGui.this.warning.setVisible(true);
                                    LFEGui.this.mnuFile.setEnabled(false);
                                    return null;
                                }
                            }.start();
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    if (Subversion.checkLogin((String)LFEGui.SOURCE_SVN, (String)LFEGui.this.subConfig.getStringProperty(LFEGui.PROPERTY_SVN_ACCESS_USER), (String)LFEGui.this.subConfig.getStringProperty(LFEGui.PROPERTY_SVN_ACCESS_PASS))) break;
                    UserIO.getInstance().requestMessageDialog(JDL.L((String)"jd.plugins.optional.langfileeditor.LangFileEditor.badlogins", (String)"Logins incorrect.\r\n PLease enter correct logins."));
                    LFEGui.this.subConfig.setProperty(LFEGui.PROPERTY_SVN_ACCESS_USER, null);
                    LFEGui.this.subConfig.setProperty(LFEGui.PROPERTY_SVN_ACCESS_PASS, null);
                    LFEGui.this.subConfig.save();
                }
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        LFEGui.this.warning.setVisible(false);
                        return null;
                    }
                }.start();
                LFEGui.this.setEnabled(false);
                LFEGui.this.updateSVN(false);
                LFEGui.this.getSourceEntries();
                LFEGui.this.populateLngMenu();
                LFEGui.this.setEnabled(true);
                if (LFEGui.this.menubar != null) {
                    LFEGui.this.menubar.setEnabled(true);
                }
                LFEGui.this.mnuFile.setEnabled(true);
            }
        });
        this.updater.start();
    }

    private void updateKeyChart() {
        int numMissing = 0;
        int numOld = 0;
        for (KeyInfo entry : this.data) {
            if (entry.isOld()) {
                ++numOld;
                continue;
            }
            if (!entry.isMissing()) continue;
            ++numMissing;
        }
        this.entDone.setData((Object)(this.data.size() - numMissing - numOld));
        this.entDone.setCaption(String.valueOf(JDL.L((String)"plugins.optional.langfileeditor.keychart.done", (String)"Done")) + " [" + this.entDone.getData() + "]");
        this.entMissing.setData((Object)numMissing);
        this.entMissing.setCaption(String.valueOf(JDL.L((String)"plugins.optional.langfileeditor.keychart.missing", (String)"Missing")) + " [" + this.entMissing.getData() + "]");
        this.entOld.setData((Object)numOld);
        this.entOld.setCaption(String.valueOf(JDL.L((String)"plugins.optional.langfileeditor.keychart.old", (String)"Old")) + " [" + this.entOld.getData() + "]");
        this.keyChart.fetchImage();
    }

    private void populateLngMenu() {
        new GuiRunnable<Object>(){

            public Object runSave() {
                LFEGui.this.mnuLoad.removeAll();
                File[] fileArray = LFEGui.this.dirLanguages.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().endsWith(".loc")) {
                        try {
                            String language = JDGeoCode.toLonger((String)f.getName().substring(0, f.getName().length() - 4));
                            if (language != null) {
                                JMenuItem mi = new JMenuItem(language);
                                mi.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        if (LFEGui.this.languageFile != null) {
                                            LFEGui.this.saveChanges();
                                        }
                                        LFEGui.this.languageFile = new File(LFEGui.this.dirLanguages, String.valueOf(JDGeoCode.longToShort((String)e.getActionCommand())) + ".loc");
                                        LFEGui.this.initLocaleData();
                                        LFEGui.this.table.setEnabled(true);
                                    }
                                });
                                LFEGui.this.mnuLoad.add(mi);
                            }
                        }
                        catch (Exception e) {
                            System.out.println(f);
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                return null;
            }
        }.waitForEDT();
    }

    private void buildContextMenu() {
        this.mnuContextPopup = new JPopupMenu();
        this.mnuContextDelete = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.deleteKeys", (String)"Delete Key(s)"));
        this.mnuContextPopup.add(this.mnuContextDelete);
        this.mnuContextClear = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.clearValues", (String)"Clear Value(s)"));
        this.mnuContextPopup.add(this.mnuContextClear);
        this.mnuContextPopup.addSeparator();
        this.mnuContextAdopt = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.adoptDefaults", (String)"Adopt Default(s)"));
        this.mnuContextPopup.add(this.mnuContextAdopt);
        this.mnuContextDelete.addActionListener(this);
        this.mnuContextClear.addActionListener(this);
        this.mnuContextAdopt.addActionListener(this);
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        int old;
        if (e.getSource() == this.mnuCompleteReload || e.getSource() == this.mnuReload) {
            this.saveChanges();
            new Thread(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LFEGui.this.mnuKey.setEnabled(false);
                            LFEGui.this.mnuCurrent.setEnabled(false);
                            LFEGui.this.mnuSave.setEnabled(false);
                            LFEGui.this.mnuSaveLocal.setEnabled(false);
                        }
                    });
                    if (e.getSource() == LFEGui.this.mnuCompleteReload) {
                        SrcParser.deleteCache();
                    }
                    LFEGui.this.getSourceEntries();
                    LFEGui.this.updateSVN(true);
                    LFEGui.this.populateLngMenu();
                    LFEGui.this.initLocaleData();
                }
            }).start();
        } else if (e.getSource() == this.mnuSaveLocal) {
            this.saveLanguageFile(this.languageFile, false);
        } else if (e.getSource() == this.mnuSave) {
            this.saveLanguageFile(this.languageFile, true);
        } else if (e.getSource() == this.mnuCurrent) {
            this.saveLanguageFile(this.languageFile, false);
            this.startNewInstance(new String[]{"-n", "-lng", this.languageFile.getAbsolutePath()});
            UserIO.getInstance().requestMessageDialog("Started JDownloader using " + this.languageFile);
        } else if (e.getSource() == this.mnuKeymode) {
            this.startNewInstance(new String[]{"-n", "-trdebug"});
            UserIO.getInstance().requestMessageDialog("Started JDownloader in KEY DEBUG Mode");
        } else if (e.getSource() == this.mnuAdd) {
            String[] result = UserIO.getInstance().requestTwoTextFieldDialog(JDL.L((String)"plugins.optional.langfileeditor.addKey.title", (String)"Add new key"), JDL.L((String)"plugins.optional.langfileeditor.addKey.message1", (String)"Type in the name of the key:"), "", JDL.L((String)"plugins.optional.langfileeditor.addKey.message2", (String)"Type in the translated message of the key:"), "");
            if (result == null || result[0].equals("")) {
                return;
            }
            result[0] = result[0].toLowerCase();
            for (KeyInfo ki : this.data) {
                if (!ki.getKey().equals(result[0])) continue;
                UserIO.getInstance().requestMessageDialog(JDL.LF((String)"plugins.optional.langfileeditor.addKey.error.message", (String)"The key '%s' is already in use!", (Object[])new Object[]{result[0]}));
                return;
            }
            this.data.add(new KeyInfo(result[0].toLowerCase(), null, result[1], this.languageENKeysFormFile.get(result[0].toLowerCase())));
            this.tableModel.refreshModel();
            this.tableModel.fireTableDataChanged();
            this.updateKeyChart();
        } else if (e.getSource() == this.mnuDelete || e.getSource() == this.mnuContextDelete) {
            this.deleteSelectedKeys();
        } else if (e.getSource() == this.mnuAdopt || e.getSource() == this.mnuContextAdopt) {
            int[] nArray = this.getSelectedRows();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                this.data.get(row).setLanguage(this.data.get(row).getSource());
                ++n2;
            }
            this.dataChanged();
        } else if (e.getSource() == this.mnuClear || e.getSource() == this.mnuContextClear) {
            int[] nArray = this.getSelectedRows();
            int n = nArray.length;
            int n3 = 0;
            while (n3 < n) {
                int row = nArray[n3];
                this.data.get(row).setLanguage("");
                ++n3;
            }
            this.dataChanged();
        } else if (e.getSource() == this.mnuOpenSearchDialog) {
            SearchFactory.getInstance().showFindInput((JComponent)this.table, this.table.getSearchable());
        } else if (e.getSource() == this.mnuDeleteOld && (old = Integer.valueOf(this.entOld.getData()).intValue()) > 0 && JDFlags.hasAllFlags((int)UserIO.getInstance().requestConfirmDialog(548, JDL.L((String)"plugins.optional.langfileeditor.deleteOld.title", (String)"Delete Old Key(s)?"), JDL.LF((String)"plugins.optional.langfileeditor.deleteOld.message", (String)"Delete all %s old Key(s)?", (Object[])new Object[]{old})), (int[])new int[]{2})) {
            this.deleteOldKeys();
        }
    }

    private void deleteOldKeys() {
        int i = this.data.size() - 1;
        while (i >= 0) {
            if (this.data.get(i).isOld()) {
                this.data.remove(i);
            }
            --i;
        }
        this.dataChanged();
    }

    private void startNewInstance(String[] strings) {
        ArrayList<String> jargs = new ArrayList<String>();
        jargs.add("-Xmx512m");
        jargs.add("-jar");
        jargs.add("JDownloader.jar");
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            jargs.add(a);
            ++n2;
        }
        JDLogger.getLogger().info(JDUtilities.runCommand((String)"java", (String[])jargs.toArray(new String[0]), (String)JDUtilities.getResourceFile((String)".").getAbsolutePath(), (int)0));
    }

    private void saveChanges() {
        if (!this.changed) {
            return;
        }
        int ret = UserIO.getInstance().requestConfirmDialog(4, JDL.L((String)"plugins.optional.langfileeditor.saveChanges", (String)"Save changes?"), JDL.LF((String)"plugins.optional.langfileeditor.saveChanges.message", (String)"Save your changes to %s?", (Object[])new Object[]{this.languageFile}), null, JDL.L((String)"gui.btn_yes", (String)"Yes"), JDL.L((String)"gui.btn_no", (String)"No"));
        if (JDFlags.hasAllFlags((int)ret, (int[])new int[]{2})) {
            this.saveLanguageFile(this.languageFile, true);
        }
    }

    private void updateSVN(boolean revert) {
        if (!this.dirLanguages.exists()) {
            this.dirLanguages.mkdirs();
        }
        if (!this.dirWorkingCopy.exists()) {
            this.dirWorkingCopy.mkdirs();
        }
        final ProgressController progress = new ProgressController(JDL.L((String)"plugins.optional.langfileeditor.svn.updating", (String)"Updating SVN: Please wait"));
        progress.setIndeterminate(true);
        try {
            Subversion svn = null;
            svn = new Subversion(SOURCE_SVN, this.subConfig.getStringProperty(PROPERTY_SVN_ACCESS_USER), this.subConfig.getStringProperty(PROPERTY_SVN_ACCESS_PASS));
            Subversion svnLanguageDir = new Subversion(LANGUAGE_SVN, this.subConfig.getStringProperty(PROPERTY_SVN_ACCESS_USER), this.subConfig.getStringProperty(PROPERTY_SVN_ACCESS_PASS));
            svn.getBroadcaster().addListener((EventListener)new MessageListener(){

                public void onMessage(MessageEvent event) {
                    progress.setStatusText(String.valueOf(JDL.L((String)"plugins.optional.langfileeditor.svn.updating", (String)"Updating SVN: Please wait")) + ": " + event.getMessage().replace(LFEGui.this.dirWorkingCopy.getParentFile().getAbsolutePath(), ""));
                }
            });
            try {
                svnLanguageDir.revert(this.dirWorkingCopy);
            }
            catch (Exception e) {
                JDLogger.exception((Throwable)e);
            }
            try {
                svn.update(this.dirWorkingCopy, null);
            }
            catch (Exception e) {
                JDLogger.exception((Throwable)e);
                UserIO.getInstance().requestMessageDialog(JDL.L((String)"plugins.optional.langfileeditor.error.title", (String)"Error occured"), JDL.LF((String)"plugins.optional.langfileeditor.error.updatesource.message", (String)"Error while updating source:\r\n %s", (Object[])new Object[]{JDLogger.getStackTrace((Throwable)e)}));
            }
            if (revert) {
                try {
                    svnLanguageDir.revert(this.dirLanguages);
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                }
            }
            try {
                svnLanguageDir.update(this.dirLanguages, null);
            }
            catch (Exception e) {
                JDLogger.exception((Throwable)e);
                UserIO.getInstance().requestMessageDialog(JDL.L((String)"plugins.optional.langfileeditor.error.title", (String)"Error occured"), JDL.LF((String)"plugins.optional.langfileeditor.error.updatelanguages.message", (String)"Error while updating languages:\r\n %s", (Object[])new Object[]{JDLogger.getStackTrace((Throwable)e)}));
            }
            svnLanguageDir.dispose();
            svn.dispose();
            progress.setStatusText(JDL.L((String)"plugins.optional.langfileeditor.svn.updating.ready", (String)"Updating SVN: Complete"));
            progress.doFinalize(2000L);
        }
        catch (SVNException e) {
            JDLogger.exception((Throwable)e);
            progress.setColor(Color.RED);
            progress.setStatusText(JDL.L((String)"plugins.optional.langfileeditor.svn.updating.error", (String)"Updating SVN: Error!"));
            progress.doFinalize(5000L);
        }
    }

    private void deleteSelectedKeys() {
        int len;
        int[] rows = this.getSelectedRows();
        Arrays.sort(rows);
        int i = len = rows.length - 1;
        while (i >= 0) {
            String temp = this.data.remove(rows[i]).getKey();
            this.data.remove(temp);
            --i;
        }
        int newRow = Math.min(rows[len] - len, this.tableModel.getRowCount() - 1);
        this.table.getSelectionModel().setSelectionInterval(newRow, newRow);
        this.dataChanged();
    }

    private int[] getSelectedRows() {
        int[] rows = this.table.getSelectedRows();
        int[] ret = new int[rows.length];
        int i = 0;
        while (i < rows.length) {
            ret[i] = this.table.convertRowIndexToModel(rows[i]);
            ++i;
        }
        Arrays.sort(ret);
        return ret;
    }

    private void saveLanguageFile(File file, boolean upload) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(this.data);
        int old = Integer.valueOf(this.entOld.getData());
        if (old > 0 && JDFlags.hasAllFlags((int)UserIO.getInstance().requestConfirmDialog(1060, JDL.L((String)"plugins.optional.langfileeditor.deleteOld.title", (String)"Delete Old Key(s)?"), JDL.LF((String)"plugins.optional.langfileeditor.deleteOld.message2", (String)"There are still %s old keys in the LanguageFile. Delete them before saving?", (Object[])new Object[]{old})), (int[])new int[]{2})) {
            this.deleteOldKeys();
        }
        for (KeyInfo entry : this.data) {
            if (entry.isMissing()) continue;
            sb.append(entry.toString()).append('\n');
        }
        try {
            Subversion svn = new Subversion(LANGUAGE_SVN, this.subConfig.getStringProperty(PROPERTY_SVN_ACCESS_USER), this.subConfig.getStringProperty(PROPERTY_SVN_ACCESS_PASS));
            ArrayList info = svn.getInfo(file);
            if (((SVNInfo)info.get(0)).getConflictWrkFile() != null) {
                svn.revert(file);
            }
            svn.dispose();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            out.write(sb.toString());
            out.close();
            if (upload) {
                String message = UserIO.getInstance().requestInputDialog(0, "Enter change description", "Please enter a short description for your changes (in english).", "", null, null, null);
                if (message == null) {
                    message = "Updated language file (" + this.lngKey + ")";
                }
                if (!this.commit(file, message, null)) {
                    UserIO.getInstance().requestMessageDialog("Could not upload changes. Please send the file " + file.getAbsolutePath() + " to support@jdownloader.org");
                    return;
                }
            }
        }
        catch (Exception e) {
            UserIO.getInstance().requestMessageDialog(JDL.LF((String)"plugins.optional.langfileeditor.save.error.message", (String)"An error occured while writing the LanguageFile:\n%s", (Object[])new Object[]{e.getMessage()}));
            return;
        }
        this.changed = false;
        if (upload) {
            UserIO.getInstance().requestMessageDialog(JDL.L((String)"plugins.optional.langfileeditor.save.success.message", (String)"LanguageFile saved successfully!"));
        }
        this.initLocaleData();
    }

    private void initLocaleData() {
        String key;
        this.parseLanguageFile(this.languageFile, this.languageKeysFormFile);
        this.parseLanguageFile(new File(this.dirLanguages, "en.loc"), this.languageENKeysFormFile);
        this.data.clear();
        if (this.languageFile != null) {
            this.lngKey = this.languageFile.getName().substring(0, this.languageFile.getName().length() - 4);
            this.lngKey = JDGeoCode.parseLanguageCode((String)this.lngKey)[0];
        }
        for (LngEntry lngEntry : this.sourceParser.getEntries()) {
            key = lngEntry.getKey();
            KeyInfo keyInfo = new KeyInfo(key, lngEntry.getValue(), this.languageKeysFormFile.remove(key), this.languageENKeysFormFile.get(key));
            this.data.add(keyInfo);
        }
        for (Map.Entry entry : this.languageKeysFormFile.entrySet()) {
            key = (String)entry.getKey();
            String value = null;
            for (String patt : this.sourceParser.getPattern()) {
                if (!key.matches(patt)) continue;
                value = "<pattern> " + patt;
            }
            this.data.add(new KeyInfo(key, value, (String)entry.getValue(), this.languageENKeysFormFile.get(key)));
        }
        Collections.sort(this.data);
        this.tableModel.refreshModel();
        this.tableModel.fireTableDataChanged();
        this.changed = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LFEGui.this.updateKeyChart();
                LFEGui.this.mnuKey.setEnabled(true);
                LFEGui.this.mnuCurrent.setEnabled(true);
                LFEGui.this.mnuSave.setEnabled(true);
                LFEGui.this.mnuSaveLocal.setEnabled(true);
            }
        });
    }

    private void getSourceEntries() {
        ProgressController progress = new ProgressController(JDL.L((String)"plugins.optional.langfileeditor.analyzingSource1", (String)"Analyzing Source Folder"));
        progress.setIndeterminate(true);
        this.sourceParser = new SrcParser(this.dirWorkingCopy);
        this.sourceParser.getBroadcaster().addListener((EventListener)progress);
        this.sourceParser.parse();
        JDLogger.getLogger().warning("Patternmatches are not recommened: \r\n" + this.sourceParser.getPattern());
        progress.setStatusText(JDL.L((String)"plugins.optional.langfileeditor.analyzingSource.ready", (String)"Analyzing Source Folder: Complete"));
        progress.doFinalize(2000L);
    }

    private boolean commit(File file, String string, Subversion svn) {
        try {
            if (svn == null) {
                svn = new Subversion(LANGUAGE_SVN, this.subConfig.getStringProperty(PROPERTY_SVN_ACCESS_USER), this.subConfig.getStringProperty(PROPERTY_SVN_ACCESS_PASS));
            }
            svn.update(file, null);
            try {
                svn.resolveConflicts(file, new ResolveHandler(){

                    public String resolveConflict(SVNInfo info, File file, String contents, int startMine, int endMine, int startTheirs, int endTheirs) {
                        String[] mine = Regex.getLines((String)contents.substring(startMine, endMine).trim());
                        String[] theirs = Regex.getLines((String)contents.substring(startTheirs, endTheirs).trim());
                        StringBuilder sb = new StringBuilder();
                        ArrayList<String> keys = new ArrayList<String>();
                        String[] stringArray = mine;
                        int n = mine.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String newValue;
                            String m = stringArray[n2];
                            int index = m.indexOf("=");
                            String key = m.substring(0, index).trim();
                            String value = m.substring(index + 1).trim();
                            boolean found = false;
                            String[] stringArray2 = theirs;
                            int n3 = theirs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String t = stringArray2[n4];
                                if (t.startsWith(key)) {
                                    int tindex = t.indexOf("=");
                                    String tkey = t.substring(0, tindex).trim();
                                    String tvalue = t.substring(tindex + 1).trim();
                                    if (key.equalsIgnoreCase(tkey)) {
                                        found = true;
                                        if (value.equals(tvalue)) {
                                            sb.append(key).append(" = ").append(value).append("\r\n");
                                            keys.add(key);
                                            break;
                                        }
                                        String newValue2 = this.selectVersion(key, value, tvalue);
                                        sb.append(key).append(" = ").append(newValue2).append("\r\n");
                                        keys.add(key);
                                        break;
                                    }
                                }
                                ++n4;
                            }
                            if (!found && (newValue = this.selectVersion(key, value, LFEGui.MISSING_KEY)) != LFEGui.MISSING_KEY) {
                                sb.append(key).append(" = ").append(value).append("\r\n");
                                keys.add(key);
                            }
                            ++n2;
                        }
                        stringArray = theirs;
                        n = theirs.length;
                        n2 = 0;
                        while (n2 < n) {
                            String t = stringArray[n2];
                            int tindex = t.indexOf("=");
                            if (tindex >= 0) {
                                String newValue;
                                String tkey = t.substring(0, tindex).trim();
                                String tvalue = t.substring(tindex + 1).trim();
                                if (!keys.contains(tkey) && (newValue = this.selectVersion(tkey, LFEGui.MISSING_KEY, tvalue)) != LFEGui.MISSING_KEY) {
                                    sb.append(String.valueOf(tkey) + " = " + tvalue + "\r\n");
                                    keys.add(tkey);
                                }
                            }
                            ++n2;
                        }
                        return sb.toString().trim();
                    }

                    private String selectVersion(String key, String value, String tvalue) {
                        String html = "<h1>Key: " + key + "</h1><h2>Translation A</h2>" + value + "<h2>Translation B</h2>" + tvalue + "<br><br>Select the better translation. A or B:";
                        int ret = UserIO.getInstance().requestConfirmDialog(196, "Conflicts occured!", html, null, "A", "B");
                        if (JDFlags.hasAllFlags((int)ret, (int[])new int[]{4})) {
                            return tvalue;
                        }
                        return value;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            svn.commit(file, string);
            svn.dispose();
            return true;
        }
        catch (SVNException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void parseLanguageFile(File file, HashMap<String, String> data) {
        data.clear();
        if (file == null || !file.exists()) {
            System.out.println("JDLocale: " + file + " not found");
            return;
        }
        try {
            String line;
            BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            while ((line = f.readLine()) != null) {
                int split;
                if (line.startsWith("#") || (split = line.indexOf("=")) <= 0) continue;
                String key = line.substring(0, split).trim().toLowerCase();
                String value = String.valueOf(line.substring(split + 1).trim()) + (line.endsWith(" ") ? " " : "");
                data.put(key, value);
            }
            f.close();
        }
        catch (IOException e) {
            JDLogger.exception((Throwable)e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            int row = this.table.rowAtPoint(e.getPoint());
            if (!this.table.isRowSelected(row)) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
            if (this.mnuContextPopup == null) {
                this.buildContextMenu();
            }
            this.mnuContextPopup.show((Component)this.table, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void onShow() {
    }

    public void onHide() {
        try {
            this.updater.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveChanges();
    }

    public void initMenu(JMenuBar menubar) {
        this.menubar = menubar;
        this.mnuLoad = new JMenu(JDL.L((String)"plugins.optional.langfileeditor.load", (String)"Load Language"));
        this.populateLngMenu();
        this.mnuFile = new JMenu(JDL.L((String)"plugins.optional.langfileeditor.file", (String)"File"));
        this.mnuFile.add(this.mnuLoad);
        this.mnuFile.addSeparator();
        this.mnuSaveLocal = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.savelocale", (String)"Save Offline"));
        this.mnuFile.add(this.mnuSaveLocal);
        this.mnuFile.setEnabled(false);
        this.mnuSave = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.saveandupload", (String)"Save & Upload"));
        this.mnuFile.add(this.mnuSave);
        this.mnuFile.addSeparator();
        this.mnuReload = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.reload", (String)"Revert/Reload"));
        this.mnuFile.add(this.mnuReload);
        this.mnuCompleteReload = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.completeReload", (String)"Complete Reload (Deletes Cache)"));
        this.mnuFile.add(this.mnuCompleteReload);
        this.mnuSaveLocal.addActionListener(this);
        this.mnuSave.addActionListener(this);
        this.mnuReload.addActionListener(this);
        this.mnuCompleteReload.addActionListener(this);
        this.mnuSaveLocal.setEnabled(false);
        this.mnuSave.setEnabled(false);
        this.mnuSave.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.mnuKey = new JMenu(JDL.L((String)"plugins.optional.langfileeditor.key", (String)"Key"));
        this.mnuKey.setEnabled(false);
        this.mnuAdd = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.addKey", (String)"Add Key"));
        this.mnuKey.add(this.mnuAdd);
        this.mnuDelete = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.deleteKeys", (String)"Delete Key(s)"));
        this.mnuKey.add(this.mnuDelete);
        this.mnuClear = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.clearValues", (String)"Clear Value(s)"));
        this.mnuKey.add(this.mnuClear);
        this.mnuKey.addSeparator();
        this.mnuAdopt = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.adoptDefaults", (String)"Adopt Default(s)"));
        this.mnuKey.add(this.mnuAdopt);
        this.mnuKey.addSeparator();
        this.mnuDeleteOld = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.deleteOldKeys", (String)"Delete Old Key(s)"));
        this.mnuKey.add(this.mnuDeleteOld);
        this.mnuKey.addSeparator();
        this.mnuOpenSearchDialog = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.openSearchDialog", (String)"Open Search Dialog"));
        this.mnuKey.add(this.mnuOpenSearchDialog);
        this.mnuAdd.addActionListener(this);
        this.mnuDelete.addActionListener(this);
        this.mnuClear.addActionListener(this);
        this.mnuAdopt.addActionListener(this);
        this.mnuDeleteOld.addActionListener(this);
        this.mnuOpenSearchDialog.addActionListener(this);
        this.mnuDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.mnuOpenSearchDialog.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.mnuTest = new JMenu(JDL.L((String)"plugins.optional.langfileeditor.test", (String)"Test"));
        this.mnuCurrent = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.startcurrent", (String)"Test JD with current translation"));
        this.mnuTest.add(this.mnuCurrent);
        this.mnuCurrent.addActionListener(this);
        this.mnuKeymode = new JMenuItem(JDL.L((String)"plugins.optional.langfileeditor.startkey", (String)"Test JD in Key mode"));
        this.mnuTest.add(this.mnuKeymode);
        this.mnuKeymode.addActionListener(this);
        this.mnuCurrent.setEnabled(false);
        menubar.add(this.mnuFile);
        menubar.add(this.mnuKey);
        menubar.add(this.mnuTest);
        menubar.setEnabled(false);
    }

    public void dataChanged() {
        this.tableModel.refreshModel();
        this.tableModel.fireTableDataChanged();
        this.updateKeyChart();
        this.changed = true;
    }
}

