/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.langfileeditor;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.JDLogger;
import jd.event.JDBroadcaster;
import jd.event.JDEvent;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.nutils.Formatter;
import jd.nutils.JDHash;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.optional.langfileeditor.LngEntry;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrcParser {
    private File root;
    private JDBroadcaster<MessageListener, MessageEvent> broadcaster;
    private ArrayList<LngEntry> entries;
    private File currentFile;
    private String currentContent;
    private ArrayList<String> pattern = new ArrayList();

    public static void deleteCache() {
        File dir = JDUtilities.getResourceFile((String)"tmp/lfe/cache/");
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    public SrcParser(File resourceFile) {
        this.root = resourceFile;
        this.entries = new ArrayList();
        this.broadcaster = new JDBroadcaster<MessageListener, MessageEvent>(){

            protected void fireEvent(MessageListener listener, MessageEvent event) {
                listener.onMessage(event);
            }
        };
        this.pattern.add("jd\\.gui\\.swing\\.ShortCuts\\.(.+?)");
        this.pattern.add("sys\\.warning\\.dlcerror\\.(.+?)");
        this.pattern.add("!(.+?)");
    }

    public JDBroadcaster<MessageListener, MessageEvent> getBroadcaster() {
        return this.broadcaster;
    }

    public ArrayList<LngEntry> getEntries() {
        return this.entries;
    }

    public ArrayList<String> getPattern() {
        return this.pattern;
    }

    public void parse() {
        for (File f : this.getSourceFiles(this.root)) {
            this.parseFile(f);
        }
    }

    private void print(String s) {
        System.out.println(s);
    }

    private void parseFile(File file) {
        String[] matches;
        this.currentFile = file;
        this.broadcaster.fireEvent((JDEvent)new MessageEvent((Object)this, 0, JDL.LF((String)"jd.plugins.optional.langfileeditor.SrcParser.parse", (String)"Parse %s", (Object[])new Object[]{file.getAbsolutePath()})));
        this.currentContent = JDIO.readFileToString((File)file);
        File cacheEntries = JDUtilities.getResourceFile((String)("tmp/lfe/cache/" + JDHash.getMD5((String)this.currentContent) + ".entries"));
        File cachePattern = JDUtilities.getResourceFile((String)("tmp/lfe/cache/" + JDHash.getMD5((String)this.currentContent) + ".pattern"));
        ArrayList<LngEntry> fileEntries = new ArrayList<LngEntry>();
        ArrayList<String> filePattern = new ArrayList<String>();
        if (cacheEntries.exists() && cachePattern.exists()) {
            try {
                fileEntries = (ArrayList<LngEntry>)JDIO.loadObject(null, (File)cacheEntries, (boolean)false);
                filePattern = (ArrayList<String>)JDIO.loadObject(null, (File)cachePattern, (boolean)false);
                for (LngEntry entry : fileEntries) {
                    if (this.entries.contains(entry)) continue;
                    this.print(" CACHE: " + entry);
                    this.entries.add(entry);
                }
                for (String patt : filePattern) {
                    if (this.pattern.contains(patt)) continue;
                    this.print(" CACHE: " + patt);
                    this.pattern.add(patt);
                }
                return;
            }
            catch (Exception e) {
                cacheEntries.delete();
                cachePattern.delete();
                fileEntries = new ArrayList<LngEntry>();
                filePattern = new ArrayList<String>();
            }
        }
        this.prepareContent();
        this.currentContent = Pattern.compile("\\/\\*(.*?)\\*\\/", 32).matcher(this.currentContent).replaceAll("[[/*.....*/]]");
        this.currentContent = Pattern.compile("[^:]//(.*?)[\n|\r]", 32).matcher(this.currentContent).replaceAll("[[\\.....]]");
        this.currentContent = Pattern.compile("JDL\\s*?\\.\\s*?L", 32).matcher(this.currentContent).replaceAll("JDL.L");
        String[] stringArray = matches = new Regex(this.currentContent, "([^;^{^}]*JDL\\.LF?\\s*?\\(.*?\\)[^;^{^}]*)").getColumn(0);
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            String match = stringArray[n2];
            this.parseCodeLine(match, fileEntries, filePattern);
            ++n2;
        }
        try {
            JDIO.saveObject(null, fileEntries, (File)cacheEntries, null, null, (boolean)false);
            JDIO.saveObject(null, filePattern, (File)cachePattern, null, null, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheEntries.delete();
            cachePattern.delete();
        }
    }

    private void prepareContent() {
        String menukey;
        String cl = this.currentFile.getAbsolutePath();
        cl = cl.replace("\\", "/");
        cl = cl.substring(cl.indexOf("/jd/") + 1).replace('/', '.');
        cl = cl.replace(".java", "");
        this.currentContent = this.currentContent.replace("this.getClass().getName()", "\"" + cl + "\"");
        this.currentContent = this.currentContent.replace("getClass().getName()", "\"" + cl + "\"");
        String simple = cl.substring(cl.lastIndexOf(".") + 1);
        this.currentContent = this.currentContent.replace("this.getClass().getSimpleName()", "\"" + simple + "\"");
        this.currentContent = this.currentContent.replace("getClass().getSimpleName()", "\"" + simple + "\"");
        this.currentContent = this.currentContent.replace("\"+\"", "");
        if (this.currentContent.contains("jd.gui.swing.jdgui.menu.actions;") && (menukey = new Regex(this.currentContent, "super\\(\"(.*?)\",\\s*\".*?\"\\);").getMatch(0)) != null) {
            this.currentContent = this.currentContent.replaceFirst("super\\(\"(.*?)\",\\s*\".*?\"\\);", "[[...]]");
            this.currentContent = String.valueOf(this.currentContent) + "\r\nJDL.L(\"gui.menu." + menukey + ".name\",\"" + menukey + "\");";
            this.currentContent = String.valueOf(this.currentContent) + "\r\nJDL.L(\"gui.menu." + menukey + ".mnem\",\"-\");";
            this.currentContent = String.valueOf(this.currentContent) + "\r\nJDL.L(\"gui.menu." + menukey + ".accel\",\"-\");";
            this.currentContent = String.valueOf(this.currentContent) + "\r\nJDL.L(\"gui.menu." + menukey + ".tooltip\",\"gui.menu." + menukey + ".tooltip\");";
        }
        if (this.currentContent.contains("jd.gui.swing.jdgui.menu;")) {
            menukey = new Regex(this.currentContent, "super\\(\"(.*?)\",\\s*\".*?\"\\);").getMatch(0);
            this.currentContent = this.currentContent.replaceFirst("super\\(\"(.*?)\",\\s*\".*?\"\\);", "[[...]]");
            this.currentContent = String.valueOf(this.currentContent) + "\r\nJDL.L(\"" + menukey + "\",\"" + menukey + "\");";
        }
        if (this.currentContent.contains(" ThreadedAction") || this.currentContent.contains(" ToolBarAction") || this.currentContent.contains(" MenuAction")) {
            String[] keys;
            String[] stringArray = keys = new Regex(this.currentContent, " (Threaded|ToolBar|Menu)Action\\s*\\(\"(.*?)\"").getColumn(1);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                this.currentContent = String.valueOf(this.currentContent) + "\r\nJDL.L(\"gui.menu." + k + ".name\",\"gui.menu." + k + ".name\");";
                this.currentContent = String.valueOf(this.currentContent) + "\r\nJDL.L(\"gui.menu." + k + ".mnem\",\"-\");";
                this.currentContent = String.valueOf(this.currentContent) + "\r\nJDL.L(\"gui.menu." + k + ".accel\",\"-\");";
                this.currentContent = String.valueOf(this.currentContent) + "\r\nJDL.L(\"gui.menu." + k + ".tooltip\",\"gui.menu." + k + ".tooltip\");";
                ++n2;
            }
        }
        if (this.currentContent.contains("extends PluginOptional")) {
            this.currentContent = String.valueOf(this.currentContent) + "\r\nJDL.L(\"" + cl + "\",\"" + simple + "\");";
        }
    }

    private ArrayList<File> getSourceFiles(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        if (dir != null) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    files.addAll(this.getSourceFiles(file));
                } else if (file.getName().toLowerCase().endsWith(".java")) {
                    files.add(file);
                }
                ++n2;
            }
        }
        return files;
    }

    /*
     * Unable to fully structure code
     */
    private void parseCodeLine(String match, ArrayList<LngEntry> fileEntries, ArrayList<String> filePattern) {
        calls = match.split("JDL\\.");
        pat_string = "\"(.*?)(?<!\\\\)\"";
        var11_6 = calls;
        var10_7 = calls.length;
        var9_8 = 0;
        block18: while (var9_8 < var10_7) {
            block54: {
                block59: {
                    block58: {
                        block55: {
                            block57: {
                                block56: {
                                    block53: {
                                        m = orgm = var11_6[var9_8];
                                        if (!(m = m.trim()).startsWith("L")) break block54;
                                        strings = new Regex(m, pat_string).getColumn(0);
                                        m = m.replace("\r", "");
                                        m = m.replace("\n", "");
                                        m = m.replaceAll(pat_string, "%%%S%%%");
                                        orgm = m = m.replace(" ", "");
                                        try {
                                            com1 = m.indexOf(",");
                                            end = m.indexOf(")", com1 + 1);
                                            com2 = m.indexOf(",", com1 + 1);
                                            if (com2 > 0 && com2 < end) {
                                                end = com2;
                                            }
                                            if (end < 0) {
                                                m = m.substring(m.indexOf("(") + 1).trim();
                                                break block53;
                                            }
                                            m = m.substring(m.indexOf("(") + 1, end).trim();
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    while (m.charAt(m.length() - 1) == ',') {
                                        m = m.substring(0, m.length() - 1);
                                    }
                                    if (m == null || m.length() == 0) break block54;
                                    m = m.replace("%%%+%%%", "%%%%%%");
                                    parameter = m.split(",");
                                    if (!orgm.startsWith("LF ") && !orgm.startsWith("LF(")) break block55;
                                    if (orgm.substring(2).trim().charAt(0) == '(') break block56;
                                    JDLogger.getLogger().severe("Malformated translation value in " + this.currentFile + " : " + m);
                                    break block54;
                                }
                                if (parameter.length == 2) break block57;
                                JDLogger.getLogger().severe("Malformated translation pair (inner functions?) in " + this.currentFile + " : " + match);
                                break block54;
                            }
                            i = 0;
                            if (!parameter[1].contains("+")) ** GOTO lbl85
                            JDLogger.getLogger().severe("Malformated translation value in " + this.currentFile + " : " + match);
                            break block54;
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    var19_35 = matches = new Regex(parameter[0], "(\\+(\\w+)\\+?)").getMatches();
                                    var18_34 = matches.length;
                                    var17_33 = 0;
                                    while (var17_33 < var18_34) {
                                        mm = var19_35[var17_33];
                                        try {
                                            value = this.getValueOf(mm[1]);
                                            parameter[0] = parameter[0].replace(mm[0], value);
                                        }
                                        catch (Exception e) {
                                            JDLogger.getLogger().severe("Malformated translation key in " + this.currentFile + " : " + match);
                                            break block18;
                                        }
                                        ++var17_33;
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    break;
                                }
                                try {
                                    var19_35 = matches = new Regex(parameter[0], "(\\+?(\\w+)\\+)").getMatches();
                                    var18_34 = matches.length;
                                    var17_33 = 0;
                                    while (var17_33 < var18_34) {
                                        mm = var19_35[var17_33];
                                        try {
                                            value = this.getValueOf(mm[1]);
                                            parameter[0] = parameter[0].replace(mm[0], value);
                                        }
                                        catch (Exception e) {
                                            JDLogger.getLogger().severe("Malformated translation key in 2" + this.currentFile + " : " + match);
                                            break block18;
                                        }
                                        ++var17_33;
                                    }
                                    continue;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    break;
                                }
lbl85:
                                // 2 sources

                                ** while (parameter[0].contains((CharSequence)"+"))
                            }
lbl86:
                            // 3 sources

                            x = 0;
                            ** GOTO lbl92
                            {
                                parameter[x] = parameter[x].replaceFirst("%%%S%%%", Matcher.quoteReplacement(strings[i++]));
                                do {
                                    if (parameter[x].contains("%%%S%%%")) continue block23;
                                    ++x;
lbl92:
                                    // 2 sources

                                } while (x < parameter.length);
                            }
                            error = new Regex(parameter[0], "([\\(\\)\\{\\}\\/\\\\\\$\\&\\+\\~\\#\\\"\\!\\?]+)").getMatch(0);
                            if (error != null) {
                                index = parameter[0].indexOf(error);
                                if (index >= 0) {
                                    JDLogger.getLogger().warning("Unsupported chars (" + parameter[0].substring(0, index) + "<< |" + parameter[0].substring(index + 1) + ") in key:" + this.currentFile + " : " + parameter[0]);
                                } else {
                                    JDLogger.getLogger().warning("Unsupported chars in key: " + this.currentFile + " : " + parameter[0]);
                                }
                            } else {
                                if (!parameter[0].contains(".")) {
                                    JDLogger.getLogger().warning("Prob. Malformated translation key in " + this.currentFile + " : " + match);
                                }
                                if (parameter[0].contains("null")) {
                                    JDLogger.getLogger().warning("Prob. Malformated translation key in " + this.currentFile + " : " + match);
                                }
                                if (!this.entries.contains(entry = new LngEntry(parameter[0], parameter[1]))) {
                                    this.entries.add(entry);
                                    this.print("LF  " + Formatter.fillInteger((long)this.entries.size(), (int)3, (String)"0") + " " + entry);
                                }
                                if (!fileEntries.contains(entry)) {
                                    fileEntries.add(entry);
                                }
                            }
                            break block54;
                        }
                        if (!orgm.startsWith("L ") && !orgm.startsWith("L(")) break block54;
                        if (orgm.substring(1).trim().charAt(0) == '(') break block58;
                        JDLogger.getLogger().severe("Malformated translation value in " + this.currentFile + " : " + m);
                        break block54;
                    }
                    if (parameter.length == 2) break block59;
                    JDLogger.getLogger().severe("Malformated translation pair (inner functions?) in " + this.currentFile + " : " + match);
                    break block54;
                }
                i = 0;
                if (!parameter[1].contains("+")) ** GOTO lbl165
                JDLogger.getLogger().severe("Malformated translation value in " + this.currentFile + " : " + match);
                break block54;
lbl-1000:
                // 1 sources

                {
                    try {
                        var19_35 = matches = new Regex(parameter[0], "(\\+([^%]+)\\+?)").getMatches();
                        var18_34 = matches.length;
                        var17_33 = 0;
                        while (var17_33 < var18_34) {
                            mm = var19_35[var17_33];
                            try {
                                value = this.getValueOf(mm[1]);
                                this.print(String.valueOf(mm[0]) + " - " + mm[1]);
                                parameter[0] = parameter[0].replace(mm[0], value);
                            }
                            catch (Exception e) {
                                parameter[0] = parameter[0].replace(mm[0], "*");
                            }
                            ++var17_33;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                    try {
                        var19_35 = matches = new Regex(parameter[0], "(\\+?([^%]+)\\+)").getMatches();
                        var18_34 = matches.length;
                        var17_33 = 0;
                        while (var17_33 < var18_34) {
                            mm = var19_35[var17_33];
                            try {
                                value = this.getValueOf(mm[1]);
                                parameter[0] = parameter[0].replace(mm[0], value);
                            }
                            catch (Exception e) {
                                JDLogger.getLogger().severe("Malformated translation key in 1" + this.currentFile + " : " + match);
                                break block18;
                            }
                            ++var17_33;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
lbl165:
                    // 2 sources

                    ** while (parameter[0].contains((CharSequence)"+"))
                }
lbl166:
                // 3 sources

                x = 0;
                ** GOTO lbl172
                {
                    parameter[x] = parameter[x].replaceFirst("%%%S%%%", Matcher.quoteReplacement(strings[i++]));
                    do {
                        if (parameter[x].contains("%%%S%%%")) continue block28;
                        ++x;
lbl172:
                        // 2 sources

                    } while (x < parameter.length);
                }
                error = new Regex(parameter[0], "([\\(\\)\\{\\}\\/\\\\\\$\\&\\+\\~\\#\\\"\\!\\?]+)").getMatch(0);
                if (error != null) {
                    index = parameter[0].indexOf(error);
                    if (index >= 0) {
                        JDLogger.getLogger().warning("Unsupported chars (" + parameter[0].substring(0, index) + "<< |" + parameter[0].substring(index + 1) + ") in key:" + this.currentFile + " : " + parameter[0]);
                    } else {
                        JDLogger.getLogger().warning("Unsupported chars in key: " + this.currentFile + " : " + parameter[0]);
                    }
                } else {
                    if (!parameter[0].contains(".")) {
                        JDLogger.getLogger().warning("Prob. Malformated translation key in " + this.currentFile + " : " + match);
                        break;
                    }
                    if (parameter[0].contains("null")) {
                        JDLogger.getLogger().warning("Prob. Malformated translation key in " + this.currentFile + " : " + match);
                        break;
                    }
                    if (parameter[0].contains("*")) {
                        if (!this.currentFile.getName().contains("ToolBarAction")) {
                            patt = parameter[0].replace(".", "\\.").replace("*", "(.+?)");
                            JDLogger.getLogger().severe("Pattern match in " + this.currentFile + " : " + match);
                            if (!this.pattern.contains(patt)) {
                                this.pattern.add(patt);
                            }
                            if (!filePattern.contains(patt)) {
                                filePattern.add(patt);
                            }
                        }
                    } else {
                        entry = new LngEntry(parameter[0], parameter[1]);
                        if (!this.entries.contains(entry)) {
                            this.entries.add(entry);
                            this.print("L   " + Formatter.fillInteger((long)this.entries.size(), (int)3, (String)"0") + " " + entry);
                        }
                        if (!fileEntries.contains(entry)) {
                            fileEntries.add(entry);
                        }
                    }
                }
            }
            ++var9_8;
        }
    }

    private String getValueOf(String variable) {
        String[] matches = new Regex(this.currentContent, String.valueOf(variable) + "\\s*=(.*?);").getColumn(0);
        String ret = matches[matches.length - 1].trim();
        while (ret.startsWith("\"")) {
            ret = ret.substring(1);
        }
        while (ret.endsWith("\"")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }
}

