/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.batik;

import de.javasoft.plaf.synthetica.batik.LinearGradientPaint;
import de.javasoft.plaf.synthetica.batik.MultipleGradientPaint;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;

abstract class MultipleGradientPaintContext
implements PaintContext {
    protected static final boolean DEBUG = false;
    protected ColorModel dataModel;
    protected ColorModel model;
    private static ColorModel lrgbmodel_NA = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private static ColorModel srgbmodel_NA = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private static ColorModel lrgbmodel_A = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    private static ColorModel srgbmodel_A = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    protected static ColorModel cachedModel;
    protected static WeakReference<?> cached;
    protected WritableRaster saved;
    protected MultipleGradientPaint.CycleMethodEnum cycleMethod;
    protected MultipleGradientPaint.ColorSpaceEnum colorSpace;
    protected float a00;
    protected float a01;
    protected float a10;
    protected float a11;
    protected float a02;
    protected float a12;
    protected boolean isSimpleLookup = true;
    protected boolean hasDiscontinuity = false;
    protected int fastGradientArraySize;
    protected int[] gradient;
    protected int[][] gradients;
    protected int gradientAverage;
    protected int gradientUnderflow;
    protected int gradientOverflow;
    protected int gradientsLength;
    protected float[] normalizedIntervals;
    protected float[] fractions;
    private int transparencyTest;
    private static final int[] SRGBtoLinearRGB;
    private static final int[] LinearRGBtoSRGB;
    protected static final int GRADIENT_SIZE = 256;
    protected static final int GRADIENT_SIZE_INDEX = 255;
    private static final int MAX_GRADIENT_ARRAY_SIZE = 5000;

    static {
        SRGBtoLinearRGB = new int[256];
        LinearRGBtoSRGB = new int[256];
        int n = 0;
        while (n < 256) {
            MultipleGradientPaintContext.SRGBtoLinearRGB[n] = MultipleGradientPaintContext.convertSRGBtoLinearRGB(n);
            MultipleGradientPaintContext.LinearRGBtoSRGB[n] = MultipleGradientPaintContext.convertLinearRGBtoSRGB(n);
            ++n;
        }
    }

    protected MultipleGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) throws NoninvertibleTransformException {
        boolean bl = false;
        boolean bl2 = false;
        int n = fArray.length;
        if (fArray[0] != 0.0f) {
            bl = true;
            ++n;
        }
        if (fArray[fArray.length - 1] != 1.0f) {
            bl2 = true;
            ++n;
        }
        int n2 = 0;
        while (n2 < fArray.length - 1) {
            if (fArray[n2] == fArray[n2 + 1]) {
                --n;
            }
            ++n2;
        }
        this.fractions = new float[n];
        Color[] colorArray2 = new Color[n - 1];
        Color[] colorArray3 = new Color[n - 1];
        this.normalizedIntervals = new float[n - 1];
        this.gradientUnderflow = colorArray[0].getRGB();
        this.gradientOverflow = colorArray[colorArray.length - 1].getRGB();
        int n3 = 0;
        if (bl) {
            this.fractions[0] = 0.0f;
            colorArray2[0] = colorArray[0];
            colorArray3[0] = colorArray[0];
            this.normalizedIntervals[0] = fArray[0];
            ++n3;
        }
        int n4 = 0;
        while (n4 < fArray.length - 1) {
            if (fArray[n4] == fArray[n4 + 1]) {
                if (!colorArray[n4].equals(colorArray[n4 + 1])) {
                    this.hasDiscontinuity = true;
                }
            } else {
                this.fractions[n3] = fArray[n4];
                colorArray2[n3] = colorArray[n4];
                colorArray3[n3] = colorArray[n4 + 1];
                this.normalizedIntervals[n3] = fArray[n4 + 1] - fArray[n4];
                ++n3;
            }
            ++n4;
        }
        this.fractions[n3] = fArray[fArray.length - 1];
        if (bl2) {
            colorArray2[n3] = colorArray3[n3] = colorArray[colorArray.length - 1];
            this.normalizedIntervals[n3] = 1.0f - fArray[fArray.length - 1];
            this.fractions[++n3] = 1.0f;
        }
        AffineTransform affineTransform2 = affineTransform.createInverse();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        this.a00 = (float)dArray[0];
        this.a10 = (float)dArray[1];
        this.a01 = (float)dArray[2];
        this.a11 = (float)dArray[3];
        this.a02 = (float)dArray[4];
        this.a12 = (float)dArray[5];
        this.cycleMethod = cycleMethodEnum;
        this.colorSpace = colorSpaceEnum;
        if (colorModel.getColorSpace() == lrgbmodel_A.getColorSpace()) {
            this.dataModel = lrgbmodel_A;
        } else if (colorModel.getColorSpace() == srgbmodel_A.getColorSpace()) {
            this.dataModel = srgbmodel_A;
        } else {
            throw new IllegalArgumentException("Unsupported ColorSpace for interpolation");
        }
        this.calculateGradientFractions(colorArray2, colorArray3);
        this.model = GraphicsUtil.coerceColorModel(this.dataModel, colorModel.isAlphaPremultiplied());
    }

    protected final void calculateGradientFractions(Color[] colorArray, Color[] colorArray2) {
        if (this.colorSpace == LinearGradientPaint.LINEAR_RGB) {
            int[] nArray = SRGBtoLinearRGB;
            int n = 0;
            while (n < colorArray.length) {
                colorArray[n] = MultipleGradientPaintContext.interpolateColor(nArray, colorArray[n]);
                colorArray2[n] = MultipleGradientPaintContext.interpolateColor(nArray, colorArray2[n]);
                ++n;
            }
        }
        this.transparencyTest = -16777216;
        if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            this.transparencyTest &= this.gradientUnderflow;
            this.transparencyTest &= this.gradientOverflow;
        }
        this.gradients = new int[this.fractions.length - 1][];
        this.gradientsLength = this.gradients.length;
        int n = this.normalizedIntervals.length;
        float f = 1.0f;
        float[] fArray = this.normalizedIntervals;
        int n2 = 0;
        while (n2 < n) {
            f = f > fArray[n2] ? fArray[n2] : f;
            ++n2;
        }
        n2 = 0;
        if (f == 0.0f) {
            n2 = Integer.MAX_VALUE;
            this.hasDiscontinuity = true;
        } else {
            int n3 = 0;
            while (n3 < fArray.length) {
                n2 = (int)((float)n2 + fArray[n3] / f * 256.0f);
                ++n3;
            }
        }
        if (n2 > 5000) {
            this.calculateMultipleArrayGradient(colorArray, colorArray2);
            if (this.cycleMethod == MultipleGradientPaint.REPEAT && this.gradients[0][0] != this.gradients[this.gradients.length - 1][255]) {
                this.hasDiscontinuity = true;
            }
        } else {
            this.calculateSingleArrayGradient(colorArray, colorArray2, f);
            if (this.cycleMethod == MultipleGradientPaint.REPEAT && this.gradient[0] != this.gradient[this.fastGradientArraySize]) {
                this.hasDiscontinuity = true;
            }
        }
        if (this.transparencyTest >>> 24 == 255) {
            if (this.dataModel.getColorSpace() == lrgbmodel_NA.getColorSpace()) {
                this.dataModel = lrgbmodel_NA;
            } else if (this.dataModel.getColorSpace() == srgbmodel_NA.getColorSpace()) {
                this.dataModel = srgbmodel_NA;
            }
            this.model = this.dataModel;
        }
    }

    private static Color interpolateColor(int[] nArray, Color color) {
        int n = color.getRGB();
        int n2 = (nArray[n >> 24 & 0xFF] & 0xFF) << 24 | (nArray[n >> 16 & 0xFF] & 0xFF) << 16 | (nArray[n >> 8 & 0xFF] & 0xFF) << 8 | nArray[n & 0xFF] & 0xFF;
        return new Color(n2, true);
    }

    private void calculateSingleArrayGradient(Color[] colorArray, Color[] colorArray2, float f) {
        int n;
        this.isSimpleLookup = true;
        int n2 = 1;
        int n3 = 32768;
        int n4 = 32768;
        int n5 = 32768;
        int n6 = 32768;
        int n7 = 0;
        while (n7 < this.gradients.length) {
            n = (int)(this.normalizedIntervals[n7] / f * 255.0f);
            n2 += n;
            this.gradients[n7] = new int[n];
            int n8 = colorArray[n7].getRGB();
            int n9 = colorArray2[n7].getRGB();
            this.interpolate(n8, n9, this.gradients[n7]);
            int n10 = this.gradients[n7][128];
            float f2 = this.normalizedIntervals[n7];
            n3 += (int)((float)(n10 >> 8 & 0xFF0000) * f2);
            n4 += (int)((float)(n10 & 0xFF0000) * f2);
            n5 += (int)((float)(n10 << 8 & 0xFF0000) * f2);
            n6 += (int)((float)(n10 << 16 & 0xFF0000) * f2);
            this.transparencyTest &= n8 & n9;
            ++n7;
        }
        this.gradientAverage = (n3 & 0xFF0000) << 8 | n4 & 0xFF0000 | (n5 & 0xFF0000) >> 8 | (n6 & 0xFF0000) >> 16;
        this.gradient = new int[n2];
        n7 = 0;
        n = 0;
        while (n < this.gradients.length) {
            System.arraycopy(this.gradients[n], 0, this.gradient, n7, this.gradients[n].length);
            n7 += this.gradients[n].length;
            ++n;
        }
        this.gradient[this.gradient.length - 1] = colorArray2[colorArray2.length - 1].getRGB();
        if (this.colorSpace == LinearGradientPaint.LINEAR_RGB) {
            if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1000)) {
                n = 0;
                while (n < this.gradient.length) {
                    this.gradient[n] = MultipleGradientPaintContext.convertEntireColorLinearRGBtoSRGB(this.gradient[n]);
                    ++n;
                }
                this.gradientAverage = MultipleGradientPaintContext.convertEntireColorLinearRGBtoSRGB(this.gradientAverage);
            }
        } else if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1004)) {
            n = 0;
            while (n < this.gradient.length) {
                this.gradient[n] = MultipleGradientPaintContext.convertEntireColorSRGBtoLinearRGB(this.gradient[n]);
                ++n;
            }
            this.gradientAverage = MultipleGradientPaintContext.convertEntireColorSRGBtoLinearRGB(this.gradientAverage);
        }
        this.fastGradientArraySize = this.gradient.length - 1;
    }

    private void calculateMultipleArrayGradient(Color[] colorArray, Color[] colorArray2) {
        int n;
        this.isSimpleLookup = false;
        int n2 = 32768;
        int n3 = 32768;
        int n4 = 32768;
        int n5 = 32768;
        int n6 = 0;
        while (n6 < this.gradients.length) {
            if (this.normalizedIntervals[n6] != 0.0f) {
                this.gradients[n6] = new int[256];
                int n7 = colorArray[n6].getRGB();
                int n8 = colorArray2[n6].getRGB();
                this.interpolate(n7, n8, this.gradients[n6]);
                n = this.gradients[n6][128];
                float f = this.normalizedIntervals[n6];
                n2 += (int)((float)(n >> 8 & 0xFF0000) * f);
                n3 += (int)((float)(n & 0xFF0000) * f);
                n4 += (int)((float)(n << 8 & 0xFF0000) * f);
                n5 += (int)((float)(n << 16 & 0xFF0000) * f);
                this.transparencyTest &= n7;
                this.transparencyTest &= n8;
            }
            ++n6;
        }
        this.gradientAverage = (n2 & 0xFF0000) << 8 | n3 & 0xFF0000 | (n4 & 0xFF0000) >> 8 | (n5 & 0xFF0000) >> 16;
        if (this.colorSpace == LinearGradientPaint.LINEAR_RGB) {
            if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1000)) {
                n6 = 0;
                while (n6 < this.gradients.length) {
                    n = 0;
                    while (n < this.gradients[n6].length) {
                        this.gradients[n6][n] = MultipleGradientPaintContext.convertEntireColorLinearRGBtoSRGB(this.gradients[n6][n]);
                        ++n;
                    }
                    ++n6;
                }
                this.gradientAverage = MultipleGradientPaintContext.convertEntireColorLinearRGBtoSRGB(this.gradientAverage);
            }
        } else if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1004)) {
            n6 = 0;
            while (n6 < this.gradients.length) {
                n = 0;
                while (n < this.gradients[n6].length) {
                    this.gradients[n6][n] = MultipleGradientPaintContext.convertEntireColorSRGBtoLinearRGB(this.gradients[n6][n]);
                    ++n;
                }
                ++n6;
            }
            this.gradientAverage = MultipleGradientPaintContext.convertEntireColorSRGBtoLinearRGB(this.gradientAverage);
        }
    }

    private void interpolate(int n, int n2, int[] nArray) {
        int n3 = nArray.length;
        float f = 1.0f / (float)n3;
        int n4 = n >> 24 & 0xFF;
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = n & 0xFF;
        int n8 = (n2 >> 24 & 0xFF) - n4;
        int n9 = (n2 >> 16 & 0xFF) - n5;
        int n10 = (n2 >> 8 & 0xFF) - n6;
        int n11 = (n2 & 0xFF) - n7;
        float f2 = 2.0f * (float)n8 * f;
        float f3 = 2.0f * (float)n9 * f;
        float f4 = 2.0f * (float)n10 * f;
        float f5 = 2.0f * (float)n11 * f;
        nArray[0] = n;
        nArray[--n3] = n2;
        int n12 = 1;
        while (n12 < n3) {
            float f6 = n12;
            nArray[n12] = (n4 + ((int)(f6 * f2) + 1 >> 1) & 0xFF) << 24 | (n5 + ((int)(f6 * f3) + 1 >> 1) & 0xFF) << 16 | (n6 + ((int)(f6 * f4) + 1 >> 1) & 0xFF) << 8 | n7 + ((int)(f6 * f5) + 1 >> 1) & 0xFF;
            ++n12;
        }
    }

    private static int convertEntireColorLinearRGBtoSRGB(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int[] nArray = LinearRGBtoSRGB;
        n3 = nArray[n3];
        n4 = nArray[n4];
        n5 = nArray[n5];
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    private static int convertEntireColorSRGBtoLinearRGB(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int[] nArray = SRGBtoLinearRGB;
        n3 = nArray[n3];
        n4 = nArray[n4];
        n5 = nArray[n5];
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    protected final int indexIntoGradientsArrays(float f) {
        int n;
        if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            if (f >= 1.0f) {
                return this.gradientOverflow;
            }
            if (f <= 0.0f) {
                return this.gradientUnderflow;
            }
        } else {
            if (this.cycleMethod == MultipleGradientPaint.REPEAT) {
                if ((f -= (float)((int)f)) < 0.0f) {
                    f += 1.0f;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (this.isSimpleLookup) {
                    int n5 = (int)(f *= (float)this.gradient.length);
                    if (n5 + 1 < this.gradient.length) {
                        return this.gradient[n5];
                    }
                    n2 = (int)((f - (float)n5) * 65536.0f);
                    n3 = this.gradient[n5];
                    n4 = this.gradient[0];
                } else {
                    int n6 = 0;
                    while (n6 < this.gradientsLength) {
                        if (f < this.fractions[n6 + 1]) {
                            float f2 = f - this.fractions[n6];
                            int n7 = (int)(f2 = f2 / this.normalizedIntervals[n6] * 256.0f);
                            if (n7 + 1 < this.gradients[n6].length || n6 + 1 < this.gradientsLength) {
                                return this.gradients[n6][n7];
                            }
                            n2 = (int)((f2 - (float)n7) * 65536.0f);
                            n3 = this.gradients[n6][n7];
                            n4 = this.gradients[0][0];
                            break;
                        }
                        ++n6;
                    }
                }
                return ((n3 >> 8 & 0xFF0000) + ((n4 >>> 24) - (n3 >>> 24)) * n2 & 0xFF0000) << 8 | (n3 & 0xFF0000) + ((n4 >> 16 & 0xFF) - (n3 >> 16 & 0xFF)) * n2 & 0xFF0000 | ((n3 << 8 & 0xFF0000) + ((n4 >> 8 & 0xFF) - (n3 >> 8 & 0xFF)) * n2 & 0xFF0000) >> 8 | ((n3 << 16 & 0xFF0000) + ((n4 & 0xFF) - (n3 & 0xFF)) * n2 & 0xFF0000) >> 16;
            }
            if (f < 0.0f) {
                f = -f;
            }
            n = (int)f;
            f -= (float)n;
            if ((n & 1) == 1) {
                f = 1.0f - f;
            }
        }
        if (this.isSimpleLookup) {
            return this.gradient[(int)(f * (float)this.fastGradientArraySize)];
        }
        n = 0;
        while (n < this.gradientsLength) {
            if (f < this.fractions[n + 1]) {
                float f3 = f - this.fractions[n];
                int n8 = (int)(f3 / this.normalizedIntervals[n] * 255.0f);
                return this.gradients[n][n8];
            }
            ++n;
        }
        return this.gradientOverflow;
    }

    protected final int indexGradientAntiAlias(float f, float f2) {
        if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            int n;
            int n2;
            float f3;
            float f4 = f - f2 / 2.0f;
            float f5 = f + f2 / 2.0f;
            if (f4 >= 1.0f) {
                return this.gradientOverflow;
            }
            if (f5 <= 0.0f) {
                return this.gradientUnderflow;
            }
            float f6 = 0.0f;
            float f7 = 0.0f;
            if (f5 >= 1.0f) {
                f6 = (f5 - 1.0f) / f2;
                if (f4 <= 0.0f) {
                    f7 = -f4 / f2;
                    f3 = 1.0f;
                    n2 = this.gradientAverage;
                } else {
                    f3 = 1.0f - f4;
                    n2 = this.getAntiAlias(f4, true, 1.0f, false, 1.0f - f4, 1.0f);
                }
            } else if (f4 <= 0.0f) {
                f7 = -f4 / f2;
                f3 = f5;
                n2 = this.getAntiAlias(0.0f, true, f5, false, f5, 1.0f);
            } else {
                return this.getAntiAlias(f4, true, f5, false, f2, 1.0f);
            }
            int n3 = (int)(65536.0f * f3 / f2);
            int n4 = (n2 >>> 20 & 0xFF0) * n3 >> 16;
            int n5 = (n2 >> 12 & 0xFF0) * n3 >> 16;
            int n6 = (n2 >> 4 & 0xFF0) * n3 >> 16;
            int n7 = (n2 << 4 & 0xFF0) * n3 >> 16;
            if (f7 != 0.0f) {
                n = this.gradientUnderflow;
                n3 = (int)(65536.0f * f7);
                n4 += (n >>> 20 & 0xFF0) * n3 >> 16;
                n5 += (n >> 12 & 0xFF0) * n3 >> 16;
                n6 += (n >> 4 & 0xFF0) * n3 >> 16;
                n7 += (n << 4 & 0xFF0) * n3 >> 16;
            }
            if (f6 != 0.0f) {
                n = this.gradientOverflow;
                n3 = (int)(65536.0f * f6);
                n4 += (n >>> 20 & 0xFF0) * n3 >> 16;
                n5 += (n >> 12 & 0xFF0) * n3 >> 16;
                n6 += (n >> 4 & 0xFF0) * n3 >> 16;
                n7 += (n << 4 & 0xFF0) * n3 >> 16;
            }
            return (n4 & 0xFF0) << 20 | (n5 & 0xFF0) << 12 | (n6 & 0xFF0) << 4 | (n7 & 0xFF0) >> 4;
        }
        int n = (int)f2;
        float f8 = 1.0f;
        if (n != 0 && (double)(f8 = (f2 -= (float)n) / ((float)n + f2)) < 0.1) {
            return this.gradientAverage;
        }
        if ((double)f2 > 0.99) {
            return this.gradientAverage;
        }
        float f9 = f - f2 / 2.0f;
        float f10 = f + f2 / 2.0f;
        boolean bl = true;
        boolean bl2 = false;
        if (this.cycleMethod == MultipleGradientPaint.REPEAT) {
            f9 -= (float)((int)f9);
            f10 -= (float)((int)f10);
            if (f9 < 0.0f) {
                f9 += 1.0f;
            }
            if (f10 < 0.0f) {
                f10 += 1.0f;
            }
        } else {
            if (f10 < 0.0f) {
                f9 = -f9;
                bl = !bl;
                f10 = -f10;
                bl2 = !bl2;
            } else if (f9 < 0.0f) {
                f9 = -f9;
                bl = !bl;
            }
            int n8 = (int)f9;
            f9 -= (float)n8;
            int n9 = (int)f10;
            f10 -= (float)n9;
            if ((n8 & 1) == 1) {
                f9 = 1.0f - f9;
                boolean bl3 = bl = !bl;
            }
            if ((n9 & 1) == 1) {
                f10 = 1.0f - f10;
                boolean bl4 = bl2 = !bl2;
            }
            if (f9 > f10 && !bl && bl2) {
                float f11 = f9;
                f9 = f10;
                f10 = f11;
                bl = true;
                bl2 = false;
            }
        }
        return this.getAntiAlias(f9, bl, f10, bl2, f2, f8);
    }

    private final int getAntiAlias(float f, boolean bl, float f2, boolean bl2, float f3, float f4) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.isSimpleLookup) {
            int n9;
            int n10;
            n4 = (int)(f *= (float)this.fastGradientArraySize);
            n3 = (int)(f2 *= (float)this.fastGradientArraySize);
            if (bl && !bl2 && n4 <= n3) {
                if (n4 == n3) {
                    return this.gradient[n4];
                }
                n2 = n4 + 1;
                while (n2 < n3) {
                    n = this.gradient[n2];
                    n5 += n >>> 20 & 0xFF0;
                    n6 += n >>> 12 & 0xFF0;
                    n7 += n >>> 4 & 0xFF0;
                    n8 += n << 4 & 0xFF0;
                    ++n2;
                }
            } else {
                if (bl) {
                    n10 = n4 + 1;
                    n9 = this.fastGradientArraySize;
                } else {
                    n10 = 0;
                    n9 = n4;
                }
                n2 = n10;
                while (n2 < n9) {
                    n = this.gradient[n2];
                    n5 += n >>> 20 & 0xFF0;
                    n6 += n >>> 12 & 0xFF0;
                    n7 += n >>> 4 & 0xFF0;
                    n8 += n << 4 & 0xFF0;
                    ++n2;
                }
                if (bl2) {
                    n10 = n3 + 1;
                    n9 = this.fastGradientArraySize;
                } else {
                    n10 = 0;
                    n9 = n3;
                }
                n2 = n10;
                while (n2 < n9) {
                    n = this.gradient[n2];
                    n5 += n >>> 20 & 0xFF0;
                    n6 += n >>> 12 & 0xFF0;
                    n7 += n >>> 4 & 0xFF0;
                    n8 += n << 4 & 0xFF0;
                    ++n2;
                }
            }
            n9 = (int)(65536.0f / (f3 * (float)this.fastGradientArraySize));
            n5 = n5 * n9 >> 16;
            n6 = n6 * n9 >> 16;
            n7 = n7 * n9 >> 16;
            n8 = n8 * n9 >> 16;
            n10 = bl ? (int)((1.0f - (f - (float)n4)) * (float)n9) : (int)((f - (float)n4) * (float)n9);
            n = this.gradient[n4];
            n5 += (n >>> 20 & 0xFF0) * n10 >> 16;
            n6 += (n >>> 12 & 0xFF0) * n10 >> 16;
            n7 += (n >>> 4 & 0xFF0) * n10 >> 16;
            n8 += (n << 4 & 0xFF0) * n10 >> 16;
            n10 = bl2 ? (int)((1.0f - (f2 - (float)n3)) * (float)n9) : (int)((f2 - (float)n3) * (float)n9);
            n = this.gradient[n3];
            n5 += (n >>> 20 & 0xFF0) * n10 >> 16;
            n6 += (n >>> 12 & 0xFF0) * n10 >> 16;
            n7 += (n >>> 4 & 0xFF0) * n10 >> 16;
            n8 += (n << 4 & 0xFF0) * n10 >> 16;
            n5 = n5 + 8 >> 4;
            n6 = n6 + 8 >> 4;
            n7 = n7 + 8 >> 4;
            n8 = n8 + 8 >> 4;
        } else {
            n4 = 0;
            n3 = 0;
            n2 = -1;
            n = -1;
            float f5 = 0.0f;
            float f6 = 0.0f;
            int n11 = 0;
            while (n11 < this.gradientsLength) {
                if (f < this.fractions[n11 + 1] && n2 == -1) {
                    n2 = n11;
                    f5 = f - this.fractions[n11];
                    f5 = f5 / this.normalizedIntervals[n11] * 255.0f;
                    n4 = (int)f5;
                    if (n != -1) break;
                }
                if (f2 < this.fractions[n11 + 1] && n == -1) {
                    n = n11;
                    f6 = f2 - this.fractions[n11];
                    f6 = f6 / this.normalizedIntervals[n11] * 255.0f;
                    n3 = (int)f6;
                    if (n2 != -1) break;
                }
                ++n11;
            }
            if (n2 == -1) {
                n2 = this.gradients.length - 1;
                n4 = 255;
                f5 = 255;
            }
            if (n == -1) {
                n = this.gradients.length - 1;
                n3 = 255;
                f6 = 255;
            }
            if (n2 == n && n4 <= n3 && bl && !bl2) {
                return this.gradients[n2][n4 + n3 + 1 >> 1];
            }
            int n12 = (int)(65536.0f / f3);
            if (n2 < n && bl && !bl2) {
                int n13 = (int)((float)n12 * this.normalizedIntervals[n2] * (255.0f - f5) / 255.0f);
                n11 = this.gradients[n2][n4 + 256 >> 1];
                n5 += (n11 >>> 20 & 0xFF0) * n13 >> 16;
                n6 += (n11 >>> 12 & 0xFF0) * n13 >> 16;
                n7 += (n11 >>> 4 & 0xFF0) * n13 >> 16;
                n8 += (n11 << 4 & 0xFF0) * n13 >> 16;
                int n14 = n2 + 1;
                while (n14 < n) {
                    n13 = (int)((float)n12 * this.normalizedIntervals[n14]);
                    n11 = this.gradients[n14][128];
                    n5 += (n11 >>> 20 & 0xFF0) * n13 >> 16;
                    n6 += (n11 >>> 12 & 0xFF0) * n13 >> 16;
                    n7 += (n11 >>> 4 & 0xFF0) * n13 >> 16;
                    n8 += (n11 << 4 & 0xFF0) * n13 >> 16;
                    ++n14;
                }
                n13 = (int)((float)n12 * this.normalizedIntervals[n] * f6 / 255.0f);
                n11 = this.gradients[n][n3 + 1 >> 1];
                n5 += (n11 >>> 20 & 0xFF0) * n13 >> 16;
                n6 += (n11 >>> 12 & 0xFF0) * n13 >> 16;
                n7 += (n11 >>> 4 & 0xFF0) * n13 >> 16;
                n8 += (n11 << 4 & 0xFF0) * n13 >> 16;
            } else {
                int n15;
                int n16;
                int n17;
                if (bl) {
                    n17 = (int)((float)n12 * this.normalizedIntervals[n2] * (255.0f - f5) / 255.0f);
                    n11 = this.gradients[n2][n4 + 256 >> 1];
                } else {
                    n17 = (int)((float)n12 * this.normalizedIntervals[n2] * f5 / 255.0f);
                    n11 = this.gradients[n2][n4 + 1 >> 1];
                }
                n5 += (n11 >>> 20 & 0xFF0) * n17 >> 16;
                n6 += (n11 >>> 12 & 0xFF0) * n17 >> 16;
                n7 += (n11 >>> 4 & 0xFF0) * n17 >> 16;
                n8 += (n11 << 4 & 0xFF0) * n17 >> 16;
                if (bl2) {
                    n17 = (int)((float)n12 * this.normalizedIntervals[n] * (255.0f - f6) / 255.0f);
                    n11 = this.gradients[n][n3 + 256 >> 1];
                } else {
                    n17 = (int)((float)n12 * this.normalizedIntervals[n] * f6 / 255.0f);
                    n11 = this.gradients[n][n3 + 1 >> 1];
                }
                n5 += (n11 >>> 20 & 0xFF0) * n17 >> 16;
                n6 += (n11 >>> 12 & 0xFF0) * n17 >> 16;
                n7 += (n11 >>> 4 & 0xFF0) * n17 >> 16;
                n8 += (n11 << 4 & 0xFF0) * n17 >> 16;
                if (bl) {
                    n16 = n2 + 1;
                    n15 = this.gradientsLength;
                } else {
                    n16 = 0;
                    n15 = n2;
                }
                int n18 = n16;
                while (n18 < n15) {
                    n17 = (int)((float)n12 * this.normalizedIntervals[n18]);
                    n11 = this.gradients[n18][128];
                    n5 += (n11 >>> 20 & 0xFF0) * n17 >> 16;
                    n6 += (n11 >>> 12 & 0xFF0) * n17 >> 16;
                    n7 += (n11 >>> 4 & 0xFF0) * n17 >> 16;
                    n8 += (n11 << 4 & 0xFF0) * n17 >> 16;
                    ++n18;
                }
                if (bl2) {
                    n16 = n + 1;
                    n15 = this.gradientsLength;
                } else {
                    n16 = 0;
                    n15 = n;
                }
                n18 = n16;
                while (n18 < n15) {
                    n17 = (int)((float)n12 * this.normalizedIntervals[n18]);
                    n11 = this.gradients[n18][128];
                    n5 += (n11 >>> 20 & 0xFF0) * n17 >> 16;
                    n6 += (n11 >>> 12 & 0xFF0) * n17 >> 16;
                    n7 += (n11 >>> 4 & 0xFF0) * n17 >> 16;
                    n8 += (n11 << 4 & 0xFF0) * n17 >> 16;
                    ++n18;
                }
            }
            n5 = n5 + 8 >> 4;
            n6 = n6 + 8 >> 4;
            n7 = n7 + 8 >> 4;
            n8 = n8 + 8 >> 4;
        }
        if (f4 != 1.0f) {
            n4 = (int)(65536.0f * (1.0f - f4));
            n3 = (this.gradientAverage >>> 24 & 0xFF) * n4;
            n2 = (this.gradientAverage >> 16 & 0xFF) * n4;
            n = (this.gradientAverage >> 8 & 0xFF) * n4;
            int n19 = (this.gradientAverage & 0xFF) * n4;
            int n20 = (int)(f4 * 65536.0f);
            n5 = n5 * n20 + n3 >> 16;
            n6 = n6 * n20 + n2 >> 16;
            n7 = n7 * n20 + n >> 16;
            n8 = n8 * n20 + n19 >> 16;
        }
        return n5 << 24 | n6 << 16 | n7 << 8 | n8;
    }

    private static int convertSRGBtoLinearRGB(int n) {
        float f = (float)n / 255.0f;
        float f2 = f <= 0.04045f ? f / 12.92f : (float)Math.pow(((double)f + 0.055) / 1.055, 2.4);
        int n2 = Math.round(f2 * 255.0f);
        return n2;
    }

    private static int convertLinearRGBtoSRGB(int n) {
        float f = (float)n / 255.0f;
        float f2 = f <= 0.0031308f ? f * 12.92f : 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f;
        int n2 = Math.round(f2 * 255.0f);
        return n2;
    }

    public final Raster getRaster(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return null;
        }
        WritableRaster writableRaster = this.saved;
        if (writableRaster == null || writableRaster.getWidth() < n3 || writableRaster.getHeight() < n4) {
            this.saved = writableRaster = MultipleGradientPaintContext.getCachedRaster(this.dataModel, n3, n4);
            writableRaster = writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), n3, n4, 0, 0, null);
        }
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n5 = dataBufferInt.getOffset();
        int n6 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n7 = n6 - n3;
        this.fillRaster(nArray, n5, n7, n, n2, n3, n4);
        GraphicsUtil.coerceData(writableRaster, this.dataModel, this.model.isAlphaPremultiplied());
        return writableRaster;
    }

    protected abstract void fillRaster(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected static final synchronized WritableRaster getCachedRaster(ColorModel colorModel, int n, int n2) {
        WritableRaster writableRaster;
        if (colorModel == cachedModel && cached != null && (writableRaster = (WritableRaster)cached.get()) != null && writableRaster.getWidth() >= n && writableRaster.getHeight() >= n2) {
            cached = null;
            return writableRaster;
        }
        if (n < 32) {
            n = 32;
        }
        if (n2 < 32) {
            n2 = 32;
        }
        return colorModel.createCompatibleWritableRaster(n, n2);
    }

    protected static final synchronized void putCachedRaster(ColorModel colorModel, WritableRaster writableRaster) {
        WritableRaster writableRaster2;
        if (cached != null && (writableRaster2 = (WritableRaster)cached.get()) != null) {
            int n = writableRaster2.getWidth();
            int n2 = writableRaster2.getHeight();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getHeight();
            if (n >= n3 && n2 >= n4) {
                return;
            }
            if (n * n2 >= n3 * n4) {
                return;
            }
        }
        cachedModel = colorModel;
        cached = new WeakReference<WritableRaster>(writableRaster);
    }

    public final void dispose() {
        if (this.saved != null) {
            MultipleGradientPaintContext.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    public final ColorModel getColorModel() {
        return this.model;
    }

    static class GraphicsUtil {
        GraphicsUtil() {
        }

        public static ColorModel coerceColorModel(ColorModel colorModel, boolean bl) {
            if (colorModel.isAlphaPremultiplied() == bl) {
                return colorModel;
            }
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(1, 1);
            return colorModel.coerceData(writableRaster, bl);
        }

        public static ColorModel coerceData(WritableRaster writableRaster, ColorModel colorModel, boolean bl) {
            if (!colorModel.hasAlpha()) {
                return colorModel;
            }
            if (colorModel.isAlphaPremultiplied() == bl) {
                return colorModel;
            }
            if (bl) {
                GraphicsUtil.multiplyAlpha(writableRaster);
            } else {
                GraphicsUtil.divideAlpha(writableRaster);
            }
            return GraphicsUtil.coerceColorModel(colorModel, bl);
        }

        public static void multiplyAlpha(WritableRaster writableRaster) {
            if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
                GraphicsUtil.mult_BYTE_COMP_Data(writableRaster);
            } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
                GraphicsUtil.mult_INT_PACK_Data(writableRaster);
            } else {
                int[] nArray = null;
                int n = writableRaster.getNumBands();
                float f = 0.003921569f;
                int n2 = writableRaster.getMinX();
                int n3 = n2 + writableRaster.getWidth();
                int n4 = writableRaster.getMinY();
                int n5 = n4 + writableRaster.getHeight();
                int n6 = n4;
                while (n6 < n5) {
                    int n7 = n2;
                    while (n7 < n3) {
                        int n8 = (nArray = writableRaster.getPixel(n7, n6, nArray))[n - 1];
                        if (n8 >= 0 && n8 < 255) {
                            float f2 = (float)n8 * f;
                            int n9 = 0;
                            while (n9 < n - 1) {
                                nArray[n9] = (int)((float)nArray[n9] * f2 + 0.5f);
                                ++n9;
                            }
                            writableRaster.setPixel(n7, n6, nArray);
                        }
                        ++n7;
                    }
                    ++n6;
                }
            }
        }

        public static void divideAlpha(WritableRaster writableRaster) {
            if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
                GraphicsUtil.divide_BYTE_COMP_Data(writableRaster);
            } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
                GraphicsUtil.divide_INT_PACK_Data(writableRaster);
            } else {
                int n = writableRaster.getNumBands();
                int[] nArray = null;
                int n2 = writableRaster.getMinX();
                int n3 = n2 + writableRaster.getWidth();
                int n4 = writableRaster.getMinY();
                int n5 = n4 + writableRaster.getHeight();
                int n6 = n4;
                while (n6 < n5) {
                    int n7 = n2;
                    while (n7 < n3) {
                        int n8 = (nArray = writableRaster.getPixel(n7, n6, nArray))[n - 1];
                        if (n8 > 0 && n8 < 255) {
                            float f = 255.0f / (float)n8;
                            int n9 = 0;
                            while (n9 < n - 1) {
                                nArray[n9] = (int)((float)nArray[n9] * f + 0.5f);
                                ++n9;
                            }
                            writableRaster.setPixel(n7, n6, nArray);
                        }
                        ++n7;
                    }
                    ++n6;
                }
            }
        }

        public static boolean is_INT_PACK_Data(SampleModel sampleModel, boolean bl) {
            if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
                return false;
            }
            if (sampleModel.getDataType() != 3) {
                return false;
            }
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int[] nArray = singlePixelPackedSampleModel.getBitMasks();
            if (nArray.length == 3 ? bl : nArray.length != 4) {
                return false;
            }
            if (nArray[0] != 0xFF0000) {
                return false;
            }
            if (nArray[1] != 65280) {
                return false;
            }
            if (nArray[2] != 255) {
                return false;
            }
            return nArray.length != 4 || nArray[3] == -16777216;
        }

        public static boolean is_BYTE_COMP_Data(SampleModel sampleModel) {
            if (!(sampleModel instanceof ComponentSampleModel)) {
                return false;
            }
            return sampleModel.getDataType() == 0;
        }

        protected static void mult_BYTE_COMP_Data(WritableRaster writableRaster) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
            int n = writableRaster.getWidth();
            int n2 = componentSampleModel.getScanlineStride();
            int n3 = componentSampleModel.getPixelStride();
            int[] nArray = componentSampleModel.getBandOffsets();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            int n4 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
            int n5 = nArray[nArray.length - 1];
            int n6 = nArray.length - 1;
            byte[] byArray = dataBufferByte.getBankData()[0];
            int n7 = 0;
            while (n7 < writableRaster.getHeight()) {
                int n8 = n4 + n7 * n2;
                int n9 = n8 + n * n3;
                while (n8 < n9) {
                    int n10 = byArray[n8 + n5] & 0xFF;
                    if (n10 != 255) {
                        int n11 = 0;
                        while (n11 < n6) {
                            int n12 = n8 + nArray[n11];
                            byArray[n12] = (byte)((byArray[n12] & 0xFF) * n10 >> 8);
                            ++n11;
                        }
                    }
                    n8 += n3;
                }
                ++n7;
            }
        }

        protected static void divide_BYTE_COMP_Data(WritableRaster writableRaster) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
            int n = writableRaster.getWidth();
            int n2 = componentSampleModel.getScanlineStride();
            int n3 = componentSampleModel.getPixelStride();
            int[] nArray = componentSampleModel.getBandOffsets();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            int n4 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
            int n5 = nArray[nArray.length - 1];
            int n6 = nArray.length - 1;
            byte[] byArray = dataBufferByte.getBankData()[0];
            int n7 = 0;
            while (n7 < writableRaster.getHeight()) {
                int n8 = n4 + n7 * n2;
                int n9 = n8 + n * n3;
                while (n8 < n9) {
                    int n10;
                    int n11 = byArray[n8 + n5] & 0xFF;
                    if (n11 == 0) {
                        n10 = 0;
                        while (n10 < n6) {
                            byArray[n8 + nArray[n10]] = -1;
                            ++n10;
                        }
                    } else if (n11 < 255) {
                        n10 = 0xFF0000 / n11;
                        int n12 = 0;
                        while (n12 < n6) {
                            int n13 = n8 + nArray[n12];
                            byArray[n13] = (byte)((byArray[n13] & 0xFF) * n10 >>> 16);
                            ++n12;
                        }
                    }
                    n8 += n3;
                }
                ++n7;
            }
        }

        protected static void mult_INT_PACK_Data(WritableRaster writableRaster) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
            int n = writableRaster.getWidth();
            int n2 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
            int[] nArray = dataBufferInt.getBankData()[0];
            int n4 = 0;
            while (n4 < writableRaster.getHeight()) {
                int n5 = n3 + n4 * n2;
                int n6 = n5 + n;
                while (n5 < n6) {
                    int n7 = nArray[n5];
                    int n8 = n7 >>> 24;
                    if (n8 >= 0 && n8 < 255) {
                        nArray[n5] = n8 << 24 | (n7 & 0xFF0000) * n8 >> 8 & 0xFF0000 | (n7 & 0xFF00) * n8 >> 8 & 0xFF00 | (n7 & 0xFF) * n8 >> 8 & 0xFF;
                    }
                    ++n5;
                }
                ++n4;
            }
        }

        protected static void divide_INT_PACK_Data(WritableRaster writableRaster) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
            int n = writableRaster.getWidth();
            int n2 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
            int[] nArray = dataBufferInt.getBankData()[0];
            int n4 = 0;
            while (n4 < writableRaster.getHeight()) {
                int n5 = n3 + n4 * n2;
                int n6 = n5 + n;
                while (n5 < n6) {
                    int n7 = nArray[n5];
                    int n8 = n7 >>> 24;
                    if (n8 <= 0) {
                        nArray[n5] = 0xFFFFFF;
                    } else if (n8 < 255) {
                        int n9 = 0xFF0000 / n8;
                        nArray[n5] = n8 << 24 | ((n7 & 0xFF0000) >> 16) * n9 & 0xFF0000 | (((n7 & 0xFF00) >> 8) * n9 & 0xFF0000) >> 8 | ((n7 & 0xFF) * n9 & 0xFF0000) >> 16;
                    }
                    ++n5;
                }
                ++n4;
            }
        }
    }
}

