/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.positioners.BasicBalloonTipPositioner;
import net.java.balloontip.positioners.Left_Above_Positioner;
import net.java.balloontip.positioners.Left_Below_Positioner;
import net.java.balloontip.positioners.Right_Above_Positioner;
import net.java.balloontip.positioners.Right_Below_Positioner;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.RoundedBalloonStyle;

public class BalloonTip
extends JPanel {
    private static Icon defaultIcon = new ImageIcon(BalloonTip.class.getResource("/net/java/balloontip/images/close_default.png"));
    private static Icon rolloverIcon = new ImageIcon(BalloonTip.class.getResource("/net/java/balloontip/images/close_rollover.png"));
    private static Icon pressedIcon = new ImageIcon(BalloonTip.class.getResource("/net/java/balloontip/images/close_pressed.png"));
    private JLabel label = new JLabel();
    private JButton closeButton = null;
    private boolean isVisible = true;
    private boolean clickToClose = false;
    private boolean clickToHide = false;
    private ComponentAdapter attachedComponentListener = new ComponentAdapter(){

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            BalloonTip.this.refreshLocation();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            BalloonTip.this.refreshLocation();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            BalloonTip.this.checkVisibility();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            BalloonTip.this.checkVisibility();
        }
    };
    private ComponentAdapter topLevelContainerListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (BalloonTip.this.attachedComponent.isShowing()) {
                BalloonTip.this.refreshLocation();
            }
        }
    };
    private MouseAdapter clickListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (BalloonTip.this.clickToHide) {
                BalloonTip.this.setVisible(false);
            } else if (BalloonTip.this.clickToClose) {
                BalloonTip.this.closeBalloon();
            }
        }
    };
    private AncestorListener attachedComponentParentListener = null;
    protected BalloonTipStyle style;
    protected BalloonTipPositioner positioner;
    protected JLayeredPane topLevelContainer = null;
    protected JComponent attachedComponent;

    public BalloonTip(JComponent jComponent, String string) {
        this(jComponent, string, new RoundedBalloonStyle(5, 5, Color.WHITE, Color.BLACK), true);
    }

    public BalloonTip(JComponent jComponent, String string, BalloonTipStyle balloonTipStyle, boolean bl) {
        this(jComponent, string, balloonTipStyle, Orientation.LEFT_ABOVE, AttachLocation.ALIGNED, 16, 20, bl);
    }

    public BalloonTip(JComponent jComponent, String string, BalloonTipStyle balloonTipStyle, Orientation orientation, AttachLocation attachLocation, int n, int n2, boolean bl) {
        BasicBalloonTipPositioner basicBalloonTipPositioner = null;
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl2 = true;
        switch (attachLocation) {
            case ALIGNED: {
                bl2 = false;
                break;
            }
            case CENTER: {
                f = 0.5f;
                f2 = 0.5f;
                break;
            }
            case NORTH: {
                f = 0.5f;
                break;
            }
            case NORTHEAST: {
                f = 1.0f;
                break;
            }
            case EAST: {
                f = 1.0f;
                f2 = 0.5f;
                break;
            }
            case SOUTHEAST: {
                f = 1.0f;
                f2 = 1.0f;
                break;
            }
            case SOUTH: {
                f = 0.5f;
                f2 = 1.0f;
                break;
            }
            case SOUTHWEST: {
                f2 = 1.0f;
                break;
            }
            case WEST: {
                f2 = 0.5f;
                break;
            }
        }
        switch (orientation) {
            case LEFT_ABOVE: {
                basicBalloonTipPositioner = new Left_Above_Positioner(n, n2);
                break;
            }
            case LEFT_BELOW: {
                basicBalloonTipPositioner = new Left_Below_Positioner(n, n2);
                break;
            }
            case RIGHT_ABOVE: {
                basicBalloonTipPositioner = new Right_Above_Positioner(n, n2);
                break;
            }
            case RIGHT_BELOW: {
                basicBalloonTipPositioner = new Right_Below_Positioner(n, n2);
            }
        }
        basicBalloonTipPositioner.enableFixedAttachLocation(bl2);
        basicBalloonTipPositioner.setAttachLocation(f, f2);
        this.initializePhase1(jComponent, string, balloonTipStyle, basicBalloonTipPositioner, bl);
    }

    public BalloonTip(JComponent jComponent, String string, BalloonTipStyle balloonTipStyle, BalloonTipPositioner balloonTipPositioner, boolean bl) {
        this.initializePhase1(jComponent, string, balloonTipStyle, balloonTipPositioner, bl);
    }

    public void finalize() {
        this.closeBalloon();
    }

    public void setText(String string) {
        this.label.setText(string);
        this.refreshLocation();
    }

    public String getText() {
        return this.label.getText();
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
        this.refreshLocation();
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIconTextGap(int n) {
        this.label.setIconTextGap(n);
        this.refreshLocation();
    }

    public int getIconTextGap() {
        return this.label.getIconTextGap();
    }

    public void setStyle(BalloonTipStyle balloonTipStyle) {
        this.firePropertyChange("style", this.style, balloonTipStyle);
        this.style = balloonTipStyle;
        this.setBorder(this.style);
        this.refreshLocation();
    }

    public BalloonTipStyle getStyle() {
        return this.style;
    }

    public void setPositioner(BalloonTipPositioner balloonTipPositioner) {
        this.firePropertyChange("positioner", this.positioner, balloonTipPositioner);
        this.positioner = balloonTipPositioner;
        this.positioner.setBalloonTip(this);
        this.refreshLocation();
    }

    public BalloonTipPositioner getPositioner() {
        return this.positioner;
    }

    public void setPadding(int n) {
        this.label.setBorder(new EmptyBorder(n, n, n, n));
        this.refreshLocation();
    }

    public int getPadding() {
        return this.label.getBorder().getBorderInsets((Component)this).left;
    }

    public void enableClickToHide(boolean bl) {
        this.clickToHide = bl;
    }

    public void enableClickToClose(boolean bl) {
        this.clickToClose = bl;
    }

    public void closeBalloon() {
        this.setVisible(false);
        this.attachedComponent.removeComponentListener(this.attachedComponentListener);
        if (this.topLevelContainer != null) {
            this.topLevelContainer.remove(this);
            this.topLevelContainer.removeComponentListener(this.attachedComponentListener);
        }
        this.removeMouseListener(this.clickListener);
    }

    public static void setCloseButtonIcons(Icon icon, Icon icon2, Icon icon3) {
        defaultIcon = icon;
        rolloverIcon = icon3;
        pressedIcon = icon2;
    }

    public void setCloseButtonBorder(int n, int n2, int n3, int n4) {
        if (this.closeButton != null) {
            this.closeButton.setBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4));
            this.refreshLocation();
        }
    }

    public void setCloseButtonActionListener(ActionListener actionListener) {
        ActionListener[] actionListenerArray = this.closeButton.getActionListeners();
        this.closeButton.removeActionListener(actionListenerArray[0]);
        this.closeButton.addActionListener(actionListener);
    }

    public JComponent getAttachedComponent() {
        return this.attachedComponent;
    }

    public JLayeredPane getTopLevelContainer() {
        return this.topLevelContainer;
    }

    public void refreshLocation() {
        Point point = SwingUtilities.convertPoint(this.attachedComponent, this.getLocation(), this);
        try {
            this.positioner.determineAndSetLocation(new Rectangle(point.x, point.y, this.attachedComponent.getWidth(), this.attachedComponent.getHeight()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.isVisible = bl;
        super.setVisible(bl);
    }

    private void checkVisibility() {
        if (this.attachedComponent.isShowing() && this.isVisible) {
            this.refreshLocation();
            super.setVisible(true);
        } else {
            super.setVisible(false);
        }
    }

    private void initializePhase1(final JComponent jComponent, String string, BalloonTipStyle balloonTipStyle, BalloonTipPositioner balloonTipPositioner, boolean bl) {
        this.attachedComponent = jComponent;
        this.style = balloonTipStyle;
        this.positioner = balloonTipPositioner;
        this.setBorder(this.style);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.label.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.label.setText(string);
        this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (bl) {
            this.closeButton = new JButton();
            this.closeButton.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
            this.closeButton.setContentAreaFilled(false);
            this.closeButton.setIcon(defaultIcon);
            this.closeButton.setRolloverIcon(rolloverIcon);
            this.closeButton.setPressedIcon(pressedIcon);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BalloonTip.this.closeBalloon();
                }
            });
            this.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        try {
            this.initializePhase2();
        }
        catch (NullPointerException nullPointerException) {
            this.attachedComponentParentListener = new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    BalloonTip.this.initializePhase2();
                    jComponent.removeAncestorListener(BalloonTip.this.attachedComponentParentListener);
                    BalloonTip.this.refreshLocation();
                    BalloonTip.this.repaint();
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }
            };
            jComponent.addAncestorListener(this.attachedComponentParentListener);
        }
    }

    private void initializePhase2() {
        Container container = this.attachedComponent.getParent();
        while (true) {
            if (container instanceof RootPaneContainer) break;
            if (container instanceof JTabbedPane) {
                ((JTabbedPane)container).addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        BalloonTip.this.checkVisibility();
                    }
                });
            }
            container = container.getParent();
        }
        this.topLevelContainer = ((RootPaneContainer)((Object)container)).getLayeredPane();
        this.topLevelContainer.add((Component)this, JLayeredPane.POPUP_LAYER);
        this.attachedComponent.addComponentListener(this.attachedComponentListener);
        this.topLevelContainer.addComponentListener(this.topLevelContainerListener);
        this.addMouseListener(this.clickListener);
        this.positioner.setBalloonTip(this);
        this.refreshLocation();
    }

    public static enum AttachLocation {
        ALIGNED,
        CENTER,
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST;

    }

    public static enum Orientation {
        LEFT_ABOVE,
        RIGHT_ABOVE,
        LEFT_BELOW,
        RIGHT_BELOW;

    }
}

