/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.jdchat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jd.PluginWrapper;
import jd.config.ConfigContainer;
import jd.config.ConfigEntry;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.SwingGui;
import jd.gui.swing.components.Balloon;
import jd.gui.swing.components.linkbutton.JLink;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.interfaces.SwitchPanelEvent;
import jd.gui.swing.jdgui.interfaces.SwitchPanelListener;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.nutils.OSDetector;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginOptional;
import jd.plugins.optional.jdchat.IRCListener;
import jd.plugins.optional.jdchat.JDChatPMS;
import jd.plugins.optional.jdchat.JDChatView;
import jd.plugins.optional.jdchat.User;
import jd.plugins.optional.jdchat.Utils;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import jd.utils.locale.JDLocale;
import net.miginfocom.swing.MigLayout;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9439 $", id="chat", hasGui=true, interfaceversion=5)
public class JDChat
extends PluginOptional
implements ControlListener {
    private static final long AWAY_TIMEOUT = 900000L;
    private static String CHANNEL = "#jDownloader";
    private static final Pattern CMD_ACTION = Pattern.compile("(me)", 2);
    private static final Pattern CMD_CONNECT = Pattern.compile("(connect|verbinden)", 2);
    private static final Pattern CMD_DISCONNECT = Pattern.compile("(disconnect|trennen)", 2);
    private static final Pattern CMD_EXIT = Pattern.compile("(exit|quit)", 2);
    private static final Pattern CMD_MODE = Pattern.compile("(mode|modus)", 2);
    private static final Pattern CMD_JOIN = Pattern.compile("join", 2);
    private static final Pattern CMD_NICK = Pattern.compile("(nick|name)", 2);
    private static final Pattern CMD_PM = Pattern.compile("(msg|query)", 2);
    private static final Pattern CMD_SLAP = Pattern.compile("(slap)", 2);
    private static final Pattern CMD_TOPIC = Pattern.compile("(topic|title)", 2);
    private static final Pattern CMD_TRANSLATE = Pattern.compile("(translate)", 2);
    private static final Pattern CMD_VERSION = Pattern.compile("(version|jdversion)", 2);
    private static final ArrayList<String> COMMANDS = new ArrayList();
    private static final String PARAM_HOST = "PARAM_HOST";
    private static final String PARAM_NICK = "PARAM_NICK";
    private static final String PARAM_DESLANGUAGE = "PARAM_DESLANGUAGE2";
    private static final String PARAM_DOAUTOTRANSLAT = "PARAM_DOAUTOTRANSLAT";
    private static final String PARAM_DOAUTOTRANSLATSELF = "PARAM_DOAUTOTRANSLATSELF";
    private static final String PARAM_NATIVELANGUAGE = "PARAM_NATIVELANGUAGE2";
    private static final String PARAM_PERFORM = "PARAM_PERFORM";
    private static final String PARAM_PORT = "PARAM_PORT";
    private static final String PARAM_USERCOLOR = "PARAM_USERCOLOR";
    private static final String PARAM_USERLISTPOSITION = "PARAM_USERLISTPOSITION";
    public static final String STYLE = JDIO.readFileToString((File)JDUtilities.getResourceFile((String)"plugins/jdchat/styles.css"));
    public static final String STYLE_ACTION = "action";
    public static final String STYLE_ERROR = "error";
    public static final String STYLE_HIGHLIGHT = "highlight";
    public static final String STYLE_NOTICE = "notice";
    public static final String STYLE_PM = "pm";
    public static final String STYLE_SELF = "self";
    public static final String STYLE_SYSTEM_MESSAGE = "system";
    public static final String USERLIST_STYLE = JDIO.readFileToString((File)JDUtilities.getResourceFile((String)"plugins/jdchat/userliststyles.css"));
    private static final String CHANNEL_LNG = "CHANNEL_LNG3";
    private JLabel top;
    private boolean changed;
    private IRCConnection conn;
    private SwitchPanel frame;
    private long lastAction;
    private String lastCommand;
    private boolean loggedIn;
    private ArrayList<JDLocale> lngmap = new ArrayList();
    private ArrayList<User> NAMES;
    private String nick;
    private boolean nickaway;
    private int nickCount = 0;
    private String orgNick;
    private JTextPane right;
    private TreeMap<String, JDChatPMS> pms = new TreeMap();
    private StringBuilder sb;
    private JScrollPane scrollPane;
    private JTextPane textArea;
    private JTextField textField;
    private JComboBox lang;
    private SubConfiguration subConfig = SubConfiguration.getConfig((String)"JDCHAT");
    private JDChatView view;
    private MenuAction activateAction;
    private JTabbedPane tabbedPane;
    private JButton closeTab;

    public TreeMap<String, JDChatPMS> getPms() {
        return this.pms;
    }

    public JDChat(PluginWrapper wrapper) {
        super(wrapper);
        CHANNEL = this.getPluginConfig().getStringProperty("CHANNEL", CHANNEL);
        COMMANDS.add("/msg ");
        COMMANDS.add("/topic ");
        COMMANDS.add("/op ");
        COMMANDS.add("/deop ");
        COMMANDS.add("/query ");
        COMMANDS.add("/nick ");
        COMMANDS.add("/mode ");
        COMMANDS.add("/join ");
        COMMANDS.add("/translate ");
        this.initConfigEntries();
        COMMANDS.add("/translate artoda ");
        COMMANDS.add("/translate artode ");
        COMMANDS.add("/translate artofi ");
        COMMANDS.add("/translate artofr ");
        COMMANDS.add("/translate artoel ");
        COMMANDS.add("/translate artohi ");
        COMMANDS.add("/translate artoit ");
        COMMANDS.add("/translate artoja ");
        COMMANDS.add("/translate artoko ");
        COMMANDS.add("/translate artohr ");
        COMMANDS.add("/translate artonl ");
        COMMANDS.add("/translate artono ");
        COMMANDS.add("/translate artopl ");
        COMMANDS.add("/translate artopt ");
        COMMANDS.add("/translate artoro ");
        COMMANDS.add("/translate artoru ");
        COMMANDS.add("/translate artosv ");
        COMMANDS.add("/translate artoes ");
        COMMANDS.add("/translate artocs ");
        COMMANDS.add("/translate artoen ");
        COMMANDS.add("/translate bgtoar ");
        COMMANDS.add("/translate bgtoda ");
        COMMANDS.add("/translate bgtode ");
        COMMANDS.add("/translate bgtofi ");
        COMMANDS.add("/translate bgtofr ");
        COMMANDS.add("/translate bgtoel ");
        COMMANDS.add("/translate bgtohi ");
        COMMANDS.add("/translate bgtoit ");
        COMMANDS.add("/translate bgtoja ");
        COMMANDS.add("/translate bgtoko ");
        COMMANDS.add("/translate bgtohr ");
        COMMANDS.add("/translate bgtonl ");
        COMMANDS.add("/translate bgtono ");
        COMMANDS.add("/translate bgtopl ");
        COMMANDS.add("/translate bgtopt ");
        COMMANDS.add("/translate bgtoro ");
        COMMANDS.add("/translate bgtoru ");
        COMMANDS.add("/translate bgtosv ");
        COMMANDS.add("/translate bgtoes ");
        COMMANDS.add("/translate bgtocs ");
        COMMANDS.add("/translate bgtoen ");
        COMMANDS.add("/translate datoar ");
        COMMANDS.add("/translate datobg ");
        COMMANDS.add("/translate datode ");
        COMMANDS.add("/translate datofi ");
        COMMANDS.add("/translate datofr ");
        COMMANDS.add("/translate datoel ");
        COMMANDS.add("/translate datohi ");
        COMMANDS.add("/translate datoit ");
        COMMANDS.add("/translate datoja ");
        COMMANDS.add("/translate datoko ");
        COMMANDS.add("/translate datohr ");
        COMMANDS.add("/translate datonl ");
        COMMANDS.add("/translate datono ");
        COMMANDS.add("/translate datopl ");
        COMMANDS.add("/translate datopt ");
        COMMANDS.add("/translate datoro ");
        COMMANDS.add("/translate datoru ");
        COMMANDS.add("/translate datosv ");
        COMMANDS.add("/translate datoes ");
        COMMANDS.add("/translate datocs ");
        COMMANDS.add("/translate datoen ");
        COMMANDS.add("/translate detoar ");
        COMMANDS.add("/translate detobg ");
        COMMANDS.add("/translate detoda ");
        COMMANDS.add("/translate detofi ");
        COMMANDS.add("/translate detofr ");
        COMMANDS.add("/translate detoel ");
        COMMANDS.add("/translate detohi ");
        COMMANDS.add("/translate detoit ");
        COMMANDS.add("/translate detoja ");
        COMMANDS.add("/translate detoko ");
        COMMANDS.add("/translate detohr ");
        COMMANDS.add("/translate detonl ");
        COMMANDS.add("/translate detono ");
        COMMANDS.add("/translate detopl ");
        COMMANDS.add("/translate detopt ");
        COMMANDS.add("/translate detoro ");
        COMMANDS.add("/translate detoru ");
        COMMANDS.add("/translate detosv ");
        COMMANDS.add("/translate detoes ");
        COMMANDS.add("/translate detocs ");
        COMMANDS.add("/translate detoen ");
        COMMANDS.add("/translate fitoar ");
        COMMANDS.add("/translate fitobg ");
        COMMANDS.add("/translate fitoda ");
        COMMANDS.add("/translate fitode ");
        COMMANDS.add("/translate fitofr ");
        COMMANDS.add("/translate fitoel ");
        COMMANDS.add("/translate fitohi ");
        COMMANDS.add("/translate fitoit ");
        COMMANDS.add("/translate fitoja ");
        COMMANDS.add("/translate fitoko ");
        COMMANDS.add("/translate fitohr ");
        COMMANDS.add("/translate fitonl ");
        COMMANDS.add("/translate fitono ");
        COMMANDS.add("/translate fitopl ");
        COMMANDS.add("/translate fitopt ");
        COMMANDS.add("/translate fitoro ");
        COMMANDS.add("/translate fitoru ");
        COMMANDS.add("/translate fitosv ");
        COMMANDS.add("/translate fitoes ");
        COMMANDS.add("/translate fitocs ");
        COMMANDS.add("/translate fitoen ");
        COMMANDS.add("/translate frtoar ");
        COMMANDS.add("/translate frtobg ");
        COMMANDS.add("/translate frtoda ");
        COMMANDS.add("/translate frtode ");
        COMMANDS.add("/translate frtofi ");
        COMMANDS.add("/translate frtoel ");
        COMMANDS.add("/translate frtohi ");
        COMMANDS.add("/translate frtoit ");
        COMMANDS.add("/translate frtoja ");
        COMMANDS.add("/translate frtoko ");
        COMMANDS.add("/translate frtohr ");
        COMMANDS.add("/translate frtonl ");
        COMMANDS.add("/translate frtono ");
        COMMANDS.add("/translate frtopl ");
        COMMANDS.add("/translate frtopt ");
        COMMANDS.add("/translate frtoro ");
        COMMANDS.add("/translate frtoru ");
        COMMANDS.add("/translate frtosv ");
        COMMANDS.add("/translate frtoes ");
        COMMANDS.add("/translate frtocs ");
        COMMANDS.add("/translate frtoen ");
        COMMANDS.add("/translate eltoar ");
        COMMANDS.add("/translate eltobg ");
        COMMANDS.add("/translate eltoda ");
        COMMANDS.add("/translate eltode ");
        COMMANDS.add("/translate eltofi ");
        COMMANDS.add("/translate eltofr ");
        COMMANDS.add("/translate eltohi ");
        COMMANDS.add("/translate eltoit ");
        COMMANDS.add("/translate eltoja ");
        COMMANDS.add("/translate eltoko ");
        COMMANDS.add("/translate eltohr ");
        COMMANDS.add("/translate eltonl ");
        COMMANDS.add("/translate eltono ");
        COMMANDS.add("/translate eltopl ");
        COMMANDS.add("/translate eltopt ");
        COMMANDS.add("/translate eltoro ");
        COMMANDS.add("/translate eltoru ");
        COMMANDS.add("/translate eltosv ");
        COMMANDS.add("/translate eltoes ");
        COMMANDS.add("/translate eltocs ");
        COMMANDS.add("/translate eltoen ");
        COMMANDS.add("/translate hitoar ");
        COMMANDS.add("/translate hitobg ");
        COMMANDS.add("/translate hitoda ");
        COMMANDS.add("/translate hitode ");
        COMMANDS.add("/translate hitofi ");
        COMMANDS.add("/translate hitofr ");
        COMMANDS.add("/translate hitoel ");
        COMMANDS.add("/translate hitoit ");
        COMMANDS.add("/translate hitoja ");
        COMMANDS.add("/translate hitoko ");
        COMMANDS.add("/translate hitohr ");
        COMMANDS.add("/translate hitonl ");
        COMMANDS.add("/translate hitono ");
        COMMANDS.add("/translate hitopl ");
        COMMANDS.add("/translate hitopt ");
        COMMANDS.add("/translate hitoro ");
        COMMANDS.add("/translate hitoru ");
        COMMANDS.add("/translate hitosv ");
        COMMANDS.add("/translate hitoes ");
        COMMANDS.add("/translate hitocs ");
        COMMANDS.add("/translate hitoen ");
        COMMANDS.add("/translate ittoar ");
        COMMANDS.add("/translate ittobg ");
        COMMANDS.add("/translate ittoda ");
        COMMANDS.add("/translate ittode ");
        COMMANDS.add("/translate ittofi ");
        COMMANDS.add("/translate ittofr ");
        COMMANDS.add("/translate ittoel ");
        COMMANDS.add("/translate ittohi ");
        COMMANDS.add("/translate ittoja ");
        COMMANDS.add("/translate ittoko ");
        COMMANDS.add("/translate ittohr ");
        COMMANDS.add("/translate ittonl ");
        COMMANDS.add("/translate ittono ");
        COMMANDS.add("/translate ittopl ");
        COMMANDS.add("/translate ittopt ");
        COMMANDS.add("/translate ittoro ");
        COMMANDS.add("/translate ittoru ");
        COMMANDS.add("/translate ittosv ");
        COMMANDS.add("/translate ittoes ");
        COMMANDS.add("/translate ittocs ");
        COMMANDS.add("/translate ittoen ");
        COMMANDS.add("/translate jatoar ");
        COMMANDS.add("/translate jatobg ");
        COMMANDS.add("/translate jatoda ");
        COMMANDS.add("/translate jatode ");
        COMMANDS.add("/translate jatofi ");
        COMMANDS.add("/translate jatofr ");
        COMMANDS.add("/translate jatoel ");
        COMMANDS.add("/translate jatohi ");
        COMMANDS.add("/translate jatoit ");
        COMMANDS.add("/translate jatoko ");
        COMMANDS.add("/translate jatohr ");
        COMMANDS.add("/translate jatonl ");
        COMMANDS.add("/translate jatono ");
        COMMANDS.add("/translate jatopl ");
        COMMANDS.add("/translate jatopt ");
        COMMANDS.add("/translate jatoro ");
        COMMANDS.add("/translate jatoru ");
        COMMANDS.add("/translate jatosv ");
        COMMANDS.add("/translate jatoes ");
        COMMANDS.add("/translate jatocs ");
        COMMANDS.add("/translate jatoen ");
        COMMANDS.add("/translate kotoar ");
        COMMANDS.add("/translate kotobg ");
        COMMANDS.add("/translate kotoda ");
        COMMANDS.add("/translate kotode ");
        COMMANDS.add("/translate kotofi ");
        COMMANDS.add("/translate kotofr ");
        COMMANDS.add("/translate kotoel ");
        COMMANDS.add("/translate kotohi ");
        COMMANDS.add("/translate kotoit ");
        COMMANDS.add("/translate kotoja ");
        COMMANDS.add("/translate kotohr ");
        COMMANDS.add("/translate kotonl ");
        COMMANDS.add("/translate kotono ");
        COMMANDS.add("/translate kotopl ");
        COMMANDS.add("/translate kotopt ");
        COMMANDS.add("/translate kotoro ");
        COMMANDS.add("/translate kotoru ");
        COMMANDS.add("/translate kotosv ");
        COMMANDS.add("/translate kotoes ");
        COMMANDS.add("/translate kotocs ");
        COMMANDS.add("/translate kotoen ");
        COMMANDS.add("/translate hrtoar ");
        COMMANDS.add("/translate hrtobg ");
        COMMANDS.add("/translate hrtoda ");
        COMMANDS.add("/translate hrtode ");
        COMMANDS.add("/translate hrtofi ");
        COMMANDS.add("/translate hrtofr ");
        COMMANDS.add("/translate hrtoel ");
        COMMANDS.add("/translate hrtohi ");
        COMMANDS.add("/translate hrtoit ");
        COMMANDS.add("/translate hrtoja ");
        COMMANDS.add("/translate hrtoko ");
        COMMANDS.add("/translate hrtonl ");
        COMMANDS.add("/translate hrtono ");
        COMMANDS.add("/translate hrtopl ");
        COMMANDS.add("/translate hrtopt ");
        COMMANDS.add("/translate hrtoro ");
        COMMANDS.add("/translate hrtoru ");
        COMMANDS.add("/translate hrtosv ");
        COMMANDS.add("/translate hrtoes ");
        COMMANDS.add("/translate hrtocs ");
        COMMANDS.add("/translate hrtoen ");
        COMMANDS.add("/translate nltoar ");
        COMMANDS.add("/translate nltobg ");
        COMMANDS.add("/translate nltoda ");
        COMMANDS.add("/translate nltode ");
        COMMANDS.add("/translate nltofi ");
        COMMANDS.add("/translate nltofr ");
        COMMANDS.add("/translate nltoel ");
        COMMANDS.add("/translate nltohi ");
        COMMANDS.add("/translate nltoit ");
        COMMANDS.add("/translate nltoja ");
        COMMANDS.add("/translate nltoko ");
        COMMANDS.add("/translate nltohr ");
        COMMANDS.add("/translate nltono ");
        COMMANDS.add("/translate nltopl ");
        COMMANDS.add("/translate nltopt ");
        COMMANDS.add("/translate nltoro ");
        COMMANDS.add("/translate nltoru ");
        COMMANDS.add("/translate nltosv ");
        COMMANDS.add("/translate nltoes ");
        COMMANDS.add("/translate nltocs ");
        COMMANDS.add("/translate nltoen ");
        COMMANDS.add("/translate notoar ");
        COMMANDS.add("/translate notobg ");
        COMMANDS.add("/translate notoda ");
        COMMANDS.add("/translate notode ");
        COMMANDS.add("/translate notofi ");
        COMMANDS.add("/translate notofr ");
        COMMANDS.add("/translate notoel ");
        COMMANDS.add("/translate notohi ");
        COMMANDS.add("/translate notoit ");
        COMMANDS.add("/translate notoja ");
        COMMANDS.add("/translate notoko ");
        COMMANDS.add("/translate notohr ");
        COMMANDS.add("/translate notonl ");
        COMMANDS.add("/translate notopl ");
        COMMANDS.add("/translate notopt ");
        COMMANDS.add("/translate notoro ");
        COMMANDS.add("/translate notoru ");
        COMMANDS.add("/translate notosv ");
        COMMANDS.add("/translate notoes ");
        COMMANDS.add("/translate notocs ");
        COMMANDS.add("/translate notoen ");
        COMMANDS.add("/translate pltoar ");
        COMMANDS.add("/translate pltobg ");
        COMMANDS.add("/translate pltoda ");
        COMMANDS.add("/translate pltode ");
        COMMANDS.add("/translate pltofi ");
        COMMANDS.add("/translate pltofr ");
        COMMANDS.add("/translate pltoel ");
        COMMANDS.add("/translate pltohi ");
        COMMANDS.add("/translate pltoit ");
        COMMANDS.add("/translate pltoja ");
        COMMANDS.add("/translate pltoko ");
        COMMANDS.add("/translate pltohr ");
        COMMANDS.add("/translate pltonl ");
        COMMANDS.add("/translate pltono ");
        COMMANDS.add("/translate pltopt ");
        COMMANDS.add("/translate pltoro ");
        COMMANDS.add("/translate pltoru ");
        COMMANDS.add("/translate pltosv ");
        COMMANDS.add("/translate pltoes ");
        COMMANDS.add("/translate pltocs ");
        COMMANDS.add("/translate pltoen ");
        COMMANDS.add("/translate pttoar ");
        COMMANDS.add("/translate pttobg ");
        COMMANDS.add("/translate pttoda ");
        COMMANDS.add("/translate pttode ");
        COMMANDS.add("/translate pttofi ");
        COMMANDS.add("/translate pttofr ");
        COMMANDS.add("/translate pttoel ");
        COMMANDS.add("/translate pttohi ");
        COMMANDS.add("/translate pttoit ");
        COMMANDS.add("/translate pttoja ");
        COMMANDS.add("/translate pttoko ");
        COMMANDS.add("/translate pttohr ");
        COMMANDS.add("/translate pttonl ");
        COMMANDS.add("/translate pttono ");
        COMMANDS.add("/translate pttopl ");
        COMMANDS.add("/translate pttoro ");
        COMMANDS.add("/translate pttoru ");
        COMMANDS.add("/translate pttosv ");
        COMMANDS.add("/translate pttoes ");
        COMMANDS.add("/translate pttocs ");
        COMMANDS.add("/translate pttoen ");
        COMMANDS.add("/translate rotoar ");
        COMMANDS.add("/translate rotobg ");
        COMMANDS.add("/translate rotoda ");
        COMMANDS.add("/translate rotode ");
        COMMANDS.add("/translate rotofi ");
        COMMANDS.add("/translate rotofr ");
        COMMANDS.add("/translate rotoel ");
        COMMANDS.add("/translate rotohi ");
        COMMANDS.add("/translate rotoit ");
        COMMANDS.add("/translate rotoja ");
        COMMANDS.add("/translate rotoko ");
        COMMANDS.add("/translate rotohr ");
        COMMANDS.add("/translate rotonl ");
        COMMANDS.add("/translate rotono ");
        COMMANDS.add("/translate rotopl ");
        COMMANDS.add("/translate rotopt ");
        COMMANDS.add("/translate rotoru ");
        COMMANDS.add("/translate rotosv ");
        COMMANDS.add("/translate rotoes ");
        COMMANDS.add("/translate rotocs ");
        COMMANDS.add("/translate rotoen ");
        COMMANDS.add("/translate rutoar ");
        COMMANDS.add("/translate rutobg ");
        COMMANDS.add("/translate rutoda ");
        COMMANDS.add("/translate rutode ");
        COMMANDS.add("/translate rutofi ");
        COMMANDS.add("/translate rutofr ");
        COMMANDS.add("/translate rutoel ");
        COMMANDS.add("/translate rutohi ");
        COMMANDS.add("/translate rutoit ");
        COMMANDS.add("/translate rutoja ");
        COMMANDS.add("/translate rutoko ");
        COMMANDS.add("/translate rutohr ");
        COMMANDS.add("/translate rutonl ");
        COMMANDS.add("/translate rutono ");
        COMMANDS.add("/translate rutopl ");
        COMMANDS.add("/translate rutopt ");
        COMMANDS.add("/translate rutoro ");
        COMMANDS.add("/translate rutosv ");
        COMMANDS.add("/translate rutoes ");
        COMMANDS.add("/translate rutocs ");
        COMMANDS.add("/translate rutoen ");
        COMMANDS.add("/translate svtoar ");
        COMMANDS.add("/translate svtobg ");
        COMMANDS.add("/translate svtoda ");
        COMMANDS.add("/translate svtode ");
        COMMANDS.add("/translate svtofi ");
        COMMANDS.add("/translate svtofr ");
        COMMANDS.add("/translate svtoel ");
        COMMANDS.add("/translate svtohi ");
        COMMANDS.add("/translate svtoit ");
        COMMANDS.add("/translate svtoja ");
        COMMANDS.add("/translate svtoko ");
        COMMANDS.add("/translate svtohr ");
        COMMANDS.add("/translate svtonl ");
        COMMANDS.add("/translate svtono ");
        COMMANDS.add("/translate svtopl ");
        COMMANDS.add("/translate svtopt ");
        COMMANDS.add("/translate svtoro ");
        COMMANDS.add("/translate svtoru ");
        COMMANDS.add("/translate svtoes ");
        COMMANDS.add("/translate svtocs ");
        COMMANDS.add("/translate svtoen ");
        COMMANDS.add("/translate estoar ");
        COMMANDS.add("/translate estobg ");
        COMMANDS.add("/translate estoda ");
        COMMANDS.add("/translate estode ");
        COMMANDS.add("/translate estofi ");
        COMMANDS.add("/translate estofr ");
        COMMANDS.add("/translate estoel ");
        COMMANDS.add("/translate estohi ");
        COMMANDS.add("/translate estoit ");
        COMMANDS.add("/translate estoja ");
        COMMANDS.add("/translate estoko ");
        COMMANDS.add("/translate estohr ");
        COMMANDS.add("/translate estonl ");
        COMMANDS.add("/translate estono ");
        COMMANDS.add("/translate estopl ");
        COMMANDS.add("/translate estopt ");
        COMMANDS.add("/translate estoro ");
        COMMANDS.add("/translate estoru ");
        COMMANDS.add("/translate estosv ");
        COMMANDS.add("/translate estocs ");
        COMMANDS.add("/translate estoen ");
        COMMANDS.add("/translate cstoar ");
        COMMANDS.add("/translate cstobg ");
        COMMANDS.add("/translate cstoda ");
        COMMANDS.add("/translate cstode ");
        COMMANDS.add("/translate cstofi ");
        COMMANDS.add("/translate cstofr ");
        COMMANDS.add("/translate cstoel ");
        COMMANDS.add("/translate cstohi ");
        COMMANDS.add("/translate cstoit ");
        COMMANDS.add("/translate cstoja ");
        COMMANDS.add("/translate cstoko ");
        COMMANDS.add("/translate cstohr ");
        COMMANDS.add("/translate cstonl ");
        COMMANDS.add("/translate cstono ");
        COMMANDS.add("/translate cstopl ");
        COMMANDS.add("/translate cstopt ");
        COMMANDS.add("/translate cstoro ");
        COMMANDS.add("/translate cstoru ");
        COMMANDS.add("/translate cstosv ");
        COMMANDS.add("/translate cstoes ");
        COMMANDS.add("/translate cstoen ");
        COMMANDS.add("/translate entoar ");
        COMMANDS.add("/translate entobg ");
        COMMANDS.add("/translate entoda ");
        COMMANDS.add("/translate entode ");
        COMMANDS.add("/translate entofi ");
        COMMANDS.add("/translate entofr ");
        COMMANDS.add("/translate entoel ");
        COMMANDS.add("/translate entohi ");
        COMMANDS.add("/translate entoit ");
        COMMANDS.add("/translate entoja ");
        COMMANDS.add("/translate entoko ");
        COMMANDS.add("/translate entohr ");
        COMMANDS.add("/translate entonl ");
        COMMANDS.add("/translate entono ");
        COMMANDS.add("/translate entopl ");
        COMMANDS.add("/translate entopt ");
        COMMANDS.add("/translate entoro ");
        COMMANDS.add("/translate entoru ");
        COMMANDS.add("/translate entosv ");
        COMMANDS.add("/translate entoes ");
        COMMANDS.add("/translate entocs ");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.activateAction) {
            if (this.conn != null) {
                this.conn.close();
            }
            this.setGuiEnable(true);
        } else {
            this.setGuiEnable(false);
        }
    }

    public void addToText(User user, String style, String msg) {
        this.addToText(user, style, msg, this.textArea, this.sb);
    }

    public void addToText(User user, String style, String msg, final JTextPane targetpane, final StringBuilder sb) {
        JDLocale dest = (JDLocale)this.subConfig.getGenericProperty(PARAM_NATIVELANGUAGE, (Object)new JDLocale("en"));
        if (this.subConfig.getBooleanProperty(PARAM_DOAUTOTRANSLAT, false).booleanValue() && dest != null && !msg.contains("<")) {
            for (JDLocale loc : this.lngmap) {
                if (!loc.getLanguageCode().equalsIgnoreCase(dest.getLanguageCode())) continue;
                String tmp = JDL.translate((String)loc.getLanguageCode(), (String)msg);
                if (tmp == null || tmp.equalsIgnoreCase(msg)) break;
                msg = tmp = String.valueOf(tmp) + "(" + msg + ")";
                break;
            }
        }
        final String msg2 = msg;
        boolean color = this.subConfig.getBooleanProperty(PARAM_USERCOLOR, true);
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        sb.append("<!---->");
        sb.append("<li>");
        if (user != null) {
            if (!color) {
                sb.append("<span style='" + user.getStyle() + (this.getUser(this.conn.getNick()) == user ? ";font-weight:bold" : "") + "'>[" + df.format(dt) + "] " + user.getNickLink("pmnick") + (STYLE_PM.equalsIgnoreCase(style) ? ">> " : ": ") + "</span>");
            } else {
                sb.append("<span style='color:#000000" + (this.getUser(this.conn.getNick()) == user ? ";font-weight:bold" : "") + "'>[" + df.format(dt) + "] " + user.getNickLink("pmnick") + (STYLE_PM.equalsIgnoreCase(style) ? ">> " : ": ") + "</span>");
            }
        } else {
            sb.append("<span class='time'>[" + df.format(dt) + "] </span>");
        }
        if (this.conn != null && msg.contains(this.conn.getNick())) {
            style = STYLE_HIGHLIGHT;
        }
        if (style != null) {
            sb.append("<span class='" + style + "'>" + msg + "</span>");
        } else {
            sb.append("<span>" + msg + "</span>");
        }
        this.changed = true;
        new GuiRunnable<Object>(){

            public Object runSave() {
                if (JDChat.this.changed) {
                    if (!SwingGui.getInstance().getMainFrame().isActive() && JDChat.this.conn != null && msg2.contains(JDChat.this.conn.getNick())) {
                        SwingGui.getInstance().getMainFrame().toFront();
                    }
                    targetpane.setText(String.valueOf(STYLE) + "<ul>" + sb.toString() + "</ul>");
                    int max = JDChat.this.scrollPane.getVerticalScrollBar().getMaximum();
                    JDChat.this.scrollPane.getVerticalScrollBar().setValue(max);
                    JDChat.this.changed = false;
                }
                return null;
            }
        }.start();
    }

    public void addUser(String name) {
        User user = this.getUser(name);
        if (user == null) {
            this.NAMES.add(new User(name));
        } else if (user.rank != new User((String)name).rank) {
            user.rank = new User((String)name).rank;
        }
        this.updateNamesPanel();
    }

    public void addUsers(String[] split) {
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            User user = this.getUser(name);
            if (user == null) {
                this.NAMES.add(new User(name));
            } else if (user.rank != new User((String)name).rank) {
                user.rank = new User((String)name).rank;
            }
            ++n2;
        }
        this.updateNamesPanel();
    }

    public void controlEvent(ControlEvent e) {
        if (e.getID() == 3) {
            if (SwingGui.getInstance().getMainFrame().isActive() && !this.nickaway) {
                this.initIRC();
            } else {
                this.addToText(null, STYLE_ERROR, "You got disconnected because of a reconnect. <a href='intern:reconnect|reconnect'><b>[RECONNECT NOW]</b></a>");
            }
        } else if (e.getID() == 2 && this.conn != null && this.conn.isConnected()) {
            this.addToText(null, STYLE_SYSTEM_MESSAGE, "closing connection due to requested reconnect.");
            this.conn.doPart(CHANNEL, "reconnecting...");
            this.conn.close();
            this.conn = null;
        }
    }

    public ArrayList<MenuAction> createMenuitems() {
        ArrayList<MenuAction> menu = new ArrayList<MenuAction>();
        MenuAction m = this.activateAction;
        menu.add(m);
        if (this.view == null || !this.view.isVisible()) {
            m.setSelected(false);
        } else {
            m.setSelected(true);
        }
        return menu;
    }

    protected void doAction(String type, String name) {
        if (type.equals("reconnect") && name.equals("reconnect")) {
            if (this.conn == null) {
                this.initIRC();
            }
            return;
        }
        User usr = this.getUser(name);
        if (this.textField.getText().length() == 0) {
            if (!this.pms.containsKey(usr.name.toLowerCase())) {
                this.addPMS(usr.name);
            }
            int x = 0;
            while (x < this.tabbedPane.getTabCount()) {
                if (this.tabbedPane.getTitleAt(x).equals(usr.name)) {
                    this.tabbedPane.setSelectedIndex(x);
                    break;
                }
                ++x;
            }
        } else {
            this.textField.setText(String.valueOf(this.textField.getText().trim()) + " " + usr.name + " ");
        }
        this.textField.requestFocus();
    }

    public String getNick() {
        return this.conn.getNick();
    }

    public int getNickCount() {
        return this.nickCount;
    }

    public String getNickname() {
        String loc = JDL.getCountryCodeByIP();
        loc = loc == null ? System.getProperty("user.country") : loc.toLowerCase();
        String def = "JD-[" + loc + "]_" + ("" + System.currentTimeMillis()).substring(6);
        this.nick = this.subConfig.getStringProperty(PARAM_NICK);
        if (this.nick == null || this.nick.equalsIgnoreCase("")) {
            this.nick = UserIO.getInstance().requestInputDialog(JDL.L((String)"plugins.optional.jdchat.enternick", (String)"Your wished nickname?"));
            if (this.nick != null && !this.nick.equalsIgnoreCase("")) {
                this.nick = String.valueOf(this.nick) + "[" + loc + "]";
            }
            if (this.nick != null) {
                this.nick = this.nick.trim();
            }
            this.subConfig.setProperty(PARAM_NICK, (Object)this.nick);
            this.subConfig.save();
        }
        if (this.nick == null) {
            this.nick = def;
        }
        this.nick = this.nick.trim();
        if (this.getNickCount() > 0) {
            this.nick = String.valueOf(this.nick) + "[" + this.getNickCount() + "]";
        }
        return this.nick;
    }

    public User getUser(String name) {
        for (User next : this.NAMES) {
            if (!next.isUser(name)) continue;
            return next;
        }
        return null;
    }

    public boolean initAddon() {
        this.NAMES = new ArrayList();
        this.sb = new StringBuilder();
        if (this.activateAction == null) {
            this.activateAction = new MenuAction(this.getWrapper().getID(), 0);
            this.activateAction.setActionListener((ActionListener)((Object)this));
            this.activateAction.setTitle(this.getHost());
            this.activateAction.setIcon(this.getIconKey());
            this.activateAction.setSelected(false);
        }
        return true;
    }

    private void initConfigEntries() {
        ConfigEntry cfg = new ConfigEntry(0, (Property)this.subConfig, PARAM_NICK, JDL.L((String)"plugins.optional.jdchat.user", (String)"Nickname"));
        this.config.addEntry(cfg);
        cfg = new ConfigEntry(3, (Property)this.subConfig, PARAM_USERCOLOR, JDL.L((String)"plugins.optional.jdchat.usercolor", (String)"Only black usernames?"));
        this.config.addEntry(cfg);
        Object[] positions = new String[]{JDL.L((String)"plugins.jdchat.userlistposition_right", (String)"Right"), JDL.L((String)"plugins.jdchat.userlistposition_left", (String)"Left")};
        cfg = new ConfigEntry(15, (Property)this.subConfig, PARAM_USERLISTPOSITION, positions, JDL.L((String)"plugins.jdchat.userlistposition", (String)"Userlist position: "));
        this.config.addEntry(cfg);
        cfg.setDefaultValue((Object)0);
        cfg = new ConfigEntry(10, (Property)this.subConfig, PARAM_PERFORM, JDL.L((String)"plugins.optional.jdchat.performonstart", (String)"Perform commands after connection estabilished"));
        this.config.addEntry(cfg);
        ConfigContainer lngse = new ConfigContainer(JDL.L((String)"plugins.optional.jdchat.locale", (String)"Language settings"));
        cfg = new ConfigEntry(13, lngse);
        this.config.addEntry(cfg);
        cfg = new ConfigEntry(3, (Property)this.subConfig, PARAM_DOAUTOTRANSLAT, JDL.L((String)"plugins.optional.jdchat.doautotranslate", (String)"Translate Chat"));
        lngse.addEntry(cfg);
        cfg.setDefaultValue((Object)false);
        ConfigEntry conditionEntry = cfg;
        this.lngmap.add(new JDLocale("ar"));
        this.lngmap.add(new JDLocale("bg"));
        this.lngmap.add(new JDLocale("zh-CN"));
        this.lngmap.add(new JDLocale("zh-TW"));
        this.lngmap.add(new JDLocale("hr"));
        this.lngmap.add(new JDLocale("cs"));
        this.lngmap.add(new JDLocale("da"));
        this.lngmap.add(new JDLocale("nl"));
        this.lngmap.add(new JDLocale("en"));
        this.lngmap.add(new JDLocale("fi"));
        this.lngmap.add(new JDLocale("fr"));
        this.lngmap.add(new JDLocale("de"));
        this.lngmap.add(new JDLocale("el"));
        this.lngmap.add(new JDLocale("hi"));
        this.lngmap.add(new JDLocale("it"));
        this.lngmap.add(new JDLocale("ja"));
        this.lngmap.add(new JDLocale("ko"));
        this.lngmap.add(new JDLocale("no"));
        this.lngmap.add(new JDLocale("pl"));
        this.lngmap.add(new JDLocale("pt"));
        this.lngmap.add(new JDLocale("ro"));
        this.lngmap.add(new JDLocale("ru"));
        this.lngmap.add(new JDLocale("es"));
        this.lngmap.add(new JDLocale("sv"));
        cfg = new ConfigEntry(1, (Property)this.subConfig, PARAM_NATIVELANGUAGE, (Object[])this.lngmap.toArray(new JDLocale[0]), JDL.L((String)"interaction.jdchat.native", (String)"to: "));
        lngse.addEntry(cfg);
        cfg.setDefaultValue((Object)JDL.DEFAULT_LOCALE);
        conditionEntry = new ConfigEntry(3, (Property)this.subConfig, PARAM_DOAUTOTRANSLATSELF, JDL.L((String)"plugins.optional.jdchat.doautotranslateself", (String)"Translate everything I say"));
        lngse.addEntry(conditionEntry);
        conditionEntry.setDefaultValue((Object)false);
        cfg = new ConfigEntry(1, (Property)this.subConfig, PARAM_DESLANGUAGE, (Object[])this.lngmap.toArray(new JDLocale[0]), JDL.L((String)"interaction.jdchat.deslanguage", (String)"to: "));
        lngse.addEntry(cfg);
        cfg.setDefaultValue((Object)JDL.DEFAULT_LOCALE);
    }

    private void initGUI() {
        int userlistposition = this.subConfig.getIntegerProperty(PARAM_USERLISTPOSITION, 0);
        this.textArea = new JTextPane();
        HyperlinkListener hyp = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e.getDescription().startsWith("intern")) {
                        String[][] m = new Regex(String.valueOf(e.getDescription()) + "?", "intern:([\\w]*?)\\|(.*?)\\?").getMatches();
                        if (m.length == 1) {
                            JDChat.this.doAction(m[0][0], m[0][1]);
                            return;
                        }
                    } else {
                        try {
                            JLink.openURL((URL)e.getURL());
                        }
                        catch (Exception e1) {
                            JDLogger.exception((Throwable)e1);
                        }
                    }
                }
            }
        };
        this.right = new JTextPane();
        this.right.setContentType("text/html");
        this.right.setEditable(false);
        this.textArea.addHyperlinkListener(hyp);
        this.right.addHyperlinkListener(hyp);
        this.scrollPane = new JScrollPane(this.textArea);
        this.tabbedPane = new JTabbedPane(1, 1);
        this.tabbedPane.add("JDChat", this.scrollPane);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JDChat.this.tabbedPane.setForegroundAt(JDChat.this.tabbedPane.getSelectedIndex(), Color.black);
            }
        });
        this.textField = new JTextField();
        this.textField.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.textField.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        this.textField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                JDChat.this.tabbedPane.setForegroundAt(JDChat.this.tabbedPane.getSelectedIndex(), Color.black);
            }

            public void focusLost(FocusEvent e) {
                JDChat.this.tabbedPane.setForegroundAt(JDChat.this.tabbedPane.getSelectedIndex(), Color.black);
            }
        });
        this.textField.addKeyListener(new KeyListener(){
            private int counter = 0;
            private String last = null;

            public void keyPressed(KeyEvent e) {
                int sel = JDChat.this.tabbedPane.getSelectedIndex();
                JDChat.this.tabbedPane.setForegroundAt(sel, Color.black);
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (JDChat.this.textField.getText().length() == 0) {
                        return;
                    }
                    if (JDChat.this.tabbedPane.getSelectedIndex() == 0 || JDChat.this.textField.getText().startsWith("/")) {
                        JDChat.this.sendMessage(CHANNEL, JDChat.this.textField.getText());
                    } else {
                        JDChat.this.sendMessage(CHANNEL, "/msg " + JDChat.this.tabbedPane.getTitleAt(JDChat.this.tabbedPane.getSelectedIndex()) + " " + JDChat.this.textField.getText());
                    }
                } else if (e.getKeyCode() == 9) {
                    if (JDChat.this.textField.getText().length() == 0) {
                        if (JDChat.this.lastCommand != null) {
                            JDChat.this.textField.setText(JDChat.this.lastCommand);
                            JDChat.this.textField.requestFocus();
                        }
                        return;
                    }
                    String txt = JDChat.this.textField.getText();
                    if (this.last != null && txt.toLowerCase().startsWith(this.last.toLowerCase())) {
                        txt = this.last;
                    }
                    String org = txt;
                    int last = Math.max(0, txt.lastIndexOf(" "));
                    txt = txt.substring(last).trim();
                    ArrayList<String> users = new ArrayList<String>();
                    ArrayList<String> strings = new ArrayList<String>();
                    strings.addAll(COMMANDS);
                    for (User user : JDChat.this.NAMES) {
                        strings.add(user.name);
                    }
                    for (String string : strings) {
                        if (string.length() < txt.length() || !string.toLowerCase().startsWith(txt.toLowerCase())) continue;
                        users.add(string);
                    }
                    if (users.size() == 0) {
                        return;
                    }
                    ++this.counter;
                    if (this.counter > users.size() - 1) {
                        this.counter = 0;
                    }
                    String string = (String)users.get(this.counter);
                    this.last = org;
                    JDChat.this.textField.setText((String.valueOf(JDChat.this.textField.getText().substring(0, last)) + " " + string).trim());
                    JDChat.this.textField.requestFocus();
                } else if (e.getKeyCode() == 38) {
                    if (JDChat.this.textField.getText().length() == 0) {
                        if (JDChat.this.lastCommand != null) {
                            JDChat.this.textField.setText(JDChat.this.lastCommand);
                            JDChat.this.textField.requestFocus();
                        }
                        return;
                    }
                } else {
                    this.last = null;
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.lang = new JComboBox<JDLocale>(new JDLocale[]{JDL.getInstance((String)"en"), JDL.getInstance((String)"de"), JDL.getInstance((String)"es"), JDL.getInstance((String)"tr")});
        this.lang.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDChat.this.getPluginConfig().setProperty(JDChat.CHANNEL_LNG, JDChat.this.lang.getSelectedItem());
                JDChat.this.getPluginConfig().save();
                JDChat.this.initChannel();
            }
        });
        this.lang.setSelectedItem(this.getPluginConfig().getProperty(CHANNEL_LNG, (Object)JDL.getInstance((String)"en")));
        this.textArea.setContentType("text/html");
        this.textArea.setEditable(false);
        this.frame = new SwitchPanel(){
            private static final long serialVersionUID = 2138710083573682339L;

            public void onShow() {
            }

            public void onHide() {
            }
        };
        this.frame.setLayout((LayoutManager)new MigLayout("ins 0, wrap 1", "[grow,fill]", "[grow,fill][]"));
        this.closeTab = new JButton("Close Tab");
        this.closeTab.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JDChat.this.tabbedPane.getSelectedIndex() > 0) {
                    JDChat.this.delPMS(JDChat.this.tabbedPane.getTitleAt(JDChat.this.tabbedPane.getSelectedIndex()));
                } else if (JDChat.this.tabbedPane.getSelectedIndex() == 0) {
                    JDChat.this.addToText(null, JDChat.STYLE_SYSTEM_MESSAGE, "You can't close the main Chat!");
                }
            }
        });
        JScrollPane scrollPane_userlist = new JScrollPane(this.right);
        switch (userlistposition) {
            case 0: {
                this.frame.add((Component)this.tabbedPane, (Object)"split 2");
                this.frame.add((Component)scrollPane_userlist, (Object)"width 180:180:180");
                break;
            }
            default: {
                this.frame.add((Component)scrollPane_userlist, (Object)"width 180:180:180 ,split 2");
                this.frame.add((Component)this.tabbedPane);
            }
        }
        this.frame.add((Component)this.textField, (Object)"growx, split 3");
        this.frame.add((Component)this.closeTab, (Object)"w pref!");
        this.frame.add((Component)this.lang, (Object)"w pref!");
        this.lastAction = System.currentTimeMillis();
        MouseMotionListener ml = new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                JDChat.this.lastAction = System.currentTimeMillis();
                JDChat.this.setNickAway(false);
            }
        };
        this.frame.addMouseMotionListener(ml);
        this.textArea.addMouseMotionListener(ml);
        this.textField.addMouseMotionListener(ml);
        this.right.addMouseMotionListener(ml);
        this.frame.setSize(new Dimension(800, 600));
        this.frame.setVisible(true);
        this.startAwayObserver();
    }

    private void initIRC() {
        this.NAMES.clear();
        int i = 0;
        while (i < 20) {
            String host = this.subConfig.getStringProperty(PARAM_HOST, "irc.freenode.net");
            int port = this.subConfig.getIntegerProperty(PARAM_PORT, 6667);
            String pass = null;
            String nick = this.getNickname();
            String user = "jdChatuser";
            String name = "jdChatuser";
            Balloon.show((String)"JD Chat", null, (String)"Connecting to JDChat...");
            this.addToText(null, STYLE_SYSTEM_MESSAGE, "Connecting to JDChat...");
            this.conn = new IRCConnection(host, new int[]{port}, pass, nick, user, name);
            this.conn.setTimeout(3600000);
            this.conn.addIRCEventListener((IRCEventListener)new IRCListener(this));
            this.conn.setEncoding("UTF-8");
            this.conn.setPong(true);
            this.conn.setDaemon(false);
            this.conn.setColors(false);
            try {
                this.conn.connect();
                break;
            }
            catch (IOException e) {
                this.addToText(null, STYLE_SYSTEM_MESSAGE, "Connect Timeout. Server not reachable...");
                JDLogger.exception((Throwable)e);
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e1) {
                    JDLogger.exception((Throwable)e1);
                }
                this.initIRC();
                ++i;
            }
        }
    }

    private void initChannel() {
        JDLocale id = JDL.getLocale();
        JDLocale lng = JDL.getInstance((String)"en");
        if (id.getLanguageCode().equals("es")) {
            lng = JDL.getInstance((String)"es");
        } else if (id.getLanguageCode().equals("tr")) {
            lng = JDL.getInstance((String)"tr");
        }
        lng = (JDLocale)this.getPluginConfig().getGenericProperty(CHANNEL_LNG, (Object)lng);
        String newChannel = null;
        newChannel = lng.getLanguageCode().equals(JDL.getInstance((String)"es").getLanguageCode()) ? "#jdownloader[es]" : (lng.getLanguageCode().equals(JDL.getInstance((String)"tr").getLanguageCode()) ? "#jdownloader[tr]" : "#jdownloader");
        if (newChannel.equalsIgnoreCase(CHANNEL) && this.isLoggedIn()) {
            if (this.conn != null && this.conn.isConnected()) {
                this.addToText(null, STYLE_NOTICE, "You are in channel: " + newChannel);
            }
            return;
        }
        this.NAMES.clear();
        if (this.conn != null && this.conn.isConnected()) {
            this.addToText(null, STYLE_NOTICE, "Change channel to: " + newChannel);
        }
        if (this.conn != null && this.conn.isConnected()) {
            this.conn.doPart(CHANNEL, " --> " + newChannel);
        }
        CHANNEL = newChannel;
        if (this.conn != null && this.conn.isConnected()) {
            this.conn.doJoin(CHANNEL, null);
        }
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void onConnected() {
        this.initChannel();
        this.setLoggedIn(true);
        this.perform();
    }

    public void onExit() {
        this.NAMES.clear();
        this.pms.clear();
        this.setLoggedIn(false);
        this.updateNamesPanel();
        if (this.view != null) {
            SwingGui.getInstance().disposeView((SwitchPanel)this.view);
        }
        this.view = null;
        if (this.conn != null) {
            this.conn.close();
        }
        this.conn = null;
    }

    public void onMode(char op, char mod, String arg) {
        switch (mod) {
            case 'o': {
                if (op == '+') {
                    this.getUser((String)arg).rank = 0;
                    this.updateNamesPanel();
                    break;
                }
                this.getUser((String)arg).rank = -1;
                this.updateNamesPanel();
                break;
            }
            case 'v': {
                if (op == '+') {
                    this.getUser((String)arg).rank = 1;
                    this.updateNamesPanel();
                    break;
                }
                this.getUser((String)arg).rank = -1;
                this.updateNamesPanel();
            }
        }
    }

    public void perform() {
        String[] perform = Regex.getLines((String)this.subConfig.getStringProperty(PARAM_PERFORM));
        if (perform == null) {
            return;
        }
        String[] stringArray = perform;
        int n = perform.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (cmd.trim().length() > 0) {
                this.sendMessage(CHANNEL, cmd);
            }
            ++n2;
        }
    }

    private String prepareToSend(String trim) {
        JDLocale dest = (JDLocale)this.subConfig.getGenericProperty(PARAM_DESLANGUAGE, (Object)new JDLocale("en"));
        if (this.subConfig.getBooleanProperty(PARAM_DOAUTOTRANSLATSELF, false).booleanValue() && dest != null) {
            for (JDLocale loc : this.lngmap) {
                if (!loc.getLanguageCode().equalsIgnoreCase(dest.getLanguageCode())) continue;
                String tmp = JDL.translate((String)loc.getLanguageCode(), (String)trim);
                if (tmp == null || tmp.equalsIgnoreCase(trim)) break;
                trim = tmp = String.valueOf(tmp) + "(" + trim + ")";
                break;
            }
        }
        return trim;
    }

    public void reconnect() {
        this.initIRC();
    }

    public void removeUser(String name) {
        User user = this.getUser(name);
        if (user != null) {
            this.NAMES.remove(user);
        }
        this.updateNamesPanel();
    }

    public void renameUser(String name, String name2) {
        User user = this.getUser(name);
        if (user != null) {
            user.name = name2;
        } else {
            this.addUser(name2);
        }
        this.updateNamesPanel();
    }

    public void requestNameList() {
        this.resetNamesList();
        this.conn.doNames(CHANNEL);
    }

    public void resetNamesList() {
        this.NAMES = new ArrayList();
        if (this.getUser(this.conn.getNick().trim()) == null) {
            this.NAMES.add(new User(this.conn.getNick().trim()));
        }
    }

    public void notifyPMS(String user, String text) {
        int x = 0;
        while (x < this.tabbedPane.getComponentCount()) {
            if (this.tabbedPane.getTitleAt(x).equals(user)) {
                this.tabbedPane.setForegroundAt(x, Color.RED);
                if (text.length() > 40) {
                    text = text.substring(0, 40).concat("...");
                }
                Object[] info = new Object[]{user, text};
                if (this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex()).equals(user)) break;
                Balloon.show((String)"JD Chat", null, (String)JDL.LF((String)"jd.plugins.optional.jdchat.newmessage", (String)"New Message from %s:<hr> %s", (Object[])info));
                break;
            }
            ++x;
        }
    }

    public void addPMS(String user) {
        if ((user = user.trim()).equals(this.conn.getNick().trim())) {
            return;
        }
        this.pms.put(user.toLowerCase(), new JDChatPMS(user));
        this.tabbedPane.add(user, this.pms.get(user.toLowerCase()).getScrollPane());
    }

    public void renamePMS(String userOld, String userNew) {
        this.pms.put(userNew.trim().toLowerCase(), this.pms.get(userOld.trim().toLowerCase()));
        int x = 0;
        while (x < this.tabbedPane.getComponentCount()) {
            if (this.tabbedPane.getTitleAt(x).equalsIgnoreCase(userOld)) {
                this.tabbedPane.remove(x);
                break;
            }
            ++x;
        }
        this.pms.remove(userOld);
        this.tabbedPane.add(userNew.trim(), this.pms.get(userNew.trim().toLowerCase()).getScrollPane());
    }

    public void delPMS(String user) {
        this.pms.remove(user.toLowerCase());
        int x = 0;
        while (x < this.tabbedPane.getComponentCount()) {
            if (this.tabbedPane.getTitleAt(x).toLowerCase().equals(user.toLowerCase())) {
                this.tabbedPane.remove(x);
                return;
            }
            ++x;
        }
    }

    protected void sendMessage(String channel2, String text) {
        this.lastAction = System.currentTimeMillis();
        this.setNickAway(false);
        if (text.startsWith("/")) {
            int end = text.indexOf(" ");
            if (end < 0) {
                end = text.length();
            }
            String cmd = text.substring(1, end).trim();
            String rest = text.substring(end).trim();
            if (Regex.matches((Object)cmd, (Pattern)CMD_PM)) {
                this.textField.setText("");
                end = rest.indexOf(" ");
                if (end < 0) {
                    end = rest.length();
                }
                if (!this.pms.containsKey(rest.substring(0, end).trim().toLowerCase())) {
                    this.addPMS(rest.substring(0, end).trim());
                }
                this.conn.doPrivmsg(rest.substring(0, end).trim(), this.prepareToSend(rest.substring(end).trim()));
                this.lastCommand = "/msg " + rest.substring(0, end).trim() + " ";
                this.addToText(this.getUser(this.conn.getNick()), STYLE_SELF, Utils.prepareMsg(rest.substring(end).trim()), this.pms.get(rest.substring(0, end).trim().toLowerCase()).getTextArea(), this.pms.get(rest.substring(0, end).trim().toLowerCase()).getSb());
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_SLAP)) {
                this.conn.doPrivmsg(channel2, String.valueOf(new String(new byte[]{1})) + "ACTION " + " slaps " + rest + " with the whole Javadocs" + new String(new byte[]{1}));
                this.addToText(null, STYLE_ACTION, String.valueOf(this.conn.getNick()) + " slaps " + rest + " with the whole Javadocs");
                this.lastCommand = "/slap ";
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_ACTION)) {
                this.lastCommand = "/me ";
                this.conn.doPrivmsg(channel2, String.valueOf(new String(new byte[]{1})) + "ACTION " + this.prepareToSend(rest.trim()) + new String(new byte[]{1}));
                this.addToText(null, STYLE_ACTION, String.valueOf(this.conn.getNick()) + " " + Utils.prepareMsg(rest.trim()));
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_VERSION)) {
                String msg = " is using " + JDUtilities.getJDTitle() + " with Java " + JDUtilities.getJavaVersion() + " on a " + OSDetector.getOSString() + " system";
                this.conn.doPrivmsg(channel2, String.valueOf(new String(new byte[]{1})) + "ACTION " + this.prepareToSend(msg) + new String(new byte[]{1}));
                this.addToText(null, STYLE_ACTION, String.valueOf(this.conn.getNick()) + " " + Utils.prepareMsg(msg));
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_MODE)) {
                end = rest.indexOf(" ");
                if (end < 0) {
                    end = rest.length();
                }
                this.lastCommand = "/mode ";
                this.conn.doMode(CHANNEL, rest.trim());
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_TRANSLATE)) {
                String[] tofrom;
                end = rest.indexOf(" ");
                if (end < 0) {
                    end = rest.length();
                }
                if ((tofrom = rest.substring(0, end).trim().split("to")) == null || tofrom.length != 2) {
                    this.addToText(null, STYLE_ERROR, "Command /translate " + rest.substring(0, end).trim() + " is not available");
                    return;
                }
                String t = JDL.translate((String)tofrom[0], (String)tofrom[1], (String)Utils.prepareMsg(rest.substring(end).trim()));
                this.lastCommand = "/translate " + rest.substring(0, end).trim() + " ";
                this.textField.setText(t);
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_TOPIC)) {
                this.conn.doTopic(CHANNEL, this.prepareToSend(rest));
                this.lastCommand = "/topic ";
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_JOIN)) {
                this.NAMES.clear();
                if (this.conn != null) {
                    this.addToText(null, STYLE_NOTICE, "Change channel to: " + rest);
                }
                if (this.conn != null) {
                    this.conn.doPart(CHANNEL, " --> " + rest);
                }
                CHANNEL = rest;
                if (this.conn != null) {
                    this.conn.doJoin(CHANNEL, null);
                }
                this.lastCommand = "/join " + rest;
                this.setLoggedIn(true);
                this.perform();
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_NICK)) {
                this.conn.doNick(rest.trim());
                this.lastCommand = "/nick ";
                this.subConfig.setProperty(PARAM_NICK, (Object)rest.trim());
                this.subConfig.save();
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_CONNECT)) {
                if (this.conn == null || !this.conn.isConnected()) {
                    this.initIRC();
                }
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_DISCONNECT)) {
                if (this.conn != null && this.conn.isConnected()) {
                    this.conn.close();
                }
            } else if (Regex.matches((Object)cmd, (Pattern)CMD_EXIT)) {
                this.setGuiEnable(false);
            } else {
                this.addToText(null, STYLE_ERROR, "Command /" + cmd + " is not available");
            }
        } else {
            this.conn.doPrivmsg(channel2, this.prepareToSend(text));
            this.addToText(this.getUser(this.conn.getNick()), STYLE_SELF, Utils.prepareMsg(text));
        }
        this.textField.setText("");
        this.textField.requestFocus();
    }

    public void setGuiEnable(boolean b) {
        if (b) {
            if (this.view == null) {
                this.initGUI();
                this.view = new JDChatView(){
                    private static final long serialVersionUID = 3966113588850405974L;

                    protected void initMenu(JMenuBar menubar) {
                        JLabel jLabel = new JLabel(JDL.L((String)"jd.plugins.optional.jdchat.JDChat.topic.default", (String)"Loading Message of the day"));
                        JDChat.this.top = jLabel;
                        menubar.add(jLabel);
                        JDChat.this.top.setToolTipText(JDL.L((String)"jd.plugins.optional.jdchat.JDChat.topic.tooltip", (String)"Message of the day"));
                    }
                };
                this.view.getBroadcaster().addListener((EventListener)new SwitchPanelListener(){

                    public void onPanelEvent(SwitchPanelEvent event) {
                        if (event.getID() == 3) {
                            JDChat.this.activateAction.setSelected(false);
                            JDChat.this.onExit();
                        }
                    }
                });
                this.view.setContent(this.frame);
            }
            SwingGui.getInstance().setContent((SwitchPanel)this.view);
            JDUtilities.getController().addControlListener((ControlListener)this);
            new Thread(){

                public void run() {
                    JDChat.this.initIRC();
                }
            }.start();
        } else if (this.frame != null) {
            SwingGui.getInstance().disposeView((SwitchPanel)this.view);
            this.onExit();
        }
        if (this.activateAction != null && this.activateAction.isSelected() != b) {
            this.activateAction.setSelected(b);
        }
    }

    public String getIconKey() {
        return "gui.images.chat";
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public void setNick(String nickname) {
        if (nickname == null) {
            return;
        }
        this.addToText(null, STYLE_SYSTEM_MESSAGE, "Rename to " + nickname);
        this.conn.doNick(nickname);
    }

    private void setNickAway(boolean b) {
        if (this.nickaway == b) {
            return;
        }
        this.nickaway = b;
        if (b) {
            this.orgNick = this.conn.getNick();
            this.setNick(String.valueOf(this.conn.getNick().substring(0, Math.min(this.conn.getNick().length(), 11))) + "|away");
        } else {
            this.setNick(this.orgNick);
        }
    }

    public void setNickCount(int nickCount) {
        this.nickCount = nickCount;
    }

    public void setTopic(final String msg) {
        this.addToText(null, STYLE_SYSTEM_MESSAGE, "<b>Topic is: " + msg + "</b>");
        new GuiRunnable<Object>(){

            public Object runSave() {
                JDChat.this.top.setText(msg);
                return null;
            }
        }.start();
    }

    private void startAwayObserver() {
        Thread th = new Thread(){

            public void run() {
                while (true) {
                    if (System.currentTimeMillis() - JDChat.this.lastAction > 900000L) {
                        JDChat.this.setNickAway(true);
                    } else {
                        JDChat.this.setNickAway(false);
                    }
                    try {
                        Thread.sleep(10000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        JDLogger.exception((Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
        th.setDaemon(true);
        th.start();
    }

    public void updateNamesPanel() {
        final StringBuilder sb = new StringBuilder();
        Collections.sort(this.NAMES);
        boolean color = this.subConfig.getBooleanProperty(PARAM_USERCOLOR, true);
        sb.append("<ul>");
        for (User name : this.NAMES) {
            sb.append("<li>");
            if (!color) {
                sb.append("<span style='color:#" + name.getColor() + (name.name.equals(this.conn.getNick()) ? ";font-weight:bold;" : "") + "'>");
            } else {
                sb.append("<span style='color:#000000" + (name.name.equals(this.conn.getNick()) ? ";font-weight:bold;" : "") + "'>");
            }
            sb.append(String.valueOf(name.getRank()) + name.getNickLink("query"));
            sb.append("</span></li>");
        }
        sb.append("</ul>");
        if (this.right != null) {
            new GuiRunnable<Object>(){

                public Object runSave() {
                    JDChat.this.right.setText(String.valueOf(USERLIST_STYLE) + sb);
                    return null;
                }
            }.start();
        }
    }
}

