/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import jd.PluginWrapper;
import jd.config.ConfigEntry;
import jd.config.Configuration;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.DistributeData;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDLogger;
import jd.controlling.reconnect.Reconnecter;
import jd.event.ControlListener;
import jd.gui.UserIO;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.http.Browser;
import jd.nrouter.IPCheck;
import jd.nutils.Formatter;
import jd.nutils.encoding.Encoding;
import jd.nutils.httpserver.Handler;
import jd.nutils.httpserver.HttpServer;
import jd.nutils.httpserver.Request;
import jd.nutils.httpserver.Response;
import jd.parser.Regex;
import jd.parser.html.HTMLParser;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginOptional;
import jd.utils.JDUtilities;
import jd.utils.WebUpdate;
import jd.utils.locale.JDL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9568 $", id="remotecontrol", interfaceversion=5)
public class JDRemoteControl
extends PluginOptional
implements ControlListener {
    private static final String PARAM_PORT = "PORT";
    private static final String PARAM_ENABLED = "ENABLED";
    private final SubConfiguration subConfig;
    private DecimalFormat f = new DecimalFormat("#0.00");
    private HttpServer server;
    private MenuAction activate;

    public JDRemoteControl(PluginWrapper wrapper) {
        super(wrapper);
        this.subConfig = this.getPluginConfig();
        this.initConfig();
    }

    public String getIconKey() {
        return "gui.images.network";
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.subConfig.setProperty(PARAM_ENABLED, (Object)this.activate.isSelected());
            this.subConfig.save();
            if (this.activate.isSelected()) {
                this.server = new HttpServer(this.subConfig.getIntegerProperty(PARAM_PORT, 10025), (Handler)new Serverhandler());
                this.server.start();
                UserIO.getInstance().requestMessageDialog(JDL.LF((String)"plugins.optional.remotecontrol.startedonport2", (String)"%s started on port %s\nhttp://127.0.0.1:%s\n/help for Developer Information.", (Object[])new Object[]{this.getHost(), this.subConfig.getIntegerProperty(PARAM_PORT, 10025), this.subConfig.getIntegerProperty(PARAM_PORT, 10025)}));
            } else {
                if (this.server != null) {
                    this.server.sstop();
                }
                UserIO.getInstance().requestMessageDialog(JDL.LF((String)"plugins.optional.remotecontrol.stopped2", (String)"%s stopped.", (Object[])new Object[]{this.getHost()}));
            }
        }
        catch (Exception ex) {
            JDLogger.exception((Throwable)ex);
        }
    }

    public ArrayList<MenuAction> createMenuitems() {
        ArrayList<MenuAction> menu = new ArrayList<MenuAction>();
        if (this.activate == null) {
            this.activate = new MenuAction(this.getWrapper().getID(), 0);
            this.activate.setActionListener((ActionListener)((Object)this));
            this.activate.setSelected(this.subConfig.getBooleanProperty(PARAM_ENABLED, true).booleanValue());
            this.activate.setTitle(this.getHost());
        }
        menu.add(this.activate);
        return menu;
    }

    public boolean initAddon() {
        logger.info("RemoteControl OK");
        this.initRemoteControl();
        JDUtilities.getController().addControlListener((ControlListener)this);
        return true;
    }

    private void initConfig() {
        ConfigEntry cfg = new ConfigEntry(8, (Property)this.subConfig, PARAM_PORT, JDL.L((String)"plugins.optional.RemoteControl.port", (String)"Port:"), 1000, 65500);
        this.config.addEntry(cfg);
        cfg.setDefaultValue((Object)10025);
    }

    private void initRemoteControl() {
        if (this.subConfig.getBooleanProperty(PARAM_ENABLED, true).booleanValue()) {
            try {
                this.server = new HttpServer(this.subConfig.getIntegerProperty(PARAM_PORT, 10025), (Handler)new Serverhandler());
                this.server.start();
            }
            catch (Exception e) {
                JDLogger.exception((Throwable)e);
            }
        }
    }

    public void onExit() {
    }

    private class Serverhandler
    implements Handler {
        private Serverhandler() {
        }

        public void handle(Request request, Response response) {
            Document xml = JDUtilities.parseXmlString((String)"<jdownloader></jdownloader>", (boolean)false);
            response.setReturnType("text/html");
            response.setReturnStatus("200 OK");
            if (request.getRequestUrl().equals("/help")) {
                Vector<String> commandvec = new Vector<String>();
                Vector<String> infovector = new Vector<String>();
                commandvec.add(" ");
                infovector.add("<br /><b>Get Values:</b><br />&nbsp;");
                commandvec.add("/get/speed");
                infovector.add("Get current Speed");
                commandvec.add("/get/ip");
                infovector.add("Get IP");
                commandvec.add("/get/randomip");
                infovector.add("Answers with Random IP as replacement for real IP-Check");
                commandvec.add("/get/config");
                infovector.add("Get Config");
                commandvec.add("/get/version");
                infovector.add("Get Version");
                commandvec.add("/get/rcversion");
                infovector.add("Get RemoteControl Version");
                commandvec.add("/get/speedlimit");
                infovector.add("Get current Speedlimit");
                commandvec.add("/get/isreconnect");
                infovector.add("Get If Reconnect");
                commandvec.add("/get/downloadstatus");
                infovector.add("Get Downloadstatus<br/>Values: RUNNING, NOT_RUNNING, STOPPING");
                commandvec.add("/get/downloads/currentcount");
                infovector.add("Get amount of current downloads");
                commandvec.add("/get/downloads/currentlist");
                infovector.add("Get Current Downloads List (XML)");
                commandvec.add("/get/downloads/allcount");
                infovector.add("Get amount of downloads in list");
                commandvec.add("/get/downloads/alllist");
                infovector.add("Get list of downloads in list (XML)");
                commandvec.add("/get/downloads/finishedcount");
                infovector.add("Get amount of finished Downloads");
                commandvec.add("/get/downloads/finishedlist");
                infovector.add("Get finished Downloads List (XML)");
                commandvec.add(" ");
                infovector.add("<br /><b>Actions:</b><br />&nbsp;");
                commandvec.add("/action/start");
                infovector.add("Start DLs");
                commandvec.add("/action/pause");
                infovector.add("Pause DLs");
                commandvec.add("/action/stop");
                infovector.add("Stop DLs");
                commandvec.add("/action/toggle");
                infovector.add("Toggle DLs");
                commandvec.add("/action/update/force(0|1)/");
                infovector.add("Do Webupdate <br />force1 activates auto-restart if update is possible");
                commandvec.add("/action/reconnect");
                infovector.add("Do Reconnect");
                commandvec.add("/action/restart");
                infovector.add("Restart JD");
                commandvec.add("/action/shutdown");
                infovector.add("Shutdown JD");
                commandvec.add("/action/set/download/limit/%X%");
                infovector.add("Set Downloadspeedlimit %X%");
                commandvec.add("/action/set/download/max/%X%");
                infovector.add("Set max sim. Downloads %X%");
                commandvec.add("/action/add/links/grabber(0|1)/start(0|1)/%X%");
                infovector.add("Add Links %X% to Grabber<br /><p><span class=\"underline\">Optional:</span><br />grabber(0|1): Hide/Show LinkGrabber<br />grabber(0|1)/start(0|1): Hide/Show LinkGrabber and start/don't start downloads afterwards<br /></p><p><span class=\"underline\">Sample:</span><br />/action/add/links/grabber0/start1/http://tinyurl.com/6o73eq http://tinyurl.com/4khvhn<br />Don't forget Space between Links!</p>");
                commandvec.add("/action/add/container/grabber(0|1)/start(0|1)/%X%");
                infovector.add("Add Container %X%<br /><p><span class=\"underline\">Optional:</span><br />grabber(0|1): Hide/Show LinkGrabber<br />grabber(0|1)/start(0|1): Hide/Show LinkGrabber and start/don't start downloads afterwards<br /></p><p><span class=\"underline\">Sample:</span><br />/action/add/container/grabber0/start1/C:\\container.dlc</p>");
                commandvec.add("/action/save/container/%X%");
                infovector.add("Save DLC-Container with all Links to %X%<br /> Sample see /action/add/container/%X%");
                commandvec.add("/action/set/reconnectenabled/(true|false)");
                infovector.add("Set Reconnect enabled or not");
                commandvec.add("/action/set/premiumenabled/(true|false)");
                infovector.add("Set Use Premium enabled or not");
                response.addContent((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><head><title>JDRemoteControl Help</title><style type=\"text/css\">a {    font-size: 14px;    text-decoration: none;    background: none;    color: #599ad6;}a:hover {    text-decoration: underline;    color:#333333;}body {    color: #333333;    background:#f0f0f0;    font-family: Verdana, Arial, Helvetica, sans-serif;    font-size: 14px;    vertical-align: top;  }.underline{    text-decoration:underline;  }</style></head><body><br /><b>JDRemoteControl " + JDRemoteControl.this.getVersion() + "<br /><br />Usage:</b><br />&nbsp;<br />1)Replace %X% with your value<br />Sample: /action/save/container/C:\\backup.dlc <br />2)Replace (true|false) with true or false<br /><table border=\"0\" cellspacing=\"5\">"));
                int commandcount = 0;
                while (commandcount < commandvec.size()) {
                    response.addContent((Object)("\r\n<tr><td valign=\"top\"><a href=\"" + (String)commandvec.get(commandcount) + "\">" + (String)commandvec.get(commandcount) + "</a></td><td valign=\"top\">" + (String)infovector.get(commandcount) + "</td></tr>"));
                    ++commandcount;
                }
                response.addContent((Object)"\r\n</table><br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;<br />&nbsp;</body></html>");
            } else if (request.getRequestUrl().equals("/get/ip")) {
                if (SubConfiguration.getConfig((String)"DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
                    response.addContent((Object)"IPCheck disabled");
                } else {
                    response.addContent((Object)IPCheck.getIPAddress());
                }
            } else if (request.getRequestUrl().equals("/get/randomip")) {
                Random r = new Random();
                response.addContent((Object)(String.valueOf(r.nextInt(255)) + "." + r.nextInt(255) + "." + r.nextInt(255) + "." + r.nextInt(255)));
            } else if (request.getRequestUrl().equals("/get/config")) {
                Configuration config = JDUtilities.getConfiguration();
                response.addContent((Object)"<pre>");
                if (request.getParameters().containsKey("sub")) {
                    config = SubConfiguration.getConfig((String)((String)request.getParameters().get("sub")).toUpperCase());
                }
                for (Map.Entry next : config.getProperties().entrySet()) {
                    response.addContent((Object)(String.valueOf((String)next.getKey()) + " = " + next.getValue() + "\r\n"));
                }
                response.addContent((Object)"</pre>");
            } else if (request.getRequestUrl().equals("/get/version")) {
                response.addContent((Object)JDUtilities.getJDTitle());
            } else if (request.getRequestUrl().equals("/get/rcversion")) {
                response.addContent((Object)JDRemoteControl.this.getVersion());
            } else if (request.getRequestUrl().equals("/get/speedlimit")) {
                response.addContent((Object)SubConfiguration.getConfig((String)"DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0));
            } else if (request.getRequestUrl().equals("/get/downloads/currentcount")) {
                int counter = 0;
                for (FilePackage fp : JDUtilities.getController().getPackages()) {
                    for (DownloadLink dl : fp.getDownloadLinkList()) {
                        if (!dl.getLinkStatus().isPluginActive()) continue;
                        ++counter;
                    }
                }
                response.addContent((Object)counter);
            } else if (request.getRequestUrl().equals("/get/downloads/currentlist")) {
                for (FilePackage fp : JDUtilities.getController().getPackages()) {
                    Element fp_xml = this.addFilePackage(xml, fp);
                    for (DownloadLink dl : fp.getDownloadLinkList()) {
                        if (!dl.getLinkStatus().isPluginActive()) continue;
                        fp_xml.appendChild(this.addDownloadLink(xml, dl));
                    }
                }
                response.addContent((Object)JDUtilities.createXmlString((Document)xml));
            } else if (request.getRequestUrl().equals("/get/downloads/allcount")) {
                int counter = 0;
                for (FilePackage fp : JDUtilities.getController().getPackages()) {
                    counter += fp.getDownloadLinkList().size();
                }
                response.addContent((Object)counter);
            } else if (request.getRequestUrl().equals("/get/downloads/alllist")) {
                for (FilePackage fp : JDUtilities.getController().getPackages()) {
                    Element fp_xml = this.addFilePackage(xml, fp);
                    for (DownloadLink dl : fp.getDownloadLinkList()) {
                        fp_xml.appendChild(this.addDownloadLink(xml, dl));
                    }
                }
                response.addContent((Object)JDUtilities.createXmlString((Document)xml));
            } else if (request.getRequestUrl().equals("/get/downloads/finishedcount")) {
                int counter = 0;
                for (FilePackage fp : JDUtilities.getController().getPackages()) {
                    for (DownloadLink dl : fp.getDownloadLinkList()) {
                        if (!dl.getLinkStatus().hasStatus(2)) continue;
                        ++counter;
                    }
                }
                response.addContent((Object)counter);
            } else if (request.getRequestUrl().equals("/get/downloads/finishedlist")) {
                for (FilePackage fp : JDUtilities.getController().getPackages()) {
                    Element fp_xml = this.addFilePackage(xml, fp);
                    for (DownloadLink dl : fp.getDownloadLinkList()) {
                        if (!dl.getLinkStatus().hasStatus(2)) continue;
                        fp_xml.appendChild(this.addDownloadLink(xml, dl));
                    }
                }
                response.addContent((Object)JDUtilities.createXmlString((Document)xml));
            } else if (request.getRequestUrl().equals("/get/speed")) {
                response.addContent((Object)(JDUtilities.getController().getSpeedMeter() / 1000));
            } else if (request.getRequestUrl().equals("/get/isreconnect")) {
                response.addContent((Object)JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true));
            } else if (request.getRequestUrl().equals("/get/downloadstatus")) {
                response.addContent((Object)DownloadWatchDog.getInstance().getDownloadStatus().toString());
            } else if (request.getRequestUrl().equals("/action/start")) {
                DownloadWatchDog.getInstance().startDownloads();
                response.addContent((Object)"Downloads started");
            } else if (request.getRequestUrl().equals("/action/pause")) {
                DownloadWatchDog.getInstance().pauseDownloads(!DownloadWatchDog.getInstance().isPaused());
                response.addContent((Object)"Downloads paused");
            } else if (request.getRequestUrl().equals("/action/stop")) {
                DownloadWatchDog.getInstance().stopDownloads();
                response.addContent((Object)"Downloads stopped");
            } else if (request.getRequestUrl().equals("/action/toggle")) {
                DownloadWatchDog.getInstance().toggleStartStop();
                response.addContent((Object)"Downloads toggled");
            } else if (request.getRequestUrl().matches("[\\s\\S]*?/action/update/force[01]{1}/[\\s\\S]*")) {
                Integer force = Integer.parseInt(new Regex(request.getRequestUrl(), "[\\s\\S]*?/action/update/force([01]{1})/[\\s\\S]*").getMatch(0));
                if (force == 1) {
                    JDUtilities.getConfiguration().setProperty("WEBUPDATE_AUTO_RESTART", (Object)true);
                    SubConfiguration.getConfig((String)"WEBUPDATE").setProperty("WEBUPDATE_DISABLE", (Object)false);
                }
                new WebUpdate().doUpdateCheck(true);
                response.addContent((Object)"Do Webupdate...");
            } else if (request.getRequestUrl().equals("/action/reconnect")) {
                response.addContent((Object)"Do Reconnect...");
                Reconnecter.doManualReconnect();
            } else if (request.getRequestUrl().equals("/action/restart")) {
                response.addContent((Object)"Restarting...");
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            JDLogger.exception((Throwable)e);
                        }
                        JDUtilities.restartJD((boolean)false);
                    }
                }).start();
            } else if (request.getRequestUrl().equals("/action/shutdown")) {
                response.addContent((Object)"Shutting down...");
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            JDLogger.exception((Throwable)e);
                        }
                        JDUtilities.getController().exit();
                    }
                }).start();
            } else if (request.getRequestUrl().matches("(?is).*/action/set/download/limit/[0-9]+.*")) {
                Integer newdllimit = Integer.parseInt(new Regex(request.getRequestUrl(), "[\\s\\S]*/action/set/download/limit/([0-9]+).*").getMatch(0));
                logger.fine("RemoteControl - Set max. Downloadspeed: " + newdllimit.toString());
                SubConfiguration.getConfig((String)"DOWNLOAD").setProperty("DOWNLOAD_MAX_SPEED_V2", (Object)newdllimit.toString());
                SubConfiguration.getConfig((String)"DOWNLOAD").save();
                response.addContent((Object)("newlimit=" + newdllimit));
            } else if (request.getRequestUrl().matches("(?is).*/action/set/download/max/[0-9]+.*")) {
                Integer newsimdl = Integer.parseInt(new Regex(request.getRequestUrl(), "[\\s\\S]*/action/set/download/max/([0-9]+).*").getMatch(0));
                logger.fine("RemoteControl - Set max. sim. Downloads: " + newsimdl.toString());
                SubConfiguration.getConfig((String)"DOWNLOAD").setProperty("DOWNLOAD_MAX_SIMULTAN", (Object)newsimdl.toString());
                SubConfiguration.getConfig((String)"DOWNLOAD").save();
                response.addContent((Object)("newmax=" + newsimdl));
            } else if (request.getRequestUrl().matches("(?is).*/action/add/links/((grabber[01]{1}/)?|(start[01]{1}/grabber[01]{1}/)?)?[\\s\\S]+")) {
                String link = new Regex(request.getRequestUrl(), "[\\s\\S]*?/action/add/links/([\\s\\S]+)").getMatch(0);
                ArrayList<String> links = new ArrayList<String>();
                String[] stringArray = HTMLParser.getHttpLinks((String)link, null);
                int n = stringArray.length;
                int dl = 0;
                while (dl < n) {
                    String tlink = stringArray[dl];
                    links.add(tlink);
                    ++dl;
                }
                if (request.getParameters().size() > 0) {
                    for (String help : request.getParameters().keySet()) {
                        if (request.getParameter(help).equals("")) continue;
                        links.add(request.getParameter(help));
                    }
                }
                Integer showgrab = null;
                Integer start = null;
                Boolean hidegrabber = false;
                try {
                    showgrab = Integer.parseInt(new Regex(request.getRequestUrl(), ".+grabber([01]{1}).+").getMatch(0));
                    start = Integer.parseInt(new Regex(request.getRequestUrl(), ".+start([01]{1}).+").getMatch(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (showgrab != null && showgrab == 0) {
                    hidegrabber = true;
                }
                StringBuilder ret = new StringBuilder();
                char[] tmp = new char[]{'\"', '\r', '\n'};
                for (String element : links) {
                    ret.append('\"');
                    ret.append(element.trim());
                    ret.append(tmp);
                }
                link = ret.toString();
                new DistributeData(link, hidegrabber.booleanValue()).start();
                if (start != null && start == 1) {
                    DownloadWatchDog.getInstance().startDownloads();
                }
                response.addContent((Object)("Link(s) added. (" + link + ")"));
            } else if (request.getRequestUrl().matches("(?is).*/action/add/container/((grabber[01]{1}/)?|(start[01]{1}/grabber[01]{1}/)?)?[\\s\\S]+")) {
                String dlcfilestr = new Regex(request.getRequestUrl(), "[\\s\\S]*/action/add/container/((grabber[01]{1}/)?|(start[01]{1}/grabber[01]{1}/)?)?([\\s\\S]+)").getMatch(3);
                dlcfilestr = Encoding.htmlDecode((String)dlcfilestr);
                Integer showgrab = null;
                Integer start = null;
                Boolean hidegrabber = false;
                Boolean startdl = false;
                try {
                    showgrab = Integer.parseInt(new Regex(request.getRequestUrl(), ".+grabber([01]{1}).+").getMatch(0));
                    start = Integer.parseInt(new Regex(request.getRequestUrl(), ".+start([01]{1}).+").getMatch(0));
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                }
                if (showgrab != null && showgrab == 0) {
                    hidegrabber = true;
                }
                if (start != null && start == 1) {
                    startdl = true;
                }
                if (dlcfilestr.matches("http://.*?\\.(dlc|ccf|rsdf)")) {
                    String containerFormat = new Regex(dlcfilestr, ".+\\.((dlc|ccf|rsdf))").getMatch(0);
                    File container = JDUtilities.getResourceFile((String)("container/" + System.currentTimeMillis() + "." + containerFormat));
                    try {
                        Browser.download((File)container, (String)dlcfilestr);
                        JDUtilities.getController().loadContainerFile(container, hidegrabber.booleanValue(), startdl.booleanValue());
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            JDLogger.exception((Throwable)e);
                        }
                        container.delete();
                    }
                    catch (Exception e) {
                        JDLogger.exception((Throwable)e);
                    }
                } else {
                    JDUtilities.getController().loadContainerFile(new File(dlcfilestr), hidegrabber.booleanValue(), startdl.booleanValue());
                }
                response.addContent((Object)("Container opened. (" + dlcfilestr + ")"));
            } else if (request.getRequestUrl().matches("(?is).*/action/save/container/[\\s\\S]+")) {
                String dlcfilestr = new Regex(request.getRequestUrl(), "[\\s\\S]*/action/save/container/([\\s\\S]+)").getMatch(0);
                dlcfilestr = Encoding.htmlDecode((String)dlcfilestr);
                JDUtilities.getController().saveDLC(new File(dlcfilestr), JDUtilities.getDownloadController().getAllDownloadLinks());
                response.addContent((Object)("Container saved. (" + dlcfilestr + ")"));
            } else if (request.getRequestUrl().matches("(?is).*/action/set/reconnectenabled/.*")) {
                boolean newrc;
                boolean disprc = newrc = Boolean.parseBoolean(new Regex(request.getRequestUrl(), "[\\s\\S]*/action/set/reconnectenabled/(.*)").getMatch(0));
                newrc = !newrc;
                logger.fine("RemoteControl - Set ReConnect: " + disprc);
                if (newrc != JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true)) {
                    JDUtilities.getConfiguration().setProperty("ALLOW_RECONNECT", (Object)newrc);
                    JDUtilities.getConfiguration().save();
                    response.addContent((Object)("reconnect=" + disprc + " (CHANGED=true)"));
                } else {
                    response.addContent((Object)("reconnect=" + disprc + " (CHANGED=false)"));
                }
            } else if (request.getRequestUrl().matches("(?is).*/action/set/premiumenabled/.*")) {
                boolean newuseprem = Boolean.parseBoolean(new Regex(request.getRequestUrl(), "[\\s\\S]*/action/set/premiumenabled/(.*)").getMatch(0));
                logger.fine("RemoteControl - Set Premium: " + newuseprem);
                if (newuseprem != JDUtilities.getConfiguration().getBooleanProperty("USE_PREMIUM_V3", true)) {
                    JDUtilities.getConfiguration().setProperty("USE_PREMIUM_V3", (Object)newuseprem);
                    JDUtilities.getConfiguration().save();
                    response.addContent((Object)("newprem=" + newuseprem + " (CHANGED=true)"));
                } else {
                    response.addContent((Object)("newprem=" + newuseprem + " (CHANGED=false)"));
                }
            } else {
                response.addContent((Object)"JDRemoteControl - Malformed Request. use /help");
            }
        }

        private Element addFilePackage(Document xml, FilePackage fp) {
            Element element = xml.createElement("package");
            xml.getFirstChild().appendChild(element);
            element.setAttribute("package_name", fp.getName());
            element.setAttribute("package_percent", JDRemoteControl.this.f.format(fp.getPercent()));
            element.setAttribute("package_linksinprogress", String.valueOf(fp.getLinksInProgress()));
            element.setAttribute("package_linkstotal", String.valueOf(fp.size()));
            element.setAttribute("package_ETA", Formatter.formatSeconds((long)fp.getETA()));
            element.setAttribute("package_speed", Formatter.formatReadable((long)fp.getTotalDownloadSpeed()));
            element.setAttribute("package_loaded", Formatter.formatReadable((long)fp.getTotalKBLoaded()));
            element.setAttribute("package_size", Formatter.formatReadable((long)fp.getTotalEstimatedPackageSize()));
            element.setAttribute("package_todo", Formatter.formatReadable((long)(fp.getTotalEstimatedPackageSize() - fp.getTotalKBLoaded())));
            return element;
        }

        private Element addDownloadLink(Document xml, DownloadLink dl) {
            Element element = xml.createElement("file");
            element.setAttribute("file_name", dl.getName());
            element.setAttribute("file_package", dl.getFilePackage().getName());
            element.setAttribute("file_percent", JDRemoteControl.this.f.format((double)dl.getDownloadCurrent() * 100.0 / (double)Math.max(1L, dl.getDownloadSize())));
            element.setAttribute("file_hoster", dl.getHost());
            element.setAttribute("file_status", dl.getLinkStatus().getStatusString().toString());
            element.setAttribute("file_speed", String.valueOf(dl.getDownloadSpeed()));
            return element;
        }
    }
}

