/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.jdtrayicon;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jd.Main;
import jd.PluginWrapper;
import jd.config.ConfigEntry;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberController;
import jd.controlling.LinkGrabberControllerEvent;
import jd.controlling.LinkGrabberControllerListener;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.SwingGui;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.nutils.Formatter;
import jd.nutils.JDImage;
import jd.nutils.OSDetector;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginOptional;
import jd.plugins.optional.jdtrayicon.TrayIconPopup;
import jd.plugins.optional.jdtrayicon.TrayIconTooltip;
import jd.plugins.optional.jdtrayicon.TrayMouseAdapter;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9265 $", defaultEnabled=true, id="trayicon", interfaceversion=5, minJVM=1.6)
public class JDLightTray
extends PluginOptional
implements MouseListener,
MouseMotionListener,
WindowListener,
LinkGrabberControllerListener,
WindowStateListener {
    private SubConfiguration subConfig = SubConfiguration.getConfig((String)"ADDONS_JDLIGHTTRAY");
    private static final String PROPERTY_START_MINIMIZED = "PROPERTY_START_MINIMIZED";
    private static final String PROPERTY_CLOSE_TO_TRAY = "PROPERTY_CLOSE_TO_TRAY";
    private static final String PROPERTY_SINGLE_CLICK = "PROPERTY_SINGLE_CLICK";
    private static final String PROPERTY_TOOLTIP = "PROPERTY_TOOLTIP";
    private static final String PROPERTY_SHOW_ON_LINKGRAB = "PROPERTY_SHOW_ON_LINKGRAB";
    private static final String PROPERTY_SHOW_ON_LINKGRAB2 = "PROPERTY_SHOW_ON_LINKGRAB2";
    private static final String PROPERTY_SHOW_INFO_IN_TITLE = "PROPERTY_SHOW_INFO_IN_TITLE";
    private static final String PROPERTY_PASSWORD_REQUIRED = "PROPERTY_PASSWORD_REQUIRED";
    private static final String PROPERTY_PASSWORD = "PROPERTY_PASSWORD";
    private TrayIconPopup trayIconPopup;
    private TrayIcon trayIcon;
    private JFrame guiFrame;
    private TrayIconTooltip trayIconTooltip;
    private TrayMouseAdapter ma;
    private Thread updateThread;
    private boolean shutdown = false;
    private boolean iconified = false;

    public JDLightTray(PluginWrapper wrapper) {
        super(wrapper);
        this.initConfig();
    }

    public ArrayList<MenuAction> createMenuitems() {
        return null;
    }

    public boolean initAddon() {
        return (Boolean)new GuiRunnable<Boolean>(){

            public Boolean runSave() {
                if (JDUtilities.getJavaVersion() < 1.6) {
                    logger.severe("Error initializing SystemTray: Tray is supported since Java 1.6. your Version: " + JDUtilities.getJavaVersion());
                    return false;
                }
                if (!SystemTray.isSupported()) {
                    logger.severe("Error initializing SystemTray: Tray isn't supported jet");
                    return false;
                }
                try {
                    JDUtilities.getController().addControlListener((ControlListener)JDLightTray.this);
                    if (SwingGui.getInstance() != null) {
                        JDLightTray.this.guiFrame = SwingGui.getInstance().getMainFrame();
                        if (JDLightTray.this.guiFrame != null) {
                            JDLightTray.this.guiFrame.removeWindowListener(JDLightTray.this);
                            JDLightTray.this.guiFrame.addWindowListener(JDLightTray.this);
                            JDLightTray.this.guiFrame.removeWindowStateListener(JDLightTray.this);
                            JDLightTray.this.guiFrame.addWindowStateListener(JDLightTray.this);
                        }
                    }
                    logger.info("Systemtray OK");
                    JDLightTray.this.initGUI();
                }
                catch (Exception e) {
                    return false;
                }
                LinkGrabberController.getInstance().addListener((LinkGrabberControllerListener)JDLightTray.this);
                return true;
            }
        }.getReturnValue();
    }

    public void initConfig() {
        this.config.addEntry(new ConfigEntry(3, (Property)this.subConfig, PROPERTY_CLOSE_TO_TRAY, JDL.L((String)"plugins.optional.JDLightTray.closetotray", (String)"Close to tray")).setDefaultValue((Object)true));
        this.config.addEntry(new ConfigEntry(3, (Property)this.subConfig, PROPERTY_START_MINIMIZED, JDL.L((String)"plugins.optional.JDLightTray.startMinimized", (String)"Start minimized")).setDefaultValue((Object)false));
        this.config.addEntry(new ConfigEntry(6));
        this.config.addEntry(new ConfigEntry(3, (Property)this.subConfig, PROPERTY_SINGLE_CLICK, JDL.L((String)"plugins.optional.JDLightTray.singleClick", (String)"Toggle window status with single click")).setDefaultValue((Object)false));
        this.config.addEntry(new ConfigEntry(6));
        this.config.addEntry(new ConfigEntry(3, (Property)this.subConfig, PROPERTY_TOOLTIP, JDL.L((String)"plugins.optional.JDLightTray.tooltip", (String)"Show Tooltip")).setDefaultValue((Object)true));
        this.config.addEntry(new ConfigEntry(3, (Property)this.subConfig, PROPERTY_SHOW_ON_LINKGRAB, JDL.L((String)"plugins.optional.JDLightTray.linkgrabber.intray", (String)"Show on Linkgrabbing (when minimized as trayicon)")).setDefaultValue((Object)true));
        this.config.addEntry(new ConfigEntry(3, (Property)this.subConfig, PROPERTY_SHOW_ON_LINKGRAB2, JDL.L((String)"plugins.optional.JDLightTray.linkgrabber.always", (String)"Show on Linkgrabbing (always)")).setDefaultValue((Object)false));
        this.config.addEntry(new ConfigEntry(3, (Property)this.subConfig, PROPERTY_SHOW_INFO_IN_TITLE, JDL.L((String)"plugins.optional.JDLightTray.titleinfo", (String)"Show info in TaskBar when minimized")).setDefaultValue((Object)true));
        this.config.addEntry(new ConfigEntry(6));
        ConfigEntry cond = new ConfigEntry(3, (Property)this.subConfig, PROPERTY_PASSWORD_REQUIRED, JDL.L((String)"plugins.optional.JDLightTray.passwordRequired", (String)"Enter Password to open from Tray")).setDefaultValue((Object)false);
        this.config.addEntry(cond);
        ConfigEntry ce = new ConfigEntry(11, (Property)this.subConfig, PROPERTY_PASSWORD, JDL.L((String)"plugins.optional.JDLightTray.password", (String)"Password:"));
        this.config.addEntry(ce);
        ce.setEnabledCondidtion(cond, true);
    }

    public void controlEvent(ControlEvent event) {
        if (event.getID() == 30 && event.getSource() instanceof Main) {
            logger.info("JDLightTrayIcon Init complete");
            this.guiFrame = SwingGui.getInstance().getMainFrame();
            if (this.guiFrame != null) {
                this.guiFrame.removeWindowListener(this);
                this.guiFrame.addWindowListener(this);
                this.guiFrame.removeWindowStateListener(this);
                this.guiFrame.addWindowStateListener(this);
            }
            if (this.subConfig.getBooleanProperty(PROPERTY_START_MINIMIZED, false).booleanValue()) {
                this.miniIt(true);
            }
        } else if (event.getID() == 26) {
            this.shutdown = true;
        } else if (event.getID() == 13) {
            this.updateThread = new Thread("Tray Icon Updater"){

                public void run() {
                    boolean needupdate = false;
                    while (DownloadWatchDog.getInstance().getDownloadStatus() == DownloadWatchDog.STATE.RUNNING) {
                        if (JDLightTray.this.iconified && JDLightTray.this.subConfig.getBooleanProperty(JDLightTray.PROPERTY_SHOW_INFO_IN_TITLE, true).booleanValue()) {
                            needupdate = true;
                            JDGui.getInstance().setWindowTitle("JD AC: " + DownloadWatchDog.getInstance().getActiveDownloads() + " DL: " + Formatter.formatReadable((long)DownloadWatchDog.getInstance().getTotalSpeed()));
                        } else if (needupdate) {
                            JDGui.getInstance().setWindowTitle(JDUtilities.getJDTitle());
                            needupdate = false;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {}
                    }
                    JDGui.getInstance().setWindowTitle(JDUtilities.getJDTitle());
                }
            };
            this.updateThread.start();
        } else if (event.getID() == 6) {
            if (this.updateThread != null) {
                this.updateThread.interrupt();
            }
            JDGui.getInstance().setWindowTitle(JDUtilities.getJDTitle());
        }
        super.controlEvent(event);
    }

    private void initGUI() {
        SystemTray systemTray = SystemTray.getSystemTray();
        Image img = JDImage.getImage((String)"logo/jd_logo_128_128").getScaledInstance((int)systemTray.getTrayIconSize().getWidth(), (int)systemTray.getTrayIconSize().getHeight(), 4);
        this.trayIcon = new TrayIcon(img, "JDownloader");
        this.trayIcon.addActionListener((ActionListener)((Object)this));
        this.ma = new TrayMouseAdapter(this, this.trayIcon);
        this.trayIcon.addMouseListener(this.ma);
        this.trayIcon.addMouseMotionListener(this.ma);
        this.trayIconTooltip = new TrayIconTooltip();
        try {
            systemTray.add(this.trayIcon);
        }
        catch (Exception e) {
            JDLogger.exception((Throwable)e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.trayIconTooltip.hideWindow();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.trayIconTooltip.hideWindow();
        if (e.getSource() instanceof TrayIcon) {
            if (!OSDetector.isMac()) {
                if (e.getClickCount() >= (this.subConfig.getBooleanProperty(PROPERTY_SINGLE_CLICK, false) != false ? 1 : 2) && !SwingUtilities.isRightMouseButton(e)) {
                    this.miniIt(this.guiFrame.isVisible());
                } else if (this.trayIconPopup != null && this.trayIconPopup.isShowing()) {
                    this.trayIconPopup.dispose();
                    this.trayIconPopup = null;
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    this.trayIconPopup = new TrayIconPopup();
                    JDLightTray.calcLocation(this.trayIconPopup, e.getPoint());
                    this.trayIconPopup.setVisible(true);
                    this.trayIconPopup.startAutoHide();
                }
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                if (e.getClickCount() >= (this.subConfig.getBooleanProperty(PROPERTY_SINGLE_CLICK, false) != false ? 1 : 2) && !SwingUtilities.isLeftMouseButton(e)) {
                    this.miniIt(this.guiFrame.isVisible());
                } else if (this.trayIconPopup != null && this.trayIconPopup.isShowing()) {
                    this.trayIconPopup.dispose();
                    this.trayIconPopup = null;
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    this.trayIconPopup = new TrayIconPopup();
                    Point pointOnScreen = e.getLocationOnScreen();
                    if (e.getX() > 0) {
                        pointOnScreen.x -= e.getPoint().x;
                    }
                    JDLightTray.calcLocation(this.trayIconPopup, pointOnScreen);
                    this.trayIconPopup.setVisible(true);
                    this.trayIconPopup.startAutoHide();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void onExit() {
        this.removeTrayIcon();
        LinkGrabberController.getInstance().removeListener((LinkGrabberControllerListener)this);
        if (this.guiFrame != null) {
            this.guiFrame.removeWindowListener(this);
            this.guiFrame.removeWindowStateListener(this);
            if (!this.shutdown) {
                this.miniIt(false);
            }
            this.guiFrame.setAlwaysOnTop(false);
        }
    }

    private static void calcLocation(final TrayIconPopup window, final Point p) {
        new GuiRunnable<Object>(){

            public Object runSave() {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int limitX = (int)screenSize.getWidth() / 2;
                int limitY = (int)screenSize.getHeight() / 2;
                if (!OSDetector.isMac()) {
                    if (p.x <= limitX) {
                        if (p.y <= limitY) {
                            window.setLocation(p.x, p.y);
                        } else {
                            window.setLocation(p.x, p.y - window.getHeight());
                        }
                    } else if (p.y <= limitY) {
                        window.setLocation(p.x - window.getWidth(), p.y);
                    } else {
                        window.setLocation(p.x - window.getWidth(), p.y - window.getHeight());
                    }
                } else if (p.getX() <= screenSize.getWidth() - (double)window.getWidth()) {
                    window.setLocation((int)p.getX(), 22);
                } else {
                    window.setLocation(p.x - window.getWidth(), 22);
                }
                return null;
            }
        }.waitForEDT();
    }

    private void miniIt(final boolean minimize) {
        String password;
        if (!(minimize || !this.subConfig.getBooleanProperty(PROPERTY_PASSWORD_REQUIRED, false).booleanValue() || (password = UserIO.getInstance().requestInputDialog(JDL.L((String)"plugins.optional.JDLightTray.enterPassword", (String)"Enter the Password to open JD:"))) != null && password.equals(this.subConfig.getStringProperty(PROPERTY_PASSWORD, "")))) {
            UserIO.getInstance().requestMessageDialog(JDL.L((String)"plugins.optional.JDLightTray.enterPassword.wrong", (String)"The entered Password was wrong!"));
            return;
        }
        new GuiRunnable<Object>(){

            public Object runSave() {
                JDLightTray.this.guiFrame.setVisible(!minimize);
                return null;
            }
        }.start();
        if (!minimize) {
            new GuiRunnable<Object>(){

                public Object runSave() {
                    JDLightTray.this.guiFrame.setAlwaysOnTop(true);
                    JDLightTray.this.guiFrame.toFront();
                    return null;
                }
            }.start();
        }
    }

    public void mouseStay(MouseEvent e) {
        if (!this.subConfig.getBooleanProperty(PROPERTY_TOOLTIP, true).booleanValue()) {
            return;
        }
        if (this.trayIconPopup != null && this.trayIconPopup.isVisible()) {
            return;
        }
        this.trayIconTooltip.show(((TrayMouseAdapter)e.getSource()).getEstimatedTopLeft(), this.trayIcon);
    }

    private void removeTrayIcon() {
        try {
            if (this.trayIcon != null) {
                this.trayIcon.removeActionListener((ActionListener)((Object)this));
                SystemTray.getSystemTray().remove(this.trayIcon);
                if (this.ma != null) {
                    this.trayIcon.removeMouseListener(this.ma);
                    this.trayIcon.removeMouseMotionListener(this.ma);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object interact(String command, Object parameter) {
        if (command == null) {
            return null;
        }
        if (command.equalsIgnoreCase("enabled")) {
            return this.subConfig.getBooleanProperty(PROPERTY_CLOSE_TO_TRAY, true);
        }
        if (command.equalsIgnoreCase("refresh")) {
            new GuiRunnable<Object>(){

                public Object runSave() {
                    JDLightTray.this.removeTrayIcon();
                    JDLightTray.this.initGUI();
                    return null;
                }
            }.start();
        }
        return null;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.subConfig.getBooleanProperty(PROPERTY_CLOSE_TO_TRAY, true).booleanValue()) {
            this.miniIt(true);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        if (this.guiFrame != null) {
            this.guiFrame.setAlwaysOnTop(false);
        }
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void onLinkGrabberControllerEvent(LinkGrabberControllerEvent event) {
        if (event.getID() == 0 && (this.subConfig.getBooleanProperty(PROPERTY_SHOW_ON_LINKGRAB, true).booleanValue() && !this.guiFrame.isVisible() || this.subConfig.getBooleanProperty(PROPERTY_SHOW_ON_LINKGRAB2, false).booleanValue())) {
            if (this.subConfig.getBooleanProperty(PROPERTY_PASSWORD_REQUIRED, false).booleanValue()) {
                return;
            }
            if (!this.guiFrame.isVisible()) {
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        JDLightTray.this.guiFrame.setVisible(true);
                        return null;
                    }
                }.start();
            }
            new GuiRunnable<Object>(){

                public Object runSave() {
                    JDLightTray.this.guiFrame.toFront();
                    return null;
                }
            }.start();
            if (this.iconified) {
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        JDLightTray.this.guiFrame.setState(0);
                        return null;
                    }
                }.start();
            }
        }
    }

    @Override
    public void windowStateChanged(WindowEvent evt) {
        int oldState = evt.getOldState();
        int newState = evt.getNewState();
        if ((oldState & 1) == 0 && (newState & 1) != 0) {
            this.iconified = true;
        } else if ((oldState & 1) != 0 && (newState & 1) == 0) {
            this.iconified = false;
        }
    }
}

