/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ImageIcon;
import jd.config.ConfigContainer;
import jd.config.ConfigGroup;
import jd.config.Property;
import jd.controlling.ListController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigEntry
implements Serializable {
    private static final long serialVersionUID = 7422046260361380162L;
    private ActionListener actionListener;
    private boolean changes;
    private String compareOperator;
    private ConfigEntry conditionEntry;
    private Object conditionValue;
    private ConfigContainer container;
    private transient ListController controller;
    private Object defaultValue;
    private String description;
    private boolean enabled = true;
    private int end;
    private ConfigGroup group;
    private PropertyChangeListener guiListener;
    private String helptags = null;
    private ImageIcon imageIcon;
    private String label;
    private Object[] list;
    private Vector<ConfigEntry> listener = new Vector();
    private Property propertyInstance;
    private String propertyName;
    private PropertyType propertyType = PropertyType.NORMAL;
    private int start;
    private int step = 1;
    private int type;

    public ConfigEntry(int type) {
        this.type = type;
    }

    public ConfigEntry(int type, ActionListener listener, String label, String description, ImageIcon icon) {
        this.type = type;
        this.label = label;
        this.imageIcon = icon;
        this.description = description;
        this.actionListener = listener;
        this.enabled = true;
    }

    public ConfigEntry(int type, ConfigContainer premiumConfig) {
        this.type = type;
        this.container = premiumConfig;
        this.enabled = true;
    }

    public ConfigEntry(int type, ListController controller, String label) {
        this.type = type;
        this.label = label;
        this.controller = controller;
        this.propertyName = "ListControlled";
        this.enabled = true;
    }

    public ConfigEntry(int type, Property propertyInstance, String propertyName, int num) {
        this.type = type;
        this.propertyName = propertyName;
        this.propertyInstance = propertyInstance;
        this.end = num;
    }

    public ConfigEntry(int type, Property propertyInstance, String propertyName, Object[] list, String label) {
        this.type = type;
        this.propertyName = propertyName;
        this.propertyInstance = propertyInstance;
        this.list = list;
        this.label = label;
    }

    public ConfigEntry(int type, Property propertyInstance, String propertyName, String label) {
        this.type = type;
        this.propertyName = propertyName;
        this.propertyInstance = propertyInstance;
        this.label = label;
        this.enabled = true;
    }

    public ConfigEntry(int type, Property propertyInstance, String propertyName, String label, int start, int end) {
        this.type = type;
        this.propertyName = propertyName;
        this.propertyInstance = propertyInstance;
        this.label = label;
        this.start = start;
        this.end = end;
    }

    public ConfigEntry(int type, String label) {
        this.type = type;
        this.label = label;
        this.enabled = true;
    }

    public ConfigEntry(int type, String label, String link) {
        this.type = type;
        this.propertyName = link;
        this.label = label;
        this.enabled = true;
    }

    public void addListener(ConfigEntry configEntry) {
        if (configEntry != null) {
            this.listener.add(configEntry);
        }
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public String getCompareOperator() {
        return this.compareOperator;
    }

    public ConfigEntry getConditionEntry() {
        return this.conditionEntry;
    }

    public Object getConditionValue() {
        return this.conditionValue;
    }

    public ConfigContainer getContainer() {
        return this.container;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public int getEnd() {
        return this.end;
    }

    public ConfigGroup getGroup() {
        return this.group;
    }

    public PropertyChangeListener getGuiListener() {
        return this.guiListener;
    }

    public String getHelptags() {
        if (this.helptags == null) {
            return this.label;
        }
        return this.helptags;
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    public String getLabel() {
        return this.label;
    }

    public Object[] getList() {
        return this.list;
    }

    public ListController getListController() {
        if (this.controller == null) {
            this.controller = new ListController(){

                public String getList() {
                    return "";
                }

                public void setList(String list) {
                }
            };
        }
        return this.controller;
    }

    public Vector<ConfigEntry> getListener() {
        return this.listener;
    }

    public Property getPropertyInstance() {
        return this.propertyInstance;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public int getStart() {
        return this.start;
    }

    public int getStep() {
        return this.step;
    }

    public int getType() {
        return this.type;
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public boolean isConditionalEnabled(PropertyChangeEvent evt) {
        if (evt.getSource() == this.conditionEntry) {
            if (this.compareOperator.equals("<")) {
                if (this.conditionValue instanceof Comparable) {
                    return ((Comparable)evt.getNewValue()).compareTo(this.conditionValue) < 0;
                }
                if (this.conditionValue instanceof Integer) {
                    return (Integer)this.conditionValue < (Integer)evt.getNewValue();
                }
                return true;
            }
            if (this.compareOperator.equals(">")) {
                if (this.conditionValue instanceof Comparable) {
                    return ((Comparable)evt.getNewValue()).compareTo(this.conditionValue) > 0;
                }
                if (this.conditionValue instanceof Integer) {
                    return (Integer)this.conditionValue > (Integer)evt.getNewValue();
                }
                return true;
            }
            if (this.compareOperator.equals("!=")) {
                if (this.conditionValue instanceof Comparable) {
                    return ((Comparable)evt.getNewValue()).compareTo(this.conditionValue) != 0;
                }
                if (this.conditionValue instanceof Integer) {
                    return !((Integer)this.conditionValue).equals(evt.getNewValue());
                }
                return true;
            }
            if (this.conditionValue instanceof Comparable) {
                return ((Comparable)evt.getNewValue()).compareTo(this.conditionValue) == 0;
            }
            if (this.conditionValue instanceof Integer) {
                return ((Integer)this.conditionValue).equals(evt.getNewValue());
            }
            return true;
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ConfigEntry setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
        return this;
    }

    public void setChanges(boolean b) {
        this.changes = b;
    }

    public void setCompareOperator(String compareOperator) {
        this.compareOperator = compareOperator;
    }

    public void setConditionEntry(ConfigEntry conditionEntry) {
        this.conditionEntry = conditionEntry;
        conditionEntry.addListener(this);
    }

    public void setConditionValue(Object conditionValue) {
        this.conditionValue = conditionValue;
    }

    public void setContainer(ConfigContainer container) {
        this.container = container;
    }

    public ConfigEntry setDefaultValue(Object value) {
        this.defaultValue = value;
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ConfigEntry setEnabled(boolean value) {
        this.enabled = value;
        return this;
    }

    public ConfigEntry setEnabledCondidtion(ConfigEntry old, String comp, Object value) {
        this.setConditionEntry(old);
        this.setCompareOperator(comp);
        this.setConditionValue(value);
        return this;
    }

    public ConfigEntry setEnd(int end) {
        this.end = end;
        return this;
    }

    public ConfigEntry setGroup(ConfigGroup cg) {
        this.group = cg;
        return this;
    }

    public void setGuiListener(PropertyChangeListener gce) {
        if (this.guiListener == null) {
            this.guiListener = gce;
        }
    }

    public void setHelptags(String helptags) {
        this.helptags = helptags;
    }

    public void setImageIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }

    public ConfigEntry setLabel(String label) {
        this.label = label;
        return this;
    }

    public ConfigEntry setList(Object[] list) {
        this.list = list;
        return this;
    }

    public ConfigEntry setPropertyInstance(Property propertyInstance) {
        this.propertyInstance = propertyInstance;
        return this;
    }

    public ConfigEntry setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public ConfigEntry setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    public ConfigEntry setStart(int start) {
        this.start = start;
        return this;
    }

    public ConfigEntry setStep(int step) {
        this.step = step;
        return this;
    }

    public ConfigEntry setType(int type) {
        this.type = type;
        return this;
    }

    public void valueChanged(Object newValue) {
        for (ConfigEntry next : this.listener) {
            if (next.getGuiListener() == null) continue;
            next.getGuiListener().propertyChange(new PropertyChangeEvent(this, this.getPropertyName(), null, newValue));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyType {
        NONE,
        NORMAL,
        NEEDS_RESTART;


        public static PropertyType getMax(PropertyType ... changes) {
            ArrayList<PropertyType> sorter = new ArrayList<PropertyType>();
            PropertyType[] propertyTypeArray = changes;
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyType type = propertyTypeArray[n2];
                sorter.add(type);
                ++n2;
            }
            Collections.sort(sorter);
            PropertyType ret = (PropertyType)((Object)sorter.get(sorter.size() - 1));
            return ret;
        }

        public PropertyType getMax(PropertyType propertyType) {
            return PropertyType.getMax(propertyType, this);
        }

        public String toString() {
            return this.name();
        }
    }
}

